package com.ibm.wsc.wcsf;

import java.io.IOException;

import javax.naming.InitialContext;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import com.ibm.websphere.smf.SmfEventInfrastructure;

import java.util.logging.Level;
import java.util.logging.Logger;

public class WebContainerServletFilter implements Filter {

	private Logger logger = Logger.getLogger(getClass().getName());
	
	private SmfEventInfrastructure smfEventInfraObject = null;
	
	private int smfUserKeyData = 0;
	
	/**
	 * The filter configuration object we are associated with. If this value is
	 * null, this filter instance is not currently configured.
	 */

	private FilterConfig config = null;
	
	@Override
	public void destroy() {
		// TODO Auto-generated method stub
		logger.logp(Level.SEVERE, getClass().getName(), "init", "in destroy");
	}

	/**
	 * The <code>doFilter</code> method of the Filter is called by the container
	 * each time a request/response pair is passed through the chain due to a
	 * client request for a resource at the end of the chain. The FilterChain
	 * passed into this method allows the Filter to pass on the request and
	 * response to the next entity in the chain.
	 * 
	 * We check to see if there is a query string in the request and if there is 
	 * we write this as user data to the SMF 120 subtype 9 record
	 */
	
	@Override
	public void doFilter(ServletRequest request, ServletResponse response,
			FilterChain chain) throws IOException, ServletException {
		// TODO Auto-generated method stub
		
		// Get the request sent in and check if there is any query string 
		// If there is write this as user data to the SMF 120 subtype 9 record
		
		String uriString = ((HttpServletRequest) request).getRequestURI();
		HttpServletRequest hsr = (HttpServletRequest) request ;
		
		String qs = hsr.getQueryString();
		if ( qs == null ) {
	        logger.logp(Level.FINEST, getClass().getName(), "doFilter", "query string is null - leaving...");

			chain.doFilter(request, response);
			return;
		}
        logger.logp(Level.FINEST, getClass().getName(), "doFilter", "uri: " + 
				uriString + " query string: " + qs);

		int rc ;
		
		// On a distributed system , there is no SMF support, 
		// and the SMF object may be null, if it is then return
		
		if ( smfEventInfraObject == null ) {
			logger.logp(Level.FINEST, getClass().getName(), "doFilter", "SMF Infrastructure object null, will not attempt SMF API");
			chain.doFilter(request, response);
			return;
		}
			
		// Check if SMF recording is active, and if it is 
		// write query string as user data to the SMF record
		// Data is written in EBCDIC
		
		if ( smfEventInfraObject.isSMF120Subtype9Enabled()) {
			if ( qs.length() <= 2000 ) 
				rc = smfEventInfraObject.addDataToSMF120Subtype9Record(smfUserKeyData, (qs).getBytes("Cp1047"));
			else {
				rc = smfEventInfraObject.addDataToSMF120Subtype9Record(smfUserKeyData, (qs.substring(0,19999)).getBytes("Cp1047"));
		        logger.logp(Level.FINEST, getClass().getName(), "doFilter", "query string truncated as length > 2000");
			}
			String smfRcDesc = getSmfRcDesc(rc);
		    logger.logp(Level.FINEST, getClass().getName(), "doFilter", " SMF User data key: " + smfUserKeyData
					+ " SMF Add user data rc: " + rc
					+ " smfRcDesc: " + smfRcDesc);
		} else {
				logger.logp(Level.FINEST, getClass().getName(), "doFilter", "SMF recording off");
		}
		
		// Carry on with normal processing of request
		
        chain.doFilter(request, response);
	}

	@Override
	public void init(FilterConfig filterConfig) throws ServletException {
		// TODO Auto-generated method stub
		this.config = filterConfig;
		
		// Check if tracing is required
		// and also get value to use as key for saving SMF user data
      
		if (filterConfig != null) {
			smfUserKeyData = Integer.parseInt( filterConfig.getInitParameter("smfUserDataKey"));
			logger.logp(Level.FINEST, getClass().getName(), "init", "smfUserKeyData set to: " + smfUserKeyData);
		}
		
		// Perform lookup of SMF object used when adding user data to 
		// SMF record
		
		try {
			InitialContext ic = new InitialContext();
			Object obj = ic.lookup(SmfEventInfrastructure.SEI_LOC);
			smfEventInfraObject = (SmfEventInfrastructure) obj;
			} catch ( Exception ex ) {
				logger.logp(Level.FINEST, getClass().getName(), "init", "SMF lookup exception: " + ex);
			}
	}

	// This method provides text description of return codes from 
	// use of addDataToSMF120Subtype9Record 
	
	private String getSmfRcDesc ( int smfRc ){
		String rc_s;
		switch(smfRc)
		{
		 case SmfEventInfrastructure.ADD_DATA_FAILED_NO_REQUEST  :
		      rc_s = new String("Add Data Failed No Request");
		     break;
		 case SmfEventInfrastructure.ADD_DATA_FAILED_RECORDING_OFF : 
		     rc_s = new String("Add Data Failed Recording Off");
		     break;
		 case SmfEventInfrastructure.ADD_DATA_FAILED_TOO_BIG : 
		     rc_s = new String("Add Data Failed Too Big");
		     break;
		 case SmfEventInfrastructure.ADD_DATA_FAILED_TOO_MANY: 
		      rc_s = new String("Add Data Failed Too Many");
		      break;
		 case SmfEventInfrastructure.ADD_DATA_OK : 
		      rc_s = new String("Added data successfully");
		      break;
		 case SmfEventInfrastructure.ADD_DATA_REPLACED_DATA :
		     rc_s = new String("Add Data Replaced Data");
		     break;
		default: 
		     rc_s = new String ("Unknown Return Code");
		}
		return rc_s;
	}
}
