/**
 * 
 * This version is only applicable to WebSphere Version 7.
 * 
 * To make this listener work uncomment the two block comments
 * and compile with the V7 runtime.  
 * 
 * The reason for inclusion of this version of code in
 * this package is to show the different package and class names,
 * as well as the different means to get a reference to the IFilterConfig
 * object necessary to establish the filter.
 * 
 */

package com.ibm.wsc.wcsf;

import java.util.Hashtable;
import java.util.Vector;

import javax.servlet.ServletContextEvent;

import javax.servlet.ServletContext;
import com.ibm.websphere.servlet.context.ExtendedServletContext;
import com.ibm.websphere.servlet.filter.IFilterConfig;

import java.util.logging.Level;
import java.util.logging.Logger;


public class WebContainerServletContextListener implements
		javax.servlet.ServletContextListener {

	private final static Logger logger = Logger.getLogger(WebContainerServletContextListener.class .getName());

	private final static String moduleName = "WebContainerServletContextListener";

	private static boolean isZos = false;
	private static String traceLevel = "0";
	
	private static Vector <String> contextRoots = new Vector<String>() ;
	private static Hashtable <String,String>contextRootsFilterMaps = new Hashtable<String,String>();
	private static String smfUserDataKey = "65999";
	
	static {
		/*
		 * Collect all the environment variable settings to setup the filter and
		 * tracing/debugging options.
		 */
		if ("z/OS".equals(System.getProperty("os.name", "not z/OS")))
			isZos = true;

        logger.logp(Level.FINEST, WebContainerServletContextListener.class .getName(), "init", "WSC Servlet filter active");
        logger.logp(Level.FINEST, WebContainerServletContextListener.class .getName(), "init", "isZos: " + isZos);
		
		// Check if property wsc.servletFilter.smfUserDataKey supplied
		// If it has use that value, if not use default 
		
		String smfUserKeyDataValue = System.getProperty("wsc.servletFilter.smfUserDataKey");
		if ( smfUserKeyDataValue != null ) {
			smfUserDataKey = smfUserKeyDataValue;
	        logger.logp(Level.FINEST, WebContainerServletContextListener.class .getName(), "init", "smfUserDataKey set to: "+smfUserDataKey);
		} else { logger.logp(Level.FINEST, WebContainerServletContextListener.class .getName(), "init", "no property smfUserDataKey found, using default value of 65999");
		}
		
		// Look for properties of the form wsc.servletFilter.contextRoot.N 
		// where N is a number starting from 1
		// The value of each such property found is a context root
		// Save each value found 
		// If no property wsc.servletFilter.contextRoot.1 is found
		// then will assume that a filter is to be created for each web app 
		
		int ii = 1;
		boolean getContextProps = true;
		String contextRoot = null, crPropName;
		while ( getContextProps ) {
			crPropName = "wsc.servletFilter.contextRoot."+ii;
			contextRoot = System.getProperty(crPropName);
            logger.logp(Level.FINEST, WebContainerServletContextListener.class .getName(), "init", "Property Name: " + crPropName + " value>" +contextRoot + "<");
			if ( contextRoot != null ) {
				contextRoots.add(contextRoot);
				ii++;
	            logger.logp(Level.FINEST, WebContainerServletContextListener.class .getName(), "init", "Added context root: " + contextRoot + " to table");
			} else {
				getContextProps = false;
			}
		}
		
		// If we found some context roots, look for properties of the 
		// form wsc.servletFilter.N.mappingFilter.X where N must match the N of 
		// a defined wsc.servletFilter.contextRoot.N property 
		// and X is a number starting from 1
		// Save each value found
		// If no matching wsc.servletFilter.N.mappingFilter.1 found, then 
		// will set mappingFilter to * to match all requests
		
		if ( contextRoots.isEmpty() ) {
				System.out.println(">>> Servlet filters will be created for each web application");
	            logger.logp(Level.FINEST, WebContainerServletContextListener.class .getName(), "init", "No context roots  added to table");
		}
		else {  String cr, contextRootFilterMap, filterMappingPropName ;
		        System.out.println(">>> Servlet filters will be created for selected web application(s)");
				for ( int xx = 0; xx < contextRoots.size(); xx++){
					getContextProps = true;
					ii = 1;
					while ( getContextProps ) {
						filterMappingPropName = "wsc.servletFilter.contextRoot."+(xx+1)+".mappingFilter."+ii;
						contextRootFilterMap = System.getProperty(filterMappingPropName);
			            logger.logp(Level.FINEST, WebContainerServletContextListener.class .getName(), "init", "value for prop: " + filterMappingPropName + " >" +contextRootFilterMap+ "<");
						if ( contextRootFilterMap != null ) {
							cr = contextRoots.get(xx);
							contextRootsFilterMaps.put(cr+"."+ii, contextRootFilterMap);
							ii++;
				            logger.logp(Level.FINEST, WebContainerServletContextListener.class .getName(), "init", "Added context root filter map: " + contextRootFilterMap);
						} else {
							getContextProps = false;
						}
					}
			}
		}
	}

	public void contextDestroyed(ServletContextEvent scEvent) {
       logger.logp(Level.FINEST, getClass().getName(), "contextDestroyed", moduleName + ".contextDestroyed() entered/exited.");
	}

	public void contextInitialized(ServletContextEvent scEvent) {

        logger.logp(Level.FINEST, getClass().getName(), "contextInitialized", moduleName + ".contextInitialized() entered.");

		String contextPath = "Unknown";
		String contextName = "Unknown";

		ServletContext ctx = scEvent.getServletContext();
		ExtendedServletContext facade = (ExtendedServletContext) ctx;
		
		contextPath = facade.getContextPath();
		contextName = facade.getServletContextName();
		
		/*
		 * Call method to determine if should enable filter for this web app
		 */

		if (!setFilterForApp(contextName, contextPath)) {
	        logger.logp(Level.FINEST, getClass().getName(), "contextInitialized", moduleName + ".contextInitialized() did NOT establish WSC Web Container Filter for: ");
	        logger.logp(Level.FINEST, getClass().getName(), "contextInitialized", moduleName + ">>> ContextName: "
								+ contextName
								+ ", contextPath: "
								+ contextPath);
			return;
		}

		//Gets the IFilterConfig object for this context or creates one if it doesn't exist. 
		
		IFilterConfig config = facade
				.getFilterConfig("WSCResponseFilterConfig");	
		
		config.setFilterClassName("com.ibm.wsc.wcsf.WebContainerServletFilter");
		config.setDisplayName("WSC-WebContainer-IFilterConfig");
		config.setName("WSC-Filter");
		config.addInitParameter("traceLevel", traceLevel);
		config.addInitParameter("smfUserDataKey", smfUserDataKey);
		int[] dispatchMode = { 0 };
		config.setDispatchMode(dispatchMode);

		// Now setup the mapping filter for this web app
		// Use the current context root, to use as key to search table
		
		boolean crUrlSearch = true;
		int zz = 1;
		String contextRootMappingFilter, contextRootIndex ;
		while (crUrlSearch){
			contextRootIndex = contextPath + "." + zz;
			contextRootMappingFilter = (String)contextRootsFilterMaps.get(contextRootIndex);
	        logger.logp(Level.FINEST, getClass().getName(), "contextInitialized", "contextRootIndex: " + contextRootIndex + " contextRootMappingFilter: " + contextRootMappingFilter);
			if ( contextRootMappingFilter != null) {
				facade.addMappingFilter("/" + contextRootMappingFilter, config);
		        logger.logp(Level.FINEST, getClass().getName(), "contextInitialized", ">>> Added mapping filter with this URL: " + contextRootMappingFilter);
				zz++;
			} else {
					crUrlSearch = false;
			}
		}
		
		// If no matching wsc.servletFilter.N.mappingFilter.X found for wsc.servletFilter.N
		// then set filter to process all requests
		
		if ( zz == 1) {
			facade.addMappingFilter("/*", config);
			System.out.println(">>> No Filter mapping properties found for web app" + contextName + " and context root: " + contextPath);
			System.out.println(">>> will set filter mapping to /* to indicate filter is to match all requests");
		}

	    logger.logp(Level.FINEST, getClass().getName(), "contextInitialized", "createFilterConfig(\"com.ibm.wsc.wcsf.WebContainerServletFilter\") for - "
					+ "\n>>> ContextName: "
					+ contextName
					+ ", ContextPath: "
					+ contextPath);
	    logger.logp(Level.FINEST, getClass().getName(), "contextInitialized", ">>> setFilterName(\"" + config.getFilterName()
					+ "\")");
	    logger.logp(Level.FINEST, getClass().getName(), "contextInitialized", ">>> addInitParameter(\"traceLevel\", \""
					+ config.getInitParameter("traceLevel") + "\")");
	    logger.logp(Level.FINEST, getClass().getName(), "contextInitialized", ">>> addInitParameter(\"smfUserDataKey\", \""
					+ config.getInitParameter("smfUserDataKey") + "\")");


	}
	
	/* 
	 * This method determines is filter app should be enabled for the web app.
	 * It does this by checking to see if the current context root 
	 * was specified as a property
	 */ 
	private boolean setFilterForApp(String contextName, String contextPath) {
		
		boolean crFound = false;
		String cr;
		
		if ( contextRoots.size() == 0 ) {
	        logger.logp(Level.FINEST, getClass().getName(), "setFilterForApp", "Creating filter for web app: " + contextName + " with context root: " + contextPath);
	        logger.logp(Level.FINEST, getClass().getName(), "setFilterForApp", "By default since no wsc.servletFilter.contextRoot.N defined");
		return true;
		}
		
		// Search table of context roots that were specified as properties
		// If match found then will enable filter for that context root
		
		for ( int ii = 0; ii < contextRoots.size(); ii++){
			cr = contextRoots.get(ii);
	        logger.logp(Level.FINEST, getClass().getName(), "setFilterForApp", "Checking context root from table:>" + cr + "<>"  + " against contextPath:>" + contextPath + "<" 
					+ " for web app: " + contextName);
			if ( cr.equals(contextPath)) crFound = true;
		}
		if ( crFound ) {
	        logger.logp(Level.FINEST, getClass().getName(), "setFilterForApp", ">>> Enabling filter for web app: " + contextName + " with context root: " + contextPath);
			return true;
		}
		logger.logp(Level.FINEST, getClass().getName(), "setFilterForApp", ">>> Not enabling filter for for web app: " + contextName + " with context root: " + contextPath);
		return false;
	}
}

