/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsc.wcsf;

import com.ibm.websphere.smf.SmfEventInfrastructure;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class WebContainerServletFilter
implements Filter {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private SmfEventInfrastructure smfEventInfraObject = null;
    private int smfUserKeyData = 0;
    private FilterConfig config = null;

    public void destroy() {
        this.logger.logp(Level.SEVERE, this.getClass().getName(), "init", "in destroy");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String uriString = ((HttpServletRequest)request).getRequestURI();
        HttpServletRequest hsr = (HttpServletRequest)request;
        String qs = hsr.getQueryString();
        if (qs == null) {
            this.logger.logp(Level.FINEST, this.getClass().getName(), "doFilter", "query string is null - leaving...");
            chain.doFilter(request, response);
            return;
        }
        this.logger.logp(Level.FINEST, this.getClass().getName(), "doFilter", "uri: " + uriString + " query string: " + qs);
        if (this.smfEventInfraObject == null) {
            this.logger.logp(Level.FINEST, this.getClass().getName(), "doFilter", "SMF Infrastructure object null, will not attempt SMF API");
            chain.doFilter(request, response);
            return;
        }
        if (this.smfEventInfraObject.isSMF120Subtype9Enabled().booleanValue()) {
            int rc;
            if (qs.length() <= 2000) {
                rc = this.smfEventInfraObject.addDataToSMF120Subtype9Record(this.smfUserKeyData, qs.getBytes("Cp1047"));
            } else {
                rc = this.smfEventInfraObject.addDataToSMF120Subtype9Record(this.smfUserKeyData, qs.substring(0, 19999).getBytes("Cp1047"));
                this.logger.logp(Level.FINEST, this.getClass().getName(), "doFilter", "query string truncated as length > 2000");
            }
            String smfRcDesc = this.getSmfRcDesc(rc);
            this.logger.logp(Level.FINEST, this.getClass().getName(), "doFilter", " SMF User data key: " + this.smfUserKeyData + " SMF Add user data rc: " + rc + " smfRcDesc: " + smfRcDesc);
        } else {
            this.logger.logp(Level.FINEST, this.getClass().getName(), "doFilter", "SMF recording off");
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.config = filterConfig;
        if (filterConfig != null) {
            this.smfUserKeyData = Integer.parseInt(filterConfig.getInitParameter("smfUserDataKey"));
            this.logger.logp(Level.FINEST, this.getClass().getName(), "init", "smfUserKeyData set to: " + this.smfUserKeyData);
        }
        try {
            InitialContext ic = new InitialContext();
            Object obj = ic.lookup("smf/sei");
            this.smfEventInfraObject = (SmfEventInfrastructure)obj;
        }
        catch (Exception ex) {
            this.logger.logp(Level.FINEST, this.getClass().getName(), "init", "SMF lookup exception: " + ex);
        }
    }

    private String getSmfRcDesc(int smfRc) {
        String rc_s;
        switch (smfRc) {
            case 20: {
                rc_s = new String("Add Data Failed No Request");
                break;
            }
            case 16: {
                rc_s = new String("Add Data Failed Recording Off");
                break;
            }
            case 8: {
                rc_s = new String("Add Data Failed Too Big");
                break;
            }
            case 12: {
                rc_s = new String("Add Data Failed Too Many");
                break;
            }
            case 0: {
                rc_s = new String("Added data successfully");
                break;
            }
            case 4: {
                rc_s = new String("Add Data Replaced Data");
                break;
            }
            default: {
                rc_s = new String("Unknown Return Code");
            }
        }
        return rc_s;
    }
}

