/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsc.wcsf;

import com.ibm.websphere.servlet.context.ExtendedServletContext;
import com.ibm.websphere.servlet.filter.IFilterConfig;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class WebContainerServletContextListener
implements ServletContextListener {
    private static final Logger logger = Logger.getLogger(WebContainerServletContextListener.class.getName());
    private static final String moduleName = "WebContainerServletContextListener";
    private static boolean isZos = false;
    private static String traceLevel = "0";
    private static Vector<String> contextRoots = new Vector();
    private static Hashtable<String, String> contextRootsFilterMaps = new Hashtable();
    private static String smfUserDataKey = "65999";

    static {
        if ("z/OS".equals(System.getProperty("os.name", "not z/OS"))) {
            isZos = true;
        }
        logger.logp(Level.FINEST, WebContainerServletContextListener.class.getName(), "init", "WSC Servlet filter active");
        logger.logp(Level.FINEST, WebContainerServletContextListener.class.getName(), "init", "isZos: " + isZos);
        String smfUserKeyDataValue = System.getProperty("wsc.servletFilter.smfUserDataKey");
        if (smfUserKeyDataValue != null) {
            smfUserDataKey = smfUserKeyDataValue;
            logger.logp(Level.FINEST, WebContainerServletContextListener.class.getName(), "init", "smfUserDataKey set to: " + smfUserDataKey);
        } else {
            logger.logp(Level.FINEST, WebContainerServletContextListener.class.getName(), "init", "no property smfUserDataKey found, using default value of 65999");
        }
        int ii = 1;
        boolean getContextProps = true;
        String contextRoot = null;
        while (getContextProps) {
            String crPropName = "wsc.servletFilter.contextRoot." + ii;
            contextRoot = System.getProperty(crPropName);
            logger.logp(Level.FINEST, WebContainerServletContextListener.class.getName(), "init", "Property Name: " + crPropName + " value>" + contextRoot + "<");
            if (contextRoot != null) {
                contextRoots.add(contextRoot);
                ++ii;
                logger.logp(Level.FINEST, WebContainerServletContextListener.class.getName(), "init", "Added context root: " + contextRoot + " to table");
                continue;
            }
            getContextProps = false;
        }
        if (contextRoots.isEmpty()) {
            System.out.println(">>> Servlet filters will be created for each web application");
            logger.logp(Level.FINEST, WebContainerServletContextListener.class.getName(), "init", "No context roots  added to table");
        } else {
            System.out.println(">>> Servlet filters will be created for selected web application(s)");
            int xx = 0;
            while (xx < contextRoots.size()) {
                getContextProps = true;
                ii = 1;
                while (getContextProps) {
                    String filterMappingPropName = "wsc.servletFilter.contextRoot." + (xx + 1) + ".mappingFilter." + ii;
                    String contextRootFilterMap = System.getProperty(filterMappingPropName);
                    logger.logp(Level.FINEST, WebContainerServletContextListener.class.getName(), "init", "value for prop: " + filterMappingPropName + " >" + contextRootFilterMap + "<");
                    if (contextRootFilterMap != null) {
                        String cr = contextRoots.get(xx);
                        contextRootsFilterMaps.put(String.valueOf(cr) + "." + ii, contextRootFilterMap);
                        ++ii;
                        logger.logp(Level.FINEST, WebContainerServletContextListener.class.getName(), "init", "Added context root filter map: " + contextRootFilterMap);
                        continue;
                    }
                    getContextProps = false;
                }
                ++xx;
            }
        }
    }

    public void contextDestroyed(ServletContextEvent scEvent) {
        logger.logp(Level.FINEST, this.getClass().getName(), "contextDestroyed", "WebContainerServletContextListener.contextDestroyed() entered/exited.");
    }

    public void contextInitialized(ServletContextEvent scEvent) {
        logger.logp(Level.FINEST, this.getClass().getName(), "contextInitialized", "WebContainerServletContextListener.contextInitialized() entered.");
        String contextPath = "Unknown";
        String contextName = "Unknown";
        ServletContext ctx = scEvent.getServletContext();
        ExtendedServletContext facade = (ExtendedServletContext)ctx;
        contextPath = facade.getContextPath();
        contextName = facade.getServletContextName();
        if (!this.setFilterForApp(contextName, contextPath)) {
            logger.logp(Level.FINEST, this.getClass().getName(), "contextInitialized", "WebContainerServletContextListener.contextInitialized() did NOT establish WSC Web Container Filter for: ");
            logger.logp(Level.FINEST, this.getClass().getName(), "contextInitialized", "WebContainerServletContextListener>>> ContextName: " + contextName + ", contextPath: " + contextPath);
            return;
        }
        IFilterConfig config = facade.getFilterConfig("WSCResponseFilterConfig");
        config.setFilterClassName("com.ibm.wsc.wcsf.WebContainerServletFilter");
        config.setDisplayName("WSC-WebContainer-IFilterConfig");
        config.setName("WSC-Filter");
        config.addInitParameter("traceLevel", traceLevel);
        config.addInitParameter("smfUserDataKey", smfUserDataKey);
        int[] dispatchMode = new int[1];
        config.setDispatchMode(dispatchMode);
        boolean crUrlSearch = true;
        int zz = 1;
        while (crUrlSearch) {
            String contextRootIndex = String.valueOf(contextPath) + "." + zz;
            String contextRootMappingFilter = contextRootsFilterMaps.get(contextRootIndex);
            logger.logp(Level.FINEST, this.getClass().getName(), "contextInitialized", "contextRootIndex: " + contextRootIndex + " contextRootMappingFilter: " + contextRootMappingFilter);
            if (contextRootMappingFilter != null) {
                facade.addMappingFilter("/" + contextRootMappingFilter, config);
                logger.logp(Level.FINEST, this.getClass().getName(), "contextInitialized", ">>> Added mapping filter with this URL: " + contextRootMappingFilter);
                ++zz;
                continue;
            }
            crUrlSearch = false;
        }
        if (zz == 1) {
            facade.addMappingFilter("/*", config);
            System.out.println(">>> No Filter mapping properties found for web app" + contextName + " and context root: " + contextPath);
            System.out.println(">>> will set filter mapping to /* to indicate filter is to match all requests");
        }
        logger.logp(Level.FINEST, this.getClass().getName(), "contextInitialized", "createFilterConfig(\"com.ibm.wsc.wcsf.WebContainerServletFilter\") for - \n>>> ContextName: " + contextName + ", ContextPath: " + contextPath);
        logger.logp(Level.FINEST, this.getClass().getName(), "contextInitialized", ">>> setFilterName(\"" + config.getFilterName() + "\")");
        logger.logp(Level.FINEST, this.getClass().getName(), "contextInitialized", ">>> addInitParameter(\"traceLevel\", \"" + config.getInitParameter("traceLevel") + "\")");
        logger.logp(Level.FINEST, this.getClass().getName(), "contextInitialized", ">>> addInitParameter(\"smfUserDataKey\", \"" + config.getInitParameter("smfUserDataKey") + "\")");
    }

    private boolean setFilterForApp(String contextName, String contextPath) {
        boolean crFound = false;
        if (contextRoots.size() == 0) {
            logger.logp(Level.FINEST, this.getClass().getName(), "setFilterForApp", "Creating filter for web app: " + contextName + " with context root: " + contextPath);
            logger.logp(Level.FINEST, this.getClass().getName(), "setFilterForApp", "By default since no wsc.servletFilter.contextRoot.N defined");
            return true;
        }
        int ii = 0;
        while (ii < contextRoots.size()) {
            String cr = contextRoots.get(ii);
            logger.logp(Level.FINEST, this.getClass().getName(), "setFilterForApp", "Checking context root from table:>" + cr + "<>" + " against contextPath:>" + contextPath + "<" + " for web app: " + contextName);
            if (cr.equals(contextPath)) {
                crFound = true;
            }
            ++ii;
        }
        if (crFound) {
            logger.logp(Level.FINEST, this.getClass().getName(), "setFilterForApp", ">>> Enabling filter for web app: " + contextName + " with context root: " + contextPath);
            return true;
        }
        logger.logp(Level.FINEST, this.getClass().getName(), "setFilterForApp", ">>> Not enabling filter for for web app: " + contextName + " with context root: " + contextPath);
        return false;
    }
}

