#!/bin/ksh

#=======================================================================
# sp12fix.sh - This script replaces the libkcudt*.so files in
# CANDLEHOME with those files from ServicePack media axls326*.jar files.
#-----------------------------------------------------------------------
# SYNTAX: sp12fix.sh -h CANDLEHOME -i IMAGE_DIR
#
#    Where:
#       -h: Specifies the ITM installation directory.
#       -i: Specifies the Service Pack directory.
#=======================================================================

unalias -a

Err_report() {
   case $1 in
      warn) print -u2 "$PROGNAME warning: $2,continuing ..."
            sleep 2
            return
            ;;
      fail) print -u2 "$PROGNAME failure: $2."
            exit 2
            ;;
      failUse) print -u2 "$PROGNAME failure: $2."
            Use_report
            ;;
      info) print -u2 "$PROGNAME        : $2."
            return
            ;;
   esac
}

Use_report() {
    print -u2 "\n$PROGNAME -h CANDLEHOME -i SPpath\n"
    exit 2
}

PROGNAME=$(basename $0)

SP=""
CH=""

while getopts ":h:i:" OPTS
do case $OPTS in
     h) CH="$OPTARG"
        ;;
     i) SP="$OPTARG"
        ;;
     ?) Use_report
        ;;
   esac
done
shift $((OPTIND-1))

[[ -n "$CH" ]] && CANDLEHOME=$CH

[[ -z "$CANDLEHOME" ]] && Err_report failUse "ITM home directory is required"
[[ -z "$SP" ]] &&         Err_report failUse "Service Pack media directory is required"
UNZIP=`which unzip 2>/dev/null`
[[ -z "$UNZIP" ]] && Err_report failUse "unzip not found in . Please ensure unzip is installed and in PATH"

cd $CANDLEHOME

echo
echo BEFORE
find * -name libkcudt\*.so 2> /dev/null | xargs -n1 cksum
echo

for file in $(ls $SP/bundles/unix/axls326*.jar 2> /dev/null); do
 libs=$($UNZIP -l $file | grep libkcudt | awk '{print $4}')
 for lib in $libs ; do
  libbase=$(basename $lib)
  libplat=$(basename $(dirname $(dirname $lib)))
  if [[ -f "$lib" ]]; then
   echo $UNZIP -o $file $lib
   $UNZIP -o $file $lib
   found=$(find * -name $libbase 2> /dev/null | grep $libplat)
   for file2 in $found ; do
    if [[ "$lib" != "$file2" ]]; then
     echo cp -f $lib $file2
     cp -f $lib $file2
    fi
   done
  fi
 done
done

echo
echo AFTER
find * -name libkcudt\*.so 2> /dev/null | xargs -n1 cksum
echo
