#!/usr/bin/perl
#********************************************************************************
# IBM Storage Protect
# 
# name: create_data_files.pl
#
# desc:   The create_data_files.pl utility is used to create the test files in the benchdata
#         folder named bench1, bench2, ...  
#
#         A seed file must be specified from which the bench files will be 
#         created.  Each bench file will be 1MB in size.
#
#         On Windows, the program wdeedee.exe must exist in the same diretory.
#
# usage:  perl create_data_files.pl <filename> [objcount]
#
# Notice: This program is provided as a tool intended for use by IBM Internal, 
#         IBM Business Partners, and IBM Customers. This program is provided as is, 
#         without support, and without warranty of any kind expressed or implied.
#
# (C) Copyright International Business Machines Corp. 2013, 2018
#********************************************************************************

if (@ARGV < 1 || @ARGV > 2)
{
  print "USAGE: perl create_data_files.pl <filename> [objcount]\n";
  print "Defaults: objcount defaults to 128\n";
  print "Example: perl create_data_files.pl testfile_50_150k\n";
  exit;
}

$filename = shift (@ARGV);
if (! -f $filename)
{
  print "ERROR: Unable to find file: $filename\n";
  exit;
}

$arg = shift(@ARGV);
if ($arg =~ m/\d+/)
{
  $objcount = $arg;
}
else
{
  $objcount = 128;
}

if (! -d "benchdata")
{
  mkdir ("benchdata");
  if (! -d "benchdata")
  {
    print "ERROR: Unable to create the benchdata folder\n";
    exit;
  }
}

if ($^O =~ m/^MSWin32/)
{
  $SS = "\\\\";
  $ddCmd = "..\\bin\\wdeedee.exe";
  if (! -e $ddCmd)
  {
    print "ERROR: Cannot locate $ddCmd\n";
    exit;
  }
}
else
{
  $SS = "/";
  $ddCmd = "dd";
}

for ($i=1; $i<=$objcount; $i++)
{
  $j = $i - 1;
  `$ddCmd if=$filename of=benchdata${SS}bench${i} bs=1024 count=1024 skip=$j`;
}
