/*
 * Decompiled with CFR 0.152.
 */
package com.outsideinsdk;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;

class PUtilities {
    private static String RESOURCE_BASE_NAME = "com.ibm.mm.viewer.CMBViewerMessages";
    private static final int MAX_BUNDLE_NAMES = 4;
    private static ResourceBundle viewerMessages = null;
    private static Vector availableBundles = new Vector(4);

    PUtilities() {
    }

    private static String getMessageString(String messageKey) {
        String message = messageKey;
        try {
            message = PUtilities.getResourceBundle().getString(messageKey);
            return message;
        }
        catch (MissingResourceException mre) {
            int size = availableBundles.size();
            for (int i = size - 1; i > 0; --i) {
                try {
                    return ((ResourceBundle)availableBundles.elementAt(i)).getString(messageKey);
                }
                catch (MissingResourceException me) {
                    continue;
                }
            }
            return messageKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Vector availableBundlesFor(String name) {
        Vector bundleNames = new Vector(4);
        Vector<PropertyResourceBundle> returnBundles = new Vector<PropertyResourceBundle>(4);
        bundleNames = PUtilities.calculateBundleNames(name.replace('.', '/'), Locale.getDefault());
        InputStream stream = null;
        String resPathName = name.replace('.', '/');
        int size = bundleNames.size();
        for (int i = 0; i < size; ++i) {
            resPathName = (String)bundleNames.elementAt(i) + ".properties";
            URL myurl = PUtilities.class.getClassLoader().getResource(resPathName);
            if (myurl != null) {
                try {
                    URLConnection myconn = myurl.openConnection();
                    myconn.setUseCaches(true);
                    stream = myconn.getInputStream();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (stream == null) continue;
            stream = new BufferedInputStream(stream);
            PropertyResourceBundle bundle = new PropertyResourceBundle(stream);
            returnBundles.insertElementAt(bundle, 0);
            Object var11_11 = null;
            try {
                stream.close();
            }
            catch (Exception e2) {}
            continue;
            {
                catch (Exception e) {
                    var11_11 = null;
                    try {
                        stream.close();
                    }
                    catch (Exception e2) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var11_11 = null;
                try {
                    stream.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return returnBundles;
    }

    private static ResourceBundle getResourceBundle() {
        if (viewerMessages == null && !(availableBundles = PUtilities.availableBundlesFor(RESOURCE_BASE_NAME)).isEmpty()) {
            viewerMessages = (PropertyResourceBundle)availableBundles.elementAt(0);
        }
        return viewerMessages;
    }

    private static Vector calculateBundleNames(String baseName, Locale locale) {
        Vector<String> result = new Vector<String>(4);
        String language = locale.getLanguage();
        int languageLength = language.length();
        String country = locale.getCountry();
        int countryLength = country.length();
        String variant = locale.getVariant();
        int variantLength = variant.length();
        result.addElement(baseName);
        if (languageLength + countryLength + variantLength == 0) {
            return result;
        }
        if (language.equals("en") && (country.equals("US") || country.equals("")) && variant.equals("")) {
            return result;
        }
        StringBuffer temp = new StringBuffer(baseName);
        temp.append('_');
        temp.append(language);
        result.addElement(temp.toString());
        if (countryLength + variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(country);
        result.addElement(temp.toString());
        if (variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(variant);
        result.addElement(temp.toString());
        return result;
    }

    public static String getMessage(String messageKey) {
        try {
            return PUtilities.getMessageString(messageKey);
        }
        catch (Throwable e) {
            return "";
        }
    }
}

