/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer.applets;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBDocumentEngineException;
import com.ibm.mm.viewer.CMBStreamingDocServicesCallbacks;
import com.ibm.mm.viewer.applets.CMBDocumentViewerApplet;
import com.ibm.mm.viewer.applets.PDocumentInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;

class PStreamingDocServicesCallbacks
extends CMBStreamingDocServicesCallbacks
implements Serializable {
    CMBDocumentViewerApplet applet;

    public PStreamingDocServicesCallbacks(CMBDocumentViewerApplet applet) {
        this.applet = applet;
    }

    public InputStream getForm(CMBDocument document, String formName) {
        String methodName = "getForm";
        PDocumentInfo docInfo = (PDocumentInfo)this.applet.getStreamingDocServices().getItemHandle(document);
        if (docInfo == null) {
            return null;
        }
        try {
            URL formURL = new URL(this.applet.getCodeBase(), docInfo.documentResourceUrlPrefix + formName);
            try {
                URLConnection urlConn = formURL.openConnection();
                InputStream formStream = urlConn == null ? new ByteArrayInputStream(new byte[0]) : urlConn.getInputStream();
                return formStream;
            }
            catch (IOException e) {
                ViewerLogger.logError((Object)this, methodName, e);
                return null;
            }
        }
        catch (MalformedURLException e) {
            ViewerLogger.logError((Object)this, methodName, e);
            return null;
        }
    }

    public boolean getPrintPrivilege(CMBDocument document) {
        PDocumentInfo docInfo = (PDocumentInfo)this.applet.getStreamingDocServices().getItemHandle(document);
        if (docInfo == null) {
            return true;
        }
        return docInfo.printPrivilege;
    }

    public InputStream getPart(CMBDocument document, int partNumber, StringBuffer outMimeType) {
        String methodName = "getPart";
        PDocumentInfo docInfo = (PDocumentInfo)this.applet.getStreamingDocServices().getItemHandle(document);
        if (docInfo == null) {
            return null;
        }
        try {
            URL partURL = new URL(this.applet.getCodeBase(), docInfo.contentPartUrls[partNumber]);
            try {
                URLConnection urlConn = partURL.openConnection();
                InputStream partStream = urlConn == null ? new ByteArrayInputStream(new byte[0]) : urlConn.getInputStream();
                return partStream;
            }
            catch (IOException e) {
                ViewerLogger.logError((Object)this, methodName, e);
                return null;
            }
        }
        catch (MalformedURLException e) {
            ViewerLogger.logError((Object)this, methodName, e);
            return null;
        }
    }

    public InputStream getAnnotation(CMBDocument document, int annotationNumber) {
        return null;
    }

    public InputStream getResources(CMBDocument document) {
        ByteArrayInputStream resourceStream = null;
        if (resourceStream == null) {
            resourceStream = new ByteArrayInputStream(new byte[0]);
        }
        return resourceStream;
    }

    public String deployNativeLibrary(String nativeLibName) {
        String methodName = "deployNativeLibrary";
        if (nativeLibName.equals("cmboutsidein_win.jar")) {
            this.removeConflictingManifest(nativeLibName, "inso.jar");
        }
        try {
            String destPath = this.getLibExt();
            if (this.isDifferentVersion(nativeLibName)) {
                this.trace("Deploying native library: " + nativeLibName);
                URL jarURL = new URL("jar:" + this.applet.getCodeBase().toString() + nativeLibName + "!/");
                JarURLConnection jarLib = (JarURLConnection)jarURL.openConnection();
                JarFile jarLibFile = jarLib.getJarFile();
                Enumeration<JarEntry> enuJarEntries = jarLibFile.entries();
                int fileIndex = 0;
                while (enuJarEntries.hasMoreElements()) {
                    JarEntry jeOneFile = enuJarEntries.nextElement();
                    File flOneFile = new File(destPath + System.getProperty("file.separator") + jeOneFile.toString());
                    if (jeOneFile.isDirectory()) {
                        if (flOneFile.exists()) continue;
                        flOneFile.mkdir();
                        continue;
                    }
                    ++fileIndex;
                    CheckedInputStream cisOneFile = new CheckedInputStream(jarLibFile.getInputStream(jeOneFile), new CRC32());
                    try {
                        int numRead;
                        FileOutputStream fos = new FileOutputStream(flOneFile);
                        int bufsize = 4096;
                        byte[] buf = new byte[bufsize];
                        for (int fsize = (int)jeOneFile.getSize(); fsize > 0; fsize -= numRead) {
                            numRead = fsize > bufsize ? cisOneFile.read(buf, 0, bufsize) : cisOneFile.read(buf, 0, fsize);
                            fos.write(buf, 0, numRead);
                        }
                        fos.flush();
                        fos.close();
                    }
                    catch (FileNotFoundException e) {
                        // empty catch block
                    }
                    cisOneFile.close();
                }
                FileOutputStream wManifestFile = new FileOutputStream(destPath + System.getProperty("file.separator") + nativeLibName + ".manifest");
                this.trace("Updating manifest file in " + destPath + System.getProperty("file.separator") + nativeLibName + ".manifest");
                Manifest cManifest = jarLibFile.getManifest();
                if (cManifest != null) {
                    cManifest.write(wManifestFile);
                }
                wManifestFile.close();
                this.trace("Deploy finished: " + nativeLibName);
            }
            return destPath;
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
            throw new CMBDocumentEngineException(e.getMessage());
        }
    }

    void removeConflictingManifest(String nativeLibName, String oldNativeLibName) {
        String destPath = this.getLibExt();
        String oldManifestName = destPath + System.getProperty("file.separator") + oldNativeLibName + ".manifest";
        String newManifestName = destPath + System.getProperty("file.separator") + nativeLibName + ".manifest";
        File oldManifestFile = new File(oldManifestName);
        if (oldManifestFile.exists()) {
            boolean isDeleted = new File(oldManifestName).delete();
            this.trace("conflicting manifest file: " + oldManifestName + " was deleted: " + isDeleted);
            isDeleted = new File(newManifestName).delete();
            this.trace("manifest file: " + newManifestName + " was deleted : " + isDeleted);
        }
    }

    private boolean isDifferentVersion(String nativeLibName) throws IOException {
        String destPath = this.getLibExt();
        this.trace("Determining if native library is different: " + nativeLibName);
        URL jarURL = new URL("jar:" + this.applet.getCodeBase().toString() + nativeLibName + "!/");
        this.trace("JAR URL is jar:" + this.applet.getCodeBase().toString() + nativeLibName + "!/");
        JarURLConnection jarLib = (JarURLConnection)jarURL.openConnection();
        JarFile jarLibFile = jarLib.getJarFile();
        boolean differentVersion = true;
        Manifest cManifest = jarLibFile.getManifest();
        Attributes cAttr = cManifest.getMainAttributes();
        String cVersion = cAttr.getValue("Implementation-Version");
        this.trace("Jar to deploy: implementation version is " + cVersion);
        FileInputStream oManifestFile = null;
        try {
            String currentManifestFile = destPath + System.getProperty("file.separator") + nativeLibName + ".manifest";
            this.trace("current manifest file to compare to: " + currentManifestFile);
            oManifestFile = new FileInputStream(currentManifestFile);
        }
        catch (FileNotFoundException e) {
            this.trace("Manifest file not found.  Assuming different version.");
            differentVersion = true;
        }
        if (oManifestFile != null) {
            Manifest oManifest = new Manifest(oManifestFile);
            Attributes oAttr = oManifest.getMainAttributes();
            String oVersion = oAttr.getValue("Implementation-Version");
            this.trace("Deployed implementation version is " + oVersion);
            if (oVersion != null && oVersion.compareToIgnoreCase(cVersion) == 0) {
                differentVersion = false;
            }
            oManifestFile.close();
        }
        return differentVersion;
    }

    private String getLibExt() {
        String libExt = System.getProperty("java.home") + System.getProperty("file.separator") + "bin" + System.getProperty("file.separator");
        File libExtDir = new File(libExt);
        if (!libExtDir.exists()) {
            libExtDir.mkdir();
        }
        return libExt;
    }

    public boolean traceEnabled() {
        return false;
    }

    public void trace(String message) {
        System.out.println("PStreamingDocServicesCallbacks.trace -- " + message);
    }
}

