/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer.applets;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.CMBViewerAction;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import com.ibm.mm.viewer.applets.CMBDocumentViewerApplet;
import com.ibm.mm.viewer.applets.PAppletUtilities;
import com.ibm.mm.viewer.applets.PAppletUtils;
import com.ibm.mm.viewer.applets.PDocumentInfo;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

class POpenDocumentAction
extends CMBViewerAction {
    CMBGenericDocViewer gdv;

    public POpenDocumentAction(CMBGenericDocViewer gdv, String name) {
        super(gdv, name);
        this.gdv = gdv;
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser fileChooser = new JFileChooser();
        if (fileChooser.showOpenDialog(this.gdv) == 0) {
            File file = fileChooser.getSelectedFile();
            String docUrlString = "file:///" + file.getAbsolutePath();
            String mimeType = PAppletUtils.getMimeType(PAppletUtils.getExtension(file.getAbsolutePath()));
            PDocumentInfo docInfo = new PDocumentInfo(file.getAbsolutePath(), docUrlString, mimeType);
            POpenDocumentAction.openDocument((CMBDocumentViewerApplet)this.gdv.getParent().getParent().getParent().getParent(), docInfo, true);
        }
    }

    public static void openDocument(CMBDocumentViewerApplet applet, final PDocumentInfo docInfo, final boolean activate) {
        String methodName = "openDocument";
        final CMBGenericDocViewer gdv = applet.getGenericDocViewer();
        String docUrlString = docInfo.contentPartUrls[0];
        String strMime = docInfo.contentPartMimeTypes[0];
        final String documentName = docInfo.documentName;
        int partCount = docInfo.contentPartCount;
        URL docURL = null;
        URLConnection docURLConn = null;
        InputStream docInputStream = null;
        try {
            docURL = new URL(applet.getCodeBase(), docUrlString);
        }
        catch (MalformedURLException e) {
            ViewerLogger.logWarning(POpenDocumentAction.class, methodName, PAppletUtilities.getMessage("Applets.incorrectDocURL"));
            ViewerLogger.logError(POpenDocumentAction.class, methodName, e);
            return;
        }
        try {
            CMBAnnotationSet annSet;
            docURLConn = docURL.openConnection();
            if (docURLConn instanceof HttpURLConnection) {
                HttpURLConnection httpURLConn = (HttpURLConnection)docURLConn;
                httpURLConn.connect();
            }
            docInputStream = docURLConn.getInputStream();
            if (strMime == null) {
                strMime = docURLConn.getContentType();
            }
            String charset = docURLConn.getContentEncoding();
            final CMBDocument document = applet.getStreamingDocServices().loadDocument(docInputStream, partCount, strMime, strMime, null, null, charset);
            int annotationPosition = document.getAnnotationPosition();
            applet.getStreamingDocServices().setItemHandle(document, docInfo);
            InputStream annis = null;
            if (docInfo.annotationPartCount > 0) {
                try {
                    URL annFileURL = new URL(applet.getCodeBase(), docInfo.annotationPartUrls[0]);
                    URLConnection annFileURLConn = annFileURL.openConnection();
                    annis = annFileURLConn.getInputStream();
                }
                catch (Exception e) {
                    ViewerLogger.logWarning(POpenDocumentAction.class, methodName, PAppletUtilities.getMessage("Applets.incorrectAnnotationURL"));
                    ViewerLogger.logError(POpenDocumentAction.class, methodName, e);
                    annis = null;
                }
            }
            if (annis == null) {
                annis = new ByteArrayInputStream(new byte[0]);
            }
            Object annSet1 = null;
            try {
                annSet = applet.getGenericDocViewer().loadAnnotations(annis, "application/vnd.ibm.modcap", annotationPosition, 1, 0);
                applet.getAnnotationServices().setItemHandle(annSet, docInfo);
            }
            catch (Exception e) {
                ViewerLogger.logError(POpenDocumentAction.class, methodName, PAppletUtilities.getMessage("Applets.errorLoadingAnnotations"));
                ViewerLogger.logError(POpenDocumentAction.class, methodName, e);
                return;
            }
            if (document == null) {
                ViewerLogger.logWarning(POpenDocumentAction.class, methodName, "DocViewerApplet.openDocument() - currDocument is null");
                return;
            }
            String finalDocFileName = docUrlString;
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        gdv.setCursor(Cursor.getPredefinedCursor(3));
                        gdv.showDocument(document, annSet, documentName, activate);
                        gdv.setPrivilege(document, 7, docInfo.exportPrivilege);
                        gdv.setPrivilege(document, 6, docInfo.printPrivilege);
                        gdv.setPrivilege(document, 1, false);
                        gdv.setPrivilege(document, 3, docInfo.contentEditPrivilege);
                        gdv.setPrivilege(document, 2, docInfo.contentEditPrivilege);
                        gdv.setPrivilege(document, 5, docInfo.contentEditPrivilege);
                        gdv.setPrivilege(document, 4, docInfo.contentEditPrivilege);
                        if (docInfo.lockedByUser != null) {
                            JOptionPane.showMessageDialog(gdv, PAppletUtilities.getMessage("Applets.documentLocked", new Object[]{docInfo.lockedByUser}), "Document Locked", 1);
                        }
                        Object var2_1 = null;
                        gdv.setCursor(Cursor.getDefaultCursor());
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        gdv.setCursor(Cursor.getDefaultCursor());
                        throw throwable;
                    }
                }
            });
        }
        catch (Throwable e) {
            ViewerLogger.logError(POpenDocumentAction.class, methodName, e);
            return;
        }
    }
}

