/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer.applets;

import java.awt.ComponentOrientation;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;

class PAppletUtilities {
    static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private static String RESOURCE_BASE_NAME = "com.ibm.mm.viewer.applets.CMBAppletMessages";
    private static final int MAX_BUNDLE_NAMES = 4;
    private static ResourceBundle appletMessages = null;
    private static Vector availableBundles = new Vector(4);
    private static int IO_BUFFER_LENGTH = 4096;

    PAppletUtilities() {
    }

    private static String getMessageString(String messageKey) {
        String message = messageKey;
        try {
            message = PAppletUtilities.getResourceBundle().getString(messageKey);
            return message;
        }
        catch (MissingResourceException mre) {
            int size = availableBundles.size();
            for (int i = size - 1; i > 0; --i) {
                try {
                    return ((ResourceBundle)availableBundles.elementAt(i)).getString(messageKey);
                }
                catch (MissingResourceException me) {
                    continue;
                }
            }
            return messageKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Vector availableBundlesFor(String name) {
        Vector bundleNames = new Vector(4);
        Vector<PropertyResourceBundle> returnBundles = new Vector<PropertyResourceBundle>(4);
        bundleNames = PAppletUtilities.calculateBundleNames(name.replace('.', '/'), Locale.getDefault());
        InputStream stream = null;
        String resPathName = name.replace('.', '/');
        int size = bundleNames.size();
        for (int i = 0; i < size; ++i) {
            resPathName = (String)bundleNames.elementAt(i) + ".properties";
            URL myurl = PAppletUtilities.class.getClassLoader().getResource(resPathName);
            if (myurl != null) {
                try {
                    URLConnection myconn = myurl.openConnection();
                    myconn.setUseCaches(true);
                    stream = myconn.getInputStream();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (stream == null) continue;
            stream = new BufferedInputStream(stream);
            PropertyResourceBundle bundle = new PropertyResourceBundle(stream);
            returnBundles.insertElementAt(bundle, 0);
            Object var11_11 = null;
            try {
                stream.close();
            }
            catch (Exception e2) {}
            continue;
            {
                catch (Exception e) {
                    var11_11 = null;
                    try {
                        stream.close();
                    }
                    catch (Exception e2) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var11_11 = null;
                try {
                    stream.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return returnBundles;
    }

    private static ResourceBundle getResourceBundle() {
        if (appletMessages == null && !(availableBundles = PAppletUtilities.availableBundlesFor(RESOURCE_BASE_NAME)).isEmpty()) {
            appletMessages = (PropertyResourceBundle)availableBundles.elementAt(0);
        }
        return appletMessages;
    }

    private static Vector calculateBundleNames(String baseName, Locale locale) {
        Vector<String> result = new Vector<String>(4);
        String language = locale.getLanguage();
        int languageLength = language.length();
        String country = locale.getCountry();
        int countryLength = country.length();
        String variant = locale.getVariant();
        int variantLength = variant.length();
        result.addElement(baseName);
        if (languageLength + countryLength + variantLength == 0) {
            return result;
        }
        if (language.equals("en") && (country.equals("US") || country.equals("")) && variant.equals("")) {
            return result;
        }
        StringBuffer temp = new StringBuffer(baseName);
        temp.append('_');
        temp.append(language);
        result.addElement(temp.toString());
        if (countryLength + variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(country);
        result.addElement(temp.toString());
        if (variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(variant);
        result.addElement(temp.toString());
        return result;
    }

    public static String getMessage(String messageKey) {
        try {
            return PAppletUtilities.getMessageString(messageKey);
        }
        catch (Throwable e) {
            return "";
        }
    }

    public static String getMessage(String messageKey, Object[] args) {
        try {
            String message = PAppletUtilities.getMessageString(messageKey);
            message = MessageFormat.format(message, args);
            return message;
        }
        catch (Throwable e) {
            return "";
        }
    }

    public static boolean isLeftToRight() {
        try {
            return ComponentOrientation.getOrientation(Locale.getDefault()).isLeftToRight();
        }
        catch (Throwable t) {
            return true;
        }
    }
}

