/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer.applets;

import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.CMBStreamingDocServices;
import com.ibm.mm.viewer.annotation.CMBAnnotationServices;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import com.ibm.mm.viewer.applets.PAnnotationServicesCallbacks;
import com.ibm.mm.viewer.applets.PAppletUtilities;
import com.ibm.mm.viewer.applets.PClosedDocumentHandler;
import com.ibm.mm.viewer.applets.PDocumentInfo;
import com.ibm.mm.viewer.applets.POpenDocumentAction;
import com.ibm.mm.viewer.applets.PSaveDocumentHandler;
import com.ibm.mm.viewer.applets.PStreamingDocServicesCallbacks;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class CMBDocumentViewerApplet
extends JApplet {
    static final long serialVersionUID = 0L;
    private Properties currConfigProperties = null;
    private CMBStreamingDocServices docServices;
    private CMBAnnotationServices annoServices;
    private CMBGenericDocViewer gdv;
    private Hashtable docToURL = new Hashtable();

    public void init() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.getRootPane().putClientProperty("defeatSystemEventQueueCheck", Boolean.TRUE);
        this.getContentPane().setLayout(new BorderLayout());
        URL configURL = null;
        URLConnection configURLConn = null;
        InputStream configInputStream = null;
        this.currConfigProperties = new Properties();
        try {
            String configPropertiesFile = this.getParameter("propertiesFile");
            if (configPropertiesFile == null) {
                InputStream defaultConfigStream = this.getClass().getClassLoader().getResourceAsStream("com/ibm/mm/viewer/applets/CMBDocumentViewerApplet.properties");
                this.currConfigProperties.load(defaultConfigStream);
            } else {
                configURL = new URL(this.getCodeBase(), configPropertiesFile);
                configURLConn = configURL.openConnection();
                configInputStream = configURLConn.getInputStream();
                this.currConfigProperties.load(configInputStream);
            }
        }
        catch (MalformedURLException e) {
            System.out.println(PAppletUtilities.getMessage("Applets.incorrectConfigURL"));
            System.out.println(e);
        }
        catch (IOException e) {
            System.out.println(PAppletUtilities.getMessage("Applets.ioErrorLoadingConfiguration"));
            System.out.println(e);
        }
        this.gdv = new CMBGenericDocViewer(this.getStreamingDocServices(), this.getAnnotationServices(), this.currConfigProperties);
        this.getContentPane().add((Component)this.gdv, "Center");
        this.gdv.setBackground(Color.white);
        this.gdv.addDocSaveListener(new PSaveDocumentHandler(this));
        this.gdv.addDocClosedListener(new PClosedDocumentHandler(this));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PDocumentInfo docinfo = new PDocumentInfo(CMBDocumentViewerApplet.this);
                POpenDocumentAction.openDocument(CMBDocumentViewerApplet.this, docinfo, true);
            }
        });
    }

    public void destroy() {
        this.gdv.terminate(false);
    }

    public boolean needsSave() {
        CMBAnnotationSet[] annotationSets = this.annoServices.getAllAnnotationSets();
        for (int i = 0; i < annotationSets.length; ++i) {
            if (!annotationSets[i].isDirty()) continue;
            return true;
        }
        CMBDocument[] documents = this.docServices.getDocuments();
        for (int i = 0; i < documents.length; ++i) {
            if (!documents[i].isModified()) continue;
            return true;
        }
        return false;
    }

    public void closeAllDocuments() {
        this.gdv.closeAllDocuments();
    }

    public CMBGenericDocViewer getGenericDocViewer() {
        return this.gdv;
    }

    public void openDocument(final String docName, final String docUrl, final String strMime, final boolean activate) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PDocumentInfo docinfo = new PDocumentInfo(docName, docUrl, strMime);
                POpenDocumentAction.openDocument(CMBDocumentViewerApplet.this, docinfo, activate);
            }
        });
    }

    public CMBStreamingDocServices getStreamingDocServices() {
        if (this.docServices == null) {
            String resourceUrlPrefix = this.getParameter("documentResourceUrlPrefix");
            if (resourceUrlPrefix != null) {
                this.currConfigProperties.put("overlayPath", this.getParameter("documentResourceUrlPrefix"));
            }
            this.docServices = new CMBStreamingDocServices(new PStreamingDocServicesCallbacks(this), this.currConfigProperties);
        }
        return this.docServices;
    }

    public CMBAnnotationServices getAnnotationServices() {
        if (this.annoServices == null) {
            this.annoServices = new CMBAnnotationServices(new PAnnotationServicesCallbacks(this));
        }
        return this.annoServices;
    }
}

