/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer.annotation;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.annotation.CMBStampAnnotation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

class StampObject {
    Color borderColor = CMBStampAnnotation.defaultBorderColor;
    Color fillColor = CMBStampAnnotation.defaultFillColor;
    int borderWidth = CMBStampAnnotation.defaultBorderWidth;
    int stampAngle = CMBStampAnnotation.defaultAngle;
    Font stampFont = CMBStampAnnotation.defaultFont;
    String stampText = CMBStampAnnotation.defaultText;
    boolean imageStamp = CMBStampAnnotation.defaultIsImageStamp;
    byte[] imageData = CMBStampAnnotation.defaultImageData;
    String imageURL;
    Dimension imageSize;
    boolean transparent = true;
    boolean rotateWithImage = CMBStampAnnotation.defaultRotate;

    StampObject() {
    }

    void updateValuesFromAnnotation(CMBStampAnnotation aStamp) {
        if (aStamp == null) {
            return;
        }
        this.borderColor = aStamp.getBorderColor();
        this.fillColor = aStamp.getFillColor();
        this.borderWidth = aStamp.getBorderWidth();
        this.stampAngle = aStamp.getStampAngle();
        this.stampFont = aStamp.getFont();
        this.stampText = aStamp.getStampText();
        this.imageStamp = aStamp.isImageStamp();
        this.transparent = aStamp.getTransparent();
        this.rotateWithImage = aStamp.getRotateWithImage();
        this.imageSize = this.imageStamp ? aStamp.getImageSize() : aStamp.getDrawRect().getSize();
        this.imageData = aStamp.getImageData();
        this.imageURL = null;
    }

    void updateAnnotation(CMBStampAnnotation aStamp) {
        if (aStamp == null) {
            return;
        }
        aStamp.setTransparent(this.transparent);
        aStamp.setBorderColor(this.borderColor);
        aStamp.setFillColor(this.fillColor);
        aStamp.setBorderWidth(this.borderWidth);
        aStamp.setStampAngle(this.stampAngle);
        aStamp.setFont(this.stampFont);
        aStamp.setStampText(this.stampText);
        aStamp.setImageStamp(this.imageStamp);
        aStamp.setRotateWithImage(this.rotateWithImage);
        if (this.retrieveImageData()) {
            aStamp.setImageData(this.imageData);
            if (this.imageSize != null) {
                aStamp.setImageSize(this.imageSize);
            }
        }
        aStamp.updateValues(102);
    }

    String getText() {
        return this.stampText;
    }

    void setText(String text) {
        this.stampText = text;
    }

    boolean retrieveImageData() {
        String methodName = "retrieveImageData";
        if (this.imageData != null) {
            return true;
        }
        if (this.imageURL != null) {
            URL iconUrl0 = this.getClass().getClassLoader().getResource(this.imageURL);
            try {
                URLConnection conn = iconUrl0.openConnection();
                conn.setUseCaches(true);
                BufferedInputStream imStream = new BufferedInputStream(conn.getInputStream());
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                int read = 0;
                byte[] buff = new byte[4096];
                read = ((InputStream)imStream).read(buff);
                while (read != -1) {
                    bos.write(buff, 0, read);
                    read = ((InputStream)imStream).read(buff);
                }
                this.imageData = bos.toByteArray();
                this.imageStamp = true;
            }
            catch (IOException e) {
                ViewerLogger.logError((Object)this, methodName, e);
                return false;
            }
            return true;
        }
        return false;
    }
}

