/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer.annotation;

import com.ibm.mm.viewer.annotation.CMBAnnotationServices;
import com.ibm.mm.viewer.annotation.PAnnotationUtilities;
import com.ibm.mm.viewer.annotation.PImageSelectDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRelationSet;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class PTextOrImagePropertiesEditor
extends JPanel
implements ActionListener {
    private static final String copyright = "Licensed Materials - Property of IBM\nIBM DB2 Content Manager Enterprise Edition V8 (program number 5724-B19)\n(c ) Copyright IBM Corp.  1998, 2004.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private boolean isimage;
    private byte[] imageData;
    private Dimension imageSize;
    private String imageFileName;
    private ArrayList changeListeners;
    private ArrayList actionListeners;
    private JTextField textField;
    private JTextField imageFileNameField;
    private JButton imageSelectButton;
    private JRadioButton textRadioButton;
    private JRadioButton imageRadioButton;
    private ButtonGroup radioButtonGroup;
    private PImageSelectDialog imageSelectDialog;
    private CMBAnnotationServices annotationServices;

    public PTextOrImagePropertiesEditor(CMBAnnotationServices annotationServices) {
        this.initLayout();
        this.annotationServices = annotationServices;
    }

    public boolean isImageStamp() {
        return this.isimage;
    }

    public void setImageStamp(boolean isimage) {
        if (this.isimage != isimage) {
            this.isimage = isimage;
            if (isimage) {
                this.getImageRadioButton().setSelected(true);
                if (this.imageFileName != null) {
                    this.getImageFileNameField().setText(this.nameWithoutPath(this.imageFileName));
                } else {
                    this.getImageFileNameField().setText(this.getTextField().getText());
                    this.imageFileName = this.getImageFileNameField().getText();
                }
                this.getImageSelectButton().setEnabled(true);
                this.getTextRadioButton().setSelected(false);
                this.getTextField().setText("");
                this.getTextField().setEditable(false);
            } else {
                this.getTextRadioButton().setSelected(true);
                this.getTextField().setText(this.getImageFileNameField().getText());
                this.getTextField().setEditable(true);
                this.getImageRadioButton().setSelected(false);
                this.getImageFileNameField().setText("");
                this.getImageSelectButton().setEnabled(false);
            }
        }
    }

    public String getStampText() {
        if (this.isImageStamp()) {
            return this.imageFileName;
        }
        return this.textField.getText();
    }

    public void setStampText(String text) {
        this.textField.setText(text);
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public void setImageData(byte[] imageData) {
        this.imageData = imageData;
    }

    public Dimension getImageSize() {
        return this.imageSize;
    }

    public void setImageSize(Dimension imageSize) {
        this.imageSize = imageSize;
    }

    public String getImageFileName() {
        return this.imageFileName;
    }

    public void setImageFileName(String imageFileName) {
        this.imageFileName = imageFileName;
        this.getImageFileNameField().setText(this.nameWithoutPath(imageFileName));
    }

    private String nameWithoutPath(String fileName) {
        int pathdelimindex = -1;
        if (fileName != null) {
            pathdelimindex = fileName.lastIndexOf(File.separatorChar);
        }
        if (pathdelimindex > 0) {
            return this.imageFileName.substring(pathdelimindex + 1);
        }
        return this.imageFileName;
    }

    public void addChangeListener(ChangeListener l) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList();
        }
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(l);
        }
    }

    public void addActionListener(ActionListener l) {
        if (this.actionListeners == null) {
            this.actionListeners = new ArrayList();
        }
        this.actionListeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        if (this.actionListeners != null) {
            this.actionListeners.remove(l);
        }
    }

    public void removeAllActionListeners() {
        if (this.actionListeners != null) {
            this.actionListeners.clear();
        }
    }

    private void initLayout() {
        GridBagConstraints gbConstraintsTextRadio = new GridBagConstraints();
        gbConstraintsTextRadio.gridy = 0;
        gbConstraintsTextRadio.gridx = 0;
        gbConstraintsTextRadio.anchor = 21;
        GridBagConstraints gbConstraintsTextField = new GridBagConstraints();
        gbConstraintsTextField.fill = 2;
        gbConstraintsTextField.weightx = 1.0;
        gbConstraintsTextField.gridy = 0;
        gbConstraintsTextField.gridx = 1;
        GridBagConstraints gbConstraintsImageRadio = new GridBagConstraints();
        gbConstraintsImageRadio.gridy = 1;
        gbConstraintsImageRadio.gridx = 0;
        gbConstraintsImageRadio.anchor = 21;
        GridBagConstraints gbConstraintsImageFileNameField = new GridBagConstraints();
        gbConstraintsImageFileNameField.fill = 2;
        gbConstraintsImageFileNameField.weightx = 1.0;
        gbConstraintsImageFileNameField.gridy = 1;
        gbConstraintsImageFileNameField.gridx = 1;
        GridBagConstraints gbConstraintsImageSelectButton = new GridBagConstraints();
        gbConstraintsImageSelectButton.gridy = 1;
        gbConstraintsImageSelectButton.gridx = 2;
        gbConstraintsImageSelectButton.gridheight = 3;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getTextRadioButton(), gbConstraintsTextRadio);
        this.add((Component)this.getTextField(), gbConstraintsTextField);
        this.add((Component)this.getImageRadioButton(), gbConstraintsImageRadio);
        this.add((Component)this.getImageFileNameField(), gbConstraintsImageFileNameField);
        this.add((Component)this.getImageSelectButton(), gbConstraintsImageSelectButton);
        this.radioButtonGroup = new ButtonGroup();
        this.radioButtonGroup.add(this.getTextRadioButton());
        this.radioButtonGroup.add(this.getImageRadioButton());
        this.applyComponentOrientation(PAnnotationUtilities.getComponentOrientation());
    }

    public JRadioButton getTextRadioButton() {
        if (this.textRadioButton == null) {
            this.textRadioButton = new JRadioButton(PAnnotationUtilities.getMessage("Annotation.stampText"));
            this.textRadioButton.setMnemonic(PAnnotationUtilities.getMessage("Annotation.stampText.mnemonic").charAt(0));
            this.textRadioButton.addActionListener(this);
            this.textRadioButton.setSelected(!this.isImageStamp());
            AccessibleContext aContext = this.textRadioButton.getAccessibleContext();
            AccessibleRelationSet relSet = aContext.getAccessibleRelationSet();
            AccessibleRelation grouped = new AccessibleRelation(AccessibleRelation.MEMBER_OF, this);
            relSet.add(grouped);
        }
        return this.textRadioButton;
    }

    JTextField getTextField() {
        if (this.textField == null) {
            this.textField = new JTextField();
            this.textField.getAccessibleContext().setAccessibleName(PAnnotationUtilities.getMessage("Annotation.stampText"));
        }
        return this.textField;
    }

    public JRadioButton getImageRadioButton() {
        if (this.imageRadioButton == null) {
            this.imageRadioButton = new JRadioButton(PAnnotationUtilities.getMessage("Annotation.stampImage"));
            this.imageRadioButton.setMnemonic(PAnnotationUtilities.getMessage("Annotation.stampImage.mnemonic").charAt(0));
            this.imageRadioButton.addActionListener(this);
            this.imageRadioButton.setSelected(this.isImageStamp());
            AccessibleContext aContext = this.imageRadioButton.getAccessibleContext();
            AccessibleRelationSet relSet = aContext.getAccessibleRelationSet();
            AccessibleRelation grouped = new AccessibleRelation(AccessibleRelation.MEMBER_OF, this);
            relSet.add(grouped);
        }
        return this.imageRadioButton;
    }

    private JTextField getImageFileNameField() {
        if (this.imageFileNameField == null) {
            this.imageFileNameField = new JTextField();
            this.imageFileNameField.setEditable(false);
            this.imageFileNameField.setFocusable(false);
        }
        return this.imageFileNameField;
    }

    JButton getImageSelectButton() {
        if (this.imageSelectButton == null) {
            this.imageSelectButton = new JButton(PAnnotationUtilities.getMessage("Annotation.ellipsis"));
            this.imageSelectButton.getAccessibleContext().setAccessibleName(PAnnotationUtilities.getMessage("Annotation.stampImage"));
            if (!this.isimage) {
                this.imageSelectButton.setEnabled(false);
            }
            this.imageSelectButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PTextOrImagePropertiesEditor.this.onSelectImage();
                }
            });
        }
        return this.imageSelectButton;
    }

    private void onSelectImage() {
        Container c;
        for (c = this.getParent(); c != null && !(c instanceof JFrame) && !(c instanceof Dialog); c = c.getParent()) {
        }
        this.imageSelectDialog = c instanceof JFrame ? new PImageSelectDialog((JFrame)c, this.annotationServices) : new PImageSelectDialog((Dialog)c, this.annotationServices);
        this.imageSelectDialog.setImageData(this.getImageData());
        this.imageSelectDialog.setImageFileNameNoValidation(this.getImageFileName());
        this.imageSelectDialog.setImageSize(this.getImageSize());
        this.imageSelectDialog.show();
        if (this.imageSelectDialog.isOkPressed()) {
            this.setImageStamp(true);
            this.setStampText(null);
            this.setImageData(this.imageSelectDialog.getImageData());
            this.setImageSize(this.imageSelectDialog.getImageSize());
            this.setImageFileName(this.imageSelectDialog.getImageFileName());
            this.fireChangedEvent();
        }
        this.imageSelectDialog = null;
    }

    public void fireChangedEvent() {
        if (this.changeListeners != null) {
            ChangeEvent e = new ChangeEvent(this);
            for (int i = 0; i < this.changeListeners.size(); ++i) {
                ((ChangeListener)this.changeListeners.get(i)).stateChanged(e);
            }
        }
    }

    public void dispose() {
        if (this.imageSelectDialog != null) {
            this.imageSelectDialog.dispose();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.getTextRadioButton().isSelected()) {
            this.setImageStamp(false);
            this.getTextField().setFocusable(true);
            this.getImageSelectButton().setFocusable(false);
        } else if (this.getImageRadioButton().isSelected()) {
            this.setImageStamp(true);
            this.getImageSelectButton().setFocusable(true);
            this.getTextField().setFocusable(false);
        }
        if (this.actionListeners != null) {
            for (int i = 0; i < this.actionListeners.size(); ++i) {
                ((ActionListener)this.actionListeners.get(i)).actionPerformed(e);
            }
        }
    }
}

