/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer.annotation;

import com.ibm.mm.viewer.annotation.CMBAnnotationPropertiesListener;
import com.ibm.mm.viewer.annotation.CMBAnnotationServices;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import com.ibm.mm.viewer.annotation.CMBStampAnnotation;
import com.ibm.mm.viewer.annotation.PAnnotationUtilities;
import com.ibm.mm.viewer.annotation.PEditStampDialog;
import com.ibm.mm.viewer.annotation.PNewStampDialog;
import com.ibm.mm.viewer.annotation.StampObject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class PStampSelectPanel
extends JPanel
implements CMBAnnotationPropertiesListener {
    private static final String copyright = "Licensed Materials - Property of IBM\nIBM DB2 Content Manager Enterprise Edition V8 (program number 5724-B19)\n(c ) Copyright IBM Corp.  1998, 2004.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private JList stampList;
    private JButton newStamp;
    private JButton editStamp;
    private JButton deleteStamp;
    private JPanel previewPanel;
    private StampPreviewLabel previewLabel;
    private Vector availableStamps;
    private Icon normalStampIcon;
    private Icon imageStampIcon;
    private CMBStampAnnotation theStamp;
    private boolean updatingAnnotationValues;
    private PNewStampDialog newStampDialog;
    private PEditStampDialog editStampDialog;
    private CMBAnnotationServices annotationServices;

    public PStampSelectPanel(CMBStampAnnotation stamp, CMBAnnotationServices annotationServices) {
        this.annotationServices = annotationServices;
        boolean ltr = PAnnotationUtilities.isLeftToRight();
        ComponentOrientation compOri = ComponentOrientation.LEFT_TO_RIGHT;
        float alignmentX = 0.0f;
        if (!ltr) {
            compOri = ComponentOrientation.RIGHT_TO_LEFT;
            alignmentX = 1.0f;
        }
        this.setLayout(new BorderLayout());
        this.setSize(200, 200);
        this.theStamp = stamp;
        StampObject defaultStampObject = new StampObject();
        defaultStampObject.updateValuesFromAnnotation(this.theStamp);
        if (CMBStampAnnotation.defaultAvailableStamps == null) {
            this.availableStamps = new Vector();
            this.availableStamps.addElement(defaultStampObject);
        } else {
            this.availableStamps = CMBStampAnnotation.defaultAvailableStamps;
        }
        this.normalStampIcon = annotationServices.getImageIcon("Stamp_normal.gif");
        this.imageStampIcon = annotationServices.getImageIcon("ImageStamp.gif");
        this.stampList = new StampList(compOri, this.availableStamps, defaultStampObject);
        JScrollPane listScroll = new JScrollPane(this.stampList);
        JPanel topBox = new JPanel(new BorderLayout());
        int titleJustfication = ltr ? 1 : 3;
        topBox.setBorder(PAnnotationUtilities.getTitledBorder(PAnnotationUtilities.getMessage("Stamp.listName"), titleJustfication, 2));
        JPanel buttonBox = new JPanel(new GridLayout(3, 1, 5, 5));
        this.newStamp = new JButton(PAnnotationUtilities.getMessage("Stamp.newStamp"));
        this.newStamp.setMnemonic(PAnnotationUtilities.getMessage("Stamp.newStamp.mnemonic").charAt(0));
        this.newStamp.setAlignmentX(alignmentX);
        this.editStamp = new JButton(PAnnotationUtilities.getMessage("Stamp.edit"));
        this.editStamp.setMnemonic(PAnnotationUtilities.getMessage("Stamp.edit.mnemonic").charAt(0));
        this.editStamp.setAlignmentX(alignmentX);
        this.deleteStamp = new JButton(PAnnotationUtilities.getMessage("Stamp.delete"));
        this.deleteStamp.setMnemonic(PAnnotationUtilities.getMessage("Stamp.delete.mnemonic").charAt(0));
        this.deleteStamp.setAlignmentX(alignmentX);
        buttonBox.setComponentOrientation(compOri);
        buttonBox.add(this.newStamp);
        buttonBox.add(this.editStamp);
        buttonBox.add(this.deleteStamp);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        buttonPanel.add((Component)buttonBox, "North");
        topBox.add((Component)listScroll, "Center");
        topBox.add((Component)buttonPanel, "After");
        Box bottomBox = Box.createHorizontalBox();
        this.previewPanel = new JPanel();
        this.previewPanel.setBorder(PAnnotationUtilities.getTitledBorder(PAnnotationUtilities.getMessage("Stamp.preview"), titleJustfication, 2));
        this.previewLabel = new StampPreviewLabel();
        this.previewPanel.setLayout(new BorderLayout());
        this.previewPanel.add("Center", this.previewLabel);
        bottomBox.add(this.previewPanel);
        this.add((Component)topBox, "Center");
        this.add((Component)bottomBox, "South");
        this.stampList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent event) {
                if (!event.getValueIsAdjusting()) {
                    JList src = (JList)event.getSource();
                    StampObject obj = (StampObject)src.getSelectedValue();
                    PStampSelectPanel.this.previewLabel.setStampObject(obj);
                    if (obj != null) {
                        PStampSelectPanel.this.updatingAnnotationValues = true;
                        obj.updateAnnotation(PStampSelectPanel.this.theStamp);
                        PStampSelectPanel.this.updatingAnnotationValues = false;
                        PStampSelectPanel.this.editStamp.setEnabled(true);
                        PStampSelectPanel.this.deleteStamp.setEnabled(true);
                    } else {
                        PStampSelectPanel.this.editStamp.setEnabled(false);
                        PStampSelectPanel.this.deleteStamp.setEnabled(false);
                    }
                }
            }
        });
        this.newStamp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PStampSelectPanel.this.addNewStamp();
            }
        });
        this.editStamp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PStampSelectPanel.this.editStamp();
            }
        });
        this.deleteStamp.setEnabled(false);
        this.deleteStamp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PStampSelectPanel.this.deleteStamp();
            }
        });
    }

    void setDummyStamp(CMBStampAnnotation stamp) {
        this.theStamp = stamp;
        StampObject obj = (StampObject)this.stampList.getSelectedValue();
        this.previewLabel.setStampObject(obj);
        if (obj != null) {
            obj.updateAnnotation(this.theStamp);
        }
    }

    private void addNewStamp() {
        this.newStampDialog = new PNewStampDialog(this, this.annotationServices);
        this.newStampDialog.show();
        StampObject obj = this.newStampDialog.getStampObject();
        if (this.newStampDialog.isOkPressed()) {
            this.availableStamps.addElement(obj);
            this.stampList.setListData(this.availableStamps);
            this.stampList.setSelectedValue(obj, true);
            this.previewLabel.setStampObject(obj);
            if (this.availableStamps.size() > 1) {
                this.deleteStamp.setEnabled(true);
            }
        }
        this.newStampDialog = null;
    }

    private void editStamp() {
        StampObject obj = (StampObject)this.stampList.getSelectedValue();
        this.editStampDialog = new PEditStampDialog(this, this.annotationServices);
        this.editStampDialog.editStampObject(obj);
        this.editStampDialog.show();
        if (this.editStampDialog.isOkPressed()) {
            this.editStampDialog.updateStampObject(obj);
            this.updatingAnnotationValues = true;
            obj.updateAnnotation(this.theStamp);
            this.updatingAnnotationValues = false;
            this.previewLabel.setStampObject(obj);
        }
        this.editStampDialog = null;
    }

    private void deleteStamp() {
        StampObject obj = (StampObject)this.stampList.getSelectedValue();
        int index = this.stampList.getSelectedIndex();
        int size = this.availableStamps.size();
        if (size == 1) {
            return;
        }
        this.availableStamps.remove(obj);
        this.stampList.setListData(this.availableStamps);
        if (index - 1 >= 0) {
            this.stampList.setSelectedIndex(index - 1);
        } else if (index == 0 && size > 1) {
            this.stampList.setSelectedIndex(index);
        } else {
            this.theStamp = null;
        }
        if (this.availableStamps.size() <= 1) {
            this.deleteStamp.setEnabled(false);
        }
        if ((obj = (StampObject)this.stampList.getSelectedValue()) != null) {
            this.previewLabel.setStampObject(obj);
        }
        this.stampList.paintImmediately(this.stampList.getBounds());
    }

    public void handleAnnPropChangedEvent(CMBPageAnnotation a) {
        StampObject obj = (StampObject)this.stampList.getSelectedValue();
        if (obj == null) {
            return;
        }
        if (!this.updatingAnnotationValues) {
            obj.updateValuesFromAnnotation(this.theStamp);
        }
        this.previewLabel.setStampObject(obj);
        this.stampList.paintImmediately(this.stampList.getBounds());
    }

    public void handleAnnPropWillChangeEvent(CMBPageAnnotation a) {
        if (SwingUtilities.getWindowAncestor(this) != null && SwingUtilities.getWindowAncestor(this).isVisible()) {
            a.setApplyNow(true);
        }
    }

    public Vector getAvailableStamps() {
        return this.availableStamps;
    }

    public void setAvailableStamps(Vector stamps) {
        if (stamps != null) {
            this.availableStamps = stamps;
            this.stampList.setListData(this.availableStamps);
            this.setDefaultStamp(CMBStampAnnotation.defaultText, CMBStampAnnotation.defaultBorderColor, CMBStampAnnotation.defaultBorderWidth, CMBStampAnnotation.defaultFillColor, CMBStampAnnotation.defaultAngle, CMBStampAnnotation.defaultFont);
            if (this.availableStamps.size() > 1) {
                this.deleteStamp.setEnabled(true);
            } else {
                this.deleteStamp.setEnabled(false);
            }
        }
    }

    public void setDefaultStamp(String stampText, Color borderColor, int borderWidth, Color fillColor, int stampAngle, Font stampFont) {
        Object obj = null;
        for (int i = 0; i < this.availableStamps.size() && obj == null; ++i) {
            StampObject availObj = (StampObject)this.availableStamps.elementAt(i);
            if (!availObj.stampText.equals(stampText) || !availObj.borderColor.equals(borderColor) || availObj.borderWidth != borderWidth || !availObj.fillColor.equals(fillColor) || availObj.stampAngle != stampAngle || !availObj.stampFont.equals(stampFont)) continue;
            obj = this.availableStamps.elementAt(i);
        }
        if (obj != null) {
            this.stampList.setSelectedValue(obj, true);
        } else {
            this.stampList.setSelectedIndex(0);
        }
    }

    public void dispose() {
        if (this.newStampDialog != null) {
            this.newStampDialog.dispose();
        }
        if (this.editStampDialog != null) {
            this.editStampDialog.dispose();
        }
    }

    protected class StampCellRenderer
    extends JPanel
    implements ListCellRenderer {
        JLabel iconLabel = new JLabel();
        JTextField textField = new JTextField();
        protected Border noFocusBorder;

        StampCellRenderer() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.iconLabel, "Before");
            this.add((Component)this.textField, "Center");
            this.applyComponentOrientation(PAnnotationUtilities.getComponentOrientation());
            if (this.noFocusBorder == null) {
                this.noFocusBorder = new EmptyBorder(1, 1, 1, 1);
            }
            this.setOpaque(true);
            this.setBorder(this.noFocusBorder);
            this.textField.setBorder(this.noFocusBorder);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            StampObject obj = (StampObject)value;
            this.setOpaque(true);
            if (obj.imageStamp) {
                this.iconLabel.setIcon(PStampSelectPanel.this.imageStampIcon);
                int pathdelimindex = -1;
                String imageFileName = obj.getText();
                if (imageFileName != null) {
                    pathdelimindex = imageFileName.lastIndexOf(File.separatorChar);
                }
                if (pathdelimindex > 0) {
                    this.textField.setText(imageFileName.substring(pathdelimindex + 1));
                } else {
                    this.textField.setText(imageFileName);
                }
            } else {
                this.iconLabel.setIcon(PStampSelectPanel.this.normalStampIcon);
                this.textField.setText(obj.getText());
            }
            int actw = this.getFontMetrics(this.getFont()).stringWidth(obj.getText());
            int availw = this.getFontMetrics(this.getFont()).stringWidth("ABCDEFGHIJKLMNOP");
            if (actw > availw) {
                int ellipsisw = this.getFontMetrics(this.getFont()).stringWidth(PAnnotationUtilities.getMessage("Annotation.ellipsis"));
                for (int i = this.textField.getText().length(); i > 0; --i) {
                    String truncatedText = this.textField.getText().substring(0, i);
                    int truncw = this.getFontMetrics(this.getFont()).stringWidth(truncatedText);
                    if (truncw + ellipsisw >= availw) continue;
                    this.textField.setText(truncatedText + PAnnotationUtilities.getMessage("Annotation.ellipsis"));
                    break;
                }
            }
            this.getAccessibleContext().setAccessibleName(obj.getText());
            if (isSelected) {
                this.setBackground(SystemColor.textHighlight);
                this.setForeground(SystemColor.textHighlightText);
                this.iconLabel.setBackground(SystemColor.textHighlight);
                this.iconLabel.setForeground(SystemColor.textHighlightText);
                this.textField.setBackground(SystemColor.textHighlight);
                this.textField.setForeground(SystemColor.textHighlightText);
            } else {
                this.setBackground(SystemColor.text);
                this.setForeground(SystemColor.textText);
                this.iconLabel.setBackground(SystemColor.text);
                this.iconLabel.setForeground(SystemColor.textText);
                this.textField.setBackground(SystemColor.text);
                this.textField.setForeground(SystemColor.textText);
            }
            LineBorder line = new LineBorder(SystemColor.textHighlightText, 1);
            EmptyBorder empty = new EmptyBorder(1, 1, 1, 1);
            if (hasFocus) {
                this.setBorder(line);
            } else {
                this.setBorder(empty);
            }
            if (PAnnotationUtilities.isLeftToRight()) {
                this.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            } else {
                this.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            }
            return this;
        }
    }

    class StampPreviewLabel
    extends JComponent {
        static final int PREVIEW_WIDTH = 250;
        static final int PREVIEW_HEIGHT = 100;
        CMBStampAnnotation stamp = null;

        StampPreviewLabel() {
        }

        public void setStampObject(StampObject stampObject) {
            if (stampObject != null) {
                this.stamp = new CMBStampAnnotation(new Rectangle(0, 0, 0, 0));
                CMBAnnotationSet stampAnnotationSet = new CMBAnnotationSet(PStampSelectPanel.this.annotationServices, null, null, 0);
                this.stamp.setAnnotationSet(stampAnnotationSet);
                this.stamp.setTransparent(false);
                this.stamp.setFillColor(stampObject.fillColor);
                this.stamp.setFont(stampObject.stampFont);
                this.stamp.setStampAngle(stampObject.stampAngle);
                this.stamp.setBorderColor(stampObject.borderColor);
                this.stamp.setBorderWidth(stampObject.borderWidth);
                if (stampObject.retrieveImageData()) {
                    this.stamp.setImageStamp(true);
                    this.stamp.setImageData(stampObject.imageData);
                    if (stampObject.imageSize != null) {
                        this.stamp.resizeDrawRect(stampObject.imageSize.width, stampObject.imageSize.height);
                    }
                } else {
                    this.stamp.setImageStamp(false);
                    this.stamp.setStampText(stampObject.stampText);
                }
            } else {
                this.stamp = null;
            }
            this.invalidate();
            this.repaint();
        }

        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            if (this.stamp != null) {
                Rectangle r = this.stamp.getRefreshRect();
                double scale = 1.0;
                if (r.width > 250) {
                    scale = 250.0 / (double)r.width;
                }
                if (r.height > 100) {
                    scale = Math.min(scale, 100.0 / (double)r.height);
                }
                g2.translate(this.getInsets().left + this.getWidth() / 2, this.getInsets().top + this.getHeight() / 2);
                g2.scale(scale, scale);
                g2.translate(-r.width / 2 - r.x, -r.height / 2 - r.y);
                this.stamp.draw(g2);
            } else {
                Color bgColor = ((Graphics2D)this.getParent().getGraphics()).getBackground();
                g2.setBackground(bgColor);
                g2.clearRect(0, 0, (int)this.getSize().getWidth(), (int)this.getSize().getHeight());
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(250, 100);
        }
    }

    class StampList
    extends JList {
        StampList(ComponentOrientation compOri, Vector stamps, StampObject defaultStampObject) {
            super(stamps);
            this.setComponentOrientation(compOri);
            this.setVisibleRowCount(5);
            this.setCellRenderer(new StampCellRenderer());
            this.setSelectionMode(0);
            this.setSelectedValue(defaultStampObject, true);
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.width = this.getFontMetrics(this.getFont()).stringWidth("ABCDEFGHIJKLMNOP");
            return d;
        }
    }
}

