/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer.annotation;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.annotation.CMBAnnotationConstants;
import com.ibm.mm.viewer.annotation.CMBAnnotationHelpEvent;
import com.ibm.mm.viewer.annotation.CMBAnnotationHelpListener;
import com.ibm.mm.viewer.annotation.CMBAnnotationServices;
import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import com.ibm.mm.viewer.annotation.CMBPropertiesPanel;
import com.ibm.mm.viewer.annotation.PAnnotationUtilities;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

class PStampSelectDialog
extends JDialog
implements CMBAnnotationConstants {
    private static final String copyright = "Licensed Materials - Property of IBM\nIBM DB2 Content Manager Enterprise Edition V8 (program number 5724-B19)\n(c ) Copyright IBM Corp.  1998, 2004.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private boolean stampCreated = false;
    private CMBAnnotationServices annotationServices;
    protected CMBPageAnnotation annotation;
    protected CMBPageAnnotation originalAnnotation;
    protected Vector annotationHelpListeners = new Vector();
    protected Box centerPanel = Box.createHorizontalBox();
    protected JPanel buttonPanel = new JPanel();
    protected Box mainPanel = Box.createVerticalBox();
    protected CMBPropertiesPanel propertiesPanel = null;
    protected JButton okButton = new JButton(PAnnotationUtilities.getMessage("PropertiesDialog.ok"));
    protected JButton cancelButton = new JButton(PAnnotationUtilities.getMessage("PropertiesDialog.cancel"));
    protected JButton helpButton = new JButton(PAnnotationUtilities.getMessage("PropertiesDialog.help"));
    protected JCheckBox applyNowBox = new JCheckBox(PAnnotationUtilities.getMessage("PropertiesDialog.applyNow"));
    boolean okPressed = false;
    private ComponentOrientation compOri = null;

    public PStampSelectDialog(Frame parentFrame, CMBAnnotationServices annotationServices) {
        super(parentFrame);
        this.setModal(true);
        this.initLayout(false);
        this.annotationServices = annotationServices;
    }

    boolean isStampCreated() {
        return this.stampCreated;
    }

    private void initLayout(boolean addApplyNow) {
        boolean ltr = PAnnotationUtilities.isLeftToRight();
        if (!ltr) {
            this.okButton.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.cancelButton.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.helpButton.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.applyNowBox.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        this.mainPanel.add(this.centerPanel);
        Box panel1 = Box.createHorizontalBox();
        if (addApplyNow) {
            panel1.add(this.applyNowBox);
        }
        Box bottomPanel = Box.createVerticalBox();
        bottomPanel.add(panel1);
        this.buttonPanel = this.makeButtonPanel();
        bottomPanel.add(this.buttonPanel);
        Box southPanel = Box.createHorizontalBox();
        southPanel.add(bottomPanel);
        this.mainPanel.add(southPanel);
        this.getContentPane().add(this.mainPanel);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PStampSelectDialog.this.onOK();
            }
        });
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PStampSelectDialog.this.onCancel();
            }
        });
        this.helpButton.setMnemonic(PAnnotationUtilities.getMessage("PropertiesDialog.help.mnemonic").charAt(0));
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PStampSelectDialog.this.onHelp();
            }
        });
        this.pack();
        AbstractAction EscAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PStampSelectDialog.this.setVisible(false);
            }
        };
        this.getRootPane().registerKeyboardAction(EscAction, KeyStroke.getKeyStroke(27, 0), 2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                Object object = event.getSource();
                if (object == PStampSelectDialog.this) {
                    try {
                        PStampSelectDialog.this.setVisible(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private JPanel makeButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(4));
        JPanel p2 = new JPanel();
        p2.setLayout(new GridLayout(1, 0, 5, 5));
        p2.add(this.makeOkButton());
        p2.add(this.makeCancelButton());
        if (!this.annotationHelpListeners.isEmpty()) {
            p2.add(this.makeHelpButton());
        }
        p2.setComponentOrientation(this.getCompOri());
        panel.add((Component)p2, "After");
        panel.setComponentOrientation(this.getCompOri());
        return panel;
    }

    private JButton makeOkButton() {
        return this.okButton;
    }

    private JButton makeCancelButton() {
        return this.cancelButton;
    }

    private JButton makeHelpButton() {
        return this.helpButton;
    }

    public ComponentOrientation getCompOri() {
        if (this.compOri == null) {
            boolean ltr = PAnnotationUtilities.isLeftToRight();
            this.compOri = ComponentOrientation.LEFT_TO_RIGHT;
            if (!ltr) {
                this.compOri = ComponentOrientation.RIGHT_TO_LEFT;
            }
        }
        return this.compOri;
    }

    public void buildPropertiesPanel() {
        String methodName = "buildPropertiesPanel";
        try {
            JPanel commonPanel = null;
            this.centerPanel.removeAll();
            commonPanel = this.annotation.getPropertiesPanel();
            this.propertiesPanel = this.annotation.getAnnotationPropertiesPanel();
            this.annotation.setApplyNow(this.applyNowBox.isSelected());
            this.annotation.updateValues(102);
            commonPanel.revalidate();
            this.centerPanel.add(commonPanel);
            this.pack();
        }
        catch (Exception e) {
            ViewerLogger.logWarning(this, methodName, e.getLocalizedMessage());
            ViewerLogger.logError((Object)this, methodName, e);
            this.centerPanel.add(new JLabel(PAnnotationUtilities.getMessage("PropertiesDialog.noProperties")));
        }
    }

    public void setAnnotation(CMBPageAnnotation a) {
        this.annotation = a;
        this.originalAnnotation = (CMBPageAnnotation)a.clone();
        this.setTitle(PAnnotationUtilities.getMessage("Stamp.title"));
        this.getRootPane().setDefaultButton(this.okButton);
        this.buildPropertiesPanel();
        this.okPressed = false;
    }

    public CMBPageAnnotation getAnnotation() {
        return this.annotation;
    }

    protected void onOK() {
        this.stampCreated = true;
        this.okPressed = true;
        this.setVisible(false);
    }

    protected void onCancel() {
        this.okPressed = false;
        this.setVisible(false);
        this.stampCreated = false;
        this.okPressed = false;
        this.setVisible(false);
    }

    protected void onHelp() {
        this.fireCMBAnnHelpEvent();
    }

    boolean isOkPressed() {
        return this.okPressed;
    }

    public void setVisible(boolean visible) {
        if (!this.isVisible() && visible) {
            this.propertiesPanel.setComponentStates(true);
            this.applyNowBox.setEnabled(this.annotation.canUpdate());
            this.okButton.setEnabled(this.annotation.canUpdate());
        }
        super.setVisible(visible);
        this.propertiesPanel.getPanel().requestFocusInWindow();
    }

    void addAnnHelpListener(CMBAnnotationHelpListener listener) {
        this.annotationHelpListeners.addElement(listener);
    }

    void removeAnnHelpListener(CMBAnnotationHelpListener listener) {
        this.annotationHelpListeners.removeElement(listener);
    }

    public void fireCMBAnnHelpEvent() {
        CMBAnnotationHelpEvent annHelpEvent = new CMBAnnotationHelpEvent(this);
        for (int i = 0; i < this.annotationHelpListeners.size(); ++i) {
            CMBAnnotationHelpListener listener = (CMBAnnotationHelpListener)this.annotationHelpListeners.elementAt(i);
            listener.onAnnotationHelp(annHelpEvent);
        }
    }
}

