/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer.annotation;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBDocumentEngine;
import com.ibm.mm.viewer.CMBDocumentEngineCallbacks;
import com.ibm.mm.viewer.annotation.CMBAnnotationServices;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

class PStampImageProvider {
    private CMBAnnotationServices annotationServices;
    private CMBDocumentEngine imageStampDocumentEngine;

    public PStampImageProvider(CMBAnnotationServices annotationServices) {
        this.annotationServices = annotationServices;
        this.initEngine();
    }

    private void initEngine() {
        String methodName = "initEngine";
        String engineClassname = this.annotationServices.getEngineProperties().getProperty("ImageStampDocumentEngine", "com.ibm.mm.viewer.mstech.CMBMSTechDocumentEngine");
        Class<?> engineClass = null;
        try {
            engineClass = Class.forName(engineClassname);
            this.imageStampDocumentEngine = (CMBDocumentEngine)engineClass.newInstance();
            this.imageStampDocumentEngine.initialize(new PDocEngineCallbacks(), new Properties());
        }
        catch (ClassNotFoundException e) {
            ViewerLogger.logError((Object)this, methodName, e);
        }
        catch (InstantiationException e1) {
            ViewerLogger.logError((Object)this, methodName, e1);
        }
        catch (IllegalAccessException e2) {
            ViewerLogger.logError((Object)this, methodName, e2);
        }
    }

    public void dispose() {
        if (this.imageStampDocumentEngine != null) {
            this.imageStampDocumentEngine.terminate();
            this.imageStampDocumentEngine = null;
        }
    }

    public Image getImage(byte[] imageData) {
        String methodName = "getImage";
        if (this.imageStampDocumentEngine == null) {
            this.initEngine();
        }
        Image stampImage = null;
        ByteArrayInputStream bisImage = new ByteArrayInputStream(imageData);
        try {
            stampImage = ImageIO.read(bisImage);
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
        }
        Object hDocument = null;
        Object hPage = null;
        if (stampImage == null) {
            try {
                ByteArrayInputStream bisImage2 = new ByteArrayInputStream(imageData);
                hDocument = this.imageStampDocumentEngine.loadDocument((InputStream)bisImage2, 1, "image/bmp", "image/bmp", null, null);
                hPage = this.imageStampDocumentEngine.loadPage(hDocument, 1);
                stampImage = this.imageStampDocumentEngine.getPageImage(hPage, 0, 1.0, false, false, false);
            }
            catch (IOException e1) {
                ViewerLogger.logError((Object)this, methodName, e1);
            }
            this.imageStampDocumentEngine.dropPage(hPage);
            this.imageStampDocumentEngine.dropDocument(hDocument);
        }
        try {
            MediaTracker tracker = new MediaTracker(new JPanel());
            tracker.addImage(stampImage, 0);
            tracker.waitForID(0);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return stampImage;
    }

    private class PDocEngineCallbacks
    extends CMBDocumentEngineCallbacks {
        private PDocEngineCallbacks() {
        }

        public InputStream getForm(Object hDocument, String formName) {
            return null;
        }

        public InputStream getPart(Object hDocument, int partNumber, StringBuffer outMimeType) {
            return null;
        }

        public InputStream getAnnotation(Object hDocument, int annotationNumber) {
            return null;
        }

        public boolean traceEnabled() {
            return false;
        }

        public void trace(String message) {
        }
    }
}

