/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer.annotation;

import com.ibm.mm.viewer.annotation.PAnnotationUtilities;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

class PNumericField
extends JTextField {
    private static final String copyright = "Licensed Materials - Property of IBM\nIBM DB2 Content Manager Enterprise Edition V8 (program number 5724-B19)\n(c ) Copyright IBM Corp.  1998, 2004.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private int minValue = 1;
    private int maxValue = 100;

    public PNumericField() {
    }

    public PNumericField(int cols) {
        super(cols);
    }

    public void setMinValue(int min) {
        this.minValue = min;
    }

    public void setMaxValue(int max) {
        this.maxValue = max;
    }

    public int getValue() {
        try {
            return Integer.parseInt(this.getText());
        }
        catch (NumberFormatException nfe) {
            return this.minValue;
        }
    }

    public void setValue(int value) {
        this.setText(new Integer(value).toString());
    }

    protected Document createDefaultModel() {
        return new NumericDocument();
    }

    class NumericDocument
    extends PlainDocument {
        NumericDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            String currString = this.getText(this.getStartPosition().getOffset(), offs) + str;
            int value = PNumericField.this.minValue;
            try {
                value = Integer.parseInt(currString);
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), PAnnotationUtilities.getMessage("Annotation.enterNumberOnlyMessage"));
                return;
            }
            if (value < PNumericField.this.minValue || value > PNumericField.this.maxValue) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), PAnnotationUtilities.getMessage("Annotation.numberOutOfRangeMessage", new Object[]{new Integer(PNumericField.this.minValue), new Integer(PNumericField.this.maxValue)}));
                return;
            }
            super.insertString(offs, str, a);
        }

        public void remove(int offs, int len) throws BadLocationException {
            int originalLength = this.getLength();
            StringBuffer originalString = new StringBuffer(this.getText(0, originalLength));
            originalString.delete(offs, offs + len);
            String newString = originalString.toString();
            try {
                int value = Integer.parseInt(newString);
                if (value < PNumericField.this.minValue || value > PNumericField.this.maxValue) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), PAnnotationUtilities.getMessage("Annotation.numberOutOfRangeMessage", new Object[]{new Integer(PNumericField.this.minValue), new Integer(PNumericField.this.maxValue)}));
                    return;
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            super.remove(offs, len);
        }
    }
}

