/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer.annotation;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.annotation.CMBAnnotationHelpEvent;
import com.ibm.mm.viewer.annotation.CMBAnnotationHelpListener;
import com.ibm.mm.viewer.annotation.CMBAnnotationServices;
import com.ibm.mm.viewer.annotation.PAnnotationUtilities;
import com.ibm.mm.viewer.annotation.PStampImageProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

class PImageSelectDialog
extends JDialog {
    public static int MAX_WIDTH_HEIGHT = 1500;
    private boolean initialized;
    private JPanel fileSelectionPanel;
    private JTextField fileNameTextField;
    private JButton browseButton;
    private JPanel previewPanel;
    private JPanel resizePanel;
    private JButton resetToOriginalSizeButton;
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JButton applyButton;
    private JButton helpButton;
    private ArrayList helpListeners = new ArrayList();
    private ImagePreviewer imagePreviewer;
    private JPanel heightAdjustPanel;
    private JPanel widthAdjustPanel;
    private JCheckBox maintainAspectRatioCheckBox;
    private NumericSpinner heightAdjustSpinner;
    private NumericSpinner widthAdjustSpinner;
    private boolean okPressed;
    private Image image;
    private byte[] imageData;
    private boolean fileNameChanged;
    private boolean sizeChanged;
    private double aspectRatio = 0.0;
    private boolean adjustingHeight;
    private boolean adjustingWidth;
    JFileChooser imageChooser;
    private CMBAnnotationServices annotationServices;

    public PImageSelectDialog(Dialog owner, CMBAnnotationServices annotationServices) throws HeadlessException {
        super(owner, PAnnotationUtilities.getMessage("SelectImage.title"));
        this.setModal(true);
        this.annotationServices = annotationServices;
    }

    public PImageSelectDialog(JFrame owner, CMBAnnotationServices annotationServices) throws HeadlessException {
        super((Frame)owner, PAnnotationUtilities.getMessage("SelectImage.title"));
        this.setModal(true);
        this.annotationServices = annotationServices;
    }

    public void show() {
        this.okPressed = false;
        if (!this.initialized) {
            this.initLayout();
        }
        super.show();
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public String getImageFileName() {
        return this.getFileNameTextField().getText();
    }

    public void setImageFileName(String imageFileName) {
        if (imageFileName == null || !imageFileName.equals(this.getFileNameTextField().getText())) {
            this.getFileNameTextField().setText(imageFileName);
        }
    }

    public void setImageFileNameNoValidation(String imageFileName) {
        if (!imageFileName.equals(this.getFileNameTextField().getText())) {
            this.getFileNameTextField().setText(imageFileName);
            this.fileNameChanged = false;
        }
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public void setImageData(byte[] imageData) {
        this.imageData = imageData;
        this.onImageDataChanged();
    }

    public Dimension getImageSize() {
        return new Dimension((Integer)this.getWidthAdjustSpinner().getValue(), (Integer)this.getHeightAdjustSpinner().getValue());
    }

    public void setImageSize(Dimension imageSize) {
        if (imageSize != null) {
            this.aspectRatio = (double)imageSize.width / (double)imageSize.height;
            this.getWidthAdjustSpinner().setValue(new Integer(imageSize.width));
            this.getHeightAdjustSpinner().setValue(new Integer(imageSize.height));
        }
    }

    public void addHelpListener(CMBAnnotationHelpListener listener) {
        this.helpListeners.add(listener);
    }

    public void removeHelpListener(CMBAnnotationHelpListener listener) {
        this.helpListeners.remove(listener);
    }

    private void fireCMBAnnHelpEvent() {
        CMBAnnotationHelpEvent annHelpEvent = new CMBAnnotationHelpEvent(this);
        for (int i = 0; i < this.helpListeners.size(); ++i) {
            CMBAnnotationHelpListener listener = (CMBAnnotationHelpListener)this.helpListeners.get(i);
            listener.onAnnotationHelp(annHelpEvent);
        }
    }

    private void initLayout() {
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        contentPane.setLayout(new BorderLayout(5, 5));
        contentPane.add((Component)this.getFileSelectionPanel(), "North");
        contentPane.add((Component)this.getPreviewPanel(), "Center");
        contentPane.add((Component)this.getResizePanel(), "After");
        contentPane.add((Component)this.getButtonPanel(), "South");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.applyComponentOrientation(PAnnotationUtilities.getComponentOrientation());
    }

    private JPanel getFileSelectionPanel() {
        if (this.fileSelectionPanel == null) {
            this.fileSelectionPanel = new JPanel(new BorderLayout(5, 5));
            JLabel fileNameLabel = new JLabel(PAnnotationUtilities.getMessage("SelectImage.fileName"));
            fileNameLabel.setDisplayedMnemonic(PAnnotationUtilities.getMessage("SelectImage.fileName.mnemonic").charAt(0));
            fileNameLabel.setLabelFor(this.getFileNameTextField());
            this.fileSelectionPanel.add((Component)this.getFileNameTextField(), "Center");
            this.fileSelectionPanel.add((Component)fileNameLabel, "Before");
            this.fileSelectionPanel.add((Component)this.getBrowseButton(), "After");
        }
        return this.fileSelectionPanel;
    }

    private JTextField getFileNameTextField() {
        if (this.fileNameTextField == null) {
            this.fileNameTextField = new JTextField(20);
            this.fileNameTextField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent e) {
                    PImageSelectDialog.this.fileNameChanged = true;
                    PImageSelectDialog.this.updateOkayButton();
                    PImageSelectDialog.this.updatePreview();
                }

                public void removeUpdate(DocumentEvent e) {
                    PImageSelectDialog.this.fileNameChanged = true;
                    PImageSelectDialog.this.updateOkayButton();
                    PImageSelectDialog.this.updatePreview();
                }

                public void changedUpdate(DocumentEvent e) {
                    PImageSelectDialog.this.fileNameChanged = true;
                    PImageSelectDialog.this.updateOkayButton();
                    PImageSelectDialog.this.updatePreview();
                }
            });
        }
        return this.fileNameTextField;
    }

    private JButton getBrowseButton() {
        if (this.browseButton == null) {
            this.browseButton = new JButton(PAnnotationUtilities.getMessage("SelectImage.browseButton"));
            this.browseButton.setMnemonic(PAnnotationUtilities.getMessage("SelectImage.browseButton.mnemonic").charAt(0));
            this.browseButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PImageSelectDialog.this.onBrowse();
                }
            });
        }
        return this.browseButton;
    }

    private JPanel getPreviewPanel() {
        if (this.previewPanel == null) {
            this.previewPanel = new JPanel(new BorderLayout());
            this.previewPanel.setBorder(PAnnotationUtilities.getTitledBorder(PAnnotationUtilities.getMessage("SelectImage.preview"), 4, 2));
            this.previewPanel.add((Component)this.getImagePreviewer(), "Center");
        }
        return this.previewPanel;
    }

    private ImagePreviewer getImagePreviewer() {
        if (this.imagePreviewer == null) {
            this.imagePreviewer = new ImagePreviewer();
        }
        return this.imagePreviewer;
    }

    private JPanel getResizePanel() {
        if (this.resizePanel == null) {
            this.resizePanel = new JPanel(new BorderLayout(5, 5));
            JPanel resizeLabelBox = new JPanel(new BorderLayout(5, 5));
            resizeLabelBox.setBorder(PAnnotationUtilities.getTitledBorder(PAnnotationUtilities.getMessage("SelectImage.resize"), 4, 2));
            JPanel resizeControlsPanel = new JPanel(new GridLayout(0, 1, 5, 5));
            resizeControlsPanel.setBorder(new EmptyBorder(0, 5, 0, 5));
            resizeControlsPanel.add(this.getWidthAdjustPanel());
            resizeControlsPanel.add(this.getHeightAdjustPanel());
            resizeControlsPanel.add(this.getMaintainAspectRatioCheckBox());
            resizeLabelBox.add((Component)resizeControlsPanel, "North");
            resizeLabelBox.add((Component)new JPanel(), "Center");
            this.resizePanel.add((Component)resizeLabelBox, "Center");
            this.resizePanel.add((Component)this.getResetToOriginalSizeButton(), "South");
            this.getWidthAdjustSpinner().setAccessibility(resizeLabelBox);
            this.getHeightAdjustSpinner().setAccessibility(resizeLabelBox);
            this.getMaintainAspectRatioCheckBox().getAccessibleContext().setAccessibleParent(resizeLabelBox);
        }
        return this.resizePanel;
    }

    private JButton getResetToOriginalSizeButton() {
        if (this.resetToOriginalSizeButton == null) {
            this.resetToOriginalSizeButton = new JButton(PAnnotationUtilities.getMessage("SelectImage.resetToOriginalSize"));
            this.resetToOriginalSizeButton.setMnemonic(PAnnotationUtilities.getMessage("SelectImage.resetToOriginalSize.mnemonic").charAt(0));
            this.resetToOriginalSizeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PImageSelectDialog.this.onResetToOriginalSize();
                }
            });
        }
        return this.resetToOriginalSizeButton;
    }

    private JPanel getHeightAdjustPanel() {
        if (this.heightAdjustPanel == null) {
            this.heightAdjustPanel = new JPanel(new BorderLayout(5, 5));
            JLabel heightAdjustLabel = new JLabel(PAnnotationUtilities.getMessage("SelectImage.height"));
            heightAdjustLabel.setDisplayedMnemonic(PAnnotationUtilities.getMessage("SelectImage.height.mnemonic").charAt(0));
            this.heightAdjustPanel.add((Component)heightAdjustLabel, "Center");
            this.heightAdjustPanel.add((Component)this.getHeightAdjustSpinner(), "After");
            heightAdjustLabel.setLabelFor(this.getHeightAdjustSpinner());
        }
        return this.heightAdjustPanel;
    }

    private JPanel getWidthAdjustPanel() {
        if (this.widthAdjustPanel == null) {
            this.widthAdjustPanel = new JPanel(new BorderLayout(5, 5));
            JLabel widthAdjustLabel = new JLabel(PAnnotationUtilities.getMessage("SelectImage.width"));
            widthAdjustLabel.setDisplayedMnemonic(PAnnotationUtilities.getMessage("SelectImage.width.mnemonic").charAt(0));
            this.widthAdjustPanel.add((Component)widthAdjustLabel, "Center");
            this.widthAdjustPanel.add((Component)this.getWidthAdjustSpinner(), "After");
            widthAdjustLabel.setLabelFor(this.getWidthAdjustSpinner());
        }
        return this.widthAdjustPanel;
    }

    private NumericSpinner getHeightAdjustSpinner() {
        if (this.heightAdjustSpinner == null) {
            SpinnerNumberModel model = new SpinnerNumberModel(1, 1, MAX_WIDTH_HEIGHT, 1);
            this.heightAdjustSpinner = new NumericSpinner(model);
            this.heightAdjustSpinner.getAccessibleContext().setAccessibleName(PAnnotationUtilities.getMessage("SelectImage.height"));
            this.heightAdjustSpinner.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    PImageSelectDialog.this.onHeightChanged();
                }
            });
        }
        return this.heightAdjustSpinner;
    }

    private NumericSpinner getWidthAdjustSpinner() {
        if (this.widthAdjustSpinner == null) {
            SpinnerNumberModel model = new SpinnerNumberModel(1, 1, MAX_WIDTH_HEIGHT, 1);
            this.widthAdjustSpinner = new NumericSpinner(model);
            this.widthAdjustSpinner.getAccessibleContext().setAccessibleName(PAnnotationUtilities.getMessage("SelectImage.width"));
            this.widthAdjustSpinner.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    PImageSelectDialog.this.onWidthChanged();
                }
            });
        }
        return this.widthAdjustSpinner;
    }

    private JCheckBox getMaintainAspectRatioCheckBox() {
        if (this.maintainAspectRatioCheckBox == null) {
            this.maintainAspectRatioCheckBox = new JCheckBox(PAnnotationUtilities.getMessage("SelectImage.maintainAspectRatio"), true);
            this.maintainAspectRatioCheckBox.setMnemonic(PAnnotationUtilities.getMessage("SelectImage.maintainAspectRatio.mnemonic").charAt(0));
            Preferences userPref = Preferences.userNodeForPackage(this.getClass());
            this.maintainAspectRatioCheckBox.setSelected(userPref.getBoolean("maintainAspectRatio", true));
            this.maintainAspectRatioCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PImageSelectDialog.this.onMaintainAspectRatio();
                }
            });
        }
        return this.maintainAspectRatioCheckBox;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new BorderLayout());
            JPanel buttonGridPanel = new JPanel(new GridLayout(1, 0, 5, 5));
            this.buttonPanel.add((Component)new JPanel(), "Center");
            buttonGridPanel.add(this.getOkButton());
            buttonGridPanel.add(this.getCancelButton());
            if (!this.helpListeners.isEmpty()) {
                buttonGridPanel.add(this.getHelpButton());
            }
            this.buttonPanel.add((Component)buttonGridPanel, "After");
        }
        return this.buttonPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton(PAnnotationUtilities.getMessage("SelectImage.okButton"));
            this.okButton.setEnabled(this.image != null);
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PImageSelectDialog.this.onOK();
                }
            });
            this.getRootPane().setDefaultButton(this.okButton);
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton(PAnnotationUtilities.getMessage("SelectImage.cancelButton"));
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PImageSelectDialog.this.onCancel();
                }
            });
        }
        return this.cancelButton;
    }

    private JButton getHelpButton() {
        if (this.helpButton == null) {
            this.helpButton = new JButton(PAnnotationUtilities.getMessage("SelectImage.helpButton"));
            this.helpButton.setMnemonic(PAnnotationUtilities.getMessage("SelectImage.helpButton.mnemonic").charAt(0));
            this.helpButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PImageSelectDialog.this.onHelp();
                }
            });
        }
        return this.helpButton;
    }

    private void setFileNameChanged(boolean fileNameChanged) {
        this.fileNameChanged = fileNameChanged;
        this.updateOkayButton();
    }

    private void onImageFileNameChanged() {
        String methodName = "onImageFileNameChanged";
        String imageFileName = this.fileNameTextField.getText();
        if (imageFileName.equals("")) {
            this.imageData = null;
        } else {
            File imageFile = new File(this.fileNameTextField.getText());
            try {
                FileInputStream imageStream = new FileInputStream(imageFile);
                byte[] newImageData = new byte[(int)imageFile.length()];
                ((InputStream)imageStream).read(newImageData);
                if (newImageData.length > 65535) {
                    JOptionPane.showMessageDialog(this, PAnnotationUtilities.getMessage("SelectImage.imageFileTooLarge", new String[]{""}));
                    this.imageData = null;
                } else {
                    this.imageData = newImageData;
                }
            }
            catch (IOException e) {
                ViewerLogger.logError((Object)this, methodName, e);
                JOptionPane.showMessageDialog(this, PAnnotationUtilities.getMessage("SelectImage.ioException", new String[]{e.getMessage()}));
                this.imageData = null;
            }
        }
        this.onImageDataChanged();
        this.fileNameChanged = false;
    }

    private void onImageDataChanged() {
        if (this.imageData == null) {
            this.image = null;
        } else {
            PStampImageProvider imageProvider = this.annotationServices.getStampImageProvider();
            this.image = imageProvider.getImage(this.imageData);
            if (this.image == null) {
                JOptionPane.showMessageDialog(this, PAnnotationUtilities.getMessage("SelectImage.invalidImage", new String[]{""}));
            }
        }
        if (this.image == null) {
            this.getWidthAdjustSpinner().setValue(new Integer(1));
            this.getHeightAdjustSpinner().setValue(new Integer(1));
            this.getImagePreviewer().updateImage(null, 1, 1);
            this.getOkButton().setEnabled(false);
        } else {
            int imageWidth = this.image.getWidth(this);
            int imageHeight = this.image.getHeight(this);
            if (this.getMaintainAspectRatioCheckBox().isSelected()) {
                this.aspectRatio = (double)imageWidth / (double)imageHeight;
            }
            this.getWidthAdjustSpinner().setValue(new Integer(imageWidth));
            this.getHeightAdjustSpinner().setValue(new Integer(imageHeight));
            this.getImagePreviewer().updateImage(this.image, imageWidth, imageHeight);
            this.getOkButton().setEnabled(true);
        }
    }

    private void onBrowse() {
        this.imageChooser = new JFileChooser();
        File file = new File(this.getImageFileName());
        this.imageChooser.setSelectedFile(file);
        this.imageChooser.setFileFilter(new SupportedFileFilter());
        this.imageChooser.setComponentOrientation(PAnnotationUtilities.getComponentOrientation());
        int rc = this.imageChooser.showOpenDialog(this);
        if (rc == 0 && this.imageChooser.getSelectedFile() != null) {
            String fileName = this.imageChooser.getSelectedFile().getAbsolutePath();
            this.setImageFileName(fileName);
        }
        this.imageChooser = null;
    }

    private void onHeightChanged() {
        int imageWidth;
        int imageHeight = (Integer)this.getHeightAdjustSpinner().getValue();
        if (this.getMaintainAspectRatioCheckBox().isSelected() && !this.adjustingWidth) {
            imageWidth = this.image != null ? (int)((double)imageHeight * this.aspectRatio) : imageHeight;
            this.adjustingHeight = true;
            this.getWidthAdjustSpinner().setValue(new Integer(imageWidth));
            this.adjustingHeight = false;
        } else {
            imageWidth = (Integer)this.getWidthAdjustSpinner().getValue();
        }
        this.getImagePreviewer().updateImage(this.image, imageWidth, imageHeight);
        this.sizeChanged = true;
        this.updateOkayButton();
    }

    private void onWidthChanged() {
        int imageHeight;
        int imageWidth = (Integer)this.getWidthAdjustSpinner().getValue();
        if (this.getMaintainAspectRatioCheckBox().isSelected() && !this.adjustingHeight) {
            imageHeight = this.image != null ? (int)((double)imageWidth / this.aspectRatio) : imageWidth;
            this.adjustingWidth = true;
            this.getHeightAdjustSpinner().setValue(new Integer(imageHeight));
            this.adjustingWidth = false;
        } else {
            imageHeight = (Integer)this.getHeightAdjustSpinner().getValue();
        }
        this.getImagePreviewer().updateImage(this.image, imageWidth, imageHeight);
        this.sizeChanged = true;
        this.updateOkayButton();
    }

    private void onMaintainAspectRatio() {
        if (this.getMaintainAspectRatioCheckBox().isSelected()) {
            this.aspectRatio = ((Integer)this.getWidthAdjustSpinner().getValue()).doubleValue() / ((Integer)this.getHeightAdjustSpinner().getValue()).doubleValue();
        }
        Preferences userPref = Preferences.userNodeForPackage(this.getClass());
        userPref.putBoolean("maintainAspectRatio", this.getMaintainAspectRatioCheckBox().isSelected());
    }

    private void onResetToOriginalSize() {
        if (this.image != null) {
            this.getWidthAdjustSpinner().setValue(new Integer(this.image.getWidth(this)));
            this.getHeightAdjustSpinner().setValue(new Integer(this.image.getHeight(this)));
            this.imagePreviewer.updateImage(this.image, this.image.getWidth(this), this.image.getHeight(this));
        } else {
            this.getWidthAdjustSpinner().setValue(new Integer(1));
            this.getHeightAdjustSpinner().setValue(new Integer(1));
            this.imagePreviewer.updateImage(null, 1, 1);
        }
        this.sizeChanged = true;
    }

    private void onOK() {
        if (this.fileNameChanged) {
            this.onImageFileNameChanged();
        }
        if (this.image != null) {
            this.okPressed = true;
            this.setVisible(false);
        }
    }

    private void onCancel() {
        this.okPressed = false;
        this.setVisible(false);
    }

    private void onHelp() {
        this.fireCMBAnnHelpEvent();
    }

    private void updatePreview() {
        File imageFile = new File(this.getFileNameTextField().getText());
        if (imageFile.exists() && imageFile.isFile()) {
            this.onImageFileNameChanged();
        }
    }

    private void updateOkayButton() {
        if (this.getFileNameTextField().getText().length() > 0 && (this.fileNameChanged || this.sizeChanged)) {
            this.getOkButton().setEnabled(true);
            return;
        }
        this.getOkButton().setEnabled(false);
    }

    public void dispose() {
        if (this.imageChooser != null) {
            this.imageChooser.cancelSelection();
        }
        super.dispose();
    }

    private class ImagePreviewer
    extends JScrollPane {
        private Image image;
        private int imageWidth;
        private int imageHeight;
        private JComponent imageComponent = new JComponent(){

            public void paint(Graphics g) {
                if (ImagePreviewer.this.image != null) {
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.drawImage(ImagePreviewer.this.image, 0, 0, this);
                }
            }
        };

        public ImagePreviewer() {
            this.setPreferredSize(new Dimension(250, 250));
            this.setViewportView(this.imageComponent);
        }

        public void updateImage(Image image, int imageWidth, int imageHeight) {
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            this.image = image == null ? null : image.getScaledInstance(imageWidth, imageHeight, 4);
            this.imageComponent.setPreferredSize(new Dimension(imageWidth, imageHeight));
            this.setViewportView(this.imageComponent);
            this.imageComponent.repaint();
        }
    }

    private class SupportedFileFilter
    extends FileFilter {
        private SupportedFileFilter() {
        }

        public boolean accept(File f) {
            String ext = this.getExtension(f);
            return f.isDirectory() || ext != null && (ext.equals("bmp") || ext.equals("gif") || ext.equals("jpg") || ext.equals("jpeg") || ext.equals("pcx"));
        }

        public String getDescription() {
            return PAnnotationUtilities.getMessage("SelectImage.supportedFileTypes");
        }

        private String getExtension(File f) {
            String ext = null;
            String fileName = f.getName();
            int i = fileName.lastIndexOf(46);
            if (i > 0 && i < fileName.length() - 1) {
                ext = fileName.substring(i + 1).toLowerCase();
            }
            return ext;
        }
    }

    public class NumericSpinner
    extends JSpinner
    implements Accessible {
        public NumericSpinner(SpinnerModel model) {
            super(model);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleJSpinner();
            }
            return this.accessibleContext;
        }

        public void setAccessibility(JPanel panel) {
            JSpinner.NumberEditor ne = (JSpinner.NumberEditor)this.getEditor();
            ne.getTextField().getAccessibleContext().setAccessibleParent(panel);
            this.getAccessibleContext().setAccessibleParent(panel);
        }

        protected class AccessibleJSpinner
        extends JComponent.AccessibleJComponent
        implements AccessibleValue,
        ChangeListener {
            private Object oldModelValue;

            protected AccessibleJSpinner() {
                super(NumericSpinner.this);
                this.oldModelValue = null;
                this.oldModelValue = NumericSpinner.this.getModel().getValue();
                NumericSpinner.this.addChangeListener(this);
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.SPIN_BOX;
            }

            public void setAccessibleName(String s) {
                super.setAccessibleName(s);
                ((JSpinner.NumberEditor)NumericSpinner.this.getEditor()).getTextField().getAccessibleContext().setAccessibleName(s);
            }

            public AccessibleValue getAccessibleValue() {
                return this;
            }

            public Number getCurrentAccessibleValue() {
                return this.getCurrentAccessibleValue();
            }

            public boolean setCurrentAccessibleValue(Number n) {
                if (n instanceof Integer) {
                    ((SpinnerNumberModel)NumericSpinner.this.getModel()).setValue(n);
                    return true;
                }
                return false;
            }

            public Number getMinimumAccessibleValue() {
                Comparable<?> c = ((SpinnerNumberModel)NumericSpinner.this.getModel()).getMinimum();
                return (Number)((Object)c);
            }

            public Number getMaximumAccessibleValue() {
                Comparable<?> c = ((SpinnerNumberModel)NumericSpinner.this.getModel()).getMaximum();
                return (Number)((Object)c);
            }

            public void stateChanged(ChangeEvent e) {
                if (e == null) {
                    throw new NullPointerException();
                }
                Object newModelValue = NumericSpinner.this.getModel().getValue();
                this.firePropertyChange("AccessibleValue", this.oldModelValue, newModelValue);
                this.oldModelValue = newModelValue;
            }
        }
    }
}

