/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer.annotation;

import com.ibm.mm.viewer.annotation.CMBAnnotationConstants;
import com.ibm.mm.viewer.annotation.PAnnotationUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class PFontChooserDialog
extends JDialog
implements ListSelectionListener,
CMBAnnotationConstants {
    private static final String copyright = "Licensed Materials - Property of IBM\nIBM DB2 Content Manager Enterprise Edition V8 (program number 5724-B19)\n(c ) Copyright IBM Corp.  1998, 2004.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    public static final int VISIBLE_ROW_COUNT = 5;
    private JLabel fontLabel;
    private JLabel sizeLabel;
    private JLabel styleLabel;
    private JList fonts;
    private JList sizes;
    private JList styles;
    private String[] envfontNames = null;
    private String sizesString = null;
    private String[] styleStrings = new String[]{"plain", "bold", "italic", "bolditalic"};
    private Font currentFont = null;
    private JLabel previewLabel;
    private JButton ok;
    private JButton cancel;
    private boolean okPressed = false;

    public PFontChooserDialog(Frame parentFrame, Font initFont) {
        super(parentFrame);
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = gEnv.getAvailableFontFamilyNames();
        this.setEnvfontNames(fontNames);
        this.currentFont = initFont;
        this.setSizesString(PAnnotationUtilities.getMessage("Font.sizesArray"));
        this.makeLayout();
        this.pack();
    }

    public PFontChooserDialog(Frame parentFrame, Font initFont, String[] fontNames, String sizesString) {
        super(parentFrame);
        this.currentFont = initFont;
        this.setSizesString(sizesString);
        this.setEnvfontNames(fontNames);
        this.makeLayout();
        this.pack();
        this.setLocationRelativeTo(parentFrame);
    }

    private void makeLayout() {
        boolean ltr = PAnnotationUtilities.isLeftToRight();
        ComponentOrientation compOri = ComponentOrientation.LEFT_TO_RIGHT;
        if (!ltr) {
            compOri = ComponentOrientation.RIGHT_TO_LEFT;
        }
        this.setTitle(PAnnotationUtilities.getMessage("Font.title"));
        this.setModal(true);
        this.setVisible(false);
        this.getContentPane().setLayout(new BorderLayout());
        Box topPanel = new Box(0);
        JPanel fontPanel = new JPanel(new BorderLayout(5, 5));
        JPanel sizePanel = new JPanel(new BorderLayout(5, 5));
        JPanel stylePanel = new JPanel(new BorderLayout(5, 5));
        JPanel buttonsPanel = new JPanel(new GridLayout(1, 0, 5, 5));
        this.fontLabel = new JLabel(PAnnotationUtilities.getMessage("Font.fontNames"), 10);
        this.fontLabel.setDisplayedMnemonic(PAnnotationUtilities.getMessage("Font.fontNames.mnemonic").charAt(0));
        JPanel fPanel = new JPanel();
        fPanel.setLayout(new BorderLayout());
        this.fontLabel.setComponentOrientation(compOri);
        this.styleLabel = new JLabel(PAnnotationUtilities.getMessage("Font.styles"), 10);
        this.styleLabel.setDisplayedMnemonic(PAnnotationUtilities.getMessage("Font.styles.mnemonic").charAt(0));
        JPanel stPanel = new JPanel();
        stPanel.setLayout(new BorderLayout());
        this.styleLabel.setComponentOrientation(compOri);
        this.sizeLabel = new JLabel(PAnnotationUtilities.getMessage("Font.sizes"), 10);
        this.sizeLabel.setDisplayedMnemonic(PAnnotationUtilities.getMessage("Font.sizes.mnemonic").charAt(0));
        JPanel siPanel = new JPanel();
        siPanel.setLayout(new BorderLayout());
        this.sizeLabel.setComponentOrientation(compOri);
        if (ltr) {
            fPanel.add((Component)this.fontLabel, "West");
            stPanel.add((Component)this.styleLabel, "West");
            siPanel.add((Component)this.sizeLabel, "West");
        } else {
            fPanel.add((Component)this.fontLabel, "East");
            stPanel.add((Component)this.styleLabel, "East");
            siPanel.add((Component)this.sizeLabel, "East");
        }
        fontPanel.add((Component)fPanel, "North");
        stylePanel.add((Component)stPanel, "North");
        sizePanel.add((Component)siPanel, "North");
        this.fonts = new JList<String>(this.envfontNames);
        this.fonts.setVisibleRowCount(5);
        this.fonts.setCellRenderer(new FontNameCellRenderer());
        this.fonts.setSelectedValue(this.currentFont.getFamily(), true);
        if (this.fonts.isSelectionEmpty()) {
            this.fonts.setSelectedValue("Arial", true);
        }
        if (this.fonts.isSelectionEmpty()) {
            this.fonts.setSelectedIndex(0);
        }
        this.fonts.addListSelectionListener(this);
        this.fontLabel.setLabelFor(this.fonts);
        StringTokenizer tok = new StringTokenizer(this.sizesString, ",");
        Vector<String> sizeVector = new Vector<String>();
        while (tok.hasMoreTokens()) {
            sizeVector.addElement(tok.nextToken());
        }
        this.sizes = new JList(sizeVector);
        this.sizes.setSelectedValue(new Integer(this.currentFont.getSize()).toString(), true);
        this.sizes.setCellRenderer(new FontCellRenderer());
        this.sizes.setVisibleRowCount(5);
        this.sizes.addListSelectionListener(this);
        this.sizeLabel.setLabelFor(this.sizes);
        String styleArray = PAnnotationUtilities.getMessage("Font.stylesArray");
        StringTokenizer tok2 = new StringTokenizer(styleArray, ",");
        Vector<String> styleVector = new Vector<String>();
        while (tok2.hasMoreTokens()) {
            styleVector.addElement(tok2.nextToken());
        }
        this.styles = new JList(styleVector);
        this.styles.setSelectedIndex(this.currentFont.getStyle());
        this.styles.setCellRenderer(new FontCellRenderer());
        this.styles.setVisibleRowCount(5);
        this.styles.addListSelectionListener(this);
        this.styleLabel.setLabelFor(this.styles);
        this.fonts.setComponentOrientation(compOri);
        this.styles.setComponentOrientation(compOri);
        this.sizes.setComponentOrientation(compOri);
        JScrollPane fontScroll = new JScrollPane(this.fonts);
        fontPanel.add((Component)fontScroll, "Center");
        JScrollPane sizeScroll = new JScrollPane(this.sizes);
        sizePanel.add((Component)sizeScroll, "Center");
        JScrollPane styleScroll = new JScrollPane(this.styles);
        stylePanel.add((Component)styleScroll, "Center");
        fontScroll.setComponentOrientation(compOri);
        sizeScroll.setComponentOrientation(compOri);
        styleScroll.setComponentOrientation(compOri);
        if (ltr) {
            topPanel.add(fontPanel);
            topPanel.add(Box.createHorizontalStrut(10));
            topPanel.add(stylePanel);
            topPanel.add(Box.createHorizontalStrut(10));
            topPanel.add(sizePanel);
        } else {
            topPanel.add(sizePanel);
            topPanel.add(Box.createHorizontalStrut(10));
            topPanel.add(stylePanel);
            topPanel.add(Box.createHorizontalStrut(10));
            topPanel.add(fontPanel);
        }
        topPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add("North", topPanel);
        this.previewLabel = new JLabel(PAnnotationUtilities.getMessage("Font.sample"));
        this.previewLabel.setFont(this.currentFont);
        this.previewLabel.setComponentOrientation(compOri);
        this.previewLabel.setHorizontalAlignment(0);
        JPanel previewPanel = new JPanel();
        int titleJustification = ltr ? 1 : 3;
        previewPanel.setBorder(PAnnotationUtilities.getTitledBorder(PAnnotationUtilities.getMessage("Font.preview"), titleJustification, 2));
        previewPanel.setLayout(new BorderLayout());
        previewPanel.add("Center", this.previewLabel);
        this.previewLabel.setLabelFor(previewPanel);
        this.ok = new JButton(PAnnotationUtilities.getMessage("Font.okButtonLabel"));
        this.ok.setMnemonic(PAnnotationUtilities.getMessage("Font.okButtonMnemonic").charAt(0));
        this.cancel = new JButton(PAnnotationUtilities.getMessage("Font.cancelButtonLabel"));
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PFontChooserDialog.this.okPressed = true;
                PFontChooserDialog.this.setVisible(false);
            }
        });
        this.getRootPane().setDefaultButton(this.ok);
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PFontChooserDialog.this.okPressed = false;
                PFontChooserDialog.this.setVisible(false);
            }
        });
        AbstractAction EscAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PFontChooserDialog.this.setVisible(false);
            }
        };
        this.getRootPane().registerKeyboardAction(EscAction, KeyStroke.getKeyStroke(27, 0), 2);
        if (ltr) {
            buttonsPanel.add(this.ok);
            buttonsPanel.add(this.cancel);
        } else {
            buttonsPanel.add(this.cancel);
            buttonsPanel.add(this.ok);
        }
        this.getContentPane().add("Center", previewPanel);
        JPanel buttonsbox = new JPanel(new BorderLayout());
        buttonsbox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonsbox.add((Component)buttonsPanel, "After");
        this.getContentPane().add("South", buttonsbox);
        this.getRootPane().setPreferredSize(new Dimension(500, 300));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                Object object = event.getSource();
                if (object == PFontChooserDialog.this) {
                    try {
                        PFontChooserDialog.this.setVisible(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this.sizes.isSelectionEmpty()) {
            this.sizes.setSelectedIndex(0);
        }
        if (this.fonts.isSelectionEmpty()) {
            this.fonts.setSelectedValue("Arial", true);
        }
        if (this.fonts.isSelectionEmpty()) {
            this.fonts.setSelectedIndex(0);
        }
        if (this.styles.isSelectionEmpty()) {
            this.styles.setSelectedIndex(0);
        }
        String styleString = this.styleStrings[this.styles.getSelectedIndex()];
        String decodeString = this.fonts.getSelectedValue() + "-" + styleString + "-" + this.sizes.getSelectedValue();
        this.currentFont = Font.decode(decodeString);
        this.previewLabel.setFont(this.currentFont);
    }

    public Font getChosenFont() {
        return this.previewLabel.getFont();
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    String[] getEnvfontNames() {
        return this.envfontNames;
    }

    String getSizesString() {
        return this.sizesString;
    }

    void setEnvfontNames(String[] newEnvfontNames) {
        this.envfontNames = newEnvfontNames;
    }

    void setSizesString(String newSizesString) {
        this.sizesString = newSizesString;
    }

    protected class FontCellRenderer
    extends JLabel
    implements ListCellRenderer {
        protected FontCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            this.setOpaque(true);
            this.setText((String)value);
            if (isSelected) {
                this.setBackground(SystemColor.textHighlight);
                this.setForeground(SystemColor.textHighlightText);
            } else {
                this.setBackground(SystemColor.text);
                this.setForeground(SystemColor.textText);
            }
            LineBorder line = new LineBorder(SystemColor.textHighlightText, 1);
            EmptyBorder empty = new EmptyBorder(1, 1, 1, 1);
            if (hasFocus) {
                this.setBorder(line);
            } else {
                this.setBorder(empty);
            }
            if (PAnnotationUtilities.isLeftToRight()) {
                this.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            } else {
                this.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            }
            return this;
        }
    }

    protected class FontNameCellRenderer
    extends JLabel
    implements ListCellRenderer {
        protected FontNameCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            this.setOpaque(true);
            this.setText((String)value);
            if (isSelected) {
                this.setBackground(SystemColor.textHighlight);
                this.setForeground(SystemColor.textHighlightText);
            } else {
                this.setBackground(SystemColor.text);
                this.setForeground(SystemColor.textText);
            }
            LineBorder line = new LineBorder(SystemColor.textHighlightText, 1);
            EmptyBorder empty = new EmptyBorder(1, 1, 1, 1);
            if (hasFocus) {
                this.setBorder(line);
            } else {
                this.setBorder(empty);
            }
            if (PAnnotationUtilities.isLeftToRight()) {
                this.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            } else {
                this.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            }
            return this;
        }
    }
}

