/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer.annotation;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.annotation.CMBAnnotationConstants;
import com.ibm.mm.viewer.annotation.CMBAnnotationHelpEvent;
import com.ibm.mm.viewer.annotation.CMBAnnotationHelpListener;
import com.ibm.mm.viewer.annotation.CMBAnnotationServices;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import com.ibm.mm.viewer.annotation.CMBPropertiesPanel;
import com.ibm.mm.viewer.annotation.CMBStampAnnotation;
import com.ibm.mm.viewer.annotation.PAnnotationUtilities;
import com.ibm.mm.viewer.annotation.StampObject;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

class PEditStampDialog
extends JDialog
implements CMBAnnotationConstants {
    private static final String copyright = "Licensed Materials - Property of IBM\nIBM DB2 Content Manager Enterprise Edition V8 (program number 5724-B19)\n(c ) Copyright IBM Corp.  1998, 2004.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    protected ArrayList helpListeners = new ArrayList();
    protected JButton cancelButton;
    private JPanel buttonPanel;
    protected Box centerPanel = Box.createHorizontalBox();
    private ComponentOrientation compOri = null;
    protected JButton helpButton;
    protected Box mainPanel = Box.createVerticalBox();
    private boolean initialized;
    protected JButton okButton;
    boolean okPressed = false;
    private CMBStampAnnotation dummyAnnotation = new CMBStampAnnotation();
    protected CMBPropertiesPanel propertiesPanel = null;

    public PEditStampDialog(JPanel invokingPanel, CMBAnnotationServices annotationServices) {
        super(PEditStampDialog.getParentDialog(invokingPanel));
        this.setTitle(PAnnotationUtilities.getMessage("EditStamp.title"));
        this.setModal(true);
        this.dummyAnnotation.setAnnotationSet(new CMBAnnotationSet(annotationServices, null, null, 0));
    }

    public void updateStampObject(StampObject stampObject) {
        stampObject.updateValuesFromAnnotation(this.dummyAnnotation);
    }

    public void editStampObject(StampObject stampObject) {
        stampObject.updateAnnotation(this.dummyAnnotation);
    }

    public void show() {
        if (!this.initialized) {
            this.initLayout();
        }
        super.show();
    }

    private static JDialog getParentDialog(JPanel invokingPanel) {
        JDialog parentDialog = null;
        Container parentPanel = invokingPanel;
        while (parentDialog == null) {
            if (parentPanel instanceof JDialog) {
                parentDialog = (JDialog)parentPanel;
                continue;
            }
            parentPanel = parentPanel.getParent();
        }
        return parentDialog;
    }

    public void addHelpListener(CMBAnnotationHelpListener listener) {
        this.helpListeners.add(listener);
    }

    private void fireCMBAnnHelpEvent() {
        CMBAnnotationHelpEvent annHelpEvent = new CMBAnnotationHelpEvent(this);
        for (int i = 0; i < this.helpListeners.size(); ++i) {
            CMBAnnotationHelpListener listener = (CMBAnnotationHelpListener)this.helpListeners.get(i);
            listener.onAnnotationHelp(annHelpEvent);
        }
    }

    private void initLayout() {
        this.makePropertiesPanel();
        this.mainPanel.add(this.centerPanel);
        Box panel1 = Box.createHorizontalBox();
        Box bottomPanel = Box.createVerticalBox();
        bottomPanel.add(panel1);
        bottomPanel.add(this.makeButtonPanel());
        Box southPanel = Box.createHorizontalBox();
        southPanel.add(bottomPanel);
        this.mainPanel.add(southPanel);
        this.getContentPane().add(this.mainPanel);
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        AbstractAction EscAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PEditStampDialog.this.setVisible(false);
            }
        };
        this.getRootPane().registerKeyboardAction(EscAction, KeyStroke.getKeyStroke(27, 0), 2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                Object object = event.getSource();
                if (object == PEditStampDialog.this) {
                    try {
                        PEditStampDialog.this.setVisible(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.applyComponentOrientation(PAnnotationUtilities.getComponentOrientation());
        this.initialized = true;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    private JPanel makeButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new FlowLayout(4));
            JPanel p2 = new JPanel();
            p2.setLayout(new GridLayout(1, 0, 5, 5));
            p2.add(this.makeOkButton());
            p2.add(this.makeCancelButton());
            if (!this.helpListeners.isEmpty()) {
                p2.add(this.makeHelpButton());
            }
            p2.setComponentOrientation(PAnnotationUtilities.getComponentOrientation());
            this.buttonPanel.add((Component)p2, "After");
            this.buttonPanel.setComponentOrientation(PAnnotationUtilities.getComponentOrientation());
        }
        return this.buttonPanel;
    }

    private JButton makeCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton(PAnnotationUtilities.getMessage("EditStamp.cancelButton"));
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PEditStampDialog.this.onCancel();
                }
            });
        }
        return this.cancelButton;
    }

    private JButton makeHelpButton() {
        if (this.helpButton == null) {
            this.helpButton = new JButton(PAnnotationUtilities.getMessage("EditStamp.helpButton"));
            this.helpButton.setMnemonic(PAnnotationUtilities.getMessage("EditStamp.helpButton.mnemonic").charAt(0));
            this.helpButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PEditStampDialog.this.onHelp();
                }
            });
        }
        return this.helpButton;
    }

    private JButton makeOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton(PAnnotationUtilities.getMessage("EditStamp.okButton"));
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PEditStampDialog.this.onOK();
                }
            });
            this.getRootPane().setDefaultButton(this.okButton);
        }
        return this.okButton;
    }

    private void makePropertiesPanel() {
        String methodName = "makePropertiesPanel";
        try {
            JPanel commonPanel = null;
            this.centerPanel.removeAll();
            this.propertiesPanel = this.dummyAnnotation.getAnnotationPropertiesPanel();
            commonPanel = this.propertiesPanel.getInteriorPanel();
            this.dummyAnnotation.updateValues(102);
            commonPanel.revalidate();
            this.centerPanel.add(commonPanel);
            this.pack();
        }
        catch (Exception e) {
            ViewerLogger.logWarning(this, methodName, e.getLocalizedMessage());
            ViewerLogger.logError((Object)this, methodName, e);
            this.centerPanel.add(new JLabel(PAnnotationUtilities.getMessage("PropertiesDialog.noProperties")));
        }
    }

    private void onCancel() {
        this.okPressed = false;
        this.setVisible(false);
        this.okPressed = false;
        this.setVisible(false);
    }

    private void onHelp() {
        this.fireCMBAnnHelpEvent();
    }

    private void onOK() {
        if (this.dummyAnnotation.isValidImageFile(this)) {
            this.okPressed = true;
            this.setVisible(false);
            this.dummyAnnotation.updateValues(101);
        }
    }

    public void removeHelpListener(CMBAnnotationHelpListener listener) {
        this.helpListeners.remove(listener);
    }

    public void dispose() {
        if (this.propertiesPanel != null) {
            this.propertiesPanel.dispose();
        }
        super.dispose();
    }
}

