/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer.annotation;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.border.Border;

class PAnnotationUtilities {
    static final String copyright = "Licensed Materials - Property of IBM\nIBM DB2 Content Manager Enterprise Edition V8 (program number 5724-B19)\n(c ) Copyright IBM Corp.  1998, 2004.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    public static String RESOURCE_BASE_NAME = "com.ibm.mm.viewer.annotation.CMBAnnotationMessages";
    private static final int MAX_BUNDLE_NAMES = 4;
    private static ResourceBundle annotationMessages = null;
    private static Vector availableBundles = new Vector(4);
    private static final int MAX_PROP_LENGTH = 4096;
    private static final byte[] decodeTable = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final char[] encodeTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    PAnnotationUtilities() {
    }

    public static ResourceBundle getResourceBundle(Locale myLocale) {
        if (myLocale == null) {
            myLocale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_BASE_NAME, myLocale);
    }

    private static String getMessageString(String messageKey) {
        String message = messageKey;
        try {
            message = PAnnotationUtilities.getResourceBundle().getString(messageKey);
            return message;
        }
        catch (MissingResourceException mre) {
            int size = availableBundles.size();
            for (int i = size - 1; i > 0; --i) {
                try {
                    return ((ResourceBundle)availableBundles.elementAt(i)).getString(messageKey);
                }
                catch (MissingResourceException me) {
                    continue;
                }
            }
            return messageKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static ResourceBundle getResourceBundle() {
        if (annotationMessages == null) {
            Vector bundleNames = new Vector(4);
            bundleNames = PAnnotationUtilities.calculateBundleNames(RESOURCE_BASE_NAME.replace('.', '/'), Locale.getDefault());
            InputStream stream = null;
            String resPathName = RESOURCE_BASE_NAME.replace('.', '/');
            int size = bundleNames.size();
            for (int i = 0; i < size; ++i) {
                resPathName = (String)bundleNames.elementAt(i) + ".properties";
                URL myurl = PAnnotationUtilities.class.getClassLoader().getResource(resPathName);
                if (myurl != null) {
                    try {
                        URLConnection myconn = myurl.openConnection();
                        myconn.setUseCaches(true);
                        stream = myconn.getInputStream();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (stream == null) continue;
                stream = new BufferedInputStream(stream);
                PropertyResourceBundle bundle = new PropertyResourceBundle(stream);
                availableBundles.insertElementAt(bundle, 0);
                Object var9_9 = null;
                try {
                    stream.close();
                }
                catch (Exception e2) {}
                continue;
                {
                    catch (Exception e) {
                        var9_9 = null;
                        try {
                            stream.close();
                        }
                        catch (Exception e2) {}
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var9_9 = null;
                    try {
                        stream.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            if (!availableBundles.isEmpty()) {
                annotationMessages = (PropertyResourceBundle)availableBundles.elementAt(0);
            }
        }
        return annotationMessages;
    }

    private static Vector calculateBundleNames(String baseName, Locale locale) {
        Vector<String> result = new Vector<String>(4);
        String language = locale.getLanguage();
        int languageLength = language.length();
        String country = locale.getCountry();
        int countryLength = country.length();
        String variant = locale.getVariant();
        int variantLength = variant.length();
        result.addElement(baseName);
        if (languageLength + countryLength + variantLength == 0) {
            return result;
        }
        if (language.equals("en") && (country.equals("US") || country.equals("")) && variant.equals("")) {
            return result;
        }
        StringBuffer temp = new StringBuffer(baseName);
        temp.append('_');
        temp.append(language);
        result.addElement(temp.toString());
        if (countryLength + variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(country);
        result.addElement(temp.toString());
        if (variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(variant);
        result.addElement(temp.toString());
        return result;
    }

    public static String getMessage(String messageKey) {
        try {
            return PAnnotationUtilities.getMessageString(messageKey);
        }
        catch (Exception e) {
            return messageKey;
        }
    }

    public static String getMessage(String messageKey, Object[] args) {
        try {
            String message = PAnnotationUtilities.getMessageString(messageKey);
            message = MessageFormat.format(message, args);
            return message;
        }
        catch (Exception e) {
            return messageKey;
        }
    }

    public static URL getResource(String imageName) {
        try {
            URL url = PAnnotationUtilities.class.getResource(imageName);
            return url;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static boolean isLeftToRight() {
        try {
            return ComponentOrientation.getOrientation(Locale.getDefault()).isLeftToRight();
        }
        catch (Throwable t) {
            return true;
        }
    }

    public static boolean isRightToLeft() {
        try {
            return !ComponentOrientation.getOrientation(Locale.getDefault()).isLeftToRight();
        }
        catch (Throwable t) {
            return true;
        }
    }

    public static ComponentOrientation getComponentOrientation() {
        if (PAnnotationUtilities.isLeftToRight()) {
            return ComponentOrientation.LEFT_TO_RIGHT;
        }
        return ComponentOrientation.RIGHT_TO_LEFT;
    }

    public static Border getTitledBorder(String title, int position, int justification) {
        Border etchedBorder = BorderFactory.createEtchedBorder();
        return BorderFactory.createTitledBorder(etchedBorder, title, position, justification);
    }

    public static boolean getBooleanProperty(String key, Properties properties, boolean defaultValue) {
        String prop = properties.getProperty(key);
        if (prop == null) {
            return defaultValue;
        }
        if (!prop.equalsIgnoreCase("true") && !prop.equalsIgnoreCase("false")) {
            properties.put(key, Boolean.toString(defaultValue));
            System.out.println(PAnnotationUtilities.getMessage("preference.InvalidValue", new Object[]{key}));
            return defaultValue;
        }
        boolean value = new Boolean(prop);
        return value;
    }

    public static void setBooleanProperty(String key, Properties properties, boolean value) {
        String prop = Boolean.toString(value);
        properties.setProperty(key, prop);
    }

    public static int getIntegerProperty(String key, Properties properties, int defaultValue) {
        String prop = properties.getProperty(key);
        if (prop == null) {
            return defaultValue;
        }
        int value = Integer.parseInt(prop);
        return value;
    }

    public static int getIntegerProperty(String key, Properties properties, int defaultValue, int minValue, int maxValue) {
        String prop = properties.getProperty(key);
        if (prop == null) {
            return defaultValue;
        }
        try {
            int value = Integer.parseInt(prop);
            if (value > maxValue || value < minValue) {
                System.out.println(PAnnotationUtilities.getMessage("preference.InvalidValue", new Object[]{key}));
                return defaultValue;
            }
            return value;
        }
        catch (NumberFormatException e) {
            System.out.println(PAnnotationUtilities.getMessage("preference.InvalidValue", new Object[]{key}));
            return defaultValue;
        }
    }

    public static void setStringProperty(String key, Properties properties, String value) {
        if (value == null) {
            if (properties.containsKey(key)) {
                properties.remove(key);
            }
        } else {
            properties.setProperty(key, value);
        }
    }

    public static String getStringProperty(String key, Properties properties, String defaultValue) {
        String prop = properties.getProperty(key);
        if (prop == null) {
            return defaultValue;
        }
        return prop;
    }

    public static void setIntegerProperty(String key, Properties properties, int value) {
        String prop = Integer.toString(value);
        properties.setProperty(key, prop);
    }

    public static Color getColorProperty(String key, Properties properties, Color defaultValue) {
        String prop = properties.getProperty(key);
        if (prop == null) {
            return defaultValue;
        }
        Color value = null;
        try {
            value = new Color(Integer.parseInt(prop), true);
        }
        catch (NumberFormatException e) {
            System.out.println(PAnnotationUtilities.getMessage("preference.InvalidValue", new Object[]{key}));
            return defaultValue;
        }
        catch (IllegalArgumentException e) {
            System.out.println(PAnnotationUtilities.getMessage("preference.InvalidValue", new Object[]{key}));
            return defaultValue;
        }
        return value;
    }

    public static void setColorProperty(String key, Properties properties, Color value) {
        String prop = Integer.toString(value.getRGB());
        properties.setProperty(key, prop);
    }

    public static Font getFontProperty(String key, Properties properties, Font defaultValue) {
        String prop = properties.getProperty(key);
        if (prop == null) {
            return defaultValue;
        }
        Font value = Font.decode(prop);
        return value;
    }

    public static void setFontProperty(String key, Properties properties, Font value) {
        String style = "";
        style = value.getStyle() == 0 ? "plain" : (value.getStyle() == 1 ? "bold" : (value.getStyle() == 2 ? "italic" : (value.getStyle() == 3 ? "bolditalic" : "plain")));
        String prop = value.getFamily() + "-" + style + "-" + value.getSize();
        properties.setProperty(key, prop);
    }

    public static byte[] getDataProperty(String key, Properties properties, byte[] defaultValue) {
        String prop = null;
        String subprop = properties.getProperty(key + ".0");
        int i = 0;
        while (subprop != null) {
            prop = prop == null ? subprop : prop + subprop;
            subprop = properties.getProperty(key + "." + ++i);
        }
        if (prop == null) {
            return defaultValue;
        }
        byte[] value = PAnnotationUtilities.base16Decode(prop);
        return value;
    }

    public static void setDataProperty(String key, Properties properties, byte[] value) {
        String prop = PAnnotationUtilities.base16Encode(value);
        if (prop != null) {
            int i = 0;
            while (i * 4096 < prop.length()) {
                if (i * 4096 + 4096 - 1 < prop.length()) {
                    properties.setProperty(key + "." + i, prop.substring(i * 4096, i * 4096 + 4096));
                } else {
                    properties.setProperty(key + "." + i, prop.substring(i * 4096));
                }
                ++i;
            }
        }
    }

    private static byte[] base16Decode(String prop) {
        if (prop == null || prop.length() == 0) {
            return null;
        }
        byte[] value = new byte[prop.length() / 2];
        for (int i = 0; i < value.length; ++i) {
            value[i] = (byte)(PAnnotationUtilities.decodeChar(prop.charAt(2 * i)) << 4 | PAnnotationUtilities.decodeChar(prop.charAt(2 * i + 1)));
        }
        return value;
    }

    private static int decodeChar(char c) {
        if (c == '0') {
            return 0;
        }
        if (c == '1') {
            return 1;
        }
        if (c == '2') {
            return 2;
        }
        if (c == '3') {
            return 3;
        }
        if (c == '4') {
            return 4;
        }
        if (c == '5') {
            return 5;
        }
        if (c == '6') {
            return 6;
        }
        if (c == '7') {
            return 7;
        }
        if (c == '8') {
            return 8;
        }
        if (c == '9') {
            return 9;
        }
        if (c == 'A') {
            return 10;
        }
        if (c == 'B') {
            return 11;
        }
        if (c == 'C') {
            return 12;
        }
        if (c == 'D') {
            return 13;
        }
        if (c == 'E') {
            return 14;
        }
        if (c == 'F') {
            return 15;
        }
        throw new IllegalArgumentException();
    }

    private static String base16Encode(byte[] value) {
        if (value == null) {
            return null;
        }
        char[] charBuf = new char[value.length * 2];
        for (int i = 0; i < value.length; ++i) {
            charBuf[2 * i] = encodeTable[(value[i] & 0xF0) >> 4];
            charBuf[2 * i + 1] = encodeTable[value[i] & 0xF];
        }
        return new String(charBuf);
    }

    public static Dimension getDimensionProperty(String key, Properties properties, Dimension defaultValue) {
        String propWidth = properties.getProperty(key + ".width");
        String propHeight = properties.getProperty(key + ".height");
        if (propWidth == null || propHeight == null) {
            return defaultValue;
        }
        Dimension value = new Dimension(Integer.parseInt(propWidth), Integer.parseInt(propHeight));
        return value;
    }

    public static void setDimensionProperty(String key, Properties properties, Dimension value) {
        if (value == null) {
            if (properties.containsKey(key + ".width")) {
                properties.remove(key + ".width");
            }
            if (properties.containsKey(key + ".height")) {
                properties.remove(key + ".height");
            }
        } else {
            String propWidth = Integer.toString(value.width);
            String propHeight = Integer.toString(value.height);
            properties.setProperty(key + ".width", propWidth);
            properties.setProperty(key + ".height", propHeight);
        }
    }

    public static Font getValidDefaultFont(String familyName, String style, int size) {
        Object validFont = null;
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontFamilyNames = gEnv.getAvailableFontFamilyNames();
        for (int i = 0; i < fontFamilyNames.length; ++i) {
            if (familyName.compareToIgnoreCase(fontFamilyNames[i]) != 0) continue;
            return Font.decode(familyName + "-" + style + "-" + size);
        }
        return Font.decode("Dialog-" + style + "-" + size);
    }
}

