/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer.annotation;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import com.ibm.mm.viewer.annotation.CMBPropertiesPanel;
import com.ibm.mm.viewer.annotation.PAnnotationUtilities;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.text.AttributedString;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CMBTextAnnotation
extends CMBPageAnnotation {
    private static final String copyright = "Licensed Materials - Property of IBM\nIBM DB2 Content Manager Enterprise Edition V8 (program number 5724-B19)\n(c ) Copyright IBM Corp.  1998, 2004.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private CMBPropertiesPanel annotationPropertiesPanel = null;
    private Hashtable compTable = new Hashtable();
    private static boolean isDefaultSet = false;
    private static final Font DEFAULT_FONT = PAnnotationUtilities.getValidDefaultFont("Arial Unicode MS", "plain", 32);
    private static final Color DEFAULT_TEXT_COLOR = new Color(0, 0, 0, 255);
    private static final Color DEFAULT_TEXT_FILL_COLOR = new Color(255, 255, 255, 0);
    private static final int DEFAULT_TEXT_BORDER_WIDTH = 2;
    static String defaultText = PAnnotationUtilities.getMessage("Annotation.text");
    static Color defaultTextColor = DEFAULT_TEXT_COLOR;
    static Color defaultFillColor = DEFAULT_TEXT_FILL_COLOR;
    private static int defaultBorderWidth = 2;
    private static boolean defaultVWD = false;
    private static boolean defaultTransparent = true;
    static boolean defaultRotate = false;
    static Font defaultFont = DEFAULT_FONT;
    static final long serialVersionUID = 1L;
    private transient Vector propList = null;
    private String textLine = defaultText;
    private Font textFont = defaultFont;
    private transient int boxWidth;
    private transient int boxHeight = 0;

    public CMBTextAnnotation() {
        this.init();
    }

    public CMBTextAnnotation(Rectangle r, String text) {
        super(r);
        this.setTextLine(text);
        this.init();
    }

    public CMBTextAnnotation(Rectangle r, String text, int pageNumber) {
        super(r, pageNumber);
        this.setTextLine(text);
        this.init();
    }

    public void init() {
        this.setBorderWidth(defaultBorderWidth);
        this.setFillColor(defaultFillColor);
        this.setFont(defaultFont);
        this.setRotateWithImage(defaultRotate);
        this.setBorderColor(defaultTextColor);
        this.setTransparent(defaultTransparent);
        this.setVisibleWhileDragging(defaultVWD);
        this.type = 9;
        if (isDefaultSet) {
            this.updateValues(104);
        } else {
            this.updateValues(103);
        }
    }

    public void setFont(Font f) {
        if (!this.canUpdate()) {
            return;
        }
        this.firePropertiesWillChangeEvent();
        this.textFont = f;
        this.recalculateDrawRect();
        this.firePropertiesChangeEvent();
    }

    public Font getFont() {
        return this.textFont;
    }

    public void setTextLine(String text) {
        if (!this.canUpdate()) {
            return;
        }
        this.firePropertiesWillChangeEvent();
        this.textLine = text;
        this.recalculateDrawRect();
        this.firePropertiesChangeEvent();
    }

    public String getTextLine() {
        return this.textLine;
    }

    private void recalculateDrawRect() {
        String methodName = "recalculateDrawRect";
        String text = this.textLine;
        if (text == null || text.length() == 0) {
            text = " ";
        }
        TextLayout textLayout = null;
        double h = 0.0;
        double w = 0.0;
        BufferedReader br = new BufferedReader(new StringReader(text));
        try {
            boolean fDone = false;
            while (!fDone) {
                String s = br.readLine();
                if (s == null) {
                    fDone = true;
                    continue;
                }
                if (s.length() <= 0) {
                    s = " ";
                }
                AttributedString attributedString = new AttributedString(s);
                attributedString.addAttribute(TextAttribute.FONT, this.textFont);
                FontRenderContext frc = new FontRenderContext(null, false, false);
                textLayout = new TextLayout(attributedString.getIterator(), frc);
                h += (double)(textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading());
                w = Math.max(w, (double)textLayout.getAdvance());
            }
        }
        catch (IOException e) {
            ViewerLogger.logError((Object)this, methodName, e);
        }
        this.boxWidth = (int)w + 10;
        this.boxHeight = (int)h + 10;
        if (this.getRotateWithImage() || this.getRotation() == 0) {
            this.resizeDrawRect(this.boxWidth, this.boxHeight);
        } else {
            int oldAnnotationCenterX = this.getDrawRect().x + this.getDrawRect().width / 2;
            int oldAnnotationCenterY = this.getDrawRect().y + this.getDrawRect().height / 2;
            Rectangle myRect = new Rectangle(oldAnnotationCenterX - this.boxWidth / 2, oldAnnotationCenterY - this.boxHeight / 2, this.boxWidth, this.boxHeight);
            this.setDrawRect(myRect.x, myRect.y, myRect.width, myRect.height);
        }
    }

    public void growBy(int dx, int dy) {
    }

    protected void drawHandles(Graphics2D g) {
        if (this.getAnnotationSet() != null && !this.getAnnotationSet().isActive()) {
            return;
        }
        Color oldColor = g.getColor();
        Stroke oldStroke = g.getStroke();
        g.setColor(Color.black);
        g.setStroke(this.getOutlineStroke());
        g.setXORMode(Color.white);
        Rectangle r = this.getAnnoDrawRect();
        r.grow(1, 1);
        g.draw(r);
        g.setPaintMode();
        g.setStroke(oldStroke);
        g.setColor(oldColor);
    }

    public boolean pointInHandle(Point p) {
        return false;
    }

    protected int getDefaultHandleWidth() {
        return 0;
    }

    protected int getDefaultHandleHeight() {
        return 0;
    }

    public void draw(Graphics2D g2) {
        String methodName = "draw";
        if (!this.allowedToDraw) {
            return;
        }
        if (this.isInMotion && !this.isVisibleWhileDragging) {
            this.drawOutline(g2);
            return;
        }
        Rectangle drawRect = this.getAnnoDrawRect();
        Color oldColor = g2.getColor();
        Stroke oldStroke = g2.getStroke();
        Paint oldPaint = g2.getPaint();
        Object oldAliasing = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle fillRect = this.getFillRect();
        g2.setColor(this.getBorderColor());
        g2.setStroke(this.getBorderStroke());
        Rectangle2D.Float rect = new Rectangle2D.Float(drawRect.x, drawRect.y, drawRect.width, drawRect.height);
        g2.setPaint(this.getFillColor());
        g2.setStroke(oldStroke);
        rect.setFrame(fillRect.x, fillRect.y, fillRect.width, fillRect.height);
        g2.fill(rect);
        g2.setPaint(oldPaint);
        Shape oldClip = g2.getClip();
        g2.clipRect(fillRect.x, fillRect.y, fillRect.width, fillRect.height);
        g2.setColor(this.getBorderColor());
        int x = 0;
        int y = 0;
        double rot = this.getRotationInRadians(this.getRotation());
        if (this.getRotateWithImage()) {
            g2.rotate(rot, drawRect.x, drawRect.y);
            switch (this.getRotation()) {
                case 0: {
                    x = drawRect.x + 5;
                    y = drawRect.y + 5;
                    break;
                }
                case 1: {
                    y = drawRect.y - drawRect.width + 5;
                    x = drawRect.x + 5;
                    break;
                }
                case 2: {
                    x = drawRect.x - drawRect.width + 5;
                    y = drawRect.y - drawRect.height + 5;
                    break;
                }
                case 3: {
                    x = drawRect.x - drawRect.height + 5;
                    y = drawRect.y + 5;
                }
            }
        } else {
            x = drawRect.x + 5;
            y = drawRect.y + 5;
        }
        String text = this.textLine;
        if (text == null || text.length() == 0) {
            text = " ";
        }
        BufferedReader br = new BufferedReader(new StringReader(text));
        if (text.indexOf(System.getProperty("line.separator")) > -1) {
            try {
                boolean fDone = false;
                while (!fDone) {
                    TextLayout textLayout;
                    FontRenderContext frc;
                    AttributedString attributedString;
                    String s = br.readLine();
                    if (s == null) {
                        fDone = true;
                        continue;
                    }
                    if (s.length() > 0) {
                        attributedString = new AttributedString(s);
                        attributedString.addAttribute(TextAttribute.FONT, this.textFont);
                        frc = new FontRenderContext(null, false, false);
                        textLayout = new TextLayout(attributedString.getIterator(), frc);
                        y = (int)((float)y + textLayout.getAscent());
                        textLayout.draw(g2, x, y);
                        y = (int)((float)y + (textLayout.getDescent() + textLayout.getLeading()));
                        continue;
                    }
                    attributedString = new AttributedString(" ");
                    attributedString.addAttribute(TextAttribute.FONT, this.textFont);
                    frc = new FontRenderContext(null, false, false);
                    textLayout = new TextLayout(attributedString.getIterator(), frc);
                    y = (int)((float)y + textLayout.getAscent());
                    textLayout.draw(g2, x, y);
                    y = (int)((float)y + (textLayout.getDescent() + textLayout.getLeading()));
                }
            }
            catch (IOException e) {
                ViewerLogger.logError((Object)this, methodName, e);
            }
        } else {
            FontRenderContext frc = new FontRenderContext(null, false, false);
            TextLayout layout = new TextLayout(text, this.textFont, frc);
            if (!PAnnotationUtilities.isLeftToRight()) {
                AttributedString attributedString = new AttributedString(text);
                attributedString.addAttribute(TextAttribute.FONT, this.textFont);
                attributedString.addAttribute(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                layout = new TextLayout(attributedString.getIterator(), frc);
            }
            if (layout != null) {
                y = (int)((float)y + layout.getAscent());
                layout.draw(g2, x, y);
            }
        }
        if (this.getRotateWithImage()) {
            g2.rotate(-rot, drawRect.x, drawRect.y);
        }
        g2.setClip(oldClip);
        g2.setColor(oldColor);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAliasing);
        super.draw(g2);
    }

    public void drawOutline(Graphics2D g2) {
        Color oldColor = g2.getColor();
        Rectangle drawRect = this.getAnnoDrawRect();
        Stroke oldStroke = g2.getStroke();
        g2.setColor(Color.black);
        g2.setStroke(this.getOutlineStroke());
        Rectangle2D.Float rect = new Rectangle2D.Float(drawRect.x, drawRect.y, drawRect.width, drawRect.height);
        g2.draw(rect);
        g2.setStroke(oldStroke);
        g2.setColor(oldColor);
        super.drawOutline(g2);
    }

    public CMBPropertiesPanel getAnnotationPropertiesPanel() {
        if (this.annotationPropertiesPanel == null) {
            if (this.propList == null) {
                this.propList = new Vector();
            }
            this.propList.addElement("Annotation.textColor");
            this.propList.addElement(Color.white);
            this.propList.addElement("Annotation.fillColor");
            this.propList.addElement(Color.white);
            this.propList.addElement("Annotation.font");
            this.propList.addElement(new Font(null));
            if (!this.getPermanentlyRotating()) {
                this.propList.addElement("Annotation.rotateWithImage");
                this.propList.addElement(new Boolean(true));
            }
            this.propList.addElement("Annotation.transparent");
            this.propList.addElement(new Boolean(true));
            this.annotationPropertiesPanel = new CMBPropertiesPanel(this, this.propList);
        }
        return this.annotationPropertiesPanel;
    }

    public JPanel getPropertiesPanel() {
        this.getAnnotationPropertiesPanel().setAnnotation(this);
        return this.annotationPropertiesPanel.getPanel();
    }

    public void handlePropertyChange(String propName, JComponent comp, int action) {
        if (action == 106) {
            isDefaultSet = true;
        }
        if (propName.equals("Annotation.textColor")) {
            switch (action) {
                case 101: {
                    this.setBorderColor(comp.getBackground());
                    break;
                }
                case 102: {
                    comp.setBackground(this.getBorderColor());
                    break;
                }
                case 103: {
                    defaultTextColor = this.getBorderColor();
                    break;
                }
                case 104: {
                    this.setBorderColor(defaultTextColor);
                    break;
                }
                case 105: {
                    comp.setBackground(defaultTextColor);
                    break;
                }
                case 106: {
                    defaultTextColor = comp.getBackground();
                }
            }
        } else if (propName.equals("Annotation.fillColor")) {
            switch (action) {
                case 101: {
                    this.setFillColor(comp.getBackground());
                    break;
                }
                case 102: {
                    comp.setBackground(this.getFillColor());
                    break;
                }
                case 103: {
                    defaultFillColor = this.getFillColor();
                    break;
                }
                case 104: {
                    this.setFillColor(defaultFillColor);
                    break;
                }
                case 105: {
                    comp.setBackground(defaultFillColor);
                    break;
                }
                case 106: {
                    defaultFillColor = comp.getBackground();
                }
            }
        } else if (propName.equals("Annotation.rotateWithImage")) {
            switch (action) {
                case 101: {
                    this.setRotateWithImage(((JCheckBox)comp).isSelected());
                    break;
                }
                case 102: {
                    ((JCheckBox)comp).setSelected(this.getRotateWithImage());
                    break;
                }
                case 103: {
                    defaultRotate = this.getRotateWithImage();
                    break;
                }
                case 104: {
                    this.setRotateWithImage(defaultRotate);
                    break;
                }
                case 105: {
                    ((JCheckBox)comp).setSelected(defaultRotate);
                    break;
                }
                case 106: {
                    defaultRotate = ((JCheckBox)comp).isSelected();
                }
            }
        } else if (propName.equals("Annotation.visibleWhileDragging")) {
            switch (action) {
                case 101: {
                    this.setVisibleWhileDragging(((JCheckBox)comp).isSelected());
                    break;
                }
                case 102: {
                    ((JCheckBox)comp).setSelected(this.getVisibleWhileDragging());
                    break;
                }
                case 103: {
                    defaultVWD = this.getVisibleWhileDragging();
                    break;
                }
                case 104: {
                    this.setVisibleWhileDragging(defaultVWD);
                    break;
                }
                case 105: {
                    ((JCheckBox)comp).setSelected(defaultVWD);
                    break;
                }
                case 106: {
                    defaultVWD = ((JCheckBox)comp).isSelected();
                }
            }
        } else if (propName.equals("Annotation.transparent")) {
            switch (action) {
                case 101: {
                    this.setTransparent(((JCheckBox)comp).isSelected());
                    break;
                }
                case 102: {
                    ((JCheckBox)comp).setSelected(this.getTransparent());
                    break;
                }
                case 103: {
                    defaultTransparent = this.getTransparent();
                    break;
                }
                case 104: {
                    this.setTransparent(defaultTransparent);
                    break;
                }
                case 105: {
                    ((JCheckBox)comp).setSelected(defaultTransparent);
                    break;
                }
                case 106: {
                    defaultTransparent = ((JCheckBox)comp).isSelected();
                }
            }
        } else if (propName.equals("Annotation.font")) {
            switch (action) {
                case 101: {
                    this.setFont(comp.getFont());
                    break;
                }
                case 102: {
                    comp.setFont(this.getFont());
                    break;
                }
                case 103: {
                    defaultFont = this.getFont();
                    break;
                }
                case 104: {
                    this.setFont(defaultFont);
                    break;
                }
                case 105: {
                    comp.setFont(defaultFont);
                    break;
                }
                case 106: {
                    defaultFont = comp.getFont();
                }
            }
        }
    }

    public void updateValues(int action) {
        if (this.compTable.isEmpty()) {
            return;
        }
        Enumeration props = this.compTable.keys();
        while (props.hasMoreElements()) {
            String propName = (String)props.nextElement();
            JComponent comp = (JComponent)this.compTable.get(propName);
            this.handlePropertyChange(propName, comp, action);
        }
        super.updateValues(action);
    }

    public void addPropertyComponent(String propertyName, JComponent component) {
        this.compTable.put(propertyName, component);
    }

    protected boolean canBePermanentlyRotated() {
        return false;
    }

    public void updatePropertiesFrom(CMBPageAnnotation newValues) {
        this.setFont(newValues.getFont());
        this.setTextLine(((CMBTextAnnotation)newValues).getTextLine());
        super.updatePropertiesFrom(newValues);
    }

    public void dispose() {
        this.textLine = null;
        this.textFont = null;
        this.annotationPropertiesPanel = null;
        super.dispose();
    }

    public Object clone() {
        CMBTextAnnotation s = (CMBTextAnnotation)super.clone();
        s.annotationPropertiesPanel = null;
        s.propList = new Vector();
        s.compTable = new Hashtable();
        s.textFont = new Font(this.textFont.getName(), this.textFont.getStyle(), this.textFont.getSize());
        return s;
    }

    public String toString() {
        return new String("[Annotation:" + this.getName() + " ,page:" + this.getPageNumber() + " ,text:" + this.getTextLine() + " ,font:" + this.getFont() + " ,drawRect:" + this.getAnnoDrawRect() + " ,fillColor:" + this.getFillColor() + " ,borderColor:" + this.getBorderColor() + "]");
    }

    static void getDefaultAnnotationProperties(Properties properties) {
        PAnnotationUtilities.setIntegerProperty("Text.borderWidth", properties, defaultBorderWidth);
        PAnnotationUtilities.setColorProperty("Text.fillColor", properties, defaultFillColor);
        PAnnotationUtilities.setFontProperty("Text.font", properties, defaultFont);
        PAnnotationUtilities.setBooleanProperty("Text.rotate", properties, defaultRotate);
        PAnnotationUtilities.setColorProperty("Text.textColor", properties, defaultTextColor);
        PAnnotationUtilities.setBooleanProperty("Text.transparent", properties, defaultTransparent);
    }

    static void setDefaultAnnotationProperties(Properties properties) {
        defaultBorderWidth = PAnnotationUtilities.getIntegerProperty("Text.borderWidth", properties, 2, 1, 100);
        defaultFillColor = PAnnotationUtilities.getColorProperty("Text.fillColor", properties, DEFAULT_TEXT_FILL_COLOR);
        defaultFont = PAnnotationUtilities.getFontProperty("Text.font", properties, DEFAULT_FONT);
        defaultRotate = PAnnotationUtilities.getBooleanProperty("Text.rotate", properties, false);
        defaultTextColor = PAnnotationUtilities.getColorProperty("Text.textColor", properties, DEFAULT_TEXT_COLOR);
        defaultTransparent = PAnnotationUtilities.getBooleanProperty("Text.transparent", properties, true);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.textLine = (String)stream.readObject();
        this.textFont = (Font)stream.readObject();
        this.setTextLine(this.textLine);
        this.setFont(this.textFont);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.getTextLine());
        stream.writeObject(this.getFont());
    }
}

