/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer.annotation;

import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import com.ibm.mm.viewer.annotation.CMBPropertiesPanel;
import com.ibm.mm.viewer.annotation.PAnnotationUtilities;
import com.ibm.mm.viewer.annotation.PNumericField;
import com.ibm.mm.viewer.annotation.PStampImageProvider;
import com.ibm.mm.viewer.annotation.PStampSelectPanel;
import com.ibm.mm.viewer.annotation.PTextOrImagePropertiesEditor;
import com.ibm.mm.viewer.annotation.StampObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.AttributedString;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class CMBStampAnnotation
extends CMBPageAnnotation {
    private static final String copyright = "Licensed Materials - Property of IBM\nIBM DB2 Content Manager Enterprise Edition V8 (program number 5724-B19)\n(c ) Copyright IBM Corp.  1998, 2004.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private CMBPropertiesPanel annotationPropertiesPanel = null;
    private PStampSelectPanel stampSelectPanel = null;
    private Hashtable compTable = new Hashtable();
    private static boolean isDefaultSet = false;
    private static final Font DEFAULT_FONT = PAnnotationUtilities.getValidDefaultFont("Arial Unicode MS", "plain", 32);
    private static final int DEFAULT_ANGLE = 0;
    private static final String DEFAULT_TEXT = PAnnotationUtilities.getMessage("Annotation.stamp");
    private static final int MIN_STAMP_COUNT = 0;
    private static final int MAX_STAMP_COUNT = 1000;
    private static final boolean DEFAULT_IS_IMAGE_STAMP = false;
    private static final byte[] DEFAULT_IMAGE_DATA = null;
    private static final Dimension DEFAULT_IMAGE_SIZE = null;
    static Color defaultBorderColor = DEFAULT_BORDER_COLOR;
    static Color defaultFillColor = DEFAULT_FILL_COLOR;
    static int defaultBorderWidth = 5;
    private static boolean defaultVWD = false;
    private static boolean defaultTransparent = true;
    static int defaultAngle = 0;
    static boolean defaultRotate = true;
    static String defaultText = DEFAULT_TEXT;
    static boolean defaultIsImageStamp = false;
    static byte[] defaultImageData = null;
    static Dimension defaultImageSize = null;
    static Vector defaultAvailableStamps = null;
    static Font defaultFont = DEFAULT_FONT;
    private boolean isDummyStamp = false;
    private ActionHandler actionHandler = null;
    static final long serialVersionUID = 1L;
    private transient Vector propList = null;
    private Rectangle containingRect = new Rectangle(this.getAnnoDrawRect());
    private String stampString = defaultText;
    private Font stampFont = defaultFont;
    private int angle = defaultAngle;
    private transient int boxWidth;
    private transient int boxHeight = 0;
    private transient Rectangle2D bounds = null;
    private transient FontRenderContext frc = null;
    private transient TextLayout layout = null;
    private boolean imageStamp = false;
    private byte[] imageData = null;
    private Dimension imageSize = null;

    public CMBStampAnnotation() {
        this.init();
    }

    public CMBStampAnnotation(Rectangle r) {
        super(r);
        this.init();
    }

    public CMBStampAnnotation(Rectangle r, int pageNumber) {
        super(r, pageNumber);
        this.init();
    }

    public void init() {
        this.type = 8;
        this.angle = defaultAngle;
        this.setBorderColor(defaultBorderColor);
        this.setBorderWidth(defaultBorderWidth);
        this.setFillColor(defaultFillColor);
        this.setFont(defaultFont);
        this.setRotateWithImage(defaultRotate);
        this.setStampText(defaultText);
        this.setImageStamp(defaultIsImageStamp);
        this.setImageData(defaultImageData);
        this.setTransparent(defaultTransparent);
        this.setVisibleWhileDragging(defaultVWD);
        if (isDefaultSet) {
            this.updateValues(104);
        } else {
            this.updateValues(103);
        }
        this.recalculateDrawRect();
    }

    public void setFont(Font f) {
        if (!this.canUpdate() || this.stampFont.equals(f)) {
            return;
        }
        this.firePropertiesWillChangeEvent();
        this.stampFont = f;
        this.recalculateDrawRect();
        this.firePropertiesChangeEvent();
    }

    public Font getFont() {
        return this.stampFont;
    }

    public void setDummyStamp(boolean flag) {
        this.isDummyStamp = flag;
    }

    public boolean getDummyStamp() {
        return this.isDummyStamp;
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public boolean isImageStamp() {
        return this.imageStamp;
    }

    public void setImageData(byte[] imData) {
        this.firePropertiesWillChangeEvent();
        this.imageData = imData;
        this.firePropertiesChangeEvent();
    }

    public Dimension getImageSize() {
        return this.imageSize;
    }

    public void setImageSize(Dimension imageSize) {
        this.firePropertiesWillChangeEvent();
        this.imageSize = imageSize;
        this.firePropertiesChangeEvent();
        this.resizeDrawRect(imageSize.width + this.getBorderWidth() * 2, imageSize.height + this.getBorderWidth() * 2);
    }

    public void setImageStamp(boolean isImage) {
        if (this.imageStamp != isImage) {
            this.firePropertiesWillChangeEvent();
            this.imageStamp = isImage;
            this.firePropertiesChangeEvent();
            if (!this.imageStamp) {
                this.recalculateDrawRect();
                this.setTransparent(defaultTransparent);
            } else {
                this.setTransparent(false);
            }
        }
    }

    private Image getImage() {
        Image stampImage = null;
        if (!this.isImageStamp() || this.getImageData() == null || this.getImageData().length == 0) {
            return null;
        }
        PStampImageProvider imageProvider = this.getAnnotationSet().getAnnotationServices().getStampImageProvider();
        stampImage = imageProvider.getImage(this.getImageData());
        return stampImage;
    }

    public void draw(Graphics2D g2) {
        if (!this.allowedToDraw) {
            return;
        }
        if (this.isInMotion && !this.isVisibleWhileDragging) {
            this.drawOutline(g2);
            return;
        }
        Color oldColor = g2.getColor();
        Rectangle drawRect = this.getAnnoDrawRect();
        Stroke oldStroke = g2.getStroke();
        Paint oldPaint = g2.getPaint();
        Rectangle fillRect = this.getFillRect();
        g2.setPaint(this.getFillColor());
        g2.setStroke(oldStroke);
        Object oldAliasing = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AffineTransform oldTransform = g2.getTransform();
        if (this.angle != 0) {
            g2.rotate((double)(360 - this.angle) * (Math.PI / 180), drawRect.x + drawRect.width / 2, drawRect.y + drawRect.height / 2);
        }
        Rectangle2D.Float rect = new Rectangle2D.Float(drawRect.x, drawRect.y, drawRect.width, drawRect.height);
        rect.setFrame(fillRect.x, fillRect.y, fillRect.width, fillRect.height);
        g2.fill(rect);
        g2.setColor(this.getBorderColor());
        g2.setStroke(this.getBorderStroke());
        g2.setFont(this.stampFont);
        Rectangle borderRect = this.getAnnoDrawRect();
        rect.setFrame(borderRect.x, borderRect.y, borderRect.width, borderRect.height);
        g2.draw(rect);
        double rotationInRadians = this.getRotationInRadians(this.getRotation());
        int x = 0;
        int y = 0;
        if (!this.isImageStamp()) {
            if (this.getRotateWithImage()) {
                switch (this.getRotation()) {
                    case 0: {
                        x = drawRect.x + (drawRect.width / 2 - (int)this.bounds.getWidth() / 2);
                        y = drawRect.y + (int)this.bounds.getHeight() / 2 + drawRect.height / 2 - (int)this.layout.getDescent() / 2;
                        break;
                    }
                    case 1: {
                        x = drawRect.x + (drawRect.height / 2 - (int)this.bounds.getWidth() / 2);
                        y = drawRect.y - (drawRect.width / 2 - ((int)this.bounds.getHeight() - (int)this.layout.getDescent()) / 2);
                        break;
                    }
                    case 2: {
                        x = drawRect.x - drawRect.width + (drawRect.width / 2 - (int)this.bounds.getWidth() / 2);
                        y = drawRect.y - (drawRect.height / 2 - ((int)this.bounds.getHeight() - (int)this.layout.getDescent()) / 2);
                        break;
                    }
                    case 3: {
                        x = drawRect.x - drawRect.height + (drawRect.height / 2 - (int)this.bounds.getWidth() / 2);
                        y = drawRect.y + drawRect.width / 2 + ((int)this.bounds.getHeight() - (int)this.layout.getDescent()) / 2;
                    }
                }
                g2.rotate(rotationInRadians, drawRect.x, drawRect.y);
            } else {
                x = drawRect.x + (drawRect.width / 2 - (int)this.bounds.getWidth() / 2);
                y = drawRect.y + (int)this.bounds.getHeight() / 2 + drawRect.height / 2 - (int)this.layout.getDescent() / 2;
            }
            this.layout.draw(g2, x, y);
        } else {
            Image stampImage = this.getImage();
            if (stampImage != null) {
                if (this.getRotateWithImage()) {
                    g2.rotate(rotationInRadians, drawRect.x, drawRect.y);
                }
                if (!this.getRotateWithImage() || this.getRotation() == 0) {
                    g2.drawImage(stampImage, drawRect.x + this.getBorderWidth(), drawRect.y + this.getBorderWidth(), drawRect.width - this.getBorderWidth() * 2, drawRect.height - this.getBorderWidth() * 2, null);
                } else if (this.getRotation() == 1) {
                    g2.drawImage(stampImage, drawRect.x + this.getBorderWidth(), drawRect.y - drawRect.width + this.getBorderWidth(), drawRect.height - this.getBorderWidth() * 2, drawRect.width - this.getBorderWidth() * 2, null);
                } else if (this.getRotation() == 2) {
                    g2.drawImage(stampImage, drawRect.x - drawRect.width + this.getBorderWidth(), drawRect.y - drawRect.height + this.getBorderWidth(), drawRect.width - this.getBorderWidth() * 2, drawRect.height - this.getBorderWidth() * 2, null);
                } else {
                    g2.drawImage(stampImage, drawRect.x - drawRect.height + this.getBorderWidth(), drawRect.y + this.getBorderWidth(), drawRect.height - this.getBorderWidth() * 2, drawRect.width - this.getBorderWidth() * 2, null);
                }
            }
        }
        g2.setTransform(oldTransform);
        g2.setPaint(oldPaint);
        g2.setStroke(oldStroke);
        g2.setColor(oldColor);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAliasing);
        super.draw(g2);
    }

    public Rectangle getRefreshRect() {
        Rectangle cRect = this.translateRotateDocRect(this.getContainingRect());
        Rectangle scaledCRect = this.scaleRectangle(cRect);
        scaledCRect.grow(4, 4);
        return scaledCRect;
    }

    public void drawOutline(Graphics2D g2) {
        Color oldColor = g2.getColor();
        AffineTransform oldTransform = g2.getTransform();
        Rectangle drawRect = this.getAnnoDrawRect();
        if (this.angle != 0) {
            g2.rotate((double)(360 - this.angle) * (Math.PI / 180), drawRect.x + drawRect.width / 2, drawRect.y + drawRect.height / 2);
        }
        Stroke oldStroke = g2.getStroke();
        g2.setColor(Color.black);
        g2.setStroke(this.getOutlineStroke());
        Rectangle2D.Float rect = new Rectangle2D.Float(drawRect.x, drawRect.y, drawRect.width, drawRect.height);
        g2.draw(rect);
        g2.setStroke(oldStroke);
        g2.setColor(oldColor);
        g2.setTransform(oldTransform);
        super.drawOutline(g2);
    }

    Rectangle getContainingRect() {
        Rectangle c = this.getDrawRect();
        AffineTransform at = AffineTransform.getRotateInstance((double)(360 - this.angle) * (Math.PI / 180), c.x + c.width / 2, c.y + c.height / 2);
        Shape r = at.createTransformedShape(c);
        return r.getBounds();
    }

    public void growBy(int dx, int dy) {
    }

    protected void drawHandles(Graphics2D g) {
        if (this.getAnnotationSet() != null && !this.getAnnotationSet().isActive()) {
            return;
        }
        Color oldColor = g.getColor();
        g.setColor(Color.black);
        Stroke oldStroke = g.getStroke();
        g.setStroke(this.getOutlineStroke());
        g.setXORMode(Color.white);
        Rectangle r = this.translateRotateDocRect(this.getContainingRect());
        r.grow(1, 1);
        g.draw(r);
        g.setPaintMode();
        g.setColor(oldColor);
        g.setStroke(oldStroke);
    }

    public boolean pointInHandle(Point p) {
        return false;
    }

    public String getStampText() {
        return this.stampString;
    }

    public void setStampText(String text) {
        if (!this.canUpdate() || this.stampString.equals(text)) {
            return;
        }
        this.firePropertiesWillChangeEvent();
        if (text != null && text.length() != 0) {
            this.stampString = text;
            this.recalculateDrawRect();
        }
        this.firePropertiesChangeEvent();
    }

    public void setBorderWidth(int width) {
        if (!this.canUpdate()) {
            return;
        }
        int oldBorderwidth = this.getBorderWidth();
        this.boxWidth = (int)this.getDrawRect().getWidth() - 2 * oldBorderwidth;
        this.boxHeight = (int)this.getDrawRect().getHeight() - 2 * oldBorderwidth;
        super.setBorderWidth(width);
        this.resizeDrawRect(this.boxWidth + this.getBorderWidth() * 2, this.boxHeight + this.getBorderWidth() * 2);
    }

    private void recalculateDrawRect() {
        if (!this.isImageStamp()) {
            if (this.bounds == null) {
                this.bounds = new Rectangle();
            }
            this.frc = new FontRenderContext(null, false, false);
            if (PAnnotationUtilities.isLeftToRight()) {
                this.layout = this.stampString != null && this.stampFont != null ? new TextLayout(this.stampString, this.stampFont, this.frc) : new TextLayout(DEFAULT_TEXT, DEFAULT_FONT, this.frc);
            } else if (this.stampString != null && this.stampFont != null) {
                AttributedString attributedString = new AttributedString(this.stampString);
                attributedString.addAttribute(TextAttribute.FONT, this.stampFont);
                attributedString.addAttribute(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                this.layout = new TextLayout(attributedString.getIterator(), this.frc);
            } else {
                AttributedString attributedString = new AttributedString(DEFAULT_TEXT);
                attributedString.addAttribute(TextAttribute.FONT, DEFAULT_FONT);
                attributedString.addAttribute(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                this.layout = new TextLayout(attributedString.getIterator(), this.frc);
            }
            this.bounds = this.layout.getBounds();
            this.boxWidth = (int)this.bounds.getWidth() + 10;
            this.boxHeight = (int)this.bounds.getHeight() + (int)this.layout.getDescent() + 10;
            this.resizeDrawRect(this.boxWidth + this.getBorderWidth() * 2, this.boxHeight + this.getBorderWidth() * 2);
        }
    }

    protected int getDefaultHandleWidth() {
        return 0;
    }

    protected int getDefaultHandleHeight() {
        return 0;
    }

    public void setStampAngle(int angle) {
        if (!this.canUpdate()) {
            return;
        }
        this.firePropertiesWillChangeEvent();
        this.angle = angle;
        this.firePropertiesChangeEvent();
    }

    public int getStampAngle() {
        return this.angle;
    }

    public void rotate(int rotation) {
        super.rotate(rotation);
        if (this.getRotateWithImage()) {
            if (rotation == 1) {
                this.setStampAngle((this.getStampAngle() + 270) % 360);
            } else if (rotation == 2) {
                this.setStampAngle((this.getStampAngle() + 180) % 360);
            } else if (rotation == 3) {
                this.setStampAngle((this.getStampAngle() + 90) % 360);
            }
        }
    }

    protected boolean canBePermanentlyRotated() {
        return false;
    }

    public CMBPropertiesPanel getAnnotationPropertiesPanel() {
        if (this.annotationPropertiesPanel == null) {
            if (this.propList == null) {
                this.propList = new Vector();
            }
            this.propList.addElement("Annotation.stampTextOrImage");
            this.propList.addElement(new PTextOrImagePropertiesEditor(this.getAnnotationSet().getAnnotationServices()));
            this.propList.addElement("Annotation.borderTextColor");
            this.propList.addElement(Color.white);
            this.propList.addElement("Annotation.borderWidth");
            this.propList.addElement(new Integer[]{new Integer(1), new Integer(100)});
            this.propList.addElement("Annotation.stampAngle");
            this.propList.addElement(new Integer[]{new Integer(0), new Integer(360)});
            this.propList.addElement("Annotation.fillColor");
            this.propList.addElement(Color.white);
            this.propList.addElement("Annotation.font");
            this.propList.addElement(new Font(null));
            this.propList.addElement("Annotation.rotateWithImage");
            this.propList.addElement(new Boolean(true));
            this.propList.addElement("Annotation.transparent");
            this.propList.addElement(new Boolean(true));
            this.annotationPropertiesPanel = new CMBPropertiesPanel(this, this.propList);
        }
        return this.annotationPropertiesPanel;
    }

    public JPanel getPropertiesPanel() {
        if (this.annotationPropertiesPanel == null) {
            this.getAnnotationPropertiesPanel();
        }
        this.annotationPropertiesPanel.setAnnotation(this);
        if (this.isDummyStamp) {
            if (this.stampSelectPanel == null) {
                this.stampSelectPanel = new PStampSelectPanel(this, this.getAnnotationSet().getAnnotationServices());
            }
            if (defaultAvailableStamps != null) {
                this.stampSelectPanel.setAvailableStamps(defaultAvailableStamps);
            }
            this.stampSelectPanel.setDefaultStamp(defaultText, defaultBorderColor, defaultBorderWidth, defaultFillColor, defaultAngle, defaultFont);
            this.stampSelectPanel.setDummyStamp(this);
            JPanel stampPanel = new JPanel();
            if (PAnnotationUtilities.isLeftToRight()) {
                stampPanel.add(this.stampSelectPanel);
            } else {
                stampPanel.add(this.stampSelectPanel);
            }
            return stampPanel;
        }
        return this.annotationPropertiesPanel.getPanel();
    }

    public void handlePropertyChange(String propName, JComponent comp, int action) {
        if (action == 106) {
            isDefaultSet = true;
        }
        if (propName.equals("Annotation.borderTextColor")) {
            switch (action) {
                case 101: {
                    this.setBorderColor(comp.getBackground());
                    break;
                }
                case 102: {
                    comp.setBackground(this.getBorderColor());
                    break;
                }
                case 103: {
                    defaultBorderColor = this.getBorderColor();
                    break;
                }
                case 104: {
                    this.setBorderColor(defaultBorderColor);
                    break;
                }
                case 105: {
                    comp.setBackground(defaultBorderColor);
                    break;
                }
                case 106: {
                    Color guiColor = comp.getBackground();
                    defaultBorderColor = new Color(guiColor.getRed(), guiColor.getGreen(), guiColor.getBlue(), defaultTransparent ? 130 : 255);
                }
            }
        } else if (propName.equals("Annotation.borderWidth")) {
            switch (action) {
                case 101: {
                    this.setBorderWidth(((PNumericField)comp).getValue());
                    break;
                }
                case 102: {
                    ((PNumericField)comp).setValue(this.getBorderWidth());
                    break;
                }
                case 103: {
                    defaultBorderWidth = this.getBorderWidth();
                    break;
                }
                case 104: {
                    this.setBorderWidth(defaultBorderWidth);
                    break;
                }
                case 105: {
                    ((PNumericField)comp).setValue(defaultBorderWidth);
                    break;
                }
                case 106: {
                    defaultBorderWidth = ((PNumericField)comp).getValue();
                }
            }
        } else if (propName.equals("Annotation.stampAngle")) {
            switch (action) {
                case 101: {
                    this.setStampAngle(((PNumericField)comp).getValue());
                    break;
                }
                case 102: {
                    ((PNumericField)comp).setValue(this.getStampAngle());
                    break;
                }
                case 103: {
                    defaultAngle = this.getStampAngle();
                    break;
                }
                case 104: {
                    this.setStampAngle(defaultAngle);
                    break;
                }
                case 105: {
                    ((PNumericField)comp).setValue(defaultAngle);
                    break;
                }
                case 106: {
                    defaultAngle = ((PNumericField)comp).getValue();
                }
            }
        } else if (propName.equals("Annotation.stampText")) {
            switch (action) {
                case 101: {
                    this.setStampText(((JTextField)comp).getText());
                    break;
                }
                case 102: {
                    ((JTextField)comp).setText(this.getStampText());
                    break;
                }
                case 103: {
                    defaultText = this.getStampText();
                    break;
                }
                case 104: {
                    this.setStampText(defaultText);
                    break;
                }
                case 105: {
                    ((JTextField)comp).setText(defaultText);
                    break;
                }
                case 106: {
                    defaultText = ((JTextField)comp).getText();
                }
            }
        } else if (propName.equals("Annotation.stampTextOrImage")) {
            PTextOrImagePropertiesEditor imageField = (PTextOrImagePropertiesEditor)comp;
            JComponent transparentCheckBox = (JComponent)this.compTable.get("Annotation.transparent");
            switch (action) {
                case 101: {
                    if (!imageField.isImageStamp()) {
                        this.setImageStamp(false);
                        this.setStampText(imageField.getStampText());
                        this.setImageData(null);
                        break;
                    }
                    this.setImageStamp(true);
                    this.setImageData(imageField.getImageData());
                    this.setStampText(imageField.getImageFileName());
                    if (imageField.getImageSize() == null) break;
                    this.setImageSize(imageField.getImageSize());
                    break;
                }
                case 102: {
                    if (transparentCheckBox != null) {
                        transparentCheckBox.setEnabled(!this.isImageStamp());
                    }
                    imageField.setImageStamp(this.isImageStamp());
                    if (!this.isImageStamp()) {
                        imageField.setStampText(this.getStampText());
                        imageField.setImageData(null);
                        imageField.setImageFileName(null);
                        break;
                    }
                    imageField.setStampText(null);
                    imageField.setImageData(this.getImageData());
                    imageField.setImageFileName(this.getStampText());
                    imageField.setImageSize(this.getImageSize());
                    break;
                }
                case 103: {
                    defaultIsImageStamp = this.isImageStamp();
                    defaultText = this.getStampText();
                    defaultImageData = this.getImageData();
                    defaultImageSize = this.getImageSize();
                    break;
                }
                case 104: {
                    this.setImageStamp(defaultIsImageStamp);
                    this.setStampText(defaultText);
                    this.setImageData(defaultImageData);
                    if (defaultImageSize == null) break;
                    this.setImageSize(defaultImageSize);
                    break;
                }
                case 105: {
                    if (transparentCheckBox != null) {
                        transparentCheckBox.setEnabled(!this.isImageStamp());
                    }
                    imageField.setImageStamp(defaultIsImageStamp);
                    imageField.setStampText(defaultText);
                    imageField.setImageData(defaultImageData);
                    imageField.setImageSize(defaultImageSize);
                    break;
                }
                case 106: {
                    defaultIsImageStamp = imageField.isImageStamp();
                    defaultText = imageField.getStampText();
                    defaultImageData = imageField.getImageData();
                    defaultImageSize = imageField.getImageSize();
                }
            }
        } else if (propName.equals("Annotation.fillColor")) {
            switch (action) {
                case 101: {
                    this.setFillColor(comp.getBackground());
                    break;
                }
                case 102: {
                    comp.setBackground(this.getFillColor());
                    break;
                }
                case 103: {
                    defaultFillColor = this.getFillColor();
                    break;
                }
                case 104: {
                    this.setFillColor(defaultFillColor);
                    break;
                }
                case 105: {
                    comp.setBackground(defaultFillColor);
                    break;
                }
                case 106: {
                    Color guiFillColor = comp.getBackground();
                    defaultFillColor = new Color(guiFillColor.getRed(), guiFillColor.getGreen(), guiFillColor.getBlue(), defaultTransparent ? 130 : 255);
                }
            }
        } else if (propName.equals("Annotation.rotateWithImage")) {
            switch (action) {
                case 101: {
                    this.setRotateWithImage(((JCheckBox)comp).isSelected());
                    break;
                }
                case 102: {
                    ((JCheckBox)comp).setSelected(this.getRotateWithImage());
                    break;
                }
                case 103: {
                    defaultRotate = this.getRotateWithImage();
                    break;
                }
                case 104: {
                    this.setRotateWithImage(defaultRotate);
                    break;
                }
                case 105: {
                    ((JCheckBox)comp).setSelected(defaultRotate);
                    break;
                }
                case 106: {
                    defaultRotate = ((JCheckBox)comp).isSelected();
                }
            }
        } else if (propName.equals("Annotation.visibleWhileDragging")) {
            switch (action) {
                case 101: {
                    this.setVisibleWhileDragging(((JCheckBox)comp).isSelected());
                    break;
                }
                case 102: {
                    ((JCheckBox)comp).setSelected(this.getVisibleWhileDragging());
                    break;
                }
                case 103: {
                    defaultVWD = this.getVisibleWhileDragging();
                    break;
                }
                case 104: {
                    this.setVisibleWhileDragging(defaultVWD);
                    break;
                }
                case 105: {
                    ((JCheckBox)comp).setSelected(defaultVWD);
                    break;
                }
                case 106: {
                    defaultVWD = ((JCheckBox)comp).isSelected();
                }
            }
        } else if (propName.equals("Annotation.transparent")) {
            switch (action) {
                case 101: {
                    this.setTransparent(((JCheckBox)comp).isSelected());
                    break;
                }
                case 102: {
                    comp.setEnabled(!this.isImageStamp());
                    ((JCheckBox)comp).setSelected(this.getTransparent());
                    break;
                }
                case 103: {
                    defaultTransparent = this.getTransparent();
                    break;
                }
                case 104: {
                    this.setTransparent(defaultTransparent);
                    break;
                }
                case 105: {
                    comp.setEnabled(!this.isImageStamp());
                    ((JCheckBox)comp).setSelected(defaultTransparent);
                    break;
                }
                case 106: {
                    defaultTransparent = ((JCheckBox)comp).isSelected();
                }
            }
        } else if (propName.equals("Annotation.font")) {
            switch (action) {
                case 101: {
                    this.setFont(comp.getFont());
                    break;
                }
                case 102: {
                    comp.setFont(this.getFont());
                    break;
                }
                case 103: {
                    defaultFont = this.getFont();
                    break;
                }
                case 104: {
                    this.setFont(defaultFont);
                    break;
                }
                case 105: {
                    comp.setFont(defaultFont);
                    break;
                }
                case 106: {
                    defaultFont = comp.getFont();
                }
            }
        }
    }

    public void updateValues(int action) {
        if (action == 106 || action == 103 || action == 101 || action == 102) {
            if (this.stampSelectPanel != null) {
                defaultAvailableStamps = this.stampSelectPanel.getAvailableStamps();
                this.fireCMBAnnotationDefaultsChangedEvent(this.getClass());
            }
        } else if ((action == 104 || action == 105) && this.stampSelectPanel != null) {
            this.stampSelectPanel.setAvailableStamps(defaultAvailableStamps);
        }
        if (this.compTable.isEmpty()) {
            return;
        }
        Enumeration props = this.compTable.keys();
        while (props.hasMoreElements()) {
            String propName = (String)props.nextElement();
            JComponent comp = (JComponent)this.compTable.get(propName);
            this.handlePropertyChange(propName, comp, action);
        }
        this.recalculateDrawRect();
        super.updateValues(action);
    }

    public void updatePropertiesFrom(CMBPageAnnotation newValues) {
        if (newValues instanceof CMBStampAnnotation) {
            CMBStampAnnotation newStampValues = (CMBStampAnnotation)newValues;
            this.setStampAngle(newStampValues.getStampAngle());
            this.setStampText(newStampValues.getStampText());
            this.setRotateWithImage(newStampValues.getRotateWithImage());
            this.setFont(newStampValues.getFont());
            this.setImageStamp(newStampValues.isImageStamp());
            this.setImageData(newStampValues.getImageData());
            this.resizeDrawRect(newStampValues.getDrawRect().width, newStampValues.getDrawRect().height);
        }
        super.updatePropertiesFrom(newValues);
        this.recalculateDrawRect();
    }

    void setComponentStates(boolean updatePriv) {
        JCheckBox transparentCheckbox = (JCheckBox)this.compTable.get("Annotation.transparent");
        if (updatePriv && this.isImageStamp()) {
            transparentCheckbox.setEnabled(false);
        }
        if (updatePriv && !this.isImageStamp()) {
            PTextOrImagePropertiesEditor toipEditor = (PTextOrImagePropertiesEditor)this.compTable.get("Annotation.stampTextOrImage");
            toipEditor.getImageSelectButton().setEnabled(false);
        }
    }

    public void addPropertyComponent(String propertyName, JComponent component) {
        this.compTable.put(propertyName, component);
        PTextOrImagePropertiesEditor toipEditor = (PTextOrImagePropertiesEditor)this.compTable.get("Annotation.stampTextOrImage");
        JCheckBox transparentCheckbox = (JCheckBox)this.compTable.get("Annotation.transparent");
        if (toipEditor != null && transparentCheckbox != null) {
            toipEditor.addActionListener(this.getActionHandler());
        }
    }

    public void dispose() {
        if (this.stampSelectPanel != null) {
            this.stampSelectPanel.dispose();
        }
        this.stampString = null;
        this.stampFont = null;
        this.annotationPropertiesPanel = null;
        super.dispose();
    }

    public Object clone() {
        CMBStampAnnotation s = (CMBStampAnnotation)super.clone();
        s.annotationPropertiesPanel = null;
        s.propList = new Vector();
        s.compTable = new Hashtable();
        s.actionHandler = null;
        s.stampFont = new Font(this.stampFont.getName(), this.stampFont.getStyle(), this.stampFont.getSize());
        return s;
    }

    public String toString() {
        return new String("[Annotation:" + this.getName() + " ,page:" + this.getPageNumber() + " ,stamp text:" + this.getStampText() + " ,stamp angle:" + this.getStampAngle() + " ,font:" + this.getFont() + " ,drawRect:" + this.getAnnoDrawRect() + " ,fillColor:" + this.getFillColor() + " ,borderColor:" + this.getBorderColor() + "]");
    }

    boolean isValidImageFile(Component parent) {
        return this.isValidImageFile(parent, true);
    }

    boolean isValidImageFile(Component parent, boolean showMessage) {
        boolean valid = true;
        PTextOrImagePropertiesEditor toipEditor = (PTextOrImagePropertiesEditor)this.compTable.get("Annotation.stampTextOrImage");
        if (toipEditor.getImageRadioButton().isSelected()) {
            String fileName = toipEditor.getImageFileName();
            File imageFile = new File(fileName);
            try {
                FileInputStream imageStream = new FileInputStream(imageFile);
                byte[] newImageData = new byte[(int)imageFile.length()];
                ((InputStream)imageStream).read(newImageData);
                if (newImageData.length > 65535) {
                    if (showMessage) {
                        JOptionPane.showMessageDialog(parent, PAnnotationUtilities.getMessage("SelectImage.imageFileTooLarge", new String[]{""}));
                    }
                    this.imageData = null;
                    valid = false;
                } else {
                    this.imageData = newImageData;
                }
            }
            catch (IOException e) {
                if (showMessage) {
                    JOptionPane.showMessageDialog(parent, PAnnotationUtilities.getMessage("SelectImage.ioException", new String[]{e.getMessage()}));
                }
                this.imageData = null;
                valid = false;
            }
        }
        return valid;
    }

    static void getDefaultAnnotationProperties(Properties properties) {
        PAnnotationUtilities.setIntegerProperty("Stamp.angle", properties, defaultAngle);
        PAnnotationUtilities.setColorProperty("Stamp.borderColor", properties, defaultBorderColor);
        PAnnotationUtilities.setIntegerProperty("Stamp.borderWidth", properties, defaultBorderWidth);
        PAnnotationUtilities.setColorProperty("Stamp.fillColor", properties, defaultFillColor);
        PAnnotationUtilities.setFontProperty("Stamp.font", properties, defaultFont);
        PAnnotationUtilities.setBooleanProperty("Stamp.rotate", properties, defaultRotate);
        PAnnotationUtilities.setStringProperty("Stamp.text", properties, defaultText);
        PAnnotationUtilities.setBooleanProperty("Stamp.transparent", properties, defaultTransparent);
        PAnnotationUtilities.setBooleanProperty("Stamp.imageStamp", properties, defaultIsImageStamp);
        PAnnotationUtilities.setDataProperty("Stamp.imageData", properties, defaultImageData);
        PAnnotationUtilities.setDimensionProperty("Stamp.imageSize", properties, defaultImageSize);
        if (defaultAvailableStamps != null) {
            int nAvailableStamps = defaultAvailableStamps.size();
            PAnnotationUtilities.setIntegerProperty("Stamp.availableStamps.count", properties, nAvailableStamps);
            for (int i = 1; i <= nAvailableStamps; ++i) {
                StampObject stampObject = (StampObject)defaultAvailableStamps.elementAt(i - 1);
                PAnnotationUtilities.setIntegerProperty("Stamp.availableStamps." + i + ".angle", properties, stampObject.stampAngle);
                PAnnotationUtilities.setColorProperty("Stamp.availableStamps." + i + ".borderColor", properties, stampObject.borderColor);
                PAnnotationUtilities.setIntegerProperty("Stamp.availableStamps." + i + ".borderWidth", properties, stampObject.borderWidth);
                PAnnotationUtilities.setColorProperty("Stamp.availableStamps." + i + ".fillColor", properties, stampObject.fillColor);
                PAnnotationUtilities.setFontProperty("Stamp.availableStamps." + i + ".font", properties, stampObject.stampFont);
                PAnnotationUtilities.setStringProperty("Stamp.availableStamps." + i + ".text", properties, stampObject.stampText);
                PAnnotationUtilities.setBooleanProperty("Stamp.availableStamps." + i + ".imageStamp", properties, stampObject.imageStamp);
                if (stampObject.imageStamp) {
                    PAnnotationUtilities.setStringProperty("Stamp.availableStamps." + i + ".imageURL", properties, stampObject.imageURL);
                    PAnnotationUtilities.setDataProperty("Stamp.availableStamps." + i + ".imageData", properties, stampObject.imageData);
                    PAnnotationUtilities.setDimensionProperty("Stamp.availableStamps." + i + ".imageSize", properties, stampObject.imageSize);
                    PAnnotationUtilities.setBooleanProperty("Stamp.availableStamps." + i + ".transparent", properties, false);
                    continue;
                }
                PAnnotationUtilities.setBooleanProperty("Stamp.availableStamps." + i + ".transparent", properties, stampObject.transparent);
            }
        }
    }

    static void setDefaultAnnotationProperties(Properties properties) {
        defaultAngle = PAnnotationUtilities.getIntegerProperty("Stamp.angle", properties, 0, 0, 360);
        defaultBorderColor = PAnnotationUtilities.getColorProperty("Stamp.borderColor", properties, DEFAULT_BORDER_COLOR);
        defaultBorderWidth = PAnnotationUtilities.getIntegerProperty("Stamp.borderWidth", properties, 5, 1, 100);
        defaultFillColor = PAnnotationUtilities.getColorProperty("Stamp.fillColor", properties, DEFAULT_FILL_COLOR);
        defaultFont = PAnnotationUtilities.getFontProperty("Stamp.font", properties, DEFAULT_FONT);
        defaultRotate = PAnnotationUtilities.getBooleanProperty("Stamp.rotate", properties, true);
        defaultText = PAnnotationUtilities.getStringProperty("Stamp.text", properties, DEFAULT_TEXT);
        defaultTransparent = PAnnotationUtilities.getBooleanProperty("Stamp.transparent", properties, true);
        defaultIsImageStamp = PAnnotationUtilities.getBooleanProperty("Stamp.imageStamp", properties, false);
        if (defaultIsImageStamp) {
            defaultImageData = PAnnotationUtilities.getDataProperty("Stamp.imageData", properties, DEFAULT_IMAGE_DATA);
            defaultImageSize = PAnnotationUtilities.getDimensionProperty("Stamp.imageSize", properties, DEFAULT_IMAGE_SIZE);
        } else {
            defaultImageData = null;
            defaultImageSize = null;
        }
        int nAvailableStamps = PAnnotationUtilities.getIntegerProperty("Stamp.availableStamps.count", properties, 0, 0, 1000);
        if (nAvailableStamps > 0) {
            defaultAvailableStamps = new Vector();
            for (int i = 1; i <= nAvailableStamps; ++i) {
                StampObject stampObject = new StampObject();
                stampObject.stampAngle = PAnnotationUtilities.getIntegerProperty("Stamp.availableStamps." + i + ".angle", properties, 0, 0, 360);
                stampObject.borderColor = PAnnotationUtilities.getColorProperty("Stamp.availableStamps." + i + ".borderColor", properties, DEFAULT_BORDER_COLOR);
                stampObject.borderWidth = PAnnotationUtilities.getIntegerProperty("Stamp.availableStamps." + i + ".borderWidth", properties, 5, 1, 100);
                stampObject.fillColor = PAnnotationUtilities.getColorProperty("Stamp.availableStamps." + i + ".fillColor", properties, DEFAULT_FILL_COLOR);
                stampObject.stampFont = PAnnotationUtilities.getFontProperty("Stamp.availableStamps." + i + ".font", properties, DEFAULT_FONT);
                stampObject.stampText = PAnnotationUtilities.getStringProperty("Stamp.availableStamps." + i + ".text", properties, DEFAULT_TEXT);
                stampObject.imageStamp = PAnnotationUtilities.getBooleanProperty("Stamp.availableStamps." + i + ".imageStamp", properties, false);
                if (stampObject.imageStamp) {
                    stampObject.imageURL = PAnnotationUtilities.getStringProperty("Stamp.availableStamps." + i + ".imageURL", properties, "");
                    stampObject.imageData = PAnnotationUtilities.getDataProperty("Stamp.availableStamps." + i + ".imageData", properties, null);
                    stampObject.imageSize = PAnnotationUtilities.getDimensionProperty("Stamp.availableStamps." + i + ".imageSize", properties, null);
                    stampObject.transparent = false;
                } else {
                    stampObject.imageURL = null;
                    stampObject.imageData = null;
                    stampObject.imageSize = null;
                    stampObject.transparent = PAnnotationUtilities.getBooleanProperty("Stamp.availableStamps." + i + ".transparent", properties, true);
                }
                defaultAvailableStamps.addElement(stampObject);
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.setStampAngle(stream.readInt());
        this.stampString = (String)stream.readObject();
        this.stampFont = (Font)stream.readObject();
        this.setStampText(this.stampString);
        this.setFont(this.stampFont);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(this.getStampAngle());
        stream.writeObject(this.getStampText());
        stream.writeObject(this.getFont());
    }

    private ActionHandler getActionHandler() {
        if (this.actionHandler == null) {
            this.actionHandler = new ActionHandler();
        }
        return this.actionHandler;
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            PTextOrImagePropertiesEditor toipEditor = (PTextOrImagePropertiesEditor)CMBStampAnnotation.this.compTable.get("Annotation.stampTextOrImage");
            JCheckBox transparentCheckbox = (JCheckBox)CMBStampAnnotation.this.compTable.get("Annotation.transparent");
            if (e.getSource().equals(toipEditor.getTextRadioButton())) {
                if (((JRadioButton)e.getSource()).isSelected()) {
                    transparentCheckbox.setEnabled(true);
                    transparentCheckbox.setSelected(defaultTransparent);
                }
            } else if (e.getSource().equals(toipEditor.getImageRadioButton()) && ((JRadioButton)e.getSource()).isSelected()) {
                transparentCheckbox.setSelected(false);
                transparentCheckbox.setEnabled(false);
            }
        }
    }
}

