/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer.annotation;

import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import com.ibm.mm.viewer.annotation.CMBPropertiesPanel;
import com.ibm.mm.viewer.annotation.PAnnotationUtilities;
import com.ibm.mm.viewer.annotation.PNumericField;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CMBRectAnnotation
extends CMBPageAnnotation {
    private static final String copyright = "Licensed Materials - Property of IBM\nIBM DB2 Content Manager Enterprise Edition V8 (program number 5724-B19)\n(c ) Copyright IBM Corp.  1998, 2004.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private CMBPropertiesPanel annotationPropertiesPanel = null;
    private Hashtable compTable = new Hashtable();
    private static boolean isDefaultSet = false;
    private static Color defaultBorderColor = DEFAULT_BORDER_COLOR;
    private static Color defaultFillColor = DEFAULT_FILL_COLOR;
    private static int defaultBorderWidth = 5;
    private static boolean defaultVWD = false;
    private static boolean defaultTransparent = true;
    static final long serialVersionUID = 1L;
    private transient Vector propList = null;

    public CMBRectAnnotation() {
        this.init();
    }

    public CMBRectAnnotation(Rectangle r) {
        super(r);
        this.init();
    }

    public CMBRectAnnotation(Rectangle r, int pageNumber) {
        super(r, pageNumber);
        this.init();
    }

    public void init() {
        this.type = 7;
        this.setBorderColor(defaultBorderColor);
        this.setBorderWidth(defaultBorderWidth);
        this.setFillColor(defaultFillColor);
        this.setTransparent(defaultTransparent);
        this.setVisibleWhileDragging(defaultVWD);
        if (isDefaultSet) {
            this.updateValues(104);
        } else {
            this.updateValues(103);
        }
    }

    public void draw(Graphics2D g2) {
        if (!this.allowedToDraw) {
            return;
        }
        if (this.isInMotion && !this.isVisibleWhileDragging) {
            this.drawOutline(g2);
            return;
        }
        Color oldColor = g2.getColor();
        Paint oldPaint = g2.getPaint();
        Stroke oldStroke = g2.getStroke();
        Object oldAliasing = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setPaint(this.getFillColor());
        g2.fill(this.getFillRect());
        g2.setColor(this.getBorderColor());
        int borderWidth = this.getBorderWidth();
        g2.setStroke(this.getBorderStroke());
        g2.draw(this.getAnnoDrawRect());
        g2.setStroke(oldStroke);
        g2.setPaint(oldPaint);
        g2.setColor(oldColor);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAliasing);
        super.draw(g2);
    }

    public void drawOutline(Graphics2D g2) {
        Color oldColor = g2.getColor();
        Stroke oldStroke = g2.getStroke();
        Rectangle drawRect = this.getAnnoDrawRect();
        g2.setColor(Color.black);
        g2.setStroke(this.getOutlineStroke());
        Rectangle2D.Float rect = new Rectangle2D.Float(drawRect.x, drawRect.y, drawRect.width, drawRect.height);
        g2.draw(rect);
        g2.setStroke(oldStroke);
        g2.setColor(oldColor);
        super.drawOutline(g2);
    }

    public CMBPropertiesPanel getAnnotationPropertiesPanel() {
        if (this.annotationPropertiesPanel == null) {
            if (this.propList == null) {
                this.propList = new Vector();
            }
            this.propList.addElement("Annotation.borderColor");
            this.propList.addElement(Color.white);
            this.propList.addElement("Annotation.borderWidth");
            this.propList.addElement(new Integer[]{new Integer(1), new Integer(100)});
            this.propList.addElement("Annotation.fillColor");
            this.propList.addElement(Color.white);
            this.propList.addElement("Annotation.transparent");
            this.propList.addElement(new Boolean(true));
            this.annotationPropertiesPanel = new CMBPropertiesPanel(this, this.propList);
        }
        return this.annotationPropertiesPanel;
    }

    public JPanel getPropertiesPanel() {
        this.getAnnotationPropertiesPanel().setAnnotation(this);
        return this.annotationPropertiesPanel.getPanel();
    }

    public void handlePropertyChange(String propName, JComponent comp, int action) {
        if (action == 106) {
            isDefaultSet = true;
        }
        if (propName.equals("Annotation.borderColor")) {
            switch (action) {
                case 101: {
                    this.setBorderColor(comp.getBackground());
                    break;
                }
                case 102: {
                    comp.setBackground(this.getBorderColor());
                    break;
                }
                case 103: {
                    defaultBorderColor = this.getBorderColor();
                    break;
                }
                case 104: {
                    this.setBorderColor(defaultBorderColor);
                    break;
                }
                case 105: {
                    comp.setBackground(defaultBorderColor);
                    break;
                }
                case 106: {
                    defaultBorderColor = comp.getBackground();
                }
            }
        } else if (propName.equals("Annotation.borderWidth")) {
            switch (action) {
                case 101: {
                    this.setBorderWidth(((PNumericField)comp).getValue());
                    break;
                }
                case 102: {
                    ((PNumericField)comp).setValue(this.getBorderWidth());
                    break;
                }
                case 103: {
                    defaultBorderWidth = this.getBorderWidth();
                    break;
                }
                case 104: {
                    this.setBorderWidth(defaultBorderWidth);
                    break;
                }
                case 105: {
                    ((PNumericField)comp).setValue(defaultBorderWidth);
                    break;
                }
                case 106: {
                    defaultBorderWidth = ((PNumericField)comp).getValue();
                }
            }
        } else if (propName.equals("Annotation.fillColor")) {
            switch (action) {
                case 101: {
                    this.setFillColor(comp.getBackground());
                    break;
                }
                case 102: {
                    comp.setBackground(this.getFillColor());
                    break;
                }
                case 103: {
                    defaultFillColor = this.getFillColor();
                    break;
                }
                case 104: {
                    this.setFillColor(defaultFillColor);
                    break;
                }
                case 105: {
                    comp.setBackground(defaultFillColor);
                    break;
                }
                case 106: {
                    defaultFillColor = comp.getBackground();
                }
            }
        } else if (propName.equals("Annotation.visibleWhileDragging")) {
            switch (action) {
                case 101: {
                    this.setVisibleWhileDragging(((JCheckBox)comp).isSelected());
                    break;
                }
                case 102: {
                    ((JCheckBox)comp).setSelected(this.getVisibleWhileDragging());
                    break;
                }
                case 103: {
                    defaultVWD = this.getVisibleWhileDragging();
                    break;
                }
                case 104: {
                    this.setVisibleWhileDragging(defaultVWD);
                    break;
                }
                case 105: {
                    ((JCheckBox)comp).setSelected(defaultVWD);
                    break;
                }
                case 106: {
                    defaultVWD = ((JCheckBox)comp).isSelected();
                }
            }
        } else if (propName.equals("Annotation.transparent")) {
            switch (action) {
                case 101: {
                    this.setTransparent(((JCheckBox)comp).isSelected());
                    break;
                }
                case 102: {
                    ((JCheckBox)comp).setSelected(this.getTransparent());
                    break;
                }
                case 103: {
                    defaultTransparent = this.getTransparent();
                    break;
                }
                case 104: {
                    this.setTransparent(defaultTransparent);
                    break;
                }
                case 105: {
                    ((JCheckBox)comp).setSelected(defaultTransparent);
                    break;
                }
                case 106: {
                    defaultTransparent = ((JCheckBox)comp).isSelected();
                }
            }
        }
    }

    public void updateValues(int action) {
        if (this.compTable.isEmpty()) {
            return;
        }
        Enumeration props = this.compTable.keys();
        while (props.hasMoreElements()) {
            String propName = (String)props.nextElement();
            JComponent comp = (JComponent)this.compTable.get(propName);
            this.handlePropertyChange(propName, comp, action);
        }
        super.updateValues(action);
    }

    public void addPropertyComponent(String propertyName, JComponent component) {
        this.compTable.put(propertyName, component);
    }

    public Object clone() {
        CMBRectAnnotation a = (CMBRectAnnotation)super.clone();
        a.annotationPropertiesPanel = null;
        a.propList = new Vector();
        a.compTable = new Hashtable();
        return a;
    }

    public void dispose() {
        this.annotationPropertiesPanel = null;
        super.dispose();
    }

    static void getDefaultAnnotationProperties(Properties properties) {
        PAnnotationUtilities.setColorProperty("Rect.borderColor", properties, defaultBorderColor);
        PAnnotationUtilities.setIntegerProperty("Rect.borderWidth", properties, defaultBorderWidth);
        PAnnotationUtilities.setColorProperty("Rect.fillColor", properties, defaultFillColor);
        PAnnotationUtilities.setBooleanProperty("Rect.transparent", properties, defaultTransparent);
    }

    static void setDefaultAnnotationProperties(Properties properties) {
        defaultBorderColor = PAnnotationUtilities.getColorProperty("Rect.borderColor", properties, DEFAULT_BORDER_COLOR);
        defaultBorderWidth = PAnnotationUtilities.getIntegerProperty("Rect.borderWidth", properties, 5, 1, 100);
        defaultFillColor = PAnnotationUtilities.getColorProperty("Rect.fillColor", properties, DEFAULT_FILL_COLOR);
        defaultTransparent = PAnnotationUtilities.getBooleanProperty("Rect.transparent", properties, true);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
    }
}

