/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer.annotation;

import com.ibm.mm.viewer.annotation.CMBAnnotationConstants;
import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import com.ibm.mm.viewer.annotation.CMBStampAnnotation;
import com.ibm.mm.viewer.annotation.PAnnotationUtilities;
import com.ibm.mm.viewer.annotation.PColorField;
import com.ibm.mm.viewer.annotation.PFontChooserDialog;
import com.ibm.mm.viewer.annotation.PNumericField;
import com.ibm.mm.viewer.annotation.PTextOrImagePropertiesEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CMBPropertiesPanel
implements CMBAnnotationConstants {
    private static final String copyright = "Licensed Materials - Property of IBM\nIBM DB2 Content Manager Enterprise Edition V8 (program number 5724-B19)\n(c ) Copyright IBM Corp.  1998, 2004.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private CMBPageAnnotation annotation;
    private final JPanel propertiesPanel = new JPanel();
    private final JPanel outerPanel = new JPanel();
    private final JButton resetButton = new JButton(PAnnotationUtilities.getMessage("Annotation.reset"));
    private final JButton setDefaultsButton = new JButton(PAnnotationUtilities.getMessage("Annotation.setDefaults"));
    private Vector labels = new Vector();
    private boolean ltrOrientation = true;
    private ComponentOrientation orient = ComponentOrientation.LEFT_TO_RIGHT;
    private boolean updatePrivilege = true;
    PFontChooserDialog fcd;
    JDialog ccd;
    private Vector components = new Vector();

    public CMBPropertiesPanel(CMBPageAnnotation annotation, Vector propList) {
        this.annotation = annotation;
        this.components.addElement(this.resetButton);
        this.components.addElement(this.setDefaultsButton);
        this.createPropertiesPanel(propList);
        this.addActionListeners();
    }

    void createPropertiesPanel(Vector propList) {
        JComponent l;
        int i;
        this.ltrOrientation = PAnnotationUtilities.isLeftToRight();
        if (!this.ltrOrientation) {
            this.orient = ComponentOrientation.RIGHT_TO_LEFT;
        }
        this.propertiesPanel.setComponentOrientation(this.orient);
        this.resetButton.setComponentOrientation(this.orient);
        this.setDefaultsButton.setComponentOrientation(this.orient);
        Box mainPanel = Box.createHorizontalBox();
        Box borderedPanel = Box.createVerticalBox();
        JPanel buttonsPanel = new JPanel(new BorderLayout());
        this.outerPanel.setBorder(BorderFactory.createEtchedBorder());
        int ht = 4;
        JComponent box = null;
        int propSize = propList.size();
        for (int i2 = 0; i2 < propSize; ++i2) {
            Object objType;
            String label = (String)propList.elementAt(i2);
            if ((objType = propList.elementAt(++i2)) instanceof Color) {
                box = this.buildColor(label);
            } else if (objType instanceof Font) {
                box = this.buildFont(label);
            } else if (objType instanceof Integer[]) {
                Integer[] newInteger = (Integer[])objType;
                box = this.buildInteger(label, newInteger[0], newInteger[1]);
            } else if (objType instanceof PTextOrImagePropertiesEditor) {
                box = this.buildTextOrImage(label);
            } else if (objType instanceof String) {
                box = this.buildString(label);
            } else if (objType instanceof Boolean) {
                box = this.buildBoolean(label);
            } else if (objType instanceof JButton) {
                // empty if block
            }
            if (box == null) continue;
            borderedPanel.add(box);
            borderedPanel.add(Box.createVerticalStrut(ht));
        }
        Dimension labelSize = new Dimension(0, 0);
        int count = this.labels.size();
        for (i = 0; i < count; ++i) {
            l = (JComponent)this.labels.elementAt(i);
            if (!((double)labelSize.width < l.getPreferredSize().getWidth())) continue;
            labelSize = l.getPreferredSize();
        }
        for (i = 0; i < count; ++i) {
            l = (JComponent)this.labels.elementAt(i);
            l.setPreferredSize(labelSize);
        }
        this.outerPanel.add(borderedPanel);
        this.resetButton.setMnemonic(PAnnotationUtilities.getMessage("Annotation.reset.mnemonic").charAt(0));
        JPanel buttonsSubpanel = new JPanel(new GridLayout(2, 1, 5, 5));
        buttonsSubpanel.add(this.resetButton);
        buttonsSubpanel.add(this.setDefaultsButton);
        buttonsPanel.add((Component)buttonsSubpanel, "North");
        this.setDefaultsButton.setMnemonic(PAnnotationUtilities.getMessage("Annotation.setDefaults.mnemonic").charAt(0));
        if (this.ltrOrientation) {
            mainPanel.add(this.outerPanel);
            mainPanel.add(Box.createHorizontalStrut(ht));
            mainPanel.add(buttonsPanel);
        } else {
            mainPanel.add(buttonsPanel);
            mainPanel.add(Box.createHorizontalStrut(ht));
            mainPanel.add(this.outerPanel);
        }
        this.propertiesPanel.add(mainPanel);
    }

    public void addActionListeners() {
        this.resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                CMBPropertiesPanel.this.onReset();
            }
        });
        this.setDefaultsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                CMBPropertiesPanel.this.onSetDefaults();
            }
        });
    }

    public JPanel getPanel() {
        return this.propertiesPanel;
    }

    public void setAnnotation(CMBPageAnnotation a) {
        this.annotation = a;
    }

    public CMBPageAnnotation getAnnotation() {
        return this.annotation;
    }

    public void onReset() {
        this.annotation.updateValues(105);
        if (this.annotation.getApplyNow()) {
            this.annotation.updateValues(101);
        }
    }

    public void onSetDefaults() {
        this.annotation.updateValues(106);
        this.annotation.firePropertiesChangeEvent();
    }

    void onPropertyChange(String property, JComponent c) {
        if (this.annotation.getApplyNow()) {
            this.annotation.handlePropertyChange(property, c, 101);
        }
    }

    Box buildColor(final String label) {
        Box colorBox = new Box(0);
        JLabel colorLabel = new JLabel(PAnnotationUtilities.getMessage(label), 10);
        colorLabel.setDisplayedMnemonic(PAnnotationUtilities.getMessage(label + ".mnemonic").charAt(0));
        this.labels.addElement(colorLabel);
        final PColorField colorText = new PColorField(3);
        colorText.setEditable(false);
        colorText.validate();
        this.annotation.handlePropertyChange(label, colorText, 102);
        JButton colorButton = new JButton(PAnnotationUtilities.getMessage("Annotation.ellipsis"));
        colorButton.getAccessibleContext().setAccessibleName(PAnnotationUtilities.getMessage(label));
        this.components.addElement(colorButton);
        colorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                final JColorChooser colorChooser = new JColorChooser(colorText.getBackground());
                ActionListener okListener = new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Color newColor = colorChooser.getColor();
                        if (newColor != null) {
                            colorText.setBackground(newColor);
                            CMBPropertiesPanel.this.onPropertyChange(label, colorText);
                        }
                    }
                };
                Window w = SwingUtilities.windowForComponent(CMBPropertiesPanel.this.outerPanel);
                colorChooser.setPreviewPanel(new JPanel());
                CMBPropertiesPanel.this.ccd = JColorChooser.createDialog(w, PAnnotationUtilities.getMessage("PropertiesDialog.chooseColor"), true, colorChooser, okListener, null);
                CMBPropertiesPanel.this.ccd.show();
                CMBPropertiesPanel.this.ccd = null;
            }
        });
        colorLabel.setLabelFor(colorButton);
        colorLabel.setComponentOrientation(this.orient);
        colorText.setComponentOrientation(this.orient);
        colorButton.setComponentOrientation(this.orient);
        colorBox.setComponentOrientation(this.orient);
        if (this.ltrOrientation) {
            colorBox.add(colorLabel);
            colorBox.add(Box.createHorizontalStrut(2));
            colorBox.add(colorText);
            colorBox.add(colorButton);
            colorBox.add(Box.createHorizontalGlue());
        } else {
            colorBox.add(Box.createHorizontalGlue());
            colorBox.add(colorButton);
            colorBox.add(colorText);
            colorBox.add(Box.createHorizontalStrut(2));
            colorBox.add(colorLabel);
        }
        this.annotation.addPropertyComponent(label, colorText);
        return colorBox;
    }

    PTextOrImagePropertiesEditor buildTextOrImage(final String label) {
        final PTextOrImagePropertiesEditor textOrImageEditor = new PTextOrImagePropertiesEditor(this.annotation.getAnnotationSet().getAnnotationServices());
        textOrImageEditor.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CMBPropertiesPanel.this.onPropertyChange(label, textOrImageEditor);
            }
        });
        this.components.add(textOrImageEditor.getTextField());
        this.components.add(textOrImageEditor.getImageSelectButton());
        this.labels.add(textOrImageEditor.getTextRadioButton());
        this.labels.add(textOrImageEditor.getImageRadioButton());
        this.annotation.handlePropertyChange(label, textOrImageEditor, 102);
        this.annotation.addPropertyComponent(label, textOrImageEditor);
        return textOrImageEditor;
    }

    Box buildFont(final String label) {
        Box fontBox = Box.createVerticalBox();
        Box fontNameBox = Box.createHorizontalBox();
        Box fontAttrBox = Box.createHorizontalBox();
        JLabel fontPropertyLabel = new JLabel(PAnnotationUtilities.getMessage(label), 10);
        fontPropertyLabel.setDisplayedMnemonic(PAnnotationUtilities.getMessage(label + ".mnemonic").charAt(0));
        this.labels.addElement(fontPropertyLabel);
        JButton fontButton = new JButton(PAnnotationUtilities.getMessage("Annotation.ellipsis"));
        fontButton.getAccessibleContext().setAccessibleName(PAnnotationUtilities.getMessage(label));
        this.components.addElement(fontButton);
        fontPropertyLabel.setLabelFor(fontButton);
        final JLabel fontComp = new JLabel();
        fontComp.setVisible(false);
        Font currentFont = this.annotation.getFont();
        final FontNameLabel fontName = new FontNameLabel(currentFont.getName());
        final JLabel fontStyle = new JLabel(this.getFontStyle(currentFont));
        fontStyle.setBorder(BorderFactory.createBevelBorder(1));
        final JLabel fontSize = new JLabel("" + currentFont.getSize());
        fontSize.setBorder(BorderFactory.createBevelBorder(1));
        this.components.addElement(fontName);
        this.components.addElement(fontStyle);
        this.components.addElement(fontSize);
        fontComp.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Font newFont = (Font)event.getNewValue();
                fontName.setText(newFont.getName());
                fontStyle.setText(CMBPropertiesPanel.this.getFontStyle(newFont));
                fontSize.setText("" + newFont.getSize());
            }
        });
        this.annotation.handlePropertyChange(label, fontComp, 102);
        fontButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                CMBPropertiesPanel.this.fcd = new PFontChooserDialog((Frame)CMBPropertiesPanel.this.getParentFrame(), CMBPropertiesPanel.this.annotation.getFont());
                CMBPropertiesPanel.this.fcd.show();
                if (CMBPropertiesPanel.this.fcd.okPressed()) {
                    Font chosenFont = CMBPropertiesPanel.this.fcd.getChosenFont();
                    fontComp.setFont(chosenFont);
                    fontName.setText(chosenFont.getName());
                    fontStyle.setText(CMBPropertiesPanel.this.getFontStyle(chosenFont));
                    fontSize.setText("" + chosenFont.getSize());
                    CMBPropertiesPanel.this.onPropertyChange(label, fontComp);
                }
                CMBPropertiesPanel.this.fcd = null;
            }
        });
        fontPropertyLabel.setComponentOrientation(this.orient);
        fontName.setComponentOrientation(this.orient);
        fontButton.setComponentOrientation(this.orient);
        fontStyle.setComponentOrientation(this.orient);
        fontSize.setComponentOrientation(this.orient);
        fontBox.setComponentOrientation(this.orient);
        if (this.ltrOrientation) {
            fontNameBox.add(fontPropertyLabel);
            fontNameBox.add(Box.createHorizontalGlue());
            fontNameBox.add(fontName);
            fontNameBox.add(fontButton);
            fontNameBox.add(Box.createHorizontalGlue());
            fontAttrBox.add(Box.createHorizontalGlue());
            fontAttrBox.add(fontStyle);
            fontAttrBox.add(fontSize);
            fontAttrBox.add(Box.createHorizontalGlue());
        } else {
            fontNameBox.add(Box.createHorizontalGlue());
            fontNameBox.add(fontButton);
            fontNameBox.add(fontName);
            fontNameBox.add(Box.createHorizontalGlue());
            fontNameBox.add(fontPropertyLabel);
            fontAttrBox.add(Box.createHorizontalGlue());
            fontAttrBox.add(fontSize);
            fontAttrBox.add(fontStyle);
            fontAttrBox.add(Box.createHorizontalGlue());
        }
        fontBox.add(fontNameBox);
        fontBox.add(fontAttrBox);
        this.annotation.addPropertyComponent(label, fontComp);
        return fontBox;
    }

    Box buildInteger(final String label, int min, int max) {
        Box intBox = new Box(0);
        JLabel intLabel = new JLabel(PAnnotationUtilities.getMessage(label), 10);
        intLabel.setDisplayedMnemonic(PAnnotationUtilities.getMessage(label + ".mnemonic").charAt(0));
        this.labels.addElement(intLabel);
        final PNumericField intField = new PNumericField();
        intField.setMinValue(min);
        intField.setMaxValue(max);
        this.annotation.handlePropertyChange(label, intField, 102);
        this.components.addElement(intField);
        intField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                CMBPropertiesPanel.this.onPropertyChange(label, intField);
            }
        });
        intField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                CMBPropertiesPanel.this.onPropertyChange(label, intField);
            }
        });
        intLabel.setLabelFor(intField);
        intLabel.setComponentOrientation(this.orient);
        intField.setComponentOrientation(this.orient);
        intBox.setComponentOrientation(this.orient);
        if (this.ltrOrientation) {
            intBox.add(intLabel);
            intBox.add(intField);
            intBox.add(Box.createHorizontalGlue());
        } else {
            intBox.add(intField);
            intBox.add(intLabel);
            intBox.add(Box.createHorizontalGlue());
        }
        this.annotation.addPropertyComponent(label, intField);
        return intBox;
    }

    Box buildString(final String label) {
        Box stringBox = new Box(0);
        JLabel stringLabel = new JLabel(PAnnotationUtilities.getMessage(label), 10);
        stringLabel.setDisplayedMnemonic(PAnnotationUtilities.getMessage(label + ".mnemonic").charAt(0));
        this.labels.addElement(stringLabel);
        final StringField stringText = new StringField();
        this.annotation.handlePropertyChange(label, stringText, 102);
        this.components.addElement(stringText);
        stringText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                CMBPropertiesPanel.this.onPropertyChange(label, stringText);
            }
        });
        stringLabel.setLabelFor(stringText);
        stringLabel.setComponentOrientation(this.orient);
        stringText.setComponentOrientation(this.orient);
        stringBox.setComponentOrientation(this.orient);
        if (this.ltrOrientation) {
            stringBox.add(stringLabel);
            stringBox.add(stringText);
            stringBox.add(Box.createHorizontalGlue());
        } else {
            stringBox.add(Box.createHorizontalGlue());
            stringBox.add(stringText);
            stringBox.add(stringLabel);
        }
        this.annotation.addPropertyComponent(label, stringText);
        return stringBox;
    }

    Box buildBoolean(final String label) {
        Box boolBox = new Box(0);
        final JCheckBox boolCheck = new JCheckBox(PAnnotationUtilities.getMessage(label));
        boolCheck.setMnemonic(PAnnotationUtilities.getMessage(label + ".mnemonic").charAt(0));
        this.annotation.handlePropertyChange(label, boolCheck, 102);
        this.components.addElement(boolCheck);
        boolCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                CMBPropertiesPanel.this.onPropertyChange(label, boolCheck);
            }
        });
        boolCheck.setComponentOrientation(this.orient);
        boolBox.setComponentOrientation(this.orient);
        if (this.ltrOrientation) {
            boolBox.add(boolCheck);
            boolBox.add(Box.createHorizontalGlue());
        } else {
            boolBox.add(Box.createHorizontalGlue());
            boolBox.add(boolCheck);
        }
        this.annotation.addPropertyComponent(label, boolCheck);
        return boolBox;
    }

    private String getFontStyle(Font font) {
        String style = font.isBold() ? (font.isItalic() ? PAnnotationUtilities.getMessage("Font.bolditalic") : PAnnotationUtilities.getMessage("Font.bold")) : (font.isItalic() ? PAnnotationUtilities.getMessage("Font.italic") : PAnnotationUtilities.getMessage("Font.plain"));
        return style;
    }

    private int getMaxFontNameLength() {
        return 0;
    }

    private int getMaxFontStyleLength() {
        return PAnnotationUtilities.getMessage("Font.bolditalic").length();
    }

    private JFrame getParentFrame() {
        for (Container c = this.propertiesPanel.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof JFrame)) continue;
            return (JFrame)c;
        }
        return null;
    }

    void setComponentStates(boolean updatePrivilege) {
        int size = this.components.size();
        for (int i = 0; i < size; ++i) {
            Component c = (Component)this.components.elementAt(i);
            c.setEnabled(updatePrivilege);
        }
        int labelsSize = this.labels.size();
        for (int j = 0; j < labelsSize; ++j) {
            Component c = (Component)this.labels.elementAt(j);
            c.setEnabled(updatePrivilege);
        }
        if (this.annotation instanceof CMBStampAnnotation) {
            ((CMBStampAnnotation)this.annotation).setComponentStates(updatePrivilege);
            if (!((CMBStampAnnotation)this.annotation).isValidImageFile(this.propertiesPanel, false)) {
                this.setDefaultsButton.setEnabled(false);
            } else {
                this.setDefaultsButton.setEnabled(true);
            }
        }
    }

    public JPanel getInteriorPanel() {
        return this.outerPanel;
    }

    public void dispose() {
        if (this.components != null) {
            for (int i = 0; i < this.components.size(); ++i) {
                JComponent component = (JComponent)this.components.get(i);
                if (!(component instanceof PTextOrImagePropertiesEditor)) continue;
                ((PTextOrImagePropertiesEditor)component).dispose();
            }
        }
        if (this.fcd != null) {
            this.fcd.dispose();
        }
        if (this.ccd != null) {
            this.ccd.dispose();
        }
    }

    boolean hasUpdatePrivilege() {
        return this.updatePrivilege;
    }

    class StringField
    extends JTextField {
        static final int MAX_FIELD_WIDTH = 150;

        public Dimension getPreferredSize() {
            return new Dimension(150, super.getPreferredSize().height);
        }
    }

    class FontNameLabel
    extends JLabel {
        FontNameLabel(String initialText) {
            super(initialText, 11);
            this.setBorder(BorderFactory.createBevelBorder(1));
            int longestFontNameLength = 0;
            String[] fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            for (int i = 0; i < fontNames.length; ++i) {
                longestFontNameLength = Math.max(longestFontNameLength, this.getFontMetrics(this.getFont()).stringWidth(fontNames[i]));
            }
            int preferredWidth = longestFontNameLength + this.getBorder().getBorderInsets((Component)this).left + this.getBorder().getBorderInsets((Component)this).left;
            this.setPreferredSize(new Dimension(preferredWidth, this.getPreferredSize().height));
        }
    }
}

