/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer.annotation;

import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import com.ibm.mm.viewer.annotation.CMBPenStroke;
import com.ibm.mm.viewer.annotation.CMBPropertiesPanel;
import com.ibm.mm.viewer.annotation.PAnnotationUtilities;
import com.ibm.mm.viewer.annotation.PNumericField;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CMBPenAnnotation
extends CMBPageAnnotation {
    private static final String copyright = "Licensed Materials - Property of IBM\nIBM DB2 Content Manager Enterprise Edition V8 (program number 5724-B19)\n(c ) Copyright IBM Corp.  1998, 2004.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private CMBPropertiesPanel annotationPropertiesPanel = null;
    private Hashtable compTable = new Hashtable();
    static boolean isDefaultSet = false;
    static Color defaultBorderColor = DEFAULT_BORDER_COLOR;
    static int defaultWidth = 5;
    private static boolean defaultVWD = false;
    private static boolean defaultTransparent = true;
    static final long serialVersionUID = 1L;
    private transient Vector propList = null;
    private Vector strokeList = new Vector();

    public CMBPenAnnotation() {
        this.init();
    }

    public CMBPenAnnotation(Vector strokes, int pageNumber) {
        this.pageNumber = pageNumber;
        this.setPenStrokes(strokes);
        this.init();
    }

    void setPenStrokes(Vector strokes) {
        this.firePropertiesWillChangeEvent();
        this.strokeList = (Vector)strokes.clone();
        this.calculateDrawRect();
        this.firePropertiesChangeEvent();
    }

    private void calculateDrawRect() {
        int size = this.strokeList.size();
        if (size == 0) {
            return;
        }
        int boundsMinX = Integer.MAX_VALUE;
        int boundsMinY = Integer.MAX_VALUE;
        int boundsMaxX = Integer.MIN_VALUE;
        int boundsMaxY = Integer.MIN_VALUE;
        for (int i = 0; i < size; ++i) {
            boundsMinX = Math.min(boundsMinX, ((CMBPenStroke)this.strokeList.elementAt((int)i)).from.x);
            boundsMaxX = Math.max(boundsMaxX, ((CMBPenStroke)this.strokeList.elementAt((int)i)).from.x);
            boundsMinX = Math.min(boundsMinX, ((CMBPenStroke)this.strokeList.elementAt((int)i)).to.x);
            boundsMaxX = Math.max(boundsMaxX, ((CMBPenStroke)this.strokeList.elementAt((int)i)).to.x);
            boundsMinY = Math.min(boundsMinY, ((CMBPenStroke)this.strokeList.elementAt((int)i)).from.y);
            boundsMaxY = Math.max(boundsMaxY, ((CMBPenStroke)this.strokeList.elementAt((int)i)).from.y);
            boundsMinY = Math.min(boundsMinY, ((CMBPenStroke)this.strokeList.elementAt((int)i)).to.y);
            boundsMaxY = Math.max(boundsMaxY, ((CMBPenStroke)this.strokeList.elementAt((int)i)).to.y);
        }
        super.setDrawRect(boundsMinX, boundsMinY, boundsMaxX - boundsMinX, boundsMaxY - boundsMinY);
    }

    public void init() {
        this.type = 6;
        this.setBorderColor(defaultBorderColor);
        this.setTransparent(defaultTransparent);
        this.setVisibleWhileDragging(defaultVWD);
        this.setBorderWidth(defaultWidth);
        this.calculateDrawRect();
        if (isDefaultSet) {
            this.updateValues(104);
        } else {
            this.updateValues(103);
        }
    }

    public Vector getPenStrokes() {
        return this.strokeList;
    }

    public void draw(Graphics2D g2) {
        if (!this.allowedToDraw) {
            return;
        }
        if (this.isInMotion && !this.isVisibleWhileDragging) {
            this.drawOutline(g2);
            return;
        }
        Color oldColor = g2.getColor();
        Stroke oldStroke = g2.getStroke();
        Object oldAliasing = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.getBorderColor());
        g2.setStroke(this.getBorderStroke());
        int size = this.strokeList.size();
        Rectangle StartPoint = new Rectangle();
        Rectangle EndPoint = new Rectangle();
        int[] xpoints = new int[size * 2];
        int[] ypoints = new int[size * 2];
        int npoints = 0;
        for (int i = 0; i < size; ++i) {
            CMBPenStroke s = (CMBPenStroke)this.strokeList.elementAt(i);
            StartPoint.x = s.from.x;
            StartPoint.y = s.from.y;
            StartPoint.width = 0;
            StartPoint.height = 0;
            Rectangle TransformedStartPoint = this.translateRotateDocRect(StartPoint);
            EndPoint.x = s.to.x;
            EndPoint.y = s.to.y;
            EndPoint.width = 0;
            EndPoint.height = 0;
            Rectangle TransformedEndPoint = this.translateRotateDocRect(EndPoint);
            if (npoints > 0 && (xpoints[npoints - 1] != TransformedStartPoint.x || ypoints[npoints - 1] != TransformedStartPoint.y)) {
                g2.drawPolyline(xpoints, ypoints, npoints);
                npoints = 0;
            }
            if (npoints == 0) {
                xpoints[npoints] = TransformedStartPoint.x;
                ypoints[npoints] = TransformedStartPoint.y;
                ++npoints;
            }
            xpoints[npoints] = TransformedEndPoint.x;
            ypoints[npoints] = TransformedEndPoint.y;
            ++npoints;
        }
        g2.drawPolyline(xpoints, ypoints, npoints);
        g2.setColor(oldColor);
        g2.setStroke(oldStroke);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAliasing);
        super.draw(g2);
    }

    public void drawOutline(Graphics2D g2) {
        Color oldColor = g2.getColor();
        Stroke oldStroke = g2.getStroke();
        Rectangle drawRect = this.getAnnoDrawRect();
        g2.setColor(Color.black);
        g2.setStroke(this.getOutlineStroke());
        Rectangle2D.Float rect = new Rectangle2D.Float(drawRect.x, drawRect.y, drawRect.width, drawRect.height);
        g2.draw(rect);
        g2.setStroke(oldStroke);
        g2.setColor(oldColor);
        super.drawOutline(g2);
    }

    protected void drawHandles(Graphics2D g) {
        if (this.getAnnotationSet() != null && !this.getAnnotationSet().isActive()) {
            return;
        }
        Color oldColor = g.getColor();
        g.setColor(Color.black);
        Stroke oldStroke = g.getStroke();
        g.setStroke(this.getOutlineStroke());
        g.setXORMode(Color.white);
        g.draw(this.getAnnoDrawRect());
        g.setPaintMode();
        g.setColor(oldColor);
        g.setStroke(oldStroke);
        g.setPaintMode();
    }

    public boolean pointInHandle(Point p) {
        return false;
    }

    protected void setDrawRect(int x, int y, int width, int height) {
        int originalX = this.getDrawRect().x;
        int originalY = this.getDrawRect().y;
        super.setDrawRect(x, y, width, height);
        Rectangle newRect = this.getDrawRect();
        int actualDx = newRect.x - originalX;
        int actualDy = newRect.y - originalY;
        this.firePropertiesWillChangeEvent();
        int size = this.strokeList.size();
        for (int i = 0; i < size; ++i) {
            CMBPenStroke s = (CMBPenStroke)this.strokeList.elementAt(i);
            s.from.x += actualDx;
            s.from.y += actualDy;
            s.to.x += actualDx;
            s.to.y += actualDy;
        }
        this.firePropertiesChangeEvent();
    }

    public void rotate(int rotation) {
        int w = this.getImageWidth();
        int h = this.getImageHeight();
        Vector savedStrokeList = this.strokeList;
        this.strokeList = new Vector();
        super.rotate(rotation);
        this.strokeList = savedStrokeList;
        int size = this.strokeList.size();
        block6: for (int i = 0; i < size; ++i) {
            CMBPenStroke s = (CMBPenStroke)this.strokeList.elementAt(i);
            switch (rotation) {
                case 0: {
                    s.from.setLocation(s.from.x, s.from.y);
                    s.to.setLocation(s.to.x, s.to.y);
                    continue block6;
                }
                case 1: {
                    s.from.setLocation(h - s.from.y, s.from.x);
                    s.to.setLocation(h - s.to.y, s.to.x);
                    continue block6;
                }
                case 2: {
                    s.from.setLocation(w - s.from.x, h - s.from.y);
                    s.to.setLocation(w - s.to.x, h - s.to.y);
                    continue block6;
                }
                case 3: {
                    s.from.setLocation(s.from.y, w - s.from.x);
                    s.to.setLocation(s.to.y, w - s.to.x);
                }
            }
        }
    }

    public void growBy(int dx, int dy) {
    }

    public void eraseSegment(Point point) {
        if (!this.canUpdate()) {
            return;
        }
        CMBPenStroke stroke = null;
        Rectangle segmentRect = new Rectangle();
        int eraserWidth = 12 * this.getScaleDeNum() / this.getScaleNum();
        int eraserHeight = 12 * this.getScaleDeNum() / this.getScaleNum();
        Rectangle eraseRect = new Rectangle(point.x, point.y - eraserHeight, eraserWidth, eraserHeight);
        Vector<CMBPenStroke> eraseList = new Vector<CMBPenStroke>();
        int size = this.strokeList.size();
        for (int i = 0; i < size; ++i) {
            stroke = (CMBPenStroke)this.strokeList.elementAt(i);
            segmentRect = new Rectangle(stroke.from);
            segmentRect.add(stroke.to);
            segmentRect.width = Math.max(segmentRect.width, this.getBorderWidth());
            segmentRect.height = Math.max(segmentRect.height, this.getBorderWidth());
            if (!eraseRect.intersects(segmentRect)) continue;
            eraseList.addElement(stroke);
        }
        int eraseCount = eraseList.size();
        CMBPenStroke erasedStroke = null;
        for (int j = 0; j < eraseCount; ++j) {
            erasedStroke = (CMBPenStroke)eraseList.elementAt(j);
            this.strokeList.remove(erasedStroke);
        }
    }

    public CMBPropertiesPanel getAnnotationPropertiesPanel() {
        if (this.annotationPropertiesPanel == null) {
            if (this.propList == null) {
                this.propList = new Vector();
            }
            this.propList.addElement("Annotation.penColor");
            this.propList.addElement(Color.white);
            this.propList.addElement("Annotation.penWidth");
            this.propList.addElement(new Integer[]{new Integer(1), new Integer(100)});
            this.propList.addElement("Annotation.transparent");
            this.propList.addElement(new Boolean(true));
            this.annotationPropertiesPanel = new CMBPropertiesPanel(this, this.propList);
        }
        return this.annotationPropertiesPanel;
    }

    public JPanel getPropertiesPanel() {
        this.getAnnotationPropertiesPanel().setAnnotation(this);
        return this.annotationPropertiesPanel.getPanel();
    }

    public void handlePropertyChange(String propName, JComponent comp, int action) {
        if (action == 106) {
            isDefaultSet = true;
        }
        if (propName.equals("Annotation.penColor")) {
            switch (action) {
                case 101: {
                    this.setBorderColor(comp.getBackground());
                    break;
                }
                case 102: {
                    comp.setBackground(this.getBorderColor());
                    break;
                }
                case 103: {
                    defaultBorderColor = this.getBorderColor();
                    break;
                }
                case 104: {
                    this.setBorderColor(defaultBorderColor);
                    break;
                }
                case 105: {
                    comp.setBackground(defaultBorderColor);
                    break;
                }
                case 106: {
                    defaultBorderColor = comp.getBackground();
                }
            }
        } else if (propName.equals("Annotation.penWidth")) {
            switch (action) {
                case 101: {
                    this.setBorderWidth(((PNumericField)comp).getValue());
                    break;
                }
                case 102: {
                    ((PNumericField)comp).setValue(this.getBorderWidth());
                    break;
                }
                case 103: {
                    defaultWidth = this.getBorderWidth();
                    break;
                }
                case 104: {
                    this.setBorderWidth(defaultWidth);
                    break;
                }
                case 105: {
                    ((PNumericField)comp).setValue(defaultWidth);
                    break;
                }
                case 106: {
                    defaultWidth = ((PNumericField)comp).getValue();
                }
            }
        } else if (propName.equals("Annotation.visibleWhileDragging")) {
            switch (action) {
                case 101: {
                    this.setVisibleWhileDragging(((JCheckBox)comp).isSelected());
                    break;
                }
                case 102: {
                    ((JCheckBox)comp).setSelected(this.getVisibleWhileDragging());
                    break;
                }
                case 103: {
                    defaultVWD = this.getVisibleWhileDragging();
                    break;
                }
                case 104: {
                    this.setVisibleWhileDragging(defaultVWD);
                    break;
                }
                case 105: {
                    ((JCheckBox)comp).setSelected(defaultVWD);
                    break;
                }
                case 106: {
                    defaultVWD = ((JCheckBox)comp).isSelected();
                }
            }
        } else if (propName.equals("Annotation.transparent")) {
            switch (action) {
                case 101: {
                    this.setTransparent(((JCheckBox)comp).isSelected());
                    break;
                }
                case 102: {
                    ((JCheckBox)comp).setSelected(this.getTransparent());
                    break;
                }
                case 103: {
                    defaultTransparent = this.getTransparent();
                    break;
                }
                case 104: {
                    this.setTransparent(defaultTransparent);
                    break;
                }
                case 105: {
                    ((JCheckBox)comp).setSelected(defaultTransparent);
                    break;
                }
                case 106: {
                    defaultTransparent = ((JCheckBox)comp).isSelected();
                }
            }
        }
    }

    public void updateValues(int action) {
        if (this.compTable.isEmpty()) {
            return;
        }
        Enumeration props = this.compTable.keys();
        while (props.hasMoreElements()) {
            String propName = (String)props.nextElement();
            JComponent comp = (JComponent)this.compTable.get(propName);
            this.handlePropertyChange(propName, comp, action);
        }
        super.updateValues(action);
    }

    public void addPropertyComponent(String propertyName, JComponent component) {
        this.compTable.put(propertyName, component);
    }

    public void dispose() {
        if (this.strokeList != null) {
            int size = this.strokeList.size();
            for (int i = 0; i < size; ++i) {
                CMBPenStroke penStroke = (CMBPenStroke)this.strokeList.elementAt(i);
                Object var3_3 = null;
            }
            this.strokeList.clear();
            this.strokeList = null;
        }
        this.annotationPropertiesPanel = null;
        super.dispose();
    }

    public Object clone() {
        CMBPenAnnotation p = (CMBPenAnnotation)super.clone();
        p.annotationPropertiesPanel = null;
        p.propList = new Vector();
        p.strokeList = new Vector();
        p.compTable = new Hashtable();
        if (this.strokeList != null) {
            int size = this.strokeList.size();
            for (int i = 0; i < size; ++i) {
                CMBPenStroke penStroke = (CMBPenStroke)((CMBPenStroke)this.strokeList.elementAt(i)).clone();
                p.strokeList.addElement(penStroke);
            }
        }
        return p;
    }

    static void getDefaultAnnotationProperties(Properties properties) {
        PAnnotationUtilities.setColorProperty("Pen.color", properties, defaultBorderColor);
        PAnnotationUtilities.setBooleanProperty("Pen.transparent", properties, defaultTransparent);
        PAnnotationUtilities.setIntegerProperty("Pen.width", properties, defaultWidth);
    }

    static void setDefaultAnnotationProperties(Properties properties) {
        defaultBorderColor = PAnnotationUtilities.getColorProperty("Pen.color", properties, DEFAULT_BORDER_COLOR);
        defaultTransparent = PAnnotationUtilities.getBooleanProperty("Pen.transparent", properties, true);
        defaultWidth = PAnnotationUtilities.getIntegerProperty("Pen.width", properties, 5, 1, 100);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int length = stream.readInt();
        this.strokeList = new Vector();
        for (int i = 0; i < length; ++i) {
            this.strokeList.addElement((CMBPenStroke)stream.readObject());
        }
        this.calculateDrawRect();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        int length = this.strokeList.size();
        stream.writeInt(length);
        for (int i = 0; i < length; ++i) {
            stream.writeObject(this.strokeList.elementAt(i));
        }
    }
}

