/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer.annotation;

import com.ibm.mm.viewer.annotation.CMBAnnotationConstants;
import com.ibm.mm.viewer.annotation.CMBAnnotationDefaultsChangedEvent;
import com.ibm.mm.viewer.annotation.CMBAnnotationDefaultsChangedListener;
import com.ibm.mm.viewer.annotation.CMBAnnotationPropertiesInterface;
import com.ibm.mm.viewer.annotation.CMBAnnotationPropertiesListener;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import com.ibm.mm.viewer.annotation.CMBPropertiesPanel;
import com.ibm.mm.viewer.annotation.PMFCRect;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CMBPageAnnotation
implements CMBAnnotationPropertiesInterface,
CMBAnnotationConstants,
Serializable,
Transferable,
Cloneable {
    private static final String copyright = "Licensed Materials - Property of IBM\nIBM DB2 Content Manager Enterprise Edition V8 (program number 5724-B19)\n(c ) Copyright IBM Corp.  1998, 2004.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    static final long serialVersionUID = 1L;
    protected transient boolean allowedToDraw = true;
    protected transient boolean showHandles = false;
    protected int type = 0;
    protected int pageNumber = 1;
    protected transient int creationIndex = 0;
    protected transient int currentIndex = 0;
    private Rectangle drawRect;
    private transient Vector annotationPropertiesListeners;
    private transient Vector annotationDefaultsListeners = new Vector();
    protected boolean invertedHorz = false;
    protected boolean invertedVert = false;
    private boolean rotateWithImage = true;
    public static DataFlavor pageAnnotationFlavor = new DataFlavor(CMBPageAnnotation.class, "Page Annotation");
    private static DataFlavor[] flavors = new DataFlavor[]{pageAnnotationFlavor};
    protected transient boolean isInMotion = false;
    protected boolean isVisibleWhileDragging = false;
    protected transient boolean applyPropertiesNow = false;
    protected transient boolean canShow = true;
    protected transient boolean canHide = true;
    protected transient boolean canUpdate = true;
    protected transient boolean canDelete = true;
    private transient int currentHandle = 3;
    private int nBorderWidth = 5;
    private boolean transparent = true;
    private static final int BORDER_STROKE_CAP = 2;
    private static final int BORDER_STROKE_JOIN = 0;
    private transient Stroke borderStroke = null;
    private transient Stroke outlineStroke = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{5.0f, 5.0f}, 0.0f);
    private Color borderColor;
    private Color fillColor;
    private transient int iRotation = 0;
    private transient int annoRotation = 0;
    private transient int imageRotationWhenAnnoWasCreated = 0;
    private transient int iScaleNum = 1000;
    private transient int iScaleDeNum = 1000;
    private transient int iImageHeight = 0;
    private transient int iImageWidth = 0;
    private boolean permanentlyRotating = false;
    boolean corrupt = false;
    private CMBAnnotationSet annotationSet;
    private Object handle;

    public CMBPageAnnotation() {
        this.initialize();
    }

    private void initialize() {
        this.annotationPropertiesListeners = new Vector();
        this.drawRect = new Rectangle();
        this.borderStroke = new BasicStroke(this.nBorderWidth, 2, 0);
        this.outlineStroke = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{5.0f, 5.0f}, 0.0f);
        this.borderColor = DEFAULT_BORDER_COLOR;
        this.fillColor = DEFAULT_FILL_COLOR;
        this.allowedToDraw = true;
        this.showHandles = false;
        this.creationIndex = 0;
        this.currentIndex = 0;
        this.drawRect = new Rectangle();
        this.annotationPropertiesListeners = new Vector();
        this.applyPropertiesNow = false;
        this.canShow = true;
        this.canHide = true;
        this.canUpdate = true;
        this.canDelete = true;
        this.invertedHorz = false;
        this.invertedVert = false;
        this.currentHandle = 3;
        this.isInMotion = false;
        this.iRotation = 0;
        this.annoRotation = 0;
        this.imageRotationWhenAnnoWasCreated = 0;
        this.iScaleNum = 1000;
        this.iScaleDeNum = 1000;
        this.iImageHeight = 0;
        this.iImageWidth = 0;
    }

    public CMBPageAnnotation(Rectangle r) {
        this();
        this.type = 0;
        this.setDrawRect(r.x, r.y, r.width, r.height);
    }

    public CMBPageAnnotation(Rectangle r, int pageNumber) {
        this(r);
        this.pageNumber = pageNumber;
    }

    public CMBAnnotationSet getAnnotationSet() {
        return this.annotationSet;
    }

    void setAnnotationSet(CMBAnnotationSet annotationSet) {
        this.annotationSet = annotationSet;
    }

    public Object getHandle() {
        return this.handle;
    }

    public void setHandle(Object handle) {
        this.handle = handle;
    }

    public int getRotation() {
        return this.iRotation;
    }

    double getRotationInRadians(int rot) {
        switch (rot) {
            case 0: {
                return Math.toRadians(0.0);
            }
            case 1: {
                return Math.toRadians(90.0);
            }
            case 2: {
                return Math.toRadians(180.0);
            }
            case 3: {
                return Math.toRadians(270.0);
            }
        }
        return Math.toRadians(0.0);
    }

    public void setRotation(int rot) {
        this.iRotation = rot;
        this.annoRotation = Math.abs(this.iRotation - this.imageRotationWhenAnnoWasCreated) % 4;
    }

    void rotate(int rotation) {
        if (rotation == 1 || rotation == 3) {
            int i = this.iImageHeight;
            this.iImageHeight = this.iImageWidth;
            this.iImageWidth = i;
        }
        if (rotation == 1) {
            if (!this.getInvertVertical() && !this.getInvertHorizontal()) {
                this.setInvertHorizontal(true);
            } else if (this.getInvertVertical() && !this.getInvertHorizontal()) {
                this.setInvertVertical(false);
            } else if (!this.getInvertVertical() && this.getInvertHorizontal()) {
                this.setInvertVertical(true);
            } else if (this.getInvertVertical() && this.getInvertHorizontal()) {
                this.setInvertHorizontal(false);
            }
        } else if (rotation == 3) {
            if (!this.getInvertVertical() && !this.getInvertHorizontal()) {
                this.setInvertVertical(true);
            } else if (this.getInvertVertical() && !this.getInvertHorizontal()) {
                this.setInvertHorizontal(true);
            } else if (!this.getInvertVertical() && this.getInvertHorizontal()) {
                this.setInvertHorizontal(false);
            } else if (this.getInvertVertical() && this.getInvertHorizontal()) {
                this.setInvertVertical(false);
            }
        } else if (rotation == 2) {
            this.setInvertVertical(!this.getInvertVertical());
            this.setInvertHorizontal(!this.getInvertHorizontal());
        }
        Rectangle newDrawRect = this.rotateWithImage && this.canBePermanentlyRotated() ? this.rotateDocRect(this.drawRect, rotation) : this.translateDocRect(this.drawRect, rotation);
        this.setDrawRect(newDrawRect.x, newDrawRect.y, newDrawRect.width, newDrawRect.height);
    }

    protected boolean canBePermanentlyRotated() {
        return true;
    }

    public void setAnnotationRotation(int rot) {
        this.firePropertiesWillChangeEvent();
        this.annoRotation = rot;
        this.imageRotationWhenAnnoWasCreated = this.iRotation;
        this.firePropertiesChangeEvent();
    }

    public int getAnnotationRotation() {
        return this.annoRotation;
    }

    int getScaleNum() {
        return this.iScaleNum;
    }

    public void setScaleNum(int sn) {
        this.iScaleNum = sn;
    }

    int getScaleDeNum() {
        return this.iScaleDeNum;
    }

    void setScaleDeNum(int sdn) {
        this.iScaleDeNum = sdn;
    }

    public boolean getRotateWithImage() {
        return this.rotateWithImage;
    }

    public void setRotateWithImage(boolean b) {
        this.firePropertiesWillChangeEvent();
        this.rotateWithImage = b;
        this.firePropertiesChangeEvent();
    }

    Stroke getBorderStroke() {
        if (this.borderStroke == null) {
            this.borderStroke = new BasicStroke(this.nBorderWidth, 2, 0);
        }
        return this.borderStroke;
    }

    public void setBorderWidth(int width) {
        if (!this.canUpdate()) {
            return;
        }
        if (width < 1) {
            width = 1;
        }
        if (width > 100) {
            width = 100;
        }
        this.firePropertiesWillChangeEvent();
        this.nBorderWidth = width;
        this.borderStroke = new BasicStroke(this.nBorderWidth, 2, 0);
        this.firePropertiesChangeEvent();
    }

    public int getImageHeight() {
        return this.iImageHeight;
    }

    public int getImageWidth() {
        return this.iImageWidth;
    }

    public void setImageHeight(int h) {
        this.iImageHeight = h;
        if (this.iRotation == 0 || this.iRotation == 2) {
            if (this.iImageHeight > 0 && this.drawRect.y > this.iImageHeight) {
                this.setDrawRect(this.drawRect.x, this.iImageHeight, this.drawRect.width, this.drawRect.height);
            }
        } else if (this.iImageHeight > 0 && this.drawRect.x > this.iImageHeight) {
            this.setDrawRect(this.iImageHeight, this.drawRect.y, this.drawRect.width, this.drawRect.height);
        }
    }

    public void setImageWidth(int w) {
        this.iImageWidth = w;
        if (this.iRotation == 0 || this.iRotation == 2) {
            if (this.iImageWidth > 0 && this.drawRect.x > this.iImageWidth) {
                this.setDrawRect(this.iImageWidth, this.drawRect.y, this.drawRect.width, this.drawRect.height);
            }
        } else if (this.iImageWidth > 0 && this.drawRect.y > this.iImageWidth) {
            this.setDrawRect(this.drawRect.x, this.iImageWidth, this.drawRect.width, this.drawRect.height);
        }
    }

    public int getBorderWidth() {
        return this.nBorderWidth;
    }

    public boolean getInvertHorizontal() {
        return this.invertedHorz;
    }

    public boolean getInvertVertical() {
        return this.invertedVert;
    }

    public void setInvertHorizontal(boolean invertH) {
        this.firePropertiesWillChangeEvent();
        this.invertedHorz = invertH;
        this.firePropertiesChangeEvent();
    }

    public void setInvertVertical(boolean invertV) {
        this.firePropertiesWillChangeEvent();
        this.invertedVert = invertV;
        this.firePropertiesChangeEvent();
    }

    protected Stroke getOutlineStroke() {
        if (this.outlineStroke == null) {
            this.outlineStroke = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{5.0f, 5.0f}, 0.0f);
        }
        return this.outlineStroke;
    }

    public boolean getTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean bTrans) {
        if (!this.canUpdate()) {
            return;
        }
        this.firePropertiesWillChangeEvent();
        this.transparent = bTrans;
        this.setBorderColor(this.getBorderColor());
        this.setFillColor(this.getFillColor());
        this.firePropertiesChangeEvent();
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setPageNumber(int page) {
        this.pageNumber = page;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    protected Rectangle rotateDocRect(Rectangle toRotate) {
        return this.rotateDocRect(toRotate, this.getRotation());
    }

    private Rectangle rotateDocRect(Rectangle toRotate, int rotation) {
        PMFCRect mfctoRotate = new PMFCRect(toRotate);
        PMFCRect mfctmpRect = new PMFCRect(toRotate);
        switch (rotation) {
            case 0: {
                mfctmpRect.left = mfctoRotate.left;
                mfctmpRect.right = mfctoRotate.right;
                mfctmpRect.top = mfctoRotate.top;
                mfctmpRect.bottom = mfctoRotate.bottom;
                break;
            }
            case 1: {
                mfctmpRect.left = this.getImageWidth() - mfctoRotate.bottom;
                mfctmpRect.top = mfctoRotate.left;
                mfctmpRect.right = this.getImageWidth() - mfctoRotate.top;
                mfctmpRect.bottom = mfctoRotate.right;
                break;
            }
            case 2: {
                mfctmpRect.left = this.getImageWidth() - mfctoRotate.right;
                mfctmpRect.top = this.getImageHeight() - mfctoRotate.bottom;
                mfctmpRect.right = this.getImageWidth() - mfctoRotate.left;
                mfctmpRect.bottom = this.getImageHeight() - mfctoRotate.top;
                break;
            }
            case 3: {
                mfctmpRect.left = mfctoRotate.top;
                mfctmpRect.top = this.getImageHeight() - mfctoRotate.right;
                mfctmpRect.right = mfctoRotate.bottom;
                mfctmpRect.bottom = this.getImageHeight() - mfctoRotate.left;
            }
        }
        return mfctmpRect.toJavaRect();
    }

    protected Rectangle translateDocRect(Rectangle toRotate) {
        return this.translateDocRect(toRotate, this.getRotation());
    }

    protected Rectangle translateDocRect(Rectangle oldRect, int rotation) {
        int oldAnnotationCenterX = this.drawRect.x + this.drawRect.width / 2;
        int oldAnnotationCenterY = this.drawRect.y + this.drawRect.height / 2;
        int newAnnotationCenterX = oldAnnotationCenterX;
        int newAnnotationCenterY = oldAnnotationCenterY;
        switch (rotation) {
            case 1: {
                newAnnotationCenterX = this.iImageWidth - oldAnnotationCenterY;
                newAnnotationCenterY = oldAnnotationCenterX;
                break;
            }
            case 2: {
                newAnnotationCenterX = this.iImageWidth - oldAnnotationCenterX;
                newAnnotationCenterY = this.iImageHeight - oldAnnotationCenterY;
                break;
            }
            case 3: {
                newAnnotationCenterX = oldAnnotationCenterY;
                newAnnotationCenterY = this.iImageHeight - oldAnnotationCenterX;
            }
        }
        Rectangle newRect = new Rectangle(oldRect.x - oldAnnotationCenterX + newAnnotationCenterX, oldRect.y - oldAnnotationCenterY + newAnnotationCenterY, oldRect.width, oldRect.height);
        return newRect;
    }

    protected Rectangle translateRotateDocRect(Rectangle toRotate) {
        return this.translateRotateDocRect(toRotate, this.getRotation());
    }

    private Rectangle translateRotateDocRect(Rectangle toRotate, int rotation) {
        if (this.rotateWithImage) {
            return this.rotateDocRect(toRotate, rotation);
        }
        return this.translateDocRect(toRotate, rotation);
    }

    public void setBorderColor(Color c) {
        if (!this.canUpdate()) {
            return;
        }
        this.firePropertiesWillChangeEvent();
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int a = this.transparent ? 130 : 255;
        this.borderColor = new Color(r, g, b, a);
        this.firePropertiesChangeEvent();
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color c) {
        if (!this.canUpdate()) {
            return;
        }
        this.firePropertiesWillChangeEvent();
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int a = this.transparent ? 130 : 255;
        this.fillColor = new Color(r, g, b, a);
        this.firePropertiesChangeEvent();
    }

    public Font getFont() {
        return null;
    }

    public void setFont(Font font) {
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        try {
            return ANN_NAMES[this.type];
        }
        catch (Exception e) {
            return this.getClass().getName();
        }
    }

    public void setInMotion(boolean inMotion) {
        this.isInMotion = inMotion;
        if (this.annotationSet != null) {
            this.annotationSet.updateViews(this);
        }
    }

    public boolean getInMotion() {
        return this.isInMotion;
    }

    public void setApplyNow(boolean now) {
        this.applyPropertiesNow = now;
    }

    public boolean getApplyNow() {
        return this.applyPropertiesNow;
    }

    public void setVisibleWhileDragging(boolean visible) {
        this.isVisibleWhileDragging = visible;
    }

    public boolean getVisibleWhileDragging() {
        return this.isVisibleWhileDragging;
    }

    public void dontDraw() {
        this.allowedToDraw = false;
        if (this.annotationSet != null) {
            this.annotationSet.updateViews(this);
        }
    }

    public void pleaseDraw() {
        if (this.canShow()) {
            this.allowedToDraw = true;
            if (this.annotationSet != null) {
                this.annotationSet.updateViews(this);
            }
        }
    }

    public boolean contains(Point p) {
        return this.translateRotateDocRect(this.getBoundingRect()).contains(p);
    }

    protected void resizeDrawRect(int newWidth, int newHeight) {
        this.setDrawRect(this.drawRect.x, this.drawRect.y, newWidth, newHeight);
    }

    protected void setDrawRect(int x, int y, int width, int height) {
        this.firePropertiesWillChangeEvent();
        this.drawRect = new Rectangle(x, y, width, height);
        Rectangle containingRect = this.getContainingRect();
        if (containingRect.x + containingRect.width < 0) {
            x -= containingRect.x + containingRect.width;
        }
        if (containingRect.y + containingRect.height < 0) {
            y -= containingRect.y + containingRect.height;
        }
        if (this.iImageWidth > 0 && this.iImageHeight > 0) {
            int maxheight;
            int maxwidth;
            if (this.iRotation == 0 || this.iRotation == 2) {
                maxwidth = this.iImageWidth;
                maxheight = this.iImageHeight;
            } else {
                maxwidth = this.iImageHeight;
                maxheight = this.iImageWidth;
            }
            if (containingRect.x > maxwidth) {
                x -= containingRect.x - maxwidth;
            }
            if (containingRect.y > maxheight) {
                y -= containingRect.y - maxheight;
            }
        }
        this.drawRect = new Rectangle(x, y, width, height);
        this.firePropertiesChangeEvent();
    }

    public void translateBy(int dx, int dy) {
        if (!this.canUpdate()) {
            return;
        }
        Point delta = new Point(dx, dy);
        this.modifyDeltas(delta);
        dx = delta.x;
        dy = delta.y;
        this.setDrawRect(this.drawRect.x + dx, this.drawRect.y + dy, this.drawRect.width, this.drawRect.height);
    }

    public Rectangle getRefreshRect() {
        Rectangle refRect = new Rectangle(this.drawRect);
        int xdifference = Math.max(this.nBorderWidth / 2, this.getUnscaledValue(this.getDefaultHandleWidth()));
        int ydifference = Math.max(this.nBorderWidth / 2, this.getUnscaledValue(this.getDefaultHandleHeight()));
        refRect.grow(xdifference, ydifference);
        Rectangle scaledRefRect = this.scaleRectangle(this.translateRotateDocRect(refRect));
        scaledRefRect.grow(4, 4);
        return scaledRefRect;
    }

    Rectangle getBoundingRect() {
        Rectangle containingRect = this.getContainingRect();
        Rectangle boundingRect = new Rectangle(containingRect.x - this.getUnscaledValue(this.getDefaultHandleWidth()), containingRect.y - this.getUnscaledValue(this.getDefaultHandleHeight()), containingRect.width + 2 * this.getUnscaledValue(this.getDefaultHandleWidth()), containingRect.height + 2 * this.getUnscaledValue(this.getDefaultHandleHeight()));
        return boundingRect;
    }

    Rectangle getContainingRect() {
        return this.getDrawRect();
    }

    public Rectangle getDrawRect() {
        return this.drawRect;
    }

    public Rectangle getAnnoDrawRect() {
        return this.translateRotateDocRect(this.drawRect);
    }

    protected Rectangle getFillRect() {
        Rectangle fillRect = new Rectangle();
        fillRect.x = this.drawRect.x;
        fillRect.y = this.drawRect.y;
        fillRect.height = this.drawRect.height;
        fillRect.width = this.drawRect.width;
        int offset = this.nBorderWidth / 2 + (this.nBorderWidth % 2 == 0 ? 0 : 1);
        fillRect.x += offset;
        fillRect.y += offset;
        fillRect.width -= this.nBorderWidth;
        fillRect.height -= this.nBorderWidth;
        return this.translateRotateDocRect(fillRect);
    }

    protected int getDefaultHandleWidth() {
        return 5;
    }

    protected int getDefaultHandleHeight() {
        return 5;
    }

    int getCurrentHandleType() {
        return this.currentHandle;
    }

    void setCurrentHandleType(int handleType) {
        this.currentHandle = handleType;
    }

    public void addAnnotationPropertiesListener(CMBAnnotationPropertiesListener apl) {
        if (!this.annotationPropertiesListeners.contains(apl)) {
            this.annotationPropertiesListeners.addElement(apl);
        }
    }

    public void firePropertiesChangeEvent() {
        int size = this.annotationPropertiesListeners.size();
        if (size <= 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            ((CMBAnnotationPropertiesListener)this.annotationPropertiesListeners.elementAt(i)).handleAnnPropChangedEvent(this);
        }
        if (this.annotationSet != null) {
            this.annotationSet.updateViews(this);
        }
    }

    public void firePropertiesWillChangeEvent() {
        int size = this.annotationPropertiesListeners.size();
        if (size <= 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            ((CMBAnnotationPropertiesListener)this.annotationPropertiesListeners.elementAt(i)).handleAnnPropWillChangeEvent(this);
        }
    }

    void addAnnotationDefaultsChangedListener(CMBAnnotationDefaultsChangedListener listener) {
        this.annotationDefaultsListeners.addElement(listener);
    }

    void removeAnnotationDefaultsChangedListener(CMBAnnotationDefaultsChangedListener listener) {
        this.annotationDefaultsListeners.removeElement(listener);
    }

    void fireCMBAnnotationDefaultsChangedEvent(Class annotationClassName) {
        CMBAnnotationDefaultsChangedEvent e = new CMBAnnotationDefaultsChangedEvent(this, annotationClassName);
        for (int i = 0; i < this.annotationDefaultsListeners.size(); ++i) {
            CMBAnnotationDefaultsChangedListener l = (CMBAnnotationDefaultsChangedListener)this.annotationDefaultsListeners.elementAt(i);
            l.annotationDefaultsChanged(e);
        }
    }

    public void draw(Graphics2D g2) {
        if (!this.allowedToDraw) {
            return;
        }
        if (this.showHandles) {
            this.drawHandles(g2);
        }
    }

    public void drawOutline(Graphics2D g2) {
    }

    public boolean handlesShowing() {
        return this.showHandles;
    }

    public void showHandles(boolean showHandles) {
        this.showHandles = showHandles;
    }

    private Rectangle getTopHandleRect() {
        Rectangle boundingRect = this.getBoundingRect();
        Rectangle rectTop = new Rectangle(this.getUnscaledValue(this.getDefaultHandleWidth()), this.getUnscaledValue(this.getDefaultHandleHeight()));
        rectTop.x = boundingRect.x + (boundingRect.width / 2 - this.getUnscaledValue(this.getDefaultHandleWidth()) / 2);
        rectTop.y = boundingRect.y;
        return rectTop;
    }

    private Rectangle getBottomHandleRect() {
        Rectangle boundingRect = this.getBoundingRect();
        Rectangle rectBottom = new Rectangle(this.getUnscaledValue(this.getDefaultHandleWidth()), this.getUnscaledValue(this.getDefaultHandleHeight()));
        rectBottom.x = boundingRect.x + (boundingRect.width / 2 - this.getUnscaledValue(this.getDefaultHandleWidth()) / 2);
        rectBottom.y = boundingRect.y + boundingRect.height - this.getUnscaledValue(this.getDefaultHandleHeight());
        return rectBottom;
    }

    private Rectangle getLeftHandleRect() {
        Rectangle boundingRect = this.getBoundingRect();
        Rectangle rectLeft = new Rectangle(this.getUnscaledValue(this.getDefaultHandleWidth()), this.getUnscaledValue(this.getDefaultHandleHeight()));
        rectLeft.x = boundingRect.x;
        rectLeft.y = boundingRect.y + (boundingRect.height / 2 - this.getUnscaledValue(this.getDefaultHandleHeight()) / 2);
        return rectLeft;
    }

    private Rectangle getRightHandleRect() {
        Rectangle boundingRect = this.getBoundingRect();
        Rectangle rectRight = new Rectangle(this.getUnscaledValue(this.getDefaultHandleWidth()), this.getUnscaledValue(this.getDefaultHandleHeight()));
        rectRight.x = boundingRect.x + boundingRect.width - this.getUnscaledValue(this.getDefaultHandleWidth());
        rectRight.y = boundingRect.y + (boundingRect.height / 2 - this.getUnscaledValue(this.getDefaultHandleHeight()) / 2);
        return rectRight;
    }

    private Rectangle getTopLeftHandleRect() {
        Rectangle boundingRect = this.getBoundingRect();
        Rectangle rectTopLeft = new Rectangle(this.getUnscaledValue(this.getDefaultHandleWidth()), this.getUnscaledValue(this.getDefaultHandleHeight()));
        rectTopLeft.x = boundingRect.x;
        rectTopLeft.y = boundingRect.y;
        return rectTopLeft;
    }

    private Rectangle getTopRightHandleRect() {
        Rectangle boundingRect = this.getBoundingRect();
        Rectangle rectTopRight = new Rectangle(this.getUnscaledValue(this.getDefaultHandleWidth()), this.getUnscaledValue(this.getDefaultHandleHeight()));
        rectTopRight.x = boundingRect.x + boundingRect.width - this.getUnscaledValue(this.getDefaultHandleWidth());
        rectTopRight.y = boundingRect.y;
        return rectTopRight;
    }

    private Rectangle getBottomLeftHandleRect() {
        Rectangle boundingRect = this.getBoundingRect();
        Rectangle rectBottomLeft = new Rectangle(this.getUnscaledValue(this.getDefaultHandleWidth()), this.getUnscaledValue(this.getDefaultHandleHeight()));
        rectBottomLeft.x = boundingRect.x;
        rectBottomLeft.y = boundingRect.y + boundingRect.height - this.getUnscaledValue(this.getDefaultHandleHeight());
        return rectBottomLeft;
    }

    private Rectangle getBottomRightHandleRect() {
        Rectangle boundingRect = this.getBoundingRect();
        Rectangle rectBottomRight = new Rectangle(this.getUnscaledValue(this.getDefaultHandleWidth()), this.getUnscaledValue(this.getDefaultHandleHeight()));
        rectBottomRight.x = boundingRect.x + boundingRect.width - this.getUnscaledValue(this.getDefaultHandleWidth());
        rectBottomRight.y = boundingRect.y + boundingRect.height - this.getUnscaledValue(this.getDefaultHandleHeight());
        return rectBottomRight;
    }

    public boolean pointInHandle(Point p) {
        int scaledWidth = this.getUnscaledValue(this.getDefaultHandleWidth()) + 1;
        int scaledHeight = this.getUnscaledValue(this.getDefaultHandleHeight()) + 1;
        Rectangle rotatedRect = this.translateRotateDocRect(this.getBottomRightHandleRect());
        if (new Rectangle(rotatedRect.x, rotatedRect.y, scaledWidth, scaledHeight).contains(p)) {
            this.currentHandle = 3;
            return true;
        }
        rotatedRect = this.translateRotateDocRect(this.getTopHandleRect());
        if (new Rectangle(rotatedRect.x, rotatedRect.y, scaledWidth, scaledHeight).contains(p)) {
            this.currentHandle = 0;
            return true;
        }
        rotatedRect = this.translateRotateDocRect(this.getBottomHandleRect());
        if (new Rectangle(rotatedRect.x, rotatedRect.y, scaledWidth, scaledHeight).contains(p)) {
            this.currentHandle = 4;
            return true;
        }
        rotatedRect = this.translateRotateDocRect(this.getLeftHandleRect());
        if (new Rectangle(rotatedRect.x, rotatedRect.y, scaledWidth, scaledHeight).contains(p)) {
            this.currentHandle = 6;
            return true;
        }
        rotatedRect = this.translateRotateDocRect(this.getRightHandleRect());
        if (new Rectangle(rotatedRect.x, rotatedRect.y, scaledWidth, scaledHeight).contains(p)) {
            this.currentHandle = 2;
            return true;
        }
        rotatedRect = this.translateRotateDocRect(this.getBottomLeftHandleRect());
        if (new Rectangle(rotatedRect.x, rotatedRect.y, scaledWidth, scaledHeight).contains(p)) {
            this.currentHandle = 5;
            return true;
        }
        rotatedRect = this.translateRotateDocRect(this.getTopRightHandleRect());
        if (new Rectangle(rotatedRect.x, rotatedRect.y, scaledWidth, scaledHeight).contains(p)) {
            this.currentHandle = 1;
            return true;
        }
        rotatedRect = this.translateRotateDocRect(this.getTopLeftHandleRect());
        if (new Rectangle(rotatedRect.x, rotatedRect.y, scaledWidth, scaledHeight).contains(p)) {
            this.currentHandle = 7;
            return true;
        }
        return false;
    }

    int getCurrentHandleCursorType(int handleType) {
        if (!this.rotateWithImage) {
            return handleType;
        }
        switch (this.getRotation()) {
            case 0: {
                break;
            }
            case 1: {
                handleType = (handleType + 2) % 8;
                break;
            }
            case 2: {
                handleType = (handleType + 4) % 8;
                break;
            }
            case 3: {
                handleType = (handleType + 6) % 8;
            }
        }
        return handleType;
    }

    public String getPropertiesGroupTitle() {
        String title = new String();
        title = ANN_NAMES[this.getType()] + " Settings";
        return title;
    }

    protected void drawSelectionBox(Graphics2D g) {
        g.draw(this.getAnnoDrawRect());
    }

    protected void drawHandles(Graphics2D g) {
        if (!this.canUpdate()) {
            this.drawSelectionBox(g);
            return;
        }
        if (this.getAnnotationSet() != null && !this.getAnnotationSet().isActive()) {
            return;
        }
        Rectangle rotatedLeft = this.translateRotateDocRect(this.getLeftHandleRect());
        Rectangle rotatedRight = this.translateRotateDocRect(this.getRightHandleRect());
        Rectangle rotatedTop = this.translateRotateDocRect(this.getTopHandleRect());
        Rectangle rotatedBottom = this.translateRotateDocRect(this.getBottomHandleRect());
        Rectangle rotatedBottomRight = this.translateRotateDocRect(this.getBottomRightHandleRect());
        Rectangle rotatedBottomLeft = this.translateRotateDocRect(this.getBottomLeftHandleRect());
        Rectangle rotatedTopRight = this.translateRotateDocRect(this.getTopRightHandleRect());
        Rectangle rotatedTopLeft = this.translateRotateDocRect(this.getTopLeftHandleRect());
        int scaledWidth = this.getUnscaledValue(this.getDefaultHandleWidth());
        int scaledHeight = this.getUnscaledValue(this.getDefaultHandleHeight());
        Color oldColor = g.getColor();
        Stroke oldStroke = g.getStroke();
        g.setColor(Color.white);
        int fillWidth = scaledWidth - 2;
        int fillHeight = scaledHeight - 2;
        g.fillRect(rotatedLeft.x + 1, rotatedLeft.y + 1, fillWidth, fillHeight);
        g.fillRect(rotatedRight.x + 1, rotatedRight.y + 1, fillWidth, fillHeight);
        g.fillRect(rotatedTop.x + 1, rotatedTop.y + 1, fillWidth, fillHeight);
        g.fillRect(rotatedBottom.x + 1, rotatedBottom.y + 1, fillWidth, fillHeight);
        g.fillRect(rotatedBottomRight.x + 1, rotatedBottomRight.y + 1, fillWidth, fillHeight);
        g.fillRect(rotatedBottomLeft.x + 1, rotatedBottomLeft.y + 1, fillWidth, fillHeight);
        g.fillRect(rotatedTopRight.x + 1, rotatedTopRight.y + 1, fillWidth, fillHeight);
        g.fillRect(rotatedTopLeft.x + 1, rotatedTopLeft.y + 1, fillWidth, fillHeight);
        g.setColor(Color.black);
        g.setStroke(new BasicStroke());
        g.drawRect(rotatedLeft.x, rotatedLeft.y, scaledWidth, scaledHeight);
        g.drawRect(rotatedRight.x, rotatedRight.y, scaledWidth, scaledHeight);
        g.drawRect(rotatedTop.x, rotatedTop.y, scaledWidth, scaledHeight);
        g.drawRect(rotatedBottom.x, rotatedBottom.y, scaledWidth, scaledHeight);
        g.drawRect(rotatedBottomRight.x, rotatedBottomRight.y, scaledWidth, scaledHeight);
        g.drawRect(rotatedBottomLeft.x, rotatedBottomLeft.y, scaledWidth, scaledHeight);
        g.drawRect(rotatedTopRight.x, rotatedTopRight.y, scaledWidth, scaledHeight);
        g.drawRect(rotatedTopLeft.x, rotatedTopLeft.y, scaledWidth, scaledHeight);
        g.setColor(oldColor);
        g.setStroke(oldStroke);
    }

    protected void modifyDeltas(Point deltasContainer) {
        int dx = deltasContainer.x;
        int dy = deltasContainer.y;
        switch (this.getRotation()) {
            case 0: {
                break;
            }
            case 1: {
                int temp = dy;
                dy = -dx;
                dx = temp;
                break;
            }
            case 2: {
                dx = -dx;
                dy = -dy;
                break;
            }
            case 3: {
                int temp = dy;
                dy = dx;
                dx = -temp;
            }
        }
        deltasContainer.x = dx;
        deltasContainer.y = dy;
    }

    public void growBy(int dx, int dy) {
        int nTemp;
        if (!this.canUpdate()) {
            return;
        }
        Point delta = new Point(dx, dy);
        this.modifyDeltas(delta);
        Rectangle newDrawRect = (Rectangle)this.drawRect.clone();
        switch (this.currentHandle) {
            case 0: {
                if (this.rotateWithImage) {
                    newDrawRect.y += delta.y;
                    newDrawRect.height -= delta.y;
                    break;
                }
                int oldHeight = newDrawRect.height;
                newDrawRect.height -= dy;
                int deltaCenterY = newDrawRect.height / 2 - oldHeight / 2;
                if (this.iRotation == 0) {
                    newDrawRect.y += dy;
                    break;
                }
                if (this.iRotation == 1) {
                    newDrawRect.x -= deltaCenterY;
                    newDrawRect.y -= deltaCenterY;
                    break;
                }
                if (this.iRotation == 2) break;
                newDrawRect.x += deltaCenterY;
                newDrawRect.y -= deltaCenterY;
                break;
            }
            case 4: {
                if (this.rotateWithImage) {
                    newDrawRect.height += delta.y;
                    break;
                }
                int oldHeight = newDrawRect.height;
                newDrawRect.height += dy;
                int deltaCenterY = newDrawRect.height / 2 - oldHeight / 2;
                if (this.iRotation == 0) break;
                if (this.iRotation == 1) {
                    newDrawRect.x += deltaCenterY;
                    newDrawRect.y -= deltaCenterY;
                    break;
                }
                if (this.iRotation == 2) {
                    newDrawRect.y -= dy;
                    break;
                }
                newDrawRect.x -= deltaCenterY;
                newDrawRect.y -= deltaCenterY;
                break;
            }
            case 6: {
                if (this.rotateWithImage) {
                    newDrawRect.x += delta.x;
                    newDrawRect.width -= delta.x;
                    break;
                }
                int oldWidth = newDrawRect.width;
                newDrawRect.width -= dx;
                int deltaCenterX = newDrawRect.width / 2 - oldWidth / 2;
                if (this.iRotation == 0) {
                    newDrawRect.x += dx;
                    break;
                }
                if (this.iRotation == 1) {
                    newDrawRect.y += deltaCenterX;
                    newDrawRect.x -= deltaCenterX;
                    break;
                }
                if (this.iRotation == 2) break;
                newDrawRect.y -= deltaCenterX;
                newDrawRect.x -= deltaCenterX;
                break;
            }
            case 2: {
                if (this.rotateWithImage) {
                    newDrawRect.width += delta.x;
                    break;
                }
                int oldWidth = newDrawRect.width;
                newDrawRect.width += dx;
                int deltaCenterX = newDrawRect.width / 2 - oldWidth / 2;
                if (this.iRotation == 0) break;
                if (this.iRotation == 1) {
                    newDrawRect.y -= deltaCenterX;
                    newDrawRect.x -= deltaCenterX;
                    break;
                }
                if (this.iRotation == 2) {
                    newDrawRect.x -= dx;
                    break;
                }
                newDrawRect.y += deltaCenterX;
                newDrawRect.x -= deltaCenterX;
                break;
            }
            case 3: {
                if (this.rotateWithImage) {
                    newDrawRect.width += delta.x;
                    newDrawRect.height += delta.y;
                    break;
                }
                int oldWidth = newDrawRect.width;
                int oldHeight = newDrawRect.height;
                newDrawRect.width += dx;
                newDrawRect.height += dy;
                int deltaCenterX = newDrawRect.width / 2 - oldWidth / 2;
                int deltaCenterY = newDrawRect.height / 2 - oldHeight / 2;
                if (this.iRotation == 0) break;
                if (this.iRotation == 1) {
                    newDrawRect.y -= deltaCenterX;
                    newDrawRect.x -= deltaCenterX;
                    newDrawRect.x += deltaCenterY;
                    newDrawRect.y -= deltaCenterY;
                    break;
                }
                if (this.iRotation == 2) {
                    newDrawRect.x -= dx;
                    newDrawRect.y -= dy;
                    break;
                }
                newDrawRect.y += deltaCenterX;
                newDrawRect.x -= deltaCenterX;
                newDrawRect.x -= deltaCenterY;
                newDrawRect.y -= deltaCenterY;
                break;
            }
            case 5: {
                if (this.rotateWithImage) {
                    newDrawRect.x += delta.x;
                    newDrawRect.width -= delta.x;
                    newDrawRect.height += delta.y;
                    break;
                }
                int oldWidth = newDrawRect.width;
                int oldHeight = newDrawRect.height;
                newDrawRect.width -= dx;
                newDrawRect.height += dy;
                int deltaCenterX = newDrawRect.width / 2 - oldWidth / 2;
                int deltaCenterY = newDrawRect.height / 2 - oldHeight / 2;
                if (this.iRotation == 0) {
                    newDrawRect.x += dx;
                    break;
                }
                if (this.iRotation == 1) {
                    newDrawRect.x += deltaCenterY;
                    newDrawRect.y -= deltaCenterY;
                    newDrawRect.y += deltaCenterX;
                    newDrawRect.x -= deltaCenterX;
                    break;
                }
                if (this.iRotation == 2) {
                    newDrawRect.y -= dy;
                    break;
                }
                newDrawRect.x -= deltaCenterY;
                newDrawRect.y -= deltaCenterY;
                newDrawRect.y -= deltaCenterX;
                newDrawRect.x -= deltaCenterX;
                break;
            }
            case 7: {
                if (this.rotateWithImage) {
                    newDrawRect.x += delta.x;
                    newDrawRect.y += delta.y;
                    newDrawRect.width -= delta.x;
                    newDrawRect.height -= delta.y;
                    break;
                }
                int oldWidth = newDrawRect.width;
                int oldHeight = newDrawRect.height;
                newDrawRect.width -= dx;
                newDrawRect.height -= dy;
                int deltaCenterX = newDrawRect.width / 2 - oldWidth / 2;
                int deltaCenterY = newDrawRect.height / 2 - oldHeight / 2;
                if (this.iRotation == 0) {
                    newDrawRect.y += dy;
                    newDrawRect.x += dx;
                    break;
                }
                if (this.iRotation == 1) {
                    newDrawRect.x -= deltaCenterY;
                    newDrawRect.y -= deltaCenterY;
                    newDrawRect.y += deltaCenterX;
                    newDrawRect.x -= deltaCenterX;
                    break;
                }
                if (this.iRotation == 2) break;
                newDrawRect.x += deltaCenterY;
                newDrawRect.y -= deltaCenterY;
                newDrawRect.y -= deltaCenterX;
                newDrawRect.x -= deltaCenterX;
                break;
            }
            case 1: {
                if (this.rotateWithImage) {
                    newDrawRect.y += delta.y;
                    newDrawRect.width += delta.x;
                    newDrawRect.height -= delta.y;
                    break;
                }
                int oldWidth = newDrawRect.width;
                int oldHeight = newDrawRect.height;
                newDrawRect.width += dx;
                newDrawRect.height -= dy;
                int deltaCenterX = newDrawRect.width / 2 - oldWidth / 2;
                int deltaCenterY = newDrawRect.height / 2 - oldHeight / 2;
                if (this.iRotation == 0) {
                    newDrawRect.y += dy;
                    break;
                }
                if (this.iRotation == 1) {
                    newDrawRect.x -= deltaCenterY;
                    newDrawRect.y -= deltaCenterY;
                    newDrawRect.y -= deltaCenterX;
                    newDrawRect.x -= deltaCenterX;
                    break;
                }
                if (this.iRotation == 2) {
                    newDrawRect.x -= dx;
                    break;
                }
                newDrawRect.x += deltaCenterY;
                newDrawRect.y -= deltaCenterY;
                newDrawRect.y += deltaCenterX;
                newDrawRect.x -= deltaCenterX;
            }
        }
        int left = newDrawRect.x;
        int right = left + newDrawRect.width;
        int top = newDrawRect.y;
        int bottom = top + newDrawRect.height;
        if (left > right) {
            this.invertedHorz = !this.invertedHorz;
            nTemp = left;
            left = right;
            right = nTemp;
            this.setOppositeHandleAsCurrent(true);
        }
        if (top > bottom) {
            this.invertedVert = !this.invertedVert;
            nTemp = top;
            top = bottom;
            bottom = nTemp;
            this.setOppositeHandleAsCurrent(false);
        }
        newDrawRect.x = left;
        newDrawRect.width = right - left;
        newDrawRect.y = top;
        newDrawRect.height = bottom - top;
        this.setDrawRect(newDrawRect.x, newDrawRect.y, newDrawRect.width, newDrawRect.height);
    }

    private void setOppositeHandleAsCurrent(boolean bHoriz) {
        if (bHoriz) {
            switch (this.currentHandle) {
                case 0: {
                    throw new IllegalArgumentException("cannot be TOP_HANDLE and horz");
                }
                case 4: {
                    throw new IllegalArgumentException("cannot be BOTTOM_HANDLE and horz");
                }
                case 6: {
                    this.currentHandle = 2;
                    break;
                }
                case 2: {
                    this.currentHandle = 6;
                    break;
                }
                case 3: {
                    this.currentHandle = 5;
                    break;
                }
                case 5: {
                    this.currentHandle = 3;
                    break;
                }
                case 7: {
                    this.currentHandle = 1;
                    break;
                }
                case 1: {
                    this.currentHandle = 7;
                }
            }
        } else {
            switch (this.currentHandle) {
                case 0: {
                    this.currentHandle = 4;
                    break;
                }
                case 4: {
                    this.currentHandle = 0;
                    break;
                }
                case 6: {
                    throw new IllegalArgumentException("cannot be LEFT_HANDLE and vertical flipp at same time!");
                }
                case 2: {
                    throw new IllegalArgumentException("cannot be RIGHT_HANDLE and vertical flipp at same time!");
                }
                case 3: {
                    this.currentHandle = 1;
                    break;
                }
                case 5: {
                    this.currentHandle = 7;
                    break;
                }
                case 7: {
                    this.currentHandle = 5;
                    break;
                }
                case 1: {
                    this.currentHandle = 3;
                }
            }
        }
    }

    protected Rectangle scaleRectangle(Rectangle toScale) {
        double scaler = (double)this.getScaleNum() / (double)this.getScaleDeNum();
        toScale.x = (int)((double)toScale.x * scaler);
        toScale.y = (int)((double)toScale.y * scaler);
        toScale.width = (int)((double)toScale.width * scaler);
        toScale.height = (int)((double)toScale.height * scaler);
        return toScale;
    }

    int getUnscaledValue(int value) {
        double scaler = (double)this.getScaleDeNum() / (double)this.getScaleNum();
        value = (int)((double)value * scaler);
        return value;
    }

    void setCreationIndex(int index) {
        this.currentIndex = this.creationIndex = index;
    }

    public int getCreationIndex() {
        return this.creationIndex;
    }

    public void setCurrentIndex(int index) {
        this.firePropertiesWillChangeEvent();
        this.currentIndex = index;
        this.firePropertiesChangeEvent();
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    private void UnScalePoint(Point p) {
        double scaler = (double)this.getScaleNum() / 1000.0;
        p.x = (int)((double)p.x * scaler);
        p.y = (int)((double)p.y * scaler);
    }

    public JPanel getPropertiesPanel() {
        return null;
    }

    public void updateValues(int action) {
        if (action == 106) {
            this.fireCMBAnnotationDefaultsChangedEvent(this.getClass());
        }
    }

    public void handlePropertyChange(String s, JComponent o, int action) {
    }

    public void addPropertyComponent(String propertyName, JComponent component) {
    }

    public CMBPropertiesPanel getAnnotationPropertiesPanel() {
        return null;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.initialize();
        this.type = stream.readInt();
        this.setPageNumber(stream.readInt());
        this.setBorderWidth(stream.readInt());
        int red = stream.readInt();
        int green = stream.readInt();
        int blue = stream.readInt();
        int alpha = stream.readInt();
        this.borderColor = new Color(red, green, blue, alpha);
        int r = stream.readInt();
        int g = stream.readInt();
        int b = stream.readInt();
        int a = stream.readInt();
        this.fillColor = new Color(r, g, b, a);
        int x = stream.readInt();
        int y = stream.readInt();
        int width = stream.readInt();
        int height = stream.readInt();
        this.setDrawRect(x, y, width, height);
        this.setTransparent(stream.readBoolean());
        this.setRotateWithImage(stream.readBoolean());
        this.setVisibleWhileDragging(stream.readBoolean());
        this.setInvertHorizontal(stream.readBoolean());
        this.setInvertVertical(stream.readBoolean());
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(this.getType());
        stream.writeInt(this.getPageNumber());
        stream.writeInt(this.getBorderWidth());
        stream.writeInt(this.getBorderColor().getRed());
        stream.writeInt(this.getBorderColor().getGreen());
        stream.writeInt(this.getBorderColor().getBlue());
        stream.writeInt(this.getBorderColor().getAlpha());
        stream.writeInt(this.getFillColor().getRed());
        stream.writeInt(this.getFillColor().getGreen());
        stream.writeInt(this.getFillColor().getBlue());
        stream.writeInt(this.getFillColor().getAlpha());
        stream.writeInt(this.getDrawRect().x);
        stream.writeInt(this.getDrawRect().y);
        stream.writeInt(this.getDrawRect().width);
        stream.writeInt(this.getDrawRect().height);
        stream.writeBoolean(this.getTransparent());
        stream.writeBoolean(this.getRotateWithImage());
        stream.writeBoolean(this.getVisibleWhileDragging());
        stream.writeBoolean(this.getInvertHorizontal());
        stream.writeBoolean(this.getInvertVertical());
    }

    public synchronized Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(pageAnnotationFlavor)) {
            return this;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(pageAnnotationFlavor);
    }

    public Object clone() {
        try {
            CMBPageAnnotation a = (CMBPageAnnotation)super.clone();
            a.drawRect = (Rectangle)this.drawRect.clone();
            return a;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public boolean canShow() {
        return this.canShow;
    }

    public boolean canHide() {
        return this.canHide;
    }

    public boolean canUpdate() {
        return this.canUpdate;
    }

    public boolean canDelete() {
        return this.canDelete;
    }

    public void setCanDelete(boolean delete) {
        this.canDelete = delete;
    }

    public void setCanShow(boolean show) {
        this.allowedToDraw = this.canShow = show;
    }

    public void setCanHide(boolean hide) {
        this.canHide = hide;
        if (!this.canHide) {
            this.allowedToDraw = true;
        }
    }

    public void setCanUpdate(boolean update) {
        this.canUpdate = update;
    }

    public void dispose() {
        this.drawRect = null;
        this.borderStroke = null;
        this.outlineStroke = null;
        this.borderColor = null;
        this.fillColor = null;
    }

    public String toString() {
        return new String("[Annotation:" + this.getName() + " ,page:" + this.pageNumber + " ,drawRect:" + this.drawRect + " ,fillColor:" + this.fillColor + " ,borderColor:" + this.borderColor + "]");
    }

    public void updatePropertiesFrom(CMBPageAnnotation newValues) {
        this.setAnnotationRotation(newValues.getAnnotationRotation());
        this.setBorderColor(newValues.getBorderColor());
        this.setFillColor(newValues.getFillColor());
        this.setBorderWidth(newValues.getBorderWidth());
        this.setVisibleWhileDragging(newValues.getVisibleWhileDragging());
        this.setTransparent(newValues.getTransparent());
        this.setRotateWithImage(newValues.getRotateWithImage());
    }

    static void getDefaultAnnotationProperties(Properties properties) {
    }

    static void setDefaultAnnotationProperties(Properties properties) {
    }

    public void setPermanentlyRotating(boolean permanentlyRotating) {
        this.permanentlyRotating = permanentlyRotating;
    }

    public boolean getPermanentlyRotating() {
        return this.permanentlyRotating;
    }

    public boolean isCorrupt() {
        return this.corrupt;
    }

    public void setCorrupt(boolean corrupt) {
        this.corrupt = corrupt;
    }

    public boolean isShowing() {
        return this.allowedToDraw;
    }
}

