/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer.annotation;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import com.ibm.mm.viewer.annotation.CMBPropertiesPanel;
import com.ibm.mm.viewer.annotation.PAnnotationUtilities;
import com.ibm.mm.viewer.annotation.PNumericField;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.text.AttributedString;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CMBNoteAnnotation
extends CMBPageAnnotation {
    private static final String copyright = "Licensed Materials - Property of IBM\nIBM DB2 Content Manager Enterprise Edition V8 (program number 5724-B19)\n(c ) Copyright IBM Corp.  1998, 2004.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private CMBPropertiesPanel annotationPropertiesPanel = null;
    private Hashtable compTable = new Hashtable();
    private static boolean isDefaultSet = false;
    private static final int DEFAULT_NOTE_WIDTH = 2;
    private static final Color DEFAULT_NOTE_BORDER_COLOR = Color.black;
    private static final Color DEFAULT_NOTE_FILL_COLOR = Color.yellow;
    private static final boolean DEFAULT_NOTE_TRANSPARENCY = false;
    private static final boolean DEFAULT_WORD_WRAP = false;
    private static final Font DEFAULT_FONT = PAnnotationUtilities.getValidDefaultFont("Arial Unicode MS", "plain", 26);
    private static Color defaultBorderColor = DEFAULT_NOTE_BORDER_COLOR;
    private static Color defaultFillColor = DEFAULT_NOTE_FILL_COLOR;
    private static int defaultWidth = 2;
    private static boolean defaultVWD = false;
    private static boolean defaultTransparent = false;
    static Font defaultFont = DEFAULT_FONT;
    static final long serialVersionUID = 1L;
    private transient Vector propList = null;
    private transient Vector lines = new Vector();
    private Font noteFont = defaultFont;
    private transient boolean measureBox = true;
    private boolean wordWrap;
    private static boolean defaultWordWrap;

    public CMBNoteAnnotation() {
        this.init();
        this.lines.addElement(" ");
    }

    public CMBNoteAnnotation(Rectangle r, String text_lines) {
        super(r);
        String methodName = "CMBNoteAnnotation";
        this.init();
        BufferedReader br = new BufferedReader(new StringReader(text_lines));
        try {
            boolean fDone = false;
            while (!fDone) {
                String s = br.readLine();
                if (s == null) {
                    fDone = true;
                    continue;
                }
                this.lines.addElement(s);
            }
        }
        catch (IOException e) {
            ViewerLogger.logError((Object)this, methodName, e);
        }
        if (this.lines.size() == 0) {
            this.setCorrupt(true);
            this.lines.addElement(" ");
        }
    }

    public CMBNoteAnnotation(Rectangle r, String text_lines, int pageNumber) {
        this(r, text_lines);
        this.pageNumber = pageNumber;
        this.init();
    }

    public void init() {
        this.setBorderColor(defaultBorderColor);
        this.setFillColor(defaultFillColor);
        this.setFont(defaultFont);
        this.setTransparent(defaultTransparent);
        this.setVisibleWhileDragging(defaultVWD);
        this.setBorderWidth(defaultWidth);
        this.setWordWrap(defaultWordWrap);
        this.setRotateWithImage(false);
        this.type = 5;
        if (isDefaultSet) {
            this.updateValues(104);
        } else {
            this.updateValues(103);
        }
    }

    public void setFont(Font f) {
        if (!this.canUpdate()) {
            return;
        }
        this.firePropertiesWillChangeEvent();
        this.noteFont = f;
        this.firePropertiesChangeEvent();
    }

    public Font getFont() {
        return this.noteFont;
    }

    public void clearText() {
        if (!this.canUpdate()) {
            return;
        }
        if (this.lines != null) {
            this.firePropertiesWillChangeEvent();
            this.lines.removeAllElements();
            this.firePropertiesChangeEvent();
        }
    }

    public void setText(String text) {
        String methodName = "setText";
        if (!this.canUpdate()) {
            return;
        }
        if (this.lines == null) {
            this.lines = new Vector();
        }
        if (text == null || text.equals("")) {
            this.clearText();
            this.lines.addElement(" ");
            return;
        }
        this.clearText();
        this.firePropertiesWillChangeEvent();
        BufferedReader br = new BufferedReader(new StringReader(text));
        try {
            boolean fDone = false;
            while (!fDone) {
                String s = br.readLine();
                if (s == null) {
                    fDone = true;
                    continue;
                }
                this.lines.addElement(s);
            }
        }
        catch (IOException e) {
            ViewerLogger.logError((Object)this, methodName, e);
        }
        if (this.lines.size() == 0) {
            this.lines.addElement(" ");
        }
        this.firePropertiesChangeEvent();
    }

    public String getText() {
        if (this.lines == null) {
            return null;
        }
        int s = this.lines.size();
        StringBuffer string = new StringBuffer();
        for (int i = 0; i < s; ++i) {
            string.append(this.lines.elementAt(i));
            if (i >= s - 1) continue;
            string.append(System.getProperty("line.separator"));
        }
        return string.toString();
    }

    public void draw(Graphics2D g2) {
        if (!this.allowedToDraw) {
            return;
        }
        if (this.isInMotion && !this.isVisibleWhileDragging) {
            this.drawOutline(g2);
            return;
        }
        Rectangle drawRect = this.getAnnoDrawRect();
        Color oldColor = g2.getColor();
        Stroke oldStroke = g2.getStroke();
        Paint oldPaint = g2.getPaint();
        AffineTransform oldTransform = g2.getTransform();
        Object oldAliasing = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle fillRect = this.getFillRect();
        g2.setPaint(this.getFillColor());
        g2.fill(fillRect);
        g2.setPaint(oldPaint);
        g2.setColor(this.getBorderColor());
        g2.setStroke(this.getBorderStroke());
        g2.draw(this.getAnnoDrawRect());
        g2.setStroke(oldStroke);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAliasing);
        Shape oldClip = g2.getClip();
        Rectangle textRect = new Rectangle(fillRect.x + 2, fillRect.y + 2, fillRect.width - 4, fillRect.height - 4);
        g2.clipRect(textRect.x, textRect.y, textRect.width, textRect.height);
        g2.setColor(this.getBorderColor());
        int x = 0;
        int y = 0;
        double rot = this.getRotationInRadians(this.getRotation());
        if (this.getRotateWithImage()) {
            g2.rotate(rot, textRect.x, textRect.y);
            switch (this.getRotation()) {
                case 0: {
                    x = textRect.x;
                    y = textRect.y;
                    break;
                }
                case 1: {
                    y = textRect.y - textRect.width;
                    x = textRect.x;
                    break;
                }
                case 2: {
                    x = textRect.x - textRect.width;
                    y = textRect.y - textRect.height;
                    break;
                }
                case 3: {
                    x = textRect.x - textRect.height;
                    y = textRect.y;
                }
            }
        } else {
            x = textRect.x;
            y = textRect.y;
        }
        FontRenderContext frc = new FontRenderContext(null, false, false);
        int num_lines = this.lines.size();
        for (int i = 0; i < num_lines; ++i) {
            String str = (String)this.lines.elementAt(i);
            if (str.length() == 0) {
                str = " ";
            }
            if (this.wordWrap && str.length() > 1) {
                AttributedString attributedString = new AttributedString(str);
                attributedString.addAttribute(TextAttribute.FONT, this.noteFont);
                if (!PAnnotationUtilities.isLeftToRight()) {
                    attributedString.addAttribute(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                }
                LineBreakMeasurer measurer = new LineBreakMeasurer(attributedString.getIterator(), frc);
                float wrappingWidth = textRect.width;
                while (measurer.getPosition() < str.length()) {
                    TextLayout layout = measurer.nextLayout(wrappingWidth);
                    y = (int)((float)y + layout.getAscent());
                    float dx = layout.isLeftToRight() ? 0.0f : wrappingWidth - layout.getAdvance();
                    layout.draw(g2, (float)x + dx, y);
                    y = (int)((float)y + (layout.getDescent() + layout.getLeading()));
                }
                continue;
            }
            TextLayout layout = new TextLayout(str, this.noteFont, frc);
            float dx = 0.0f;
            if (!PAnnotationUtilities.isLeftToRight()) {
                AttributedString attributedString = new AttributedString(str);
                attributedString.addAttribute(TextAttribute.FONT, this.noteFont);
                attributedString.addAttribute(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                layout = new TextLayout(attributedString.getIterator(), frc);
                dx = (float)textRect.width - layout.getAdvance();
            }
            y = (int)((float)y + layout.getAscent());
            layout.draw(g2, (float)x + dx, y);
            y = (int)((float)y + (layout.getDescent() + layout.getLeading()));
        }
        if (this.getRotateWithImage()) {
            g2.rotate(-rot, drawRect.x, drawRect.y);
        }
        g2.setClip(oldClip);
        g2.setColor(oldColor);
        g2.setTransform(oldTransform);
        super.draw(g2);
    }

    public void drawOutline(Graphics2D g2) {
        Color oldColor = g2.getColor();
        Rectangle drawRect = this.getAnnoDrawRect();
        Stroke oldStroke = g2.getStroke();
        g2.setColor(Color.black);
        g2.setStroke(this.getOutlineStroke());
        Rectangle2D.Float rect = new Rectangle2D.Float(drawRect.x, drawRect.y, drawRect.width, drawRect.height);
        g2.draw(rect);
        g2.setStroke(oldStroke);
        g2.setColor(oldColor);
        super.drawOutline(g2);
    }

    public CMBPropertiesPanel getAnnotationPropertiesPanel() {
        if (this.annotationPropertiesPanel == null) {
            if (this.propList == null) {
                this.propList = new Vector();
            }
            this.propList.addElement("Annotation.borderTextColor");
            this.propList.addElement(Color.white);
            this.propList.addElement("Annotation.borderWidth");
            this.propList.addElement(new Integer[]{new Integer(1), new Integer(100)});
            this.propList.addElement("Annotation.fillColor");
            this.propList.addElement(Color.white);
            this.propList.addElement("Annotation.font");
            this.propList.addElement(new Font(null));
            this.propList.addElement("Annotation.transparent");
            this.propList.addElement(new Boolean(true));
            this.propList.addElement("Annotation.wordWrap");
            this.propList.addElement(new Boolean(true));
            this.annotationPropertiesPanel = new CMBPropertiesPanel(this, this.propList);
        }
        return this.annotationPropertiesPanel;
    }

    public JPanel getPropertiesPanel() {
        this.getAnnotationPropertiesPanel().setAnnotation(this);
        return this.annotationPropertiesPanel.getPanel();
    }

    public void handlePropertyChange(String propName, JComponent comp, int action) {
        if (action == 106) {
            isDefaultSet = true;
        }
        if (propName.equals("Annotation.borderTextColor")) {
            switch (action) {
                case 101: {
                    this.setBorderColor(comp.getBackground());
                    break;
                }
                case 102: {
                    comp.setBackground(this.getBorderColor());
                    break;
                }
                case 103: {
                    defaultBorderColor = this.getBorderColor();
                    break;
                }
                case 104: {
                    this.setBorderColor(defaultBorderColor);
                    break;
                }
                case 105: {
                    comp.setBackground(defaultBorderColor);
                    break;
                }
                case 106: {
                    defaultBorderColor = comp.getBackground();
                }
            }
        } else if (propName.equals("Annotation.borderWidth")) {
            switch (action) {
                case 101: {
                    this.setBorderWidth(((PNumericField)comp).getValue());
                    break;
                }
                case 102: {
                    ((PNumericField)comp).setValue(this.getBorderWidth());
                    break;
                }
                case 103: {
                    defaultWidth = this.getBorderWidth();
                    break;
                }
                case 104: {
                    this.setBorderWidth(defaultWidth);
                    break;
                }
                case 105: {
                    ((PNumericField)comp).setValue(defaultWidth);
                    break;
                }
                case 106: {
                    defaultWidth = ((PNumericField)comp).getValue();
                }
            }
        } else if (propName.equals("Annotation.fillColor")) {
            switch (action) {
                case 101: {
                    this.setFillColor(comp.getBackground());
                    break;
                }
                case 102: {
                    comp.setBackground(this.getFillColor());
                    break;
                }
                case 103: {
                    defaultFillColor = this.getFillColor();
                    break;
                }
                case 104: {
                    this.setFillColor(defaultFillColor);
                    break;
                }
                case 105: {
                    comp.setBackground(defaultFillColor);
                    break;
                }
                case 106: {
                    defaultFillColor = comp.getBackground();
                }
            }
        } else if (propName.equals("Annotation.visibleWhileDragging")) {
            switch (action) {
                case 101: {
                    this.setVisibleWhileDragging(((JCheckBox)comp).isSelected());
                    break;
                }
                case 102: {
                    ((JCheckBox)comp).setSelected(this.getVisibleWhileDragging());
                    break;
                }
                case 103: {
                    defaultVWD = this.getVisibleWhileDragging();
                    break;
                }
                case 104: {
                    this.setVisibleWhileDragging(defaultVWD);
                    break;
                }
                case 105: {
                    ((JCheckBox)comp).setSelected(defaultVWD);
                    break;
                }
                case 106: {
                    defaultVWD = ((JCheckBox)comp).isSelected();
                }
            }
        } else if (propName.equals("Annotation.transparent")) {
            switch (action) {
                case 101: {
                    this.setTransparent(((JCheckBox)comp).isSelected());
                    break;
                }
                case 102: {
                    ((JCheckBox)comp).setSelected(this.getTransparent());
                    break;
                }
                case 103: {
                    defaultTransparent = this.getTransparent();
                    break;
                }
                case 104: {
                    this.setTransparent(defaultTransparent);
                    break;
                }
                case 105: {
                    ((JCheckBox)comp).setSelected(defaultTransparent);
                    break;
                }
                case 106: {
                    defaultTransparent = ((JCheckBox)comp).isSelected();
                }
            }
        } else if (propName.equals("Annotation.font")) {
            switch (action) {
                case 101: {
                    this.setFont(comp.getFont());
                    break;
                }
                case 102: {
                    comp.setFont(this.getFont());
                    break;
                }
                case 103: {
                    defaultFont = this.getFont();
                    break;
                }
                case 104: {
                    this.setFont(defaultFont);
                    break;
                }
                case 105: {
                    comp.setFont(defaultFont);
                    break;
                }
                case 106: {
                    defaultFont = comp.getFont();
                }
            }
        } else if (propName.equals("Annotation.wordWrap")) {
            switch (action) {
                case 101: {
                    this.setWordWrap(((JCheckBox)comp).isSelected());
                    break;
                }
                case 102: {
                    ((JCheckBox)comp).setSelected(this.getWordWrap());
                    break;
                }
                case 103: {
                    defaultWordWrap = this.getWordWrap();
                    break;
                }
                case 104: {
                    this.setWordWrap(defaultWordWrap);
                    break;
                }
                case 105: {
                    ((JCheckBox)comp).setSelected(defaultWordWrap);
                    break;
                }
                case 106: {
                    defaultWordWrap = ((JCheckBox)comp).isSelected();
                }
            }
        }
    }

    public void updateValues(int action) {
        if (this.compTable.isEmpty()) {
            return;
        }
        Enumeration props = this.compTable.keys();
        while (props.hasMoreElements()) {
            String propName = (String)props.nextElement();
            JComponent comp = (JComponent)this.compTable.get(propName);
            this.handlePropertyChange(propName, comp, action);
        }
        super.updateValues(action);
    }

    public void updatePropertiesFrom(CMBPageAnnotation newValues) {
        this.setFont(newValues.getFont());
        this.setText(((CMBNoteAnnotation)newValues).getText());
        this.setWordWrap(((CMBNoteAnnotation)newValues).getWordWrap());
        super.updatePropertiesFrom(newValues);
    }

    public void addPropertyComponent(String propertyName, JComponent component) {
        this.compTable.put(propertyName, component);
    }

    protected boolean canBePermanentlyRotated() {
        return false;
    }

    public boolean getWordWrap() {
        return this.wordWrap;
    }

    public void setWordWrap(boolean wrap) {
        this.firePropertiesWillChangeEvent();
        this.wordWrap = wrap;
        this.firePropertiesChangeEvent();
    }

    public void dispose() {
        if (this.lines != null) {
            this.lines.clear();
            this.lines = null;
        }
        this.noteFont = null;
        this.annotationPropertiesPanel = null;
        super.dispose();
    }

    public Object clone() {
        CMBNoteAnnotation a = (CMBNoteAnnotation)super.clone();
        a.annotationPropertiesPanel = null;
        a.propList = new Vector();
        a.compTable = new Hashtable();
        a.noteFont = new Font(this.noteFont.getName(), this.noteFont.getStyle(), this.noteFont.getSize());
        a.lines = new Vector();
        int size = this.lines.size();
        for (int i = 0; i < size; ++i) {
            a.lines.addElement(new String((String)this.lines.elementAt(i)));
        }
        return a;
    }

    public String toString() {
        return new String("[Annotation:" + this.getName() + " ,page:" + this.getPageNumber() + " ,note:" + this.getText() + " ,font:" + this.getFont() + " ,drawRect:" + this.getAnnoDrawRect() + " ,fillColor:" + this.getFillColor() + " ,borderColor:" + this.getBorderColor() + "]");
    }

    static void getDefaultAnnotationProperties(Properties properties) {
        PAnnotationUtilities.setColorProperty("Note.borderColor", properties, defaultBorderColor);
        PAnnotationUtilities.setColorProperty("Note.fillColor", properties, defaultFillColor);
        PAnnotationUtilities.setFontProperty("Note.font", properties, defaultFont);
        PAnnotationUtilities.setBooleanProperty("Note.transparent", properties, defaultTransparent);
        PAnnotationUtilities.setIntegerProperty("Note.borderWidth", properties, defaultWidth);
        PAnnotationUtilities.setBooleanProperty("Note.wordWrap", properties, defaultWordWrap);
    }

    static void setDefaultAnnotationProperties(Properties properties) {
        defaultBorderColor = PAnnotationUtilities.getColorProperty("Note.borderColor", properties, DEFAULT_NOTE_BORDER_COLOR);
        defaultFillColor = PAnnotationUtilities.getColorProperty("Note.fillColor", properties, DEFAULT_NOTE_FILL_COLOR);
        defaultFont = PAnnotationUtilities.getFontProperty("Note.font", properties, DEFAULT_FONT);
        defaultTransparent = PAnnotationUtilities.getBooleanProperty("Note.transparent", properties, false);
        defaultWidth = PAnnotationUtilities.getIntegerProperty("Note.borderWidth", properties, 2, 1, 100);
        defaultWordWrap = PAnnotationUtilities.getBooleanProperty("Note.wordWrap", properties, false);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.setText((String)stream.readObject());
        this.setFont((Font)stream.readObject());
        try {
            this.setWordWrap(stream.readBoolean());
        }
        catch (EOFException e) {
            this.setWordWrap(defaultWordWrap);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.getText());
        stream.writeObject(this.getFont());
        stream.writeBoolean(this.getWordWrap());
    }
}

