/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer.annotation;

import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import com.ibm.mm.viewer.annotation.CMBPropertiesPanel;
import com.ibm.mm.viewer.annotation.PAnnotationUtilities;
import com.ibm.mm.viewer.annotation.PNumericField;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CMBLineAnnotation
extends CMBPageAnnotation {
    private static final String copyright = "Licensed Materials - Property of IBM\nIBM DB2 Content Manager Enterprise Edition V8 (program number 5724-B19)\n(c ) Copyright IBM Corp.  1998, 2004.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private CMBPropertiesPanel annotationPropertiesPanel = null;
    private Hashtable compTable = new Hashtable();
    private static boolean isDefaultSet = false;
    private static Color defaultBorderColor = DEFAULT_BORDER_COLOR;
    private static int defaultBorderWidth = 5;
    private static boolean defaultVWD = false;
    private static boolean defaultTransparent = true;
    static final long serialVersionUID = 1L;
    private transient Vector propList = null;
    private transient Point beginPoint = new Point();
    private transient Point endPoint = new Point();

    public CMBLineAnnotation() {
        this.init();
    }

    public CMBLineAnnotation(Rectangle r) {
        super(r);
        this.init();
    }

    public CMBLineAnnotation(Rectangle r, int pageNumber) {
        super(r, pageNumber);
        this.init();
    }

    public void init() {
        this.type = 4;
        this.setBorderColor(defaultBorderColor);
        this.setBorderWidth(defaultBorderWidth);
        this.setTransparent(defaultTransparent);
        this.setVisibleWhileDragging(defaultVWD);
        if (isDefaultSet) {
            this.updateValues(104);
        } else {
            this.updateValues(103);
        }
        this.calculateLinePoints();
    }

    public Point getBeginPoint() {
        return this.beginPoint;
    }

    public void setBeginPoint(Point begin) {
        if (!this.canUpdate()) {
            return;
        }
        this.firePropertiesWillChangeEvent();
        this.beginPoint = begin;
        this.firePropertiesChangeEvent();
    }

    public Point getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(Point end) {
        if (!this.canUpdate()) {
            return;
        }
        this.firePropertiesWillChangeEvent();
        this.endPoint = end;
        this.firePropertiesChangeEvent();
    }

    public void draw(Graphics2D g2) {
        if (!this.allowedToDraw) {
            return;
        }
        if (this.isInMotion && !this.isVisibleWhileDragging) {
            this.drawOutline(g2);
            return;
        }
        this.calculateLinePoints();
        Color oldColor = g2.getColor();
        Stroke oldStroke = g2.getStroke();
        Object oldAliasing = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.getBorderColor());
        g2.setStroke(this.getBorderStroke());
        g2.drawLine(this.beginPoint.x, this.beginPoint.y, this.endPoint.x, this.endPoint.y);
        g2.setColor(oldColor);
        g2.setStroke(oldStroke);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAliasing);
        super.draw(g2);
    }

    public void drawOutline(Graphics2D g2) {
        this.calculateLinePoints();
        Color oldColor = g2.getColor();
        Stroke oldStroke = g2.getStroke();
        g2.setColor(Color.black);
        g2.setStroke(this.getOutlineStroke());
        g2.drawLine(this.beginPoint.x, this.beginPoint.y, this.endPoint.x, this.endPoint.y);
        g2.setColor(oldColor);
        g2.setStroke(oldStroke);
        super.drawOutline(g2);
    }

    public Rectangle getRefreshRect() {
        Rectangle refRect = super.getRefreshRect();
        int xdifference = (int)Math.max((double)this.getBorderWidth() / 1.3, (double)this.getDefaultHandleWidth());
        int ydifference = (int)Math.max((double)this.getBorderWidth() / 1.3, (double)this.getDefaultHandleHeight());
        refRect.x -= xdifference;
        refRect.y -= ydifference;
        refRect.width += xdifference * 2;
        refRect.height += ydifference * 2;
        return refRect;
    }

    private void calculateLinePoints() {
        Rectangle drawRect = this.getAnnoDrawRect();
        int rotation = this.getRotation();
        if (!this.invertedVert && !this.invertedHorz) {
            if (this.getRotateWithImage()) {
                switch (rotation) {
                    case 0: {
                        this.beginPoint.x = drawRect.x;
                        this.beginPoint.y = drawRect.y;
                        this.endPoint.x = drawRect.x + drawRect.width;
                        this.endPoint.y = drawRect.y + drawRect.height;
                        break;
                    }
                    case 1: {
                        this.beginPoint.x = drawRect.x + drawRect.width;
                        this.beginPoint.y = drawRect.y;
                        this.endPoint.x = drawRect.x;
                        this.endPoint.y = drawRect.y + drawRect.height;
                        break;
                    }
                    case 2: {
                        this.beginPoint.x = drawRect.x + drawRect.width;
                        this.beginPoint.y = drawRect.y + drawRect.height;
                        this.endPoint.x = drawRect.x;
                        this.endPoint.y = drawRect.y;
                        break;
                    }
                    case 3: {
                        this.beginPoint.x = drawRect.x;
                        this.beginPoint.y = drawRect.y + drawRect.height;
                        this.endPoint.x = drawRect.x + drawRect.width;
                        this.endPoint.y = drawRect.y;
                    }
                }
            } else {
                this.beginPoint.x = drawRect.x;
                this.beginPoint.y = drawRect.y;
                this.endPoint.x = drawRect.x + drawRect.width;
                this.endPoint.y = drawRect.y + drawRect.height;
            }
        }
        if (this.invertedVert) {
            if (this.getRotateWithImage()) {
                switch (rotation) {
                    case 0: {
                        this.beginPoint.x = drawRect.x;
                        this.beginPoint.y = drawRect.y + drawRect.height;
                        this.endPoint.x = drawRect.x + drawRect.width;
                        this.endPoint.y = drawRect.y;
                        break;
                    }
                    case 1: {
                        this.beginPoint.x = drawRect.x;
                        this.beginPoint.y = drawRect.y;
                        this.endPoint.x = drawRect.x + drawRect.width;
                        this.endPoint.y = drawRect.y + drawRect.height;
                        break;
                    }
                    case 2: {
                        this.beginPoint.x = drawRect.x + drawRect.width;
                        this.beginPoint.y = drawRect.y;
                        this.endPoint.x = drawRect.x;
                        this.endPoint.y = drawRect.y + drawRect.height;
                        break;
                    }
                    case 3: {
                        this.beginPoint.x = drawRect.x + drawRect.width;
                        this.beginPoint.y = drawRect.y + drawRect.height;
                        this.endPoint.x = drawRect.x;
                        this.endPoint.y = drawRect.y;
                    }
                }
            } else {
                this.beginPoint.x = drawRect.x;
                this.beginPoint.y = drawRect.y + drawRect.height;
                this.endPoint.x = drawRect.x + drawRect.width;
                this.endPoint.y = drawRect.y;
            }
        }
        if (this.invertedHorz) {
            if (this.getRotateWithImage()) {
                switch (rotation) {
                    case 0: {
                        this.beginPoint.x = drawRect.x + drawRect.width;
                        this.beginPoint.y = drawRect.y;
                        this.endPoint.x = drawRect.x;
                        this.endPoint.y = drawRect.y + drawRect.height;
                        break;
                    }
                    case 1: {
                        this.beginPoint.x = drawRect.x + drawRect.width;
                        this.beginPoint.y = drawRect.y + drawRect.height;
                        this.endPoint.x = drawRect.x;
                        this.endPoint.y = drawRect.y;
                        break;
                    }
                    case 2: {
                        this.beginPoint.x = drawRect.x;
                        this.beginPoint.y = drawRect.y + drawRect.height;
                        this.endPoint.x = drawRect.x + drawRect.width;
                        this.endPoint.y = drawRect.y;
                        break;
                    }
                    case 3: {
                        this.beginPoint.x = drawRect.x;
                        this.beginPoint.y = drawRect.y;
                        this.endPoint.x = drawRect.x + drawRect.width;
                        this.endPoint.y = drawRect.y + drawRect.height;
                    }
                }
            } else {
                this.beginPoint.x = drawRect.x + drawRect.width;
                this.beginPoint.y = drawRect.y;
                this.endPoint.x = drawRect.x;
                this.endPoint.y = drawRect.y + drawRect.height;
            }
        }
        if (this.invertedHorz && this.invertedVert) {
            if (this.getRotateWithImage()) {
                switch (rotation) {
                    case 0: {
                        this.beginPoint.x = drawRect.x + drawRect.width;
                        this.beginPoint.y = drawRect.y + drawRect.height;
                        this.endPoint.x = drawRect.x;
                        this.endPoint.y = drawRect.y;
                        break;
                    }
                    case 1: {
                        this.beginPoint.x = drawRect.x;
                        this.beginPoint.y = drawRect.y + drawRect.height;
                        this.endPoint.x = drawRect.x + drawRect.width;
                        this.endPoint.y = drawRect.y;
                        break;
                    }
                    case 2: {
                        this.beginPoint.x = drawRect.x;
                        this.beginPoint.y = drawRect.y;
                        this.endPoint.x = drawRect.x + drawRect.width;
                        this.endPoint.y = drawRect.y + drawRect.height;
                        break;
                    }
                    case 3: {
                        this.beginPoint.x = drawRect.x + drawRect.width;
                        this.beginPoint.y = drawRect.y;
                        this.endPoint.x = drawRect.x;
                        this.endPoint.y = drawRect.y + drawRect.height;
                    }
                }
            } else {
                this.beginPoint.x = drawRect.x + drawRect.width;
                this.beginPoint.y = drawRect.y + drawRect.height;
                this.endPoint.x = drawRect.x;
                this.endPoint.y = drawRect.y;
            }
        }
    }

    public CMBPropertiesPanel getAnnotationPropertiesPanel() {
        if (this.annotationPropertiesPanel == null) {
            if (this.propList == null) {
                this.propList = new Vector();
            }
            this.propList.addElement("Annotation.lineColor");
            this.propList.addElement(Color.white);
            this.propList.addElement("Annotation.lineWidth");
            this.propList.addElement(new Integer[]{new Integer(1), new Integer(100)});
            this.propList.addElement("Annotation.transparent");
            this.propList.addElement(new Boolean(true));
            this.annotationPropertiesPanel = new CMBPropertiesPanel(this, this.propList);
        }
        return this.annotationPropertiesPanel;
    }

    public JPanel getPropertiesPanel() {
        this.getAnnotationPropertiesPanel().setAnnotation(this);
        return this.annotationPropertiesPanel.getPanel();
    }

    public void handlePropertyChange(String propName, JComponent comp, int action) {
        if (action == 106) {
            isDefaultSet = true;
        }
        if (propName.equals("Annotation.lineColor")) {
            switch (action) {
                case 101: {
                    this.setBorderColor(comp.getBackground());
                    break;
                }
                case 102: {
                    comp.setBackground(this.getBorderColor());
                    break;
                }
                case 103: {
                    defaultBorderColor = this.getBorderColor();
                    break;
                }
                case 104: {
                    this.setBorderColor(defaultBorderColor);
                    break;
                }
                case 105: {
                    comp.setBackground(defaultBorderColor);
                    break;
                }
                case 106: {
                    defaultBorderColor = comp.getBackground();
                }
            }
        } else if (propName.equals("Annotation.lineWidth")) {
            switch (action) {
                case 101: {
                    this.setBorderWidth(((PNumericField)comp).getValue());
                    break;
                }
                case 102: {
                    ((PNumericField)comp).setValue(this.getBorderWidth());
                    break;
                }
                case 103: {
                    defaultBorderWidth = this.getBorderWidth();
                    break;
                }
                case 104: {
                    this.setBorderWidth(defaultBorderWidth);
                    break;
                }
                case 105: {
                    ((PNumericField)comp).setValue(defaultBorderWidth);
                    break;
                }
                case 106: {
                    defaultBorderWidth = ((PNumericField)comp).getValue();
                }
            }
        } else if (propName.equals("Annotation.visibleWhileDragging")) {
            switch (action) {
                case 101: {
                    this.setVisibleWhileDragging(((JCheckBox)comp).isSelected());
                    break;
                }
                case 102: {
                    ((JCheckBox)comp).setSelected(this.getVisibleWhileDragging());
                    break;
                }
                case 103: {
                    defaultVWD = this.getVisibleWhileDragging();
                    break;
                }
                case 104: {
                    this.setVisibleWhileDragging(defaultVWD);
                    break;
                }
                case 105: {
                    ((JCheckBox)comp).setSelected(defaultVWD);
                    break;
                }
                case 106: {
                    defaultVWD = ((JCheckBox)comp).isSelected();
                }
            }
        } else if (propName.equals("Annotation.transparent")) {
            switch (action) {
                case 101: {
                    this.setTransparent(((JCheckBox)comp).isSelected());
                    break;
                }
                case 102: {
                    ((JCheckBox)comp).setSelected(this.getTransparent());
                    break;
                }
                case 103: {
                    defaultTransparent = this.getTransparent();
                    break;
                }
                case 104: {
                    this.setTransparent(defaultTransparent);
                    break;
                }
                case 105: {
                    ((JCheckBox)comp).setSelected(defaultTransparent);
                    break;
                }
                case 106: {
                    defaultTransparent = ((JCheckBox)comp).isSelected();
                }
            }
        }
    }

    public void updateValues(int action) {
        if (this.compTable.isEmpty()) {
            return;
        }
        Enumeration props = this.compTable.keys();
        while (props.hasMoreElements()) {
            String propName = (String)props.nextElement();
            JComponent comp = (JComponent)this.compTable.get(propName);
            this.handlePropertyChange(propName, comp, action);
        }
        super.updateValues(action);
    }

    public void addPropertyComponent(String propertyName, JComponent component) {
        this.compTable.put(propertyName, component);
    }

    public void dispose() {
        this.annotationPropertiesPanel = null;
        this.beginPoint = null;
        this.endPoint = null;
        super.dispose();
    }

    public Object clone() {
        CMBLineAnnotation s = (CMBLineAnnotation)super.clone();
        s.annotationPropertiesPanel = null;
        s.propList = new Vector();
        s.compTable = new Hashtable();
        s.beginPoint = (Point)this.beginPoint.clone();
        s.endPoint = (Point)this.endPoint.clone();
        return s;
    }

    static void getDefaultAnnotationProperties(Properties properties) {
        PAnnotationUtilities.setColorProperty("Line.color", properties, defaultBorderColor);
        PAnnotationUtilities.setIntegerProperty("Line.width", properties, defaultBorderWidth);
        PAnnotationUtilities.setBooleanProperty("Line.transparent", properties, defaultTransparent);
    }

    static void setDefaultAnnotationProperties(Properties properties) {
        defaultBorderColor = PAnnotationUtilities.getColorProperty("Line.color", properties, DEFAULT_BORDER_COLOR);
        defaultBorderWidth = PAnnotationUtilities.getIntegerProperty("Line.width", properties, 5, 1, 100);
        defaultTransparent = PAnnotationUtilities.getBooleanProperty("Line.transparent", properties, true);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.beginPoint = new Point();
        this.endPoint = new Point();
        this.calculateLinePoints();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
    }
}

