/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer.annotation;

import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import com.ibm.mm.viewer.annotation.CMBPropertiesPanel;
import com.ibm.mm.viewer.annotation.PAnnotationUtilities;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CMBHighlightAnnotation
extends CMBPageAnnotation {
    private static final String copyright = "Licensed Materials - Property of IBM\nIBM DB2 Content Manager Enterprise Edition V8 (program number 5724-B19)\n(c ) Copyright IBM Corp.  1998, 2004.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private CMBPropertiesPanel annotationPropertiesPanel = null;
    private Hashtable compTable = new Hashtable();
    private static boolean isDefaultSet = false;
    private static final Color DEFAULT_HIGH_FILL_COLOR;
    private static Color defaultFillColor;
    private static boolean defaultVWD;
    static final long serialVersionUID = 1L;
    private transient Vector propList = null;

    public CMBHighlightAnnotation() {
        this.init();
    }

    public CMBHighlightAnnotation(Rectangle r) {
        super(r);
        this.init();
    }

    public CMBHighlightAnnotation(Rectangle r, int pageNumber) {
        super(r, pageNumber);
        this.init();
    }

    public void init() {
        this.setTransparent(true);
        this.setFillColor(defaultFillColor);
        this.setVisibleWhileDragging(defaultVWD);
        this.type = 3;
        if (isDefaultSet) {
            this.updateValues(104);
        } else {
            this.updateValues(103);
        }
    }

    public void draw(Graphics2D g2) {
        if (!this.allowedToDraw) {
            return;
        }
        if (this.isInMotion && !this.isVisibleWhileDragging) {
            this.drawOutline(g2);
            return;
        }
        Color oldColor = g2.getColor();
        Rectangle drawRect = this.getAnnoDrawRect();
        g2.setColor(this.getFillColor());
        g2.fillRect(drawRect.x, drawRect.y, drawRect.width, drawRect.height);
        g2.setColor(oldColor);
        super.draw(g2);
    }

    public void drawOutline(Graphics2D g2) {
        Color oldColor = g2.getColor();
        Stroke oldStroke = g2.getStroke();
        Rectangle drawRect = this.getAnnoDrawRect();
        g2.setColor(Color.black);
        g2.setStroke(this.getOutlineStroke());
        Rectangle2D.Float rect = new Rectangle2D.Float(drawRect.x, drawRect.y, drawRect.width, drawRect.height);
        g2.draw(rect);
        g2.setStroke(oldStroke);
        g2.setColor(oldColor);
        super.drawOutline(g2);
    }

    public CMBPropertiesPanel getAnnotationPropertiesPanel() {
        if (this.annotationPropertiesPanel == null) {
            if (this.propList == null) {
                this.propList = new Vector();
            }
            this.propList.addElement("Annotation.fillColor");
            this.propList.addElement(Color.white);
            this.annotationPropertiesPanel = new CMBPropertiesPanel(this, this.propList);
        }
        return this.annotationPropertiesPanel;
    }

    public JPanel getPropertiesPanel() {
        this.getAnnotationPropertiesPanel().setAnnotation(this);
        return this.annotationPropertiesPanel.getPanel();
    }

    public void handlePropertyChange(String propName, JComponent comp, int action) {
        if (action == 106) {
            isDefaultSet = true;
        }
        if (propName.equals("Annotation.fillColor")) {
            switch (action) {
                case 101: {
                    this.setFillColor(comp.getBackground());
                    break;
                }
                case 102: {
                    comp.setBackground(this.getFillColor());
                    break;
                }
                case 103: {
                    defaultFillColor = this.getFillColor();
                    break;
                }
                case 104: {
                    this.setFillColor(defaultFillColor);
                    break;
                }
                case 105: {
                    comp.setBackground(defaultFillColor);
                    break;
                }
                case 106: {
                    defaultFillColor = comp.getBackground();
                }
            }
        } else if (propName.equals("Annotation.visibleWhileDragging")) {
            switch (action) {
                case 101: {
                    this.setVisibleWhileDragging(((JCheckBox)comp).isSelected());
                    break;
                }
                case 102: {
                    ((JCheckBox)comp).setSelected(this.getVisibleWhileDragging());
                    break;
                }
                case 103: {
                    defaultVWD = this.getVisibleWhileDragging();
                    break;
                }
                case 104: {
                    this.setVisibleWhileDragging(defaultVWD);
                    break;
                }
                case 105: {
                    ((JCheckBox)comp).setSelected(defaultVWD);
                    break;
                }
                case 106: {
                    defaultVWD = ((JCheckBox)comp).isSelected();
                }
            }
        }
    }

    public void updateValues(int action) {
        if (this.compTable.isEmpty()) {
            return;
        }
        Enumeration props = this.compTable.keys();
        while (props.hasMoreElements()) {
            String propName = (String)props.nextElement();
            JComponent comp = (JComponent)this.compTable.get(propName);
            this.handlePropertyChange(propName, comp, action);
        }
        super.updateValues(action);
    }

    public void addPropertyComponent(String propertyName, JComponent component) {
        this.compTable.put(propertyName, component);
    }

    public Object clone() {
        CMBHighlightAnnotation a = (CMBHighlightAnnotation)super.clone();
        a.annotationPropertiesPanel = null;
        a.propList = new Vector();
        a.compTable = new Hashtable();
        return a;
    }

    public void dispose() {
        this.annotationPropertiesPanel = null;
        super.dispose();
    }

    static void getDefaultAnnotationProperties(Properties properties) {
        PAnnotationUtilities.setColorProperty("Highlight.fillColor", properties, defaultFillColor);
    }

    static void setDefaultAnnotationProperties(Properties properties) {
        defaultFillColor = PAnnotationUtilities.getColorProperty("Highlight.fillColor", properties, DEFAULT_HIGH_FILL_COLOR);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
    }

    static {
        defaultFillColor = DEFAULT_HIGH_FILL_COLOR = Color.yellow;
        defaultVWD = false;
    }
}

