/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer.annotation;

import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import com.ibm.mm.viewer.annotation.CMBPropertiesPanel;
import com.ibm.mm.viewer.annotation.PAnnotationUtilities;
import com.ibm.mm.viewer.annotation.PMFCRect;
import com.ibm.mm.viewer.annotation.PNumericField;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CMBArrowAnnotation
extends CMBPageAnnotation {
    private static final String copyright = "Licensed Materials - Property of IBM\nIBM DB2 Content Manager Enterprise Edition V8 (program number 5724-B19)\n(c ) Copyright IBM Corp.  1998, 2004.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private CMBPropertiesPanel annotationPropertiesPanel = null;
    private Hashtable compTable = new Hashtable();
    private static boolean isDefaultSet = false;
    private static final int DEFAULT_ARROW_WING_LENGTH = 20;
    private static final int DEFAULT_ARROW_WING_ANGLE = 20;
    private static Color defaultArrowColor = DEFAULT_BORDER_COLOR;
    private static int defaultWingLength = 20;
    private static int defaultWingAngle = 20;
    private static Color defaultFillColor = DEFAULT_FILL_COLOR;
    private static int defaultArrowWidth = 5;
    private static boolean defaultVWD = false;
    private static boolean defaultTransparent = true;
    static final long serialVersionUID = 1L;
    private transient Vector propList = null;
    private transient Point rPtWing1 = new Point();
    private transient Point rPtWing2 = new Point();
    private transient Point rPtEnd = new Point();
    private transient Point rPtBeg = new Point();
    private int wingLength = 20;
    private int angle = 20;

    public CMBArrowAnnotation() {
        this.init();
    }

    public CMBArrowAnnotation(Rectangle r) {
        super(r);
        this.init();
    }

    public CMBArrowAnnotation(Rectangle r, int pageNumber) {
        super(r, pageNumber);
        this.init();
    }

    public void init() {
        this.type = 1;
        this.setBorderColor(defaultArrowColor);
        this.setBorderWidth(defaultArrowWidth);
        this.setTransparent(defaultTransparent);
        this.setVisibleWhileDragging(defaultVWD);
        this.wingLength = defaultWingLength;
        this.angle = defaultWingAngle;
        if (isDefaultSet) {
            this.updateValues(104);
        } else {
            this.updateValues(103);
        }
        this.calculateArrowPoints();
    }

    public Rectangle getRefreshRect() {
        PMFCRect r = new PMFCRect();
        r.left = Math.min(this.rPtBeg.x, this.rPtEnd.x);
        r.left = Math.min(r.left, this.rPtWing1.x);
        r.left = Math.min(r.left, this.rPtWing2.x);
        r.top = Math.min(this.rPtBeg.y, this.rPtEnd.y);
        r.top = Math.min(r.top, this.rPtWing1.y);
        r.top = Math.min(r.top, this.rPtWing2.y);
        r.right = Math.max(this.rPtBeg.x, this.rPtEnd.x);
        r.right = Math.max(r.right, this.rPtWing1.x);
        r.right = Math.max(r.right, this.rPtWing2.x);
        r.bottom = Math.max(this.rPtBeg.y, this.rPtEnd.y);
        r.bottom = Math.max(r.bottom, this.rPtWing1.y);
        r.bottom = Math.max(r.bottom, this.rPtWing2.y);
        Rectangle refRect = r.toJavaRect();
        int xdifference = (int)Math.max((double)this.getBorderWidth() / 1.3, (double)this.getUnscaledValue(this.getDefaultHandleWidth()));
        int ydifference = (int)Math.max((double)this.getBorderWidth() / 1.3, (double)this.getUnscaledValue(this.getDefaultHandleHeight()));
        refRect.grow(xdifference, ydifference);
        Rectangle scaledRefRect = this.scaleRectangle(refRect);
        scaledRefRect.grow(1, 1);
        return scaledRefRect;
    }

    public void setWingLength(int length) {
        if (!this.canUpdate()) {
            return;
        }
        if (length < 1 || length > 100) {
            return;
        }
        this.firePropertiesWillChangeEvent();
        this.wingLength = length;
        this.firePropertiesChangeEvent();
    }

    public int getWingLength() {
        return this.wingLength;
    }

    public void setWingAngle(int wangle) {
        if (!this.canUpdate()) {
            return;
        }
        if (wangle < 0 || wangle > 360) {
            return;
        }
        this.firePropertiesWillChangeEvent();
        this.angle = wangle;
        this.firePropertiesChangeEvent();
    }

    public int getWingAngle() {
        return this.angle;
    }

    public Point getBeginPoint() {
        return this.rPtBeg;
    }

    public void setBeginPoint(Point begin) {
        if (!this.canUpdate()) {
            return;
        }
        this.firePropertiesWillChangeEvent();
        this.rPtBeg = begin;
        this.firePropertiesChangeEvent();
    }

    public Point getEndPoint() {
        return this.rPtEnd;
    }

    public void setEndPoint(Point end) {
        if (!this.canUpdate()) {
            return;
        }
        this.firePropertiesWillChangeEvent();
        this.rPtEnd = end;
        this.firePropertiesChangeEvent();
    }

    public Point[] getWingPoints() {
        return new Point[]{this.rPtWing1, this.rPtWing2};
    }

    public void setWingPoints(Point[] points) {
        if (points == null) {
            return;
        }
        if (!this.canUpdate()) {
            return;
        }
        this.firePropertiesWillChangeEvent();
        this.rPtWing1 = points[0];
        this.rPtWing2 = points[1];
        this.firePropertiesChangeEvent();
    }

    public void draw(Graphics2D g2) {
        if (!this.allowedToDraw) {
            return;
        }
        if (this.isInMotion && !this.isVisibleWhileDragging) {
            this.drawOutline(g2);
            return;
        }
        this.calculateArrowPoints();
        Color oldColor = g2.getColor();
        g2.setColor(this.getBorderColor());
        Stroke oldStroke = g2.getStroke();
        Object oldAliasing = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Stroke usual_stroke = this.getBorderStroke();
        BasicStroke rounded = new BasicStroke(((BasicStroke)usual_stroke).getLineWidth(), 1, 1);
        g2.setStroke(rounded);
        g2.drawLine(this.rPtBeg.x, this.rPtBeg.y, this.rPtEnd.x, this.rPtEnd.y);
        g2.drawLine(this.rPtWing1.x, this.rPtWing1.y, this.rPtEnd.x, this.rPtEnd.y);
        g2.drawLine(this.rPtEnd.x, this.rPtEnd.y, this.rPtWing2.x, this.rPtWing2.y);
        g2.setStroke(oldStroke);
        g2.setColor(oldColor);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAliasing);
        super.draw(g2);
    }

    public void drawOutline(Graphics2D g2) {
        if (!this.allowedToDraw) {
            return;
        }
        this.calculateArrowPoints();
        Color oldColor = g2.getColor();
        g2.setColor(Color.black);
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(this.getOutlineStroke());
        g2.drawLine(this.rPtBeg.x, this.rPtBeg.y, this.rPtEnd.x, this.rPtEnd.y);
        g2.drawLine(this.rPtWing1.x, this.rPtWing1.y, this.rPtEnd.x, this.rPtEnd.y);
        g2.drawLine(this.rPtEnd.x, this.rPtEnd.y, this.rPtWing2.x, this.rPtWing2.y);
        g2.setStroke(oldStroke);
        g2.setColor(oldColor);
        super.drawOutline(g2);
    }

    private void calculateArrowPoints() {
        double rad = 57.3;
        Rectangle drawRect = this.getAnnoDrawRect();
        int rotation = this.getRotation();
        if (!this.invertedVert && !this.invertedHorz) {
            if (this.getRotateWithImage()) {
                switch (rotation) {
                    case 0: {
                        this.rPtBeg.x = drawRect.x;
                        this.rPtBeg.y = drawRect.y;
                        this.rPtEnd.x = drawRect.x + drawRect.width;
                        this.rPtEnd.y = drawRect.y + drawRect.height;
                        break;
                    }
                    case 1: {
                        this.rPtBeg.x = drawRect.x + drawRect.width;
                        this.rPtBeg.y = drawRect.y;
                        this.rPtEnd.x = drawRect.x;
                        this.rPtEnd.y = drawRect.y + drawRect.height;
                        break;
                    }
                    case 2: {
                        this.rPtBeg.x = drawRect.x + drawRect.width;
                        this.rPtBeg.y = drawRect.y + drawRect.height;
                        this.rPtEnd.x = drawRect.x;
                        this.rPtEnd.y = drawRect.y;
                        break;
                    }
                    case 3: {
                        this.rPtBeg.x = drawRect.x;
                        this.rPtBeg.y = drawRect.y + drawRect.height;
                        this.rPtEnd.x = drawRect.x + drawRect.width;
                        this.rPtEnd.y = drawRect.y;
                    }
                }
            } else {
                this.rPtBeg.x = drawRect.x;
                this.rPtBeg.y = drawRect.y;
                this.rPtEnd.x = drawRect.x + drawRect.width;
                this.rPtEnd.y = drawRect.y + drawRect.height;
            }
        }
        if (this.invertedVert) {
            if (this.getRotateWithImage()) {
                switch (rotation) {
                    case 0: {
                        this.rPtBeg.x = drawRect.x;
                        this.rPtBeg.y = drawRect.y + drawRect.height;
                        this.rPtEnd.x = drawRect.x + drawRect.width;
                        this.rPtEnd.y = drawRect.y;
                        break;
                    }
                    case 1: {
                        this.rPtBeg.x = drawRect.x;
                        this.rPtBeg.y = drawRect.y;
                        this.rPtEnd.x = drawRect.x + drawRect.width;
                        this.rPtEnd.y = drawRect.y + drawRect.height;
                        break;
                    }
                    case 2: {
                        this.rPtBeg.x = drawRect.x + drawRect.width;
                        this.rPtBeg.y = drawRect.y;
                        this.rPtEnd.x = drawRect.x;
                        this.rPtEnd.y = drawRect.y + drawRect.height;
                        break;
                    }
                    case 3: {
                        this.rPtBeg.x = drawRect.x + drawRect.width;
                        this.rPtBeg.y = drawRect.y + drawRect.height;
                        this.rPtEnd.x = drawRect.x;
                        this.rPtEnd.y = drawRect.y;
                    }
                }
            } else {
                this.rPtBeg.x = drawRect.x;
                this.rPtBeg.y = drawRect.y + drawRect.height;
                this.rPtEnd.x = drawRect.x + drawRect.width;
                this.rPtEnd.y = drawRect.y;
            }
        }
        if (this.invertedHorz) {
            if (this.getRotateWithImage()) {
                switch (rotation) {
                    case 0: {
                        this.rPtBeg.x = drawRect.x + drawRect.width;
                        this.rPtBeg.y = drawRect.y;
                        this.rPtEnd.x = drawRect.x;
                        this.rPtEnd.y = drawRect.y + drawRect.height;
                        break;
                    }
                    case 1: {
                        this.rPtBeg.x = drawRect.x + drawRect.width;
                        this.rPtBeg.y = drawRect.y + drawRect.height;
                        this.rPtEnd.x = drawRect.x;
                        this.rPtEnd.y = drawRect.y;
                        break;
                    }
                    case 2: {
                        this.rPtBeg.x = drawRect.x;
                        this.rPtBeg.y = drawRect.y + drawRect.height;
                        this.rPtEnd.x = drawRect.x + drawRect.width;
                        this.rPtEnd.y = drawRect.y;
                        break;
                    }
                    case 3: {
                        this.rPtBeg.x = drawRect.x;
                        this.rPtBeg.y = drawRect.y;
                        this.rPtEnd.x = drawRect.x + drawRect.width;
                        this.rPtEnd.y = drawRect.y + drawRect.height;
                    }
                }
            } else {
                this.rPtBeg.x = drawRect.x + drawRect.width;
                this.rPtBeg.y = drawRect.y;
                this.rPtEnd.x = drawRect.x;
                this.rPtEnd.y = drawRect.y + drawRect.height;
            }
        }
        if (this.invertedHorz && this.invertedVert) {
            if (this.getRotateWithImage()) {
                switch (rotation) {
                    case 0: {
                        this.rPtBeg.x = drawRect.x + drawRect.width;
                        this.rPtBeg.y = drawRect.y + drawRect.height;
                        this.rPtEnd.x = drawRect.x;
                        this.rPtEnd.y = drawRect.y;
                        break;
                    }
                    case 1: {
                        this.rPtBeg.x = drawRect.x;
                        this.rPtBeg.y = drawRect.y + drawRect.height;
                        this.rPtEnd.x = drawRect.x + drawRect.width;
                        this.rPtEnd.y = drawRect.y;
                        break;
                    }
                    case 2: {
                        this.rPtBeg.x = drawRect.x;
                        this.rPtBeg.y = drawRect.y;
                        this.rPtEnd.x = drawRect.x + drawRect.width;
                        this.rPtEnd.y = drawRect.y + drawRect.height;
                        break;
                    }
                    case 3: {
                        this.rPtBeg.x = drawRect.x + drawRect.width;
                        this.rPtBeg.y = drawRect.y;
                        this.rPtEnd.x = drawRect.x;
                        this.rPtEnd.y = drawRect.y + drawRect.height;
                    }
                }
            } else {
                this.rPtBeg.x = drawRect.x + drawRect.width;
                this.rPtBeg.y = drawRect.y + drawRect.height;
                this.rPtEnd.x = drawRect.x;
                this.rPtEnd.y = drawRect.y;
            }
        }
        double dTheta1 = Math.abs(this.rPtEnd.x - this.rPtBeg.x);
        double dTheta2 = Math.abs(this.rPtEnd.y - this.rPtBeg.y);
        int iWing = (int)(Math.sqrt(dTheta1 * dTheta1 + dTheta2 * dTheta2) * (double)this.wingLength / 100.0);
        double dSlope = Math.atan2(Math.abs(this.rPtEnd.y - this.rPtBeg.y), Math.abs(this.rPtEnd.x - this.rPtBeg.x));
        int iSlope = (int)(dSlope * rad);
        int iTheta1 = iSlope - this.angle;
        dTheta1 = (double)iTheta1 / rad;
        dSlope = Math.atan2(Math.abs(this.rPtEnd.x - this.rPtBeg.x), Math.abs(this.rPtEnd.y - this.rPtBeg.y));
        iSlope = (int)(dSlope * rad);
        int iTheta2 = iSlope - this.angle;
        dTheta2 = (double)iTheta2 / rad;
        this.rPtWing1.x = (int)((double)iWing * Math.cos(dTheta1));
        this.rPtWing1.y = (int)((double)iWing * Math.sin(dTheta1));
        this.rPtWing2.x = (int)((double)iWing * Math.sin(dTheta2));
        this.rPtWing2.y = (int)((double)iWing * Math.cos(dTheta2));
        if (this.rPtEnd.x > this.rPtBeg.x) {
            this.rPtWing1.x = this.rPtEnd.x - this.rPtWing1.x;
            this.rPtWing2.x = this.rPtEnd.x - this.rPtWing2.x;
        } else {
            this.rPtWing1.x = this.rPtEnd.x + this.rPtWing1.x;
            this.rPtWing2.x = this.rPtEnd.x + this.rPtWing2.x;
        }
        if (this.rPtEnd.y > this.rPtBeg.y) {
            this.rPtWing1.y = this.rPtEnd.y - this.rPtWing1.y;
            this.rPtWing2.y = this.rPtEnd.y - this.rPtWing2.y;
        } else {
            this.rPtWing1.y = this.rPtEnd.y + this.rPtWing1.y;
            this.rPtWing2.y = this.rPtEnd.y + this.rPtWing2.y;
        }
    }

    public CMBPropertiesPanel getAnnotationPropertiesPanel() {
        if (this.annotationPropertiesPanel == null) {
            if (this.propList == null) {
                this.propList = new Vector();
            }
            this.propList.addElement("Annotation.arrowColor");
            this.propList.addElement(Color.white);
            this.propList.addElement("Annotation.lineWidth");
            this.propList.addElement(new Integer[]{new Integer(1), new Integer(100)});
            this.propList.addElement("Annotation.wingLength");
            this.propList.addElement(new Integer[]{new Integer(1), new Integer(100)});
            this.propList.addElement("Annotation.wingAngle");
            this.propList.addElement(new Integer[]{new Integer(0), new Integer(360)});
            this.propList.addElement("Annotation.transparent");
            this.propList.addElement(new Boolean(true));
            this.annotationPropertiesPanel = new CMBPropertiesPanel(this, this.propList);
        }
        return this.annotationPropertiesPanel;
    }

    public JPanel getPropertiesPanel() {
        this.getAnnotationPropertiesPanel().setAnnotation(this);
        return this.annotationPropertiesPanel.getPanel();
    }

    public void handlePropertyChange(String propName, JComponent comp, int action) {
        if (action == 106) {
            isDefaultSet = true;
        }
        if (propName.equals("Annotation.arrowColor")) {
            switch (action) {
                case 101: {
                    this.setBorderColor(comp.getBackground());
                    break;
                }
                case 102: {
                    comp.setBackground(this.getBorderColor());
                    break;
                }
                case 103: {
                    defaultArrowColor = this.getBorderColor();
                    break;
                }
                case 104: {
                    this.setBorderColor(defaultArrowColor);
                    break;
                }
                case 105: {
                    comp.setBackground(defaultArrowColor);
                    break;
                }
                case 106: {
                    defaultArrowColor = comp.getBackground();
                }
            }
        } else if (propName.equals("Annotation.lineWidth")) {
            switch (action) {
                case 101: {
                    this.setBorderWidth(((PNumericField)comp).getValue());
                    break;
                }
                case 102: {
                    ((PNumericField)comp).setValue(this.getBorderWidth());
                    break;
                }
                case 103: {
                    defaultArrowWidth = this.getBorderWidth();
                    break;
                }
                case 104: {
                    this.setBorderWidth(defaultArrowWidth);
                    break;
                }
                case 105: {
                    ((PNumericField)comp).setValue(defaultArrowWidth);
                    break;
                }
                case 106: {
                    defaultArrowWidth = ((PNumericField)comp).getValue();
                }
            }
        } else if (propName.equals("Annotation.visibleWhileDragging")) {
            switch (action) {
                case 101: {
                    this.setVisibleWhileDragging(((JCheckBox)comp).isSelected());
                    break;
                }
                case 102: {
                    ((JCheckBox)comp).setSelected(this.getVisibleWhileDragging());
                    break;
                }
                case 103: {
                    defaultVWD = this.getVisibleWhileDragging();
                    break;
                }
                case 104: {
                    this.setVisibleWhileDragging(defaultVWD);
                    break;
                }
                case 105: {
                    ((JCheckBox)comp).setSelected(defaultVWD);
                    break;
                }
                case 106: {
                    defaultVWD = ((JCheckBox)comp).isSelected();
                }
            }
        } else if (propName.equals("Annotation.transparent")) {
            switch (action) {
                case 101: {
                    this.setTransparent(((JCheckBox)comp).isSelected());
                    break;
                }
                case 102: {
                    ((JCheckBox)comp).setSelected(this.getTransparent());
                    break;
                }
                case 103: {
                    defaultTransparent = this.getTransparent();
                    break;
                }
                case 104: {
                    this.setTransparent(defaultTransparent);
                    break;
                }
                case 105: {
                    ((JCheckBox)comp).setSelected(defaultTransparent);
                    break;
                }
                case 106: {
                    defaultTransparent = ((JCheckBox)comp).isSelected();
                }
            }
        } else if (propName.equals("Annotation.wingLength")) {
            switch (action) {
                case 101: {
                    this.setWingLength(((PNumericField)comp).getValue());
                    break;
                }
                case 102: {
                    ((PNumericField)comp).setValue(this.getWingLength());
                    break;
                }
                case 103: {
                    defaultWingLength = this.getWingLength();
                    break;
                }
                case 104: {
                    this.setWingLength(defaultWingLength);
                    break;
                }
                case 105: {
                    ((PNumericField)comp).setValue(defaultWingLength);
                    break;
                }
                case 106: {
                    defaultWingLength = ((PNumericField)comp).getValue();
                }
            }
        } else if (propName.equals("Annotation.wingAngle")) {
            switch (action) {
                case 101: {
                    this.setWingAngle(((PNumericField)comp).getValue());
                    break;
                }
                case 102: {
                    ((PNumericField)comp).setValue(this.getWingAngle());
                    break;
                }
                case 103: {
                    defaultWingAngle = this.getWingAngle();
                    break;
                }
                case 104: {
                    this.setWingAngle(defaultWingAngle);
                    break;
                }
                case 105: {
                    ((PNumericField)comp).setValue(defaultWingAngle);
                    break;
                }
                case 106: {
                    defaultWingAngle = ((PNumericField)comp).getValue();
                }
            }
        }
    }

    public void updateValues(int action) {
        if (this.compTable.isEmpty()) {
            return;
        }
        Enumeration props = this.compTable.keys();
        while (props.hasMoreElements()) {
            String propName = (String)props.nextElement();
            JComponent comp = (JComponent)this.compTable.get(propName);
            this.handlePropertyChange(propName, comp, action);
        }
        super.updateValues(action);
    }

    public void updatePropertiesFrom(CMBPageAnnotation newValues) {
        if (newValues instanceof CMBArrowAnnotation) {
            this.setWingLength(((CMBArrowAnnotation)newValues).getWingLength());
            this.setWingAngle(((CMBArrowAnnotation)newValues).getWingAngle());
        }
        super.updatePropertiesFrom(newValues);
    }

    public void addPropertyComponent(String propertyName, JComponent component) {
        this.compTable.put(propertyName, component);
    }

    public void dispose() {
        Object rPtWing1 = null;
        Object rPtWing2 = null;
        Object rPtEnd = null;
        Object rPtBeg = null;
        this.annotationPropertiesPanel = null;
        super.dispose();
    }

    public Object clone() {
        CMBArrowAnnotation a = (CMBArrowAnnotation)super.clone();
        a.annotationPropertiesPanel = null;
        a.propList = new Vector();
        a.compTable = new Hashtable();
        a.rPtBeg = (Point)this.rPtBeg.clone();
        a.rPtEnd = (Point)this.rPtEnd.clone();
        a.rPtWing1 = (Point)this.rPtWing1.clone();
        a.rPtWing2 = (Point)this.rPtWing2.clone();
        return a;
    }

    public String toString() {
        return new String("[Annotation:" + this.getName() + ", Arrow Wing Length:" + this.getWingLength() + ", Arrow Wing Angle:" + this.getWingAngle() + super.toString() + " ]");
    }

    static void getDefaultAnnotationProperties(Properties properties) {
        PAnnotationUtilities.setColorProperty("Arrow.color", properties, defaultArrowColor);
        PAnnotationUtilities.setIntegerProperty("Arrow.width", properties, defaultArrowWidth);
        PAnnotationUtilities.setColorProperty("Arrow.fillColor", properties, defaultFillColor);
        PAnnotationUtilities.setBooleanProperty("Arrow.transparent", properties, defaultTransparent);
        PAnnotationUtilities.setIntegerProperty("Arrow.wingAngle", properties, defaultWingAngle);
        PAnnotationUtilities.setIntegerProperty("Arrow.wingLength", properties, defaultWingLength);
    }

    static void setDefaultAnnotationProperties(Properties properties) {
        defaultArrowColor = PAnnotationUtilities.getColorProperty("Arrow.color", properties, DEFAULT_BORDER_COLOR);
        defaultArrowWidth = PAnnotationUtilities.getIntegerProperty("Arrow.width", properties, 5, 1, 100);
        defaultTransparent = PAnnotationUtilities.getBooleanProperty("Arrow.transparent", properties, true);
        defaultWingAngle = PAnnotationUtilities.getIntegerProperty("Arrow.wingAngle", properties, 20, 0, 360);
        defaultWingLength = PAnnotationUtilities.getIntegerProperty("Arrow.wingLength", properties, 20, 1, 100);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.wingLength = stream.readInt();
        this.angle = stream.readInt();
        this.rPtWing1 = new Point();
        this.rPtWing2 = new Point();
        this.rPtBeg = new Point();
        this.rPtEnd = new Point();
        this.calculateArrowPoints();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(this.wingLength);
        stream.writeInt(this.angle);
    }
}

