/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer.annotation;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.annotation.CMBAnnotationCreatedEvent;
import com.ibm.mm.viewer.annotation.CMBAnnotationCreatedListener;
import com.ibm.mm.viewer.annotation.CMBAnnotationDeletedEvent;
import com.ibm.mm.viewer.annotation.CMBAnnotationDeletedListener;
import com.ibm.mm.viewer.annotation.CMBAnnotationEngineException;
import com.ibm.mm.viewer.annotation.CMBAnnotationPropertiesListener;
import com.ibm.mm.viewer.annotation.CMBAnnotationReorderedEvent;
import com.ibm.mm.viewer.annotation.CMBAnnotationReorderedListener;
import com.ibm.mm.viewer.annotation.CMBAnnotationSelectedEvent;
import com.ibm.mm.viewer.annotation.CMBAnnotationSelectedListener;
import com.ibm.mm.viewer.annotation.CMBAnnotationServices;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import com.ibm.mm.viewer.annotation.CMBArrowAnnotation;
import com.ibm.mm.viewer.annotation.CMBCircleAnnotation;
import com.ibm.mm.viewer.annotation.CMBHighlightAnnotation;
import com.ibm.mm.viewer.annotation.CMBLineAnnotation;
import com.ibm.mm.viewer.annotation.CMBNoteAnnotation;
import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import com.ibm.mm.viewer.annotation.CMBPenAnnotation;
import com.ibm.mm.viewer.annotation.CMBPenStroke;
import com.ibm.mm.viewer.annotation.CMBRectAnnotation;
import com.ibm.mm.viewer.annotation.CMBSelectedAnnotationToolChangedEvent;
import com.ibm.mm.viewer.annotation.CMBSelectedAnnotationToolChangedListener;
import com.ibm.mm.viewer.annotation.CMBStampAnnotation;
import com.ibm.mm.viewer.annotation.CMBTextAnnotation;
import com.ibm.mm.viewer.annotation.PAnnotationUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CMBAnnotationView
implements CMBAnnotationPropertiesListener,
CMBAnnotationCreatedListener,
CMBAnnotationReorderedListener,
CMBAnnotationDeletedListener,
CMBAnnotationSelectedListener,
CMBSelectedAnnotationToolChangedListener {
    private static final String copyright = "Licensed Materials - Property of IBM\nIBM DB2 Content Manager Enterprise Edition V8 (program number 5724-B19)\n(c ) Copyright IBM Corp.  1998, 2004.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private JComponent owner;
    private CMBAnnotationSet model;
    private CMBAnnotationServices services;
    private Vector penStrokes = null;
    private boolean isPenBeingDrawn = false;
    private Color penColor;
    private Stroke penStroke;
    private int penPageNumber = -1;
    private int currentPage = -1;
    private Point oldPoint;
    private Point originalPoint;
    private Point originalAnnotationLocation;
    private Cursor oldCursor = Cursor.getDefaultCursor();
    private Rectangle dragRect;
    private Vector tempStrokes;
    private boolean createState = false;
    private JTextArea noteArea = null;
    private JScrollPane noteScroll = null;
    private boolean directEditing = false;
    private boolean creatingNoteAnnotation = false;
    KeyBinding[] commonCreateBindings = null;
    KeyBinding[] commonEditBindings = null;
    private Action annoPopupAction = null;
    private KeyStroke commonPopupKey = KeyStroke.getKeyStroke(121, 1, false);
    private JTextField textField;
    private final AnnotationViewMouseHandler mouseHandler = new AnnotationViewMouseHandler();
    private final AnnotationViewFocusHandler focusHandler = new AnnotationViewFocusHandler();
    double scale = 1.0;
    private boolean infocuslost = false;

    public CMBAnnotationView(CMBAnnotationSet model) {
        this();
        this.model = model;
        this.services = model.getAnnotationServices();
        model.addAnnSelectedListener(this);
        model.getAnnotationServices().addAnnotationToolListener(this);
        model.addView(this);
        this.scale = (double)model.getScale() / 1000.0;
    }

    public CMBAnnotationView() {
        this.tempStrokes = new Vector();
    }

    public void setModel(CMBAnnotationSet model) {
        if (this.services.getSelectedAnnotationTool() == 6) {
            this.createPenAnnotation();
        }
        if (this.directEditing && this.textField != null && this.textField.isVisible()) {
            this.directEditing = false;
            this.textField.postActionEvent();
        }
        if (this.model != null) {
            if (this.scale > 0.0) {
                model.setScale((int)(this.scale * 1000.0));
            }
            this.model.removeAnnSelectedListener(this);
            model.removeView(this);
        }
        this.model = model;
        this.services = model.getAnnotationServices();
        model.addAnnSelectedListener(this);
        model.addView(this);
        this.scale = (double)model.getScale() / 1000.0;
        this.resetSelectedAnnotation();
        if (model.isEditable()) {
            this.setActionsEnabled(true);
        } else {
            this.setActionsEnabled(false);
        }
    }

    public CMBAnnotationSet getModel() {
        return this.model;
    }

    public void setViewComponent(JComponent component) {
        if (this.owner != null) {
            this.owner.removeMouseListener(this.mouseHandler);
            this.owner.removeMouseMotionListener(this.mouseHandler);
            this.owner.removeFocusListener(this.focusHandler);
        }
        this.owner = component;
        if (this.owner != null) {
            this.owner.addMouseListener(this.mouseHandler);
            this.owner.addMouseMotionListener(this.mouseHandler);
            this.owner.addFocusListener(this.focusHandler);
            this.registerKeyActions();
        }
    }

    public JComponent getViewComponent() {
        return this.owner;
    }

    public void paintAll(Graphics2D g2, boolean scale) {
        Iterator i = this.model.getReverseIterator(-1);
        AffineTransform oldTransform = g2.getTransform();
        if (scale) {
            this.scaleGraphics(g2);
        }
        while (i.hasNext()) {
            CMBPageAnnotation a = (CMBPageAnnotation)i.next();
            if (this.currentPage != -1 && this.currentPage != a.getPageNumber()) continue;
            a.draw(g2);
        }
        this.drawPenStrokes(g2);
        g2.setTransform(oldTransform);
    }

    public void paintAnnotations(Graphics2D g2, int pageNum, boolean scale) {
        Iterator i = this.model.getReverseIterator(pageNum);
        AffineTransform oldTransform = g2.getTransform();
        if (scale) {
            if (this.scale == 0.0) {
                return;
            }
            this.scaleGraphics(g2);
        }
        while (i.hasNext()) {
            CMBPageAnnotation a = (CMBPageAnnotation)i.next();
            a.draw(g2);
        }
        if (this.penPageNumber == pageNum) {
            this.drawPenStrokes(g2);
        }
        g2.setTransform(oldTransform);
    }

    public void paintThoseInRect(Rectangle r, int pageNumber) {
        if (this.owner == null) {
            return;
        }
        Iterator i = this.model.getReverseIterator(pageNumber);
        Graphics2D g2 = (Graphics2D)this.owner.getGraphics();
        AffineTransform oldTransform = g2.getTransform();
        this.scaleGraphics(g2);
        while (i.hasNext()) {
            Rectangle bnds;
            CMBPageAnnotation a = (CMBPageAnnotation)i.next();
            if (this.currentPage != -1 && this.currentPage != a.getPageNumber() || !(bnds = a.getRefreshRect()).intersects(r)) continue;
            a.draw(g2);
        }
        if ((this.currentPage == -1 || this.currentPage == this.penPageNumber) && this.penPageNumber == pageNumber) {
            this.drawPenStrokes(g2);
        }
        g2.setTransform(oldTransform);
        g2.dispose();
    }

    public void drawAllAnnotations() {
        if (this.owner == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)this.owner.getGraphics();
        this.drawAllAnnotations(g2);
        g2.dispose();
    }

    public void drawAllAnnotations(Graphics2D g2) {
        Iterator i = this.model.getReverseIterator(-1);
        AffineTransform oldTransform = g2.getTransform();
        this.scaleGraphics(g2);
        while (i.hasNext()) {
            CMBPageAnnotation a = (CMBPageAnnotation)i.next();
            if (this.currentPage != -1 && this.currentPage != a.getPageNumber()) continue;
            a.draw(g2);
        }
        if (this.currentPage == -1 || this.currentPage == this.penPageNumber) {
            this.drawPenStrokes(g2);
        }
        g2.setTransform(oldTransform);
    }

    public void drawAnnotation(CMBPageAnnotation a) {
        if (this.owner == null) {
            return;
        }
        if (this.currentPage == -1 || this.currentPage == a.getPageNumber()) {
            Graphics2D g2 = (Graphics2D)this.owner.getGraphics();
            AffineTransform oldTransform = g2.getTransform();
            this.scaleGraphics(g2);
            a.draw(g2);
            g2.setTransform(oldTransform);
            g2.dispose();
        }
    }

    void setPenStrokes(Vector strokes, boolean drawPen, Color color, Stroke stroke, int page) {
        this.isPenBeingDrawn = drawPen;
        this.penStrokes = strokes;
        this.penColor = color;
        this.penStroke = stroke;
        if (page != -1) {
            this.penPageNumber = page;
        }
    }

    int getPenPageNumber() {
        return this.penPageNumber;
    }

    void drawPenStrokes(Graphics2D g2) {
        if (this.isPenBeingDrawn && this.penStrokes != null) {
            Color oldColor = g2.getColor();
            Stroke oldStroke = g2.getStroke();
            g2.setColor(this.penColor);
            g2.setStroke(this.penStroke);
            int nStrokes = this.penStrokes.size();
            for (int i = 0; i < nStrokes; ++i) {
                CMBPenStroke s = (CMBPenStroke)this.penStrokes.elementAt(i);
                g2.drawLine(s.from.x, s.from.y, s.to.x, s.to.y);
            }
            g2.setColor(oldColor);
            g2.setStroke(oldStroke);
        }
    }

    void drawStroke(CMBPenStroke s, Color penColor, Stroke penStroke) {
        if (this.owner == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)this.owner.getGraphics();
        AffineTransform oldTransform = g2.getTransform();
        Object oldAliasing = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.scaleGraphics(g2);
        Color oldColor = g2.getColor();
        Stroke oldStroke = g2.getStroke();
        g2.setColor(penColor);
        g2.setStroke(penStroke);
        g2.drawLine(s.from.x, s.from.y, s.to.x, s.to.y);
        g2.setTransform(oldTransform);
        g2.setColor(oldColor);
        g2.setStroke(oldStroke);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAliasing);
        g2.dispose();
    }

    public void refreshRect(Rectangle r) {
        if (this.owner != null) {
            this.owner.repaint(r);
        }
    }

    public void refreshEntireDrawArea() {
        if (this.owner != null) {
            this.owner.repaint();
        }
    }

    public void refreshSlightlyBiggerRect(Rectangle r) {
        Rectangle bigger_r = new Rectangle(r);
        bigger_r.grow(2, 2);
        this.refreshRect(bigger_r);
    }

    public void eraseAnnotationFromScreen(CMBPageAnnotation a) {
        if (this.owner == null) {
            return;
        }
        if (this.currentPage == -1 || this.currentPage == a.getPageNumber()) {
            a.dontDraw();
            Rectangle annRect = new Rectangle(a.getRefreshRect());
            annRect.grow(2, 2);
            this.owner.paintImmediately(annRect);
            a.pleaseDraw();
        }
    }

    public void drawAnnotationInXOR(CMBPageAnnotation a) {
        if (this.owner == null) {
            return;
        }
        if (this.currentPage == -1 || this.currentPage == a.getPageNumber()) {
            Graphics2D g2 = (Graphics2D)this.owner.getGraphics();
            AffineTransform oldTransform = g2.getTransform();
            this.scaleGraphics(g2);
            g2.setXORMode(Color.white);
            a.draw(g2);
            g2.setPaintMode();
            g2.setTransform(oldTransform);
            g2.dispose();
        }
    }

    public void drawRectInXOR(Rectangle r) {
        if (this.owner == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)this.owner.getGraphics();
        AffineTransform oldTransform = g2.getTransform();
        this.scaleGraphics(g2);
        g2.setXORMode(Color.white);
        g2.draw(r);
        g2.setPaintMode();
        g2.setTransform(oldTransform);
        g2.dispose();
    }

    void drawRect(Rectangle r) {
        if (this.owner == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)this.owner.getGraphics();
        AffineTransform oldTransform = g2.getTransform();
        this.scaleGraphics(g2);
        g2.draw(r);
        g2.setTransform(oldTransform);
        g2.dispose();
    }

    public Frame getOwningFrame() {
        if (this.owner == null) {
            return null;
        }
        for (Container c = this.owner.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof Frame)) continue;
            return (Frame)c;
        }
        return null;
    }

    public void handleAnnPropWillChangeEvent(CMBPageAnnotation a) {
        this.refreshSlightlyBiggerRect(a.getRefreshRect());
    }

    public void handleAnnPropChangedEvent(CMBPageAnnotation a) {
        this.refreshSlightlyBiggerRect(a.getRefreshRect());
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        if (scale == 0.0) {
            throw new IllegalArgumentException(PAnnotationUtilities.getMessage("Annotation.invalidScale"));
        }
        this.scale = scale;
        this.model.setScale((int)(scale * 1000.0));
    }

    private void scaleGraphics(Graphics2D g2) {
        this.model.setScale((int)(this.scale * 1000.0));
        g2.scale(this.scale * this.model.getScaleFactor(), this.scale * this.model.getScaleFactor());
    }

    public void setCurrentPage(int page) {
        this.currentPage = page;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void annotationSelected(CMBAnnotationSelectedEvent evt) {
        CMBPageAnnotation[] previousSelection = evt.getPreviousSelection();
        for (int i = 0; i < previousSelection.length; ++i) {
            this.refreshSlightlyBiggerRect(previousSelection[i].getRefreshRect());
        }
        CMBPageAnnotation[] selectedAnnotations = evt.getSelectedAnnotations();
        for (int i = 0; i < selectedAnnotations.length; ++i) {
            this.refreshSlightlyBiggerRect(selectedAnnotations[i].getRefreshRect());
        }
        if (selectedAnnotations.length > 0 && this.owner != null) {
            this.owner.getInputMap(2).put(this.commonPopupKey, this.annoPopupAction.getValue("Name"));
            this.owner.getInputMap(0).put(this.commonPopupKey, this.annoPopupAction.getValue("Name"));
            this.owner.getInputMap(1).put(this.commonPopupKey, this.annoPopupAction.getValue("Name"));
            this.owner.getActionMap().put(this.annoPopupAction.getValue("Name"), this.annoPopupAction);
        }
    }

    private void resetSelectedAnnotation() {
        this.setSelectedAnnotation(null);
    }

    private void registerKeyActions() {
        AbstractAction deleteAction = new AbstractAction("deleteAction"){

            public void actionPerformed(ActionEvent e) {
                String methodName = "registerKeyActions:actionperformed";
                if (CMBAnnotationView.this.getSelectedAnnotation() != null) {
                    try {
                        CMBAnnotationView.this.model.removeAnnotation(CMBAnnotationView.this.getSelectedAnnotation());
                    }
                    catch (CMBAnnotationEngineException aee) {
                        ViewerLogger.logError((Object)this, methodName, aee);
                    }
                }
                CMBAnnotationView.this.setIdleMode();
            }
        };
        KeyStroke deleteKey = KeyStroke.getKeyStroke(127, 0, false);
        this.updateMaps(deleteAction, deleteKey);
        AbstractAction moveUpAction = new AbstractAction("moveUpAction"){

            public void actionPerformed(ActionEvent e) {
                String methodName = "moveUpAction:actionPerformed";
                if (CMBAnnotationView.this.getSelectedAnnotation() != null) {
                    try {
                        CMBAnnotationView.this.moveAnnotation(CMBAnnotationView.this.getSelectedAnnotation(), "up", 5);
                    }
                    catch (CMBAnnotationEngineException aee) {
                        ViewerLogger.logError((Object)this, methodName, aee);
                    }
                }
                CMBAnnotationView.this.setIdleMode();
            }
        };
        AbstractAction moveDownAction = new AbstractAction("moveDownAction"){

            public void actionPerformed(ActionEvent e) {
                String methodName = "moveDownAction:actionPerformed";
                if (CMBAnnotationView.this.getSelectedAnnotation() != null) {
                    try {
                        CMBAnnotationView.this.moveAnnotation(CMBAnnotationView.this.getSelectedAnnotation(), "down", 5);
                    }
                    catch (CMBAnnotationEngineException aee) {
                        ViewerLogger.logError((Object)this, methodName, aee);
                    }
                }
                CMBAnnotationView.this.setIdleMode();
            }
        };
        AbstractAction moveRightAction = new AbstractAction("moveRightAction"){

            public void actionPerformed(ActionEvent e) {
                String methodName = "moveRightAction:actionPerformed";
                if (CMBAnnotationView.this.getSelectedAnnotation() != null) {
                    try {
                        CMBAnnotationView.this.moveAnnotation(CMBAnnotationView.this.getSelectedAnnotation(), "right", 5);
                    }
                    catch (CMBAnnotationEngineException aee) {
                        ViewerLogger.logError((Object)this, methodName, aee);
                    }
                }
                CMBAnnotationView.this.setIdleMode();
            }
        };
        AbstractAction moveLeftAction = new AbstractAction("moveLeftAction"){

            public void actionPerformed(ActionEvent e) {
                String methodName = "moveLeftAction:actionPerformed";
                if (CMBAnnotationView.this.getSelectedAnnotation() != null) {
                    try {
                        CMBAnnotationView.this.moveAnnotation(CMBAnnotationView.this.getSelectedAnnotation(), "left", 5);
                    }
                    catch (CMBAnnotationEngineException aee) {
                        ViewerLogger.logError((Object)this, methodName, aee);
                    }
                }
                CMBAnnotationView.this.setIdleMode();
            }
        };
        AbstractAction resizeUpAction = new AbstractAction("resizeUpAction"){

            public void actionPerformed(ActionEvent e) {
                String methodName = "resizeUpAction:actionPerformed";
                if (CMBAnnotationView.this.getSelectedAnnotation() != null) {
                    try {
                        CMBAnnotationView.this.resizeAnnotation(CMBAnnotationView.this.getSelectedAnnotation(), "up", 5);
                    }
                    catch (CMBAnnotationEngineException aee) {
                        ViewerLogger.logError((Object)this, methodName, aee);
                    }
                }
                CMBAnnotationView.this.setIdleMode();
            }
        };
        AbstractAction resizeDownAction = new AbstractAction("resizeDownAction"){

            public void actionPerformed(ActionEvent e) {
                String methodName = "resizeDownAction:actionPerformed";
                if (CMBAnnotationView.this.getSelectedAnnotation() != null) {
                    try {
                        CMBAnnotationView.this.resizeAnnotation(CMBAnnotationView.this.getSelectedAnnotation(), "down", 5);
                    }
                    catch (CMBAnnotationEngineException aee) {
                        ViewerLogger.logError((Object)this, methodName, aee);
                    }
                }
                CMBAnnotationView.this.setIdleMode();
            }
        };
        AbstractAction resizeRightAction = new AbstractAction("resizeRightAction"){

            public void actionPerformed(ActionEvent e) {
                String methodName = "resizeRightAction:actionPerformed";
                if (CMBAnnotationView.this.getSelectedAnnotation() != null) {
                    try {
                        CMBAnnotationView.this.resizeAnnotation(CMBAnnotationView.this.getSelectedAnnotation(), "right", 5);
                    }
                    catch (CMBAnnotationEngineException aee) {
                        ViewerLogger.logError((Object)this, methodName, aee);
                    }
                }
                CMBAnnotationView.this.setIdleMode();
            }
        };
        AbstractAction resizeLeftAction = new AbstractAction("resizeLeftAction"){

            public void actionPerformed(ActionEvent e) {
                String methodName = "resizeLeftAction:actionPerformed";
                if (CMBAnnotationView.this.getSelectedAnnotation() != null) {
                    try {
                        CMBAnnotationView.this.resizeAnnotation(CMBAnnotationView.this.getSelectedAnnotation(), "left", 5);
                    }
                    catch (CMBAnnotationEngineException aee) {
                        ViewerLogger.logError((Object)this, methodName, aee);
                    }
                }
                CMBAnnotationView.this.setIdleMode();
            }
        };
        AbstractAction deselectAction = new AbstractAction("deselectAction"){

            public void actionPerformed(ActionEvent e) {
                if (CMBAnnotationView.this.getSelectedAnnotation() != null) {
                    CMBAnnotationView.this.setSelectedAnnotation(null);
                }
                CMBAnnotationView.this.setIdleMode();
            }
        };
        AbstractAction navigationAction = new AbstractAction("navigationAction"){

            public void actionPerformed(ActionEvent e) {
                if (CMBAnnotationView.this.model.getAnnotationCount() >= 1) {
                    int matchIndex = 0;
                    Vector<CMBPageAnnotation> allAnnotations = new Vector<CMBPageAnnotation>();
                    CMBPageAnnotation[] pageAnnotations = CMBAnnotationView.this.model.getPageAnnotations(CMBAnnotationView.this.currentPage);
                    if (pageAnnotations.length > 0) {
                        for (int i = 0; i < pageAnnotations.length; ++i) {
                            CMBPageAnnotation a = pageAnnotations[i];
                            allAnnotations.add(a);
                            if (a != CMBAnnotationView.this.getSelectedAnnotation()) continue;
                            matchIndex = i < pageAnnotations.length - 1 ? i + 1 : 0;
                        }
                        CMBPageAnnotation currAnnotation = pageAnnotations[matchIndex];
                        CMBAnnotationView.this.setSelectedAnnotation(currAnnotation);
                    }
                }
            }
        };
        this.annoPopupAction = new AbstractAction("popupAction"){

            public void actionPerformed(ActionEvent e) {
                if (CMBAnnotationView.this.getSelectedAnnotation() != null) {
                    CMBAnnotationView.this.invokePopupMenu();
                    CMBAnnotationView.this.setIdleMode();
                }
            }
        };
        AbstractAction editAction = new AbstractAction("editAction"){

            public void actionPerformed(ActionEvent e) {
                if (CMBAnnotationView.this.getSelectedAnnotation() != null) {
                    MouseEvent editEvent = new MouseEvent(CMBAnnotationView.this.owner, 500, 0L, 0, 0, 0, 2, false);
                    CMBAnnotationView.this.mouseHandler.mouseClicked(editEvent);
                    MouseEvent editReleaseEvent = new MouseEvent(CMBAnnotationView.this.owner, 502, 0L, 0, 0, 0, 1, false);
                    CMBAnnotationView.this.mouseHandler.mouseReleased(editReleaseEvent);
                }
                CMBAnnotationView.this.setIdleMode();
            }
        };
        KeyStroke editKey = KeyStroke.getKeyStroke(113, 0, false);
        this.updateMaps(editAction, editKey);
        AbstractAction createAnnotationAction = new AbstractAction("createAction"){

            public void actionPerformed(ActionEvent e) {
                if (!CMBAnnotationView.this.services.isSelectAreaMode() && CMBAnnotationView.this.services.getSelectedAnnotationTool() != 0) {
                    CMBAnnotationView.this.services.setMode(4);
                    Rectangle vRect = new Rectangle(0, 0, 0, 0);
                    if (CMBAnnotationView.this.owner != null) {
                        vRect = CMBAnnotationView.this.owner.getVisibleRect();
                    }
                    MouseEvent createEvent = new MouseEvent(CMBAnnotationView.this.owner, 501, 0L, 0, vRect.x + 25, vRect.y + 25, 1, false);
                    CMBAnnotationView.this.mouseHandler.mousePressed(createEvent);
                    MouseEvent createReleaseEvent = new MouseEvent(CMBAnnotationView.this.owner, 502, 0L, 0, vRect.x + 25, vRect.y + 25, 1, false);
                    CMBAnnotationView.this.mouseHandler.mouseReleased(createReleaseEvent);
                    CMBAnnotationView.this.setIdleMode();
                }
            }
        };
        KeyStroke createAnnotationKey = KeyStroke.getKeyStroke(113, 8, false);
        this.updateMaps(createAnnotationAction, createAnnotationKey);
        this.updateMaps(deselectAction, KeyStroke.getKeyStroke(68, 2, false));
        this.updateMaps(navigationAction, KeyStroke.getKeyStroke(113, 2, false));
        this.updateMaps(moveUpAction, KeyStroke.getKeyStroke(38, 8, false));
        this.updateMaps(moveDownAction, KeyStroke.getKeyStroke(40, 8, false));
        this.updateMaps(moveRightAction, KeyStroke.getKeyStroke(39, 8, false));
        this.updateMaps(moveLeftAction, KeyStroke.getKeyStroke(37, 8, false));
        this.updateMaps(resizeUpAction, KeyStroke.getKeyStroke(38, 1, false));
        this.updateMaps(resizeDownAction, KeyStroke.getKeyStroke(40, 1, false));
        this.updateMaps(resizeRightAction, KeyStroke.getKeyStroke(39, 1, false));
        this.updateMaps(resizeLeftAction, KeyStroke.getKeyStroke(37, 1, false));
        KeyBinding[] bindings = new KeyBinding[]{new KeyBinding(createAnnotationAction, createAnnotationKey)};
        this.commonCreateBindings = bindings;
        KeyBinding[] bindings2 = new KeyBinding[]{new KeyBinding(moveRightAction, KeyStroke.getKeyStroke(39, 8, false)), new KeyBinding(moveLeftAction, KeyStroke.getKeyStroke(37, 8, false)), new KeyBinding(moveUpAction, KeyStroke.getKeyStroke(38, 8, false)), new KeyBinding(moveDownAction, KeyStroke.getKeyStroke(40, 8, false)), new KeyBinding(resizeRightAction, KeyStroke.getKeyStroke(39, 1, false)), new KeyBinding(resizeLeftAction, KeyStroke.getKeyStroke(37, 1, false)), new KeyBinding(resizeUpAction, KeyStroke.getKeyStroke(38, 1, false)), new KeyBinding(resizeDownAction, KeyStroke.getKeyStroke(40, 1, false))};
        this.commonEditBindings = bindings2;
    }

    private void registerCommonKeyBindings(KeyBinding[] bindings) {
        if (this.owner == null) {
            return;
        }
        for (KeyBinding binding : bindings) {
            this.owner.getInputMap(1).put(binding.key, binding.action.getValue("Name"));
            this.owner.getInputMap(2).put(binding.key, binding.action.getValue("Name"));
            this.owner.getActionMap().put(binding.action.getValue("Name"), binding.action);
        }
    }

    private void updateMaps(Action action, KeyStroke ks) {
        if (this.owner != null) {
            this.owner.getInputMap(2).put(ks, action.getValue("Name"));
            this.owner.getInputMap(1).put(ks, action.getValue("Name"));
            this.owner.getActionMap().put(action.getValue("Name"), action);
        }
    }

    void setActionEnabled(String key, boolean enable) {
        if (this.owner == null) {
            return;
        }
        Action a = this.owner.getActionMap().get(key);
        if (a != null) {
            a.setEnabled(enable);
        }
    }

    void setActionsEnabled(boolean enable) {
        if (this.owner != null && this.owner.getActionMap() != null) {
            this.setActionEnabled("deleteAction", enable);
            this.setActionEnabled("editAction", enable);
            this.setActionEnabled("createAction", enable);
            this.setActionEnabled("moveUpAction", enable);
            this.setActionEnabled("moveDownAction", enable);
            this.setActionEnabled("moveLeftAction", enable);
            this.setActionEnabled("moveRightAction", enable);
            this.setActionEnabled("resizeUpAction", enable);
            this.setActionEnabled("resizeDownAction", enable);
            this.setActionEnabled("resizeLeftAction", enable);
            this.setActionEnabled("resizeRightAction", enable);
        }
    }

    private void createStampAnnotation(Point stampPoint, int page) {
        int scaledInitialWidth = this.scale(0);
        int scaledInitialHeight = this.scale(0);
        this.scalePoint(stampPoint);
        this.rotatePoint(stampPoint, scaledInitialWidth, scaledInitialHeight);
        Rectangle rect = new Rectangle(stampPoint.x, stampPoint.y, scaledInitialWidth, scaledInitialHeight);
        CMBStampAnnotation realStamp = (CMBStampAnnotation)this.services.getSelectedStamp().clone();
        realStamp.setPageNumber(page);
        realStamp.setApplyNow(false);
        realStamp.translateBy(rect.x, rect.y);
        this.createAnnotation(realStamp);
    }

    private void setIdleMode() {
        if (this.services.isAnnotationToolSticky() && this.services.getSelectedAnnotationTool() != 5 && this.services.getSelectedAnnotationTool() != 9 && this.services.getSelectedAnnotationTool() != 0 && this.services.getSelectedAnnotationTool() != 20) {
            this.createState = false;
            this.services.setMode(4);
        } else {
            this.services.setIdleDrawingMode();
            this.createState = false;
        }
    }

    private void moveAnnotation(CMBPageAnnotation anno, String direction, int distance) throws CMBAnnotationEngineException {
        String methodName = "moveAnnotation";
        if (anno == null || !anno.canUpdate() || !this.model.isEditable()) {
            return;
        }
        this.oldPoint = new Point(anno.getDrawRect().x, anno.getDrawRect().y);
        Point newPoint = new Point(this.oldPoint);
        this.scalePoint(newPoint);
        this.scalePoint(this.oldPoint);
        if (direction.equalsIgnoreCase("up")) {
            newPoint.y -= distance;
            ViewerLogger.logDebug(this, methodName, "Moving annotation up from " + this.oldPoint.y + " to " + newPoint.y);
        } else if (direction.equalsIgnoreCase("down")) {
            newPoint.y += distance;
            ViewerLogger.logDebug(this, methodName, "Moving annotation down from " + this.oldPoint.y + " to " + newPoint.y);
        } else if (direction.equalsIgnoreCase("left")) {
            newPoint.x -= distance;
            ViewerLogger.logDebug(this, methodName, "Moving annotation left from " + this.oldPoint.x + " to " + newPoint.x);
        } else if (direction.equalsIgnoreCase("right")) {
            newPoint.x += distance;
            ViewerLogger.logDebug(this, methodName, "Moving annotation right from " + this.oldPoint.x + " to " + newPoint.x);
        }
        ViewerLogger.logDebug(this, methodName, "Moving annotation from " + this.oldPoint.x + ", " + this.oldPoint.y + " to " + newPoint.x + ", " + newPoint.y);
        this.services.setMode(2);
        this.getSelectedAnnotation().setInMotion(true);
        Rectangle oldRefreshRect = this.getSelectedAnnotation().getRefreshRect();
        this.getSelectedAnnotation().translateBy(newPoint.x - this.oldPoint.x, newPoint.y - this.oldPoint.y);
        this.getSelectedAnnotation().setInMotion(false);
        this.model.fireCMBAnnMovedEvent(this, this.getSelectedAnnotation(), newPoint, this.oldPoint);
        if (this.owner != null) {
            this.owner.repaint(oldRefreshRect);
            this.owner.repaint(this.getSelectedAnnotation().getRefreshRect());
        }
        this.createState = false;
        this.setIdleMode();
        if (this.noteScroll != null && this.noteScroll.isVisible()) {
            this.positionNoteAnnotationEditor();
        }
    }

    private void resizeAnnotation(CMBPageAnnotation anno, String direction, int distance) throws CMBAnnotationEngineException {
        String methodName = "resizeAnnotation";
        if (anno == null || !anno.canUpdate() || !this.model.isEditable()) {
            return;
        }
        this.oldPoint = new Point(anno.getDrawRect().x, anno.getDrawRect().y);
        Point newPoint = new Point(this.oldPoint);
        this.scalePoint(newPoint);
        this.scalePoint(this.oldPoint);
        if (direction.equalsIgnoreCase("down")) {
            newPoint.y += distance;
            ViewerLogger.logDebug(this, methodName, "Growing annotation vertically from " + this.oldPoint.y + " to " + newPoint.y);
        } else if (direction.equalsIgnoreCase("up")) {
            newPoint.y -= distance;
            ViewerLogger.logDebug(this, methodName, "Shrinking annotation vertically from " + this.oldPoint.y + " to " + newPoint.y);
        } else if (direction.equalsIgnoreCase("right")) {
            newPoint.x += distance;
            ViewerLogger.logDebug(this, methodName, "Growing annotation horizontally from " + this.oldPoint.x + " to " + newPoint.x);
        } else if (direction.equalsIgnoreCase("left")) {
            newPoint.x -= distance;
            ViewerLogger.logDebug(this, methodName, "Shrinking annotation horizontally from " + this.oldPoint.x + " to " + newPoint.x);
        }
        ViewerLogger.logDebug(this, methodName, "Resizing annotation from " + this.oldPoint.x + ", " + this.oldPoint.y + " to " + newPoint.x + ", " + newPoint.y);
        this.services.setMode(1);
        this.getSelectedAnnotation().setInMotion(true);
        Rectangle oldRefreshRect = this.getSelectedAnnotation().getRefreshRect();
        this.getSelectedAnnotation().setCurrentHandleType(3);
        this.getSelectedAnnotation().growBy(newPoint.x - this.oldPoint.x, newPoint.y - this.oldPoint.y);
        this.getSelectedAnnotation().setInMotion(false);
        this.model.fireCMBAnnResizedEvent(this, this.getSelectedAnnotation(), newPoint, this.oldPoint);
        if (this.owner != null) {
            this.owner.repaint(oldRefreshRect);
            this.owner.repaint(this.getSelectedAnnotation().getRefreshRect());
        }
        this.createState = false;
        this.setIdleMode();
        if (this.noteScroll != null && this.noteScroll.isVisible()) {
            this.positionNoteAnnotationEditor();
        }
    }

    CMBPageAnnotation findAnnotationFromPoint(Point p) {
        Iterator i = this.model.getIterator(this.currentPage);
        while (i.hasNext()) {
            CMBPageAnnotation a = (CMBPageAnnotation)i.next();
            if (!a.isShowing() || !a.contains(p)) continue;
            return a;
        }
        return null;
    }

    private CMBPageAnnotation getSelectedAnnotation() {
        CMBPageAnnotation[] selectedAnnotations = this.model.getSelectedAnnotations();
        if (selectedAnnotations == null || selectedAnnotations.length == 0) {
            return null;
        }
        return selectedAnnotations[0];
    }

    private void clickedOnAnnotation(Point p) {
        this.setSelectedAnnotation(this.findAnnotationFromPoint(p));
        if (this.getSelectedAnnotation() == null) {
            return;
        }
        this.refreshSlightlyBiggerRect(this.getSelectedAnnotation().getRefreshRect());
        if (this.getSelectedAnnotation().pointInHandle(p)) {
            this.services.setMode(1);
        } else {
            this.services.setMode(2);
        }
        this.getSelectedAnnotation().setInMotion(true);
    }

    private void setSelectedAnnotation(CMBPageAnnotation sa) {
        if (sa == null) {
            this.model.setSelectedAnnotations(new CMBPageAnnotation[0]);
        } else {
            this.model.setSelectedAnnotations(new CMBPageAnnotation[]{sa});
        }
    }

    private void invokePopupMenu() {
        CMBPageAnnotation a = this.getSelectedAnnotation();
        if (a != null) {
            Rectangle refRect = a.getRefreshRect();
            if (this.services.getPopupMenu() != null) {
                this.services.getPopupMenu().show(this.owner, refRect.x + refRect.width / 2, refRect.y + refRect.height / 2);
            } else {
                this.services.changeAnnotationProperties(a);
            }
        }
    }

    Cursor createCustomCursor(String cursorStr, Point hotSpot) {
        String methodName = "createCustomCursor";
        Toolkit tk = Toolkit.getDefaultToolkit();
        try {
            MediaTracker tracker = new MediaTracker(new Frame());
            URL cursorUrl = this.getClass().getClassLoader().getResource(cursorStr);
            if (cursorUrl == null) {
                ViewerLogger.logError((Object)this, methodName, "Loading of cursor image for  " + cursorStr + "failed. Using default cursor.");
                return null;
            }
            Image cursor = tk.getImage(cursorUrl);
            tracker.addImage(cursor, 0);
            try {
                tracker.waitForID(0);
            }
            catch (InterruptedException ie) {
                ViewerLogger.logError((Object)this, methodName, ie);
            }
            catch (Exception ex) {
                ViewerLogger.logError(this, methodName, "Loading of cursor image for " + cursorStr + " failed. Using default cursor.", ex);
                return null;
            }
            Cursor cr = null;
            cr = tk.createCustomCursor(cursor, hotSpot, "custom cursor");
            return cr;
        }
        catch (Exception e) {
            ViewerLogger.logError(this, methodName, "Creating custom cursors failed. Using default cursors.", e);
            return null;
        }
    }

    private void scalePoint(Point p) {
        double scaler = 1.0 / (this.getScale() * this.model.getScaleFactor());
        p.x = (int)((double)p.x * scaler);
        p.y = (int)((double)p.y * scaler);
    }

    private int scale(int p) {
        double scaler = 1.0 / (this.getScale() * this.model.getScaleFactor());
        return (int)((double)p * scaler);
    }

    private int reverseScale(int p) {
        double scaler = this.getScale() * this.model.getScaleFactor();
        return (int)((double)p * scaler);
    }

    private void rotatePoint(Point p, int width, int height) {
        int oldx = p.x;
        int oldy = p.y;
        switch (this.model.getRotation()) {
            case 0: {
                break;
            }
            case 1: {
                p.x = oldy;
                p.y = this.model.getImageWidth() - (oldx + width);
                break;
            }
            case 2: {
                p.x = this.model.getImageWidth() - (oldx + width);
                p.y = this.model.getImageHeight() - (oldy + height);
                break;
            }
            case 3: {
                p.x = this.model.getImageHeight() - (oldy + height);
                p.y = oldx;
            }
        }
    }

    private void rotatePenStrokes() {
        int size = this.tempStrokes.size();
        CMBPenStroke s = null;
        for (int i = 0; i < size; ++i) {
            s = (CMBPenStroke)this.tempStrokes.elementAt(i);
            this.rotatePoint(s.from, 0, 0);
            this.rotatePoint(s.to, 0, 0);
        }
    }

    private void translatePenStrokes() {
        int size = this.tempStrokes.size();
        if (size == 0) {
            return;
        }
        CMBPenStroke firstStroke = (CMBPenStroke)this.tempStrokes.elementAt(0);
        int minx = firstStroke.from.x;
        int miny = firstStroke.from.y;
        int maxx = firstStroke.from.x;
        int maxy = firstStroke.from.y;
        for (int i = 0; i < size; ++i) {
            CMBPenStroke s = (CMBPenStroke)this.tempStrokes.elementAt(i);
            if (s.from.x < minx) {
                minx = s.from.x;
            }
            if (s.from.x > maxx) {
                maxx = s.from.x;
            }
            if (s.from.y < miny) {
                miny = s.from.y;
            }
            if (s.from.y > maxy) {
                maxy = s.from.y;
            }
            if (s.to.x < minx) {
                minx = s.to.x;
            }
            if (s.to.x > maxx) {
                maxx = s.to.x;
            }
            if (s.to.y < miny) {
                miny = s.to.y;
            }
            if (s.to.y <= maxy) continue;
            maxy = s.to.y;
        }
        Point oldCenter = new Point((maxx - minx) / 2 + minx, (maxy - miny) / 2 + miny);
        Point newCenter = (Point)oldCenter.clone();
        this.rotatePoint(newCenter, 0, 0);
        for (int i = 0; i < size; ++i) {
            CMBPenStroke s = (CMBPenStroke)this.tempStrokes.elementAt(i);
            s.from.translate(newCenter.x - oldCenter.x, newCenter.y - oldCenter.y);
            s.to.translate(newCenter.x - oldCenter.x, newCenter.y - oldCenter.y);
        }
    }

    private void createPenAnnotation() {
        if (this.tempStrokes.size() <= 0) {
            return;
        }
        CMBPenAnnotation pa = new CMBPenAnnotation();
        pa.setPageNumber(this.getPenPageNumber());
        pa.setInMotion(false);
        this.createAnnotation(pa);
        if (pa.getRotateWithImage()) {
            this.rotatePenStrokes();
        } else {
            this.translatePenStrokes();
        }
        pa.setPenStrokes(this.tempStrokes);
        this.tempStrokes.clear();
        this.setPenStrokes(null, false, null, null, -1);
        this.setSelectedAnnotation(pa);
        if (this.getSelectedAnnotation() != null) {
            this.getSelectedAnnotation().showHandles(true);
            this.refreshSlightlyBiggerRect(this.getSelectedAnnotation().getRefreshRect());
        }
    }

    private void createAnnotation(CMBPageAnnotation a, Point endPoint) {
        this.createAnnotation(a);
        this.clickedOnAnnotation(endPoint);
    }

    private void createTextAnnotation(Rectangle textRect, String text, int pageNumber, boolean select) {
        CMBTextAnnotation a = new CMBTextAnnotation(textRect, text, pageNumber);
        if (a != null) {
            this.createAnnotation((CMBPageAnnotation)a, select);
        }
    }

    private void createAnnotation(CMBPageAnnotation anno) {
        this.createAnnotation(anno, true);
    }

    private void createAnnotation(CMBPageAnnotation anno, boolean select) {
        String methodName = "createAnnotation";
        anno.dontDraw();
        anno.addAnnotationPropertiesListener(this);
        anno.setRotation(this.model.getRotation());
        anno.setImageHeight(this.model.getImageHeight());
        anno.setImageWidth(this.model.getImageWidth());
        anno.setAnnotationRotation(0);
        try {
            this.model.addAnnotation(anno, select);
        }
        catch (CMBAnnotationEngineException aee) {
            ViewerLogger.logError((Object)this, methodName, aee);
        }
        anno.pleaseDraw();
        if (this.owner != null) {
            this.owner.repaint(anno.getRefreshRect());
        }
    }

    private void editTextAnnotation(Point createPoint, boolean newlyCreated) {
        if (this.owner == null) {
            return;
        }
        this.textField = new JTextField(){

            protected void processKeyEvent(KeyEvent e) {
                boolean pressed;
                boolean bl = pressed = e.getID() == 401;
                KeyStroke ks = e.getID() == 400 ? KeyStroke.getKeyStroke(e.getKeyChar()) : KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers(), !pressed);
                ActionListener action = null;
                if (this.getActionForKeyStroke(ks) == null) {
                    for (Container component = CMBAnnotationView.this.owner; component != null && component instanceof JComponent && action == null; component = component.getParent()) {
                        action = component.getActionForKeyStroke(ks);
                    }
                }
                if (action != null) {
                    this.getActionListeners()[0].actionPerformed(new ActionEvent(this, 0, null));
                }
                super.processKeyEvent(e);
            }
        };
        this.textField.setBorder(BorderFactory.createEmptyBorder());
        if (!PAnnotationUtilities.isLeftToRight()) {
            this.textField.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
            this.textField.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        this.model.setScale((int)(this.scale * 1000.0));
        if (newlyCreated) {
            this.owner.add(this.textField);
            this.textField.setForeground(new Color(CMBTextAnnotation.defaultTextColor.getRGB(), false));
            this.textField.setBackground(new Color(CMBTextAnnotation.defaultFillColor.getRGB(), false));
            Font annoFont = CMBTextAnnotation.defaultFont;
            double scale = this.getScale() * this.getModel().getScaleFactor();
            Font scaledFont = new Font(annoFont.getName(), annoFont.getStyle(), (int)((double)annoFont.getSize() * scale));
            this.textField.setFont(scaledFont);
            FontRenderContext frc = new FontRenderContext(null, false, false);
            TextLayout layout = new TextLayout(CMBTextAnnotation.defaultText, CMBTextAnnotation.defaultFont, frc);
            Point p = createPoint;
            int width = this.textField.getBorder().getBorderInsets((Component)this.textField).left + this.textField.getBorder().getBorderInsets((Component)this.textField).right + 5;
            int height = this.reverseScale((int)(layout.getAscent() + layout.getDescent() + layout.getLeading() + layout.getLeading()));
            final Rectangle tRect = new Rectangle(p.x, p.y, width, height);
            final Point tPoint = new Point(createPoint);
            this.textField.setBounds(tRect);
            this.textField.setVisible(true);
            this.textField.grabFocus();
            this.owner.revalidate();
            final int originalPageNumber = this.currentPage;
            AbstractAction commitAction = new AbstractAction("commitAction"){

                public void actionPerformed(ActionEvent e) {
                    if (CMBAnnotationView.this.textField.getText().length() > 0) {
                        FontRenderContext frc = new FontRenderContext(null, false, false);
                        TextLayout layout = new TextLayout(CMBAnnotationView.this.textField.getText(), CMBTextAnnotation.defaultFont, frc);
                        int w = (int)layout.getBounds().getWidth();
                        int h = (int)(layout.getBounds().getHeight() + (double)layout.getAscent());
                        int halfW = w / 2;
                        int halfH = h / 2;
                        CMBAnnotationView.this.scalePoint(tPoint);
                        tPoint.translate(halfW, halfH);
                        CMBAnnotationView.this.rotatePoint(tPoint, 0, 0);
                        tPoint.translate(-halfW, -halfH);
                        Rectangle textRect = new Rectangle(tPoint, new Dimension(w, h));
                        CMBAnnotationView.this.createTextAnnotation(textRect, CMBAnnotationView.this.textField.getText(), originalPageNumber, !CMBAnnotationView.this.infocuslost);
                        CMBAnnotationView.this.directEditing = false;
                        if (CMBAnnotationView.this.textField != null && e.getActionCommand() != null) {
                            CMBAnnotationView.this.textField.setVisible(false);
                            CMBAnnotationView.this.owner.remove(CMBAnnotationView.this.textField);
                        }
                        if (!CMBAnnotationView.this.infocuslost) {
                            CMBAnnotationView.this.owner.requestFocus();
                        }
                    } else {
                        if (CMBAnnotationView.this.textField != null && e.getActionCommand() != null) {
                            CMBAnnotationView.this.textField.setVisible(false);
                            CMBAnnotationView.this.owner.remove(CMBAnnotationView.this.textField);
                        }
                        CMBAnnotationView.this.refreshSlightlyBiggerRect(tRect);
                        if (!CMBAnnotationView.this.infocuslost) {
                            CMBAnnotationView.this.owner.requestFocus();
                        }
                    }
                    CMBAnnotationView.this.directEditing = false;
                    CMBAnnotationView.this.services.setSelectedAnnotationTool(0);
                }
            };
            KeyStroke commitKey = KeyStroke.getKeyStroke(27, 0, false);
            this.textField.getInputMap(0).put(commitKey, commitAction.getValue("Name"));
            this.textField.getActionMap().put(commitAction.getValue("Name"), commitAction);
            this.textField.addActionListener(commitAction);
        } else {
            final CMBTextAnnotation ta = (CMBTextAnnotation)this.getSelectedAnnotation();
            final CMBPageAnnotation oldProps = (CMBPageAnnotation)ta.clone();
            this.textField.setText(ta.getTextLine());
            final String originalText = this.textField.getText();
            ta.dontDraw();
            final Rectangle refRect = ta.getRefreshRect();
            this.textField.setForeground(new Color(ta.getBorderColor().getRGB(), false));
            this.textField.setBackground(new Color(ta.getFillColor().getRGB(), false));
            Font annoFont = ta.getFont();
            double scale = this.getScale() * this.getModel().getScaleFactor();
            Font scaledFont = new Font(annoFont.getName(), annoFont.getStyle(), (int)((double)annoFont.getSize() * scale));
            this.textField.setFont(scaledFont);
            this.textField.setLocation(refRect.x, refRect.y);
            this.textField.setSize(refRect.width, refRect.height);
            this.owner.add(this.textField);
            ta.showHandles(false);
            this.refreshSlightlyBiggerRect(refRect);
            this.textField.setVisible(true);
            this.textField.selectAll();
            this.textField.grabFocus();
            KeyStroke commitKey = KeyStroke.getKeyStroke(27, 0, false);
            AbstractAction commitAction = new AbstractAction("commitAction"){

                public void actionPerformed(ActionEvent e) {
                    String methodName = "commitAction:actionPerformed";
                    if (CMBAnnotationView.this.textField.getText().length() > 0) {
                        String newText = CMBAnnotationView.this.textField.getText();
                        if (!newText.equals(originalText)) {
                            ta.setTextLine(newText);
                            CMBPageAnnotation newProps = (CMBPageAnnotation)ta.clone();
                            CMBAnnotationView.this.model.fireCMBAnnPropertiesUpdatedEvent(CMBAnnotationView.this, ta, oldProps, newProps);
                        }
                        if (CMBAnnotationView.this.textField != null && e.getActionCommand() != null) {
                            CMBAnnotationView.this.textField.setVisible(false);
                            CMBAnnotationView.this.owner.remove(CMBAnnotationView.this.textField);
                        }
                        ta.pleaseDraw();
                        if (CMBAnnotationView.this.getSelectedAnnotation() == ta) {
                            ta.showHandles(true);
                        }
                        CMBAnnotationView.this.refreshSlightlyBiggerRect(refRect);
                        CMBAnnotationView.this.refreshSlightlyBiggerRect(ta.getRefreshRect());
                        if (!CMBAnnotationView.this.infocuslost) {
                            CMBAnnotationView.this.owner.requestFocus();
                        }
                    } else {
                        ta.pleaseDraw();
                        try {
                            CMBAnnotationView.this.model.removeAnnotation(ta);
                        }
                        catch (CMBAnnotationEngineException aee) {
                            ViewerLogger.logError((Object)this, methodName, aee);
                        }
                        if (CMBAnnotationView.this.textField != null && e.getActionCommand() != null) {
                            CMBAnnotationView.this.textField.setVisible(false);
                            CMBAnnotationView.this.owner.remove(CMBAnnotationView.this.textField);
                        }
                        if (!CMBAnnotationView.this.infocuslost) {
                            CMBAnnotationView.this.owner.requestFocus();
                        }
                    }
                    CMBAnnotationView.this.directEditing = false;
                }
            };
            this.textField.getInputMap(0).put(commitKey, commitAction.getValue("Name"));
            this.textField.getActionMap().put(commitAction.getValue("Name"), commitAction);
            this.textField.addActionListener(commitAction);
        }
        this.textField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                if (!CMBAnnotationView.this.directEditing) {
                    if (CMBAnnotationView.this.textField != null && CMBAnnotationView.this.textField.isVisible()) {
                        CMBAnnotationView.this.textField.setVisible(false);
                        CMBAnnotationView.this.owner.remove(CMBAnnotationView.this.textField);
                    }
                } else {
                    CMBAnnotationView.this.directEditing = false;
                    if (CMBAnnotationView.this.textField.isVisible()) {
                        CMBAnnotationView.this.infocuslost = true;
                        CMBAnnotationView.this.textField.postActionEvent();
                        CMBAnnotationView.this.infocuslost = false;
                    }
                }
            }
        });
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                this.changed();
            }

            public void removeUpdate(DocumentEvent e) {
                this.changed();
            }

            public void changedUpdate(DocumentEvent e) {
                this.changed();
            }

            private void changed() {
                int width = CMBAnnotationView.this.textField.getFontMetrics(CMBAnnotationView.this.textField.getFont()).stringWidth(CMBAnnotationView.this.textField.getText()) + ((CMBAnnotationView)CMBAnnotationView.this).textField.getBorder().getBorderInsets((Component)((CMBAnnotationView)CMBAnnotationView.this).textField).left + ((CMBAnnotationView)CMBAnnotationView.this).textField.getBorder().getBorderInsets((Component)((CMBAnnotationView)CMBAnnotationView.this).textField).right + 5;
                CMBAnnotationView.this.textField.setSize(width, CMBAnnotationView.this.textField.getHeight());
            }
        });
        this.directEditing = true;
    }

    private void editNoteAnnotation(final boolean newlyCreated) {
        if (this.owner == null) {
            return;
        }
        CMBNoteAnnotation na = (CMBNoteAnnotation)this.getSelectedAnnotation();
        final CMBNoteAnnotation noteAnnotation = (CMBNoteAnnotation)this.getSelectedAnnotation();
        final CMBPageAnnotation oldProps = (CMBPageAnnotation)na.clone();
        String text = na.getText();
        if (text == null || text.equals(" ")) {
            text = "";
        }
        this.noteArea = new JTextArea(text, 1, 1){

            protected void processKeyEvent(KeyEvent e) {
                boolean pressed;
                boolean bl = pressed = e.getID() == 401;
                KeyStroke ks = e.getID() == 400 ? KeyStroke.getKeyStroke(e.getKeyChar()) : KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers(), !pressed);
                ActionListener action = null;
                if (this.getActionForKeyStroke(ks) == null) {
                    for (Container component = CMBAnnotationView.this.owner; component != null && component instanceof JComponent && action == null; component = component.getParent()) {
                        action = component.getActionForKeyStroke(ks);
                    }
                }
                if (action != null && CMBAnnotationView.this.noteArea.isVisible()) {
                    CMBAnnotationView.this.directEditing = false;
                    noteAnnotation.setText(CMBAnnotationView.this.noteArea.getText());
                    if (!newlyCreated) {
                        CMBPageAnnotation newProps = (CMBPageAnnotation)noteAnnotation.clone();
                        CMBAnnotationView.this.model.fireCMBAnnPropertiesUpdatedEvent(CMBAnnotationView.this, noteAnnotation, oldProps, newProps);
                    }
                    CMBAnnotationView.this.noteScroll.setVisible(false);
                    CMBAnnotationView.this.owner.grabFocus();
                }
                super.processKeyEvent(e);
            }
        };
        this.noteArea.setBorder(BorderFactory.createEmptyBorder());
        this.noteArea.setText(text);
        if (((CMBNoteAnnotation)this.getSelectedAnnotation()).getWordWrap()) {
            this.noteArea.setWrapStyleWord(true);
            this.noteArea.setLineWrap(true);
        } else {
            this.noteArea.setWrapStyleWord(false);
            this.noteArea.setLineWrap(false);
        }
        this.noteArea.setForeground(new Color(this.getSelectedAnnotation().getBorderColor().getRGB(), false));
        this.noteArea.setBackground(new Color(this.getSelectedAnnotation().getFillColor().getRGB(), false));
        Font annoFont = this.getSelectedAnnotation().getFont();
        this.model.setScale((int)(this.scale * 1000.0));
        double scale = this.getScale() * this.getModel().getScaleFactor();
        Font scaledFont = new Font(annoFont.getName(), annoFont.getStyle(), (int)((double)annoFont.getSize() * scale));
        this.noteArea.setFont(scaledFont);
        if (!PAnnotationUtilities.isLeftToRight()) {
            this.noteArea.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
            this.noteArea.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        if (this.noteScroll != null) {
            this.owner.remove(this.noteScroll);
        }
        this.noteScroll = new JScrollPane(this.noteArea);
        this.noteScroll.setBorder(BorderFactory.createEmptyBorder());
        this.owner.add(this.noteScroll);
        this.noteScroll.setVisible(true);
        this.noteScroll.validate();
        this.positionNoteAnnotationEditor();
        this.noteArea.grabFocus();
        this.directEditing = true;
        AbstractAction commitAction = new AbstractAction("commitAction"){

            public void actionPerformed(ActionEvent e) {
                if (CMBAnnotationView.this.noteArea.isVisible()) {
                    CMBAnnotationView.this.directEditing = false;
                    noteAnnotation.setText(CMBAnnotationView.this.noteArea.getText());
                    if (!newlyCreated) {
                        CMBPageAnnotation newProps = (CMBPageAnnotation)noteAnnotation.clone();
                        CMBAnnotationView.this.model.fireCMBAnnPropertiesUpdatedEvent(CMBAnnotationView.this, noteAnnotation, oldProps, newProps);
                    }
                    CMBAnnotationView.this.noteScroll.setVisible(false);
                    CMBAnnotationView.this.owner.grabFocus();
                }
            }
        };
        KeyStroke commitKey = KeyStroke.getKeyStroke(27, 0, false);
        this.noteArea.getInputMap(2).put(commitKey, commitAction.getValue("Name"));
        this.noteArea.getActionMap().put(commitAction.getValue("Name"), commitAction);
        this.noteArea.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                if (CMBAnnotationView.this.noteArea.isVisible()) {
                    if (event.getOppositeComponent() != CMBAnnotationView.this.owner || CMBAnnotationView.this.getSelectedAnnotation() != noteAnnotation) {
                        if (CMBAnnotationView.this.directEditing) {
                            CMBAnnotationView.this.directEditing = false;
                            noteAnnotation.setText(CMBAnnotationView.this.noteArea.getText());
                            if (!newlyCreated) {
                                CMBPageAnnotation newProps = (CMBPageAnnotation)noteAnnotation.clone();
                                CMBAnnotationView.this.model.fireCMBAnnPropertiesUpdatedEvent(CMBAnnotationView.this, noteAnnotation, oldProps, newProps);
                            }
                        }
                        CMBAnnotationView.this.noteScroll.setVisible(false);
                    } else {
                        CMBAnnotationView.this.noteArea.grabFocus();
                    }
                }
            }
        });
    }

    private void positionNoteAnnotationEditor() {
        if (!(this.getSelectedAnnotation() instanceof CMBNoteAnnotation)) {
            return;
        }
        CMBNoteAnnotation na = (CMBNoteAnnotation)this.getSelectedAnnotation();
        Rectangle refRect = na.getRefreshRect();
        this.noteScroll.setBounds(refRect.x + 5 + 6, refRect.y + 5 + 6, refRect.width - 10 - 8, refRect.height - 10 - 8);
        this.noteScroll.validate();
    }

    public void updateComponentUI() {
        if (this.noteArea != null) {
            SwingUtilities.updateComponentTreeUI(this.noteArea);
        }
    }

    public void finalize() {
        this.dispose();
    }

    public void dispose() {
        if (this.model != null) {
            if (this.model.getAnnotationServices() != null) {
                this.model.getAnnotationServices().removeAnnotationToolListener(this);
            }
            this.model.removeView(this);
            this.model.removeAnnSelectedListener(this);
        }
        if (this.services != null && this.services.getActiveAnnotationView() == this) {
            this.services.setActiveAnnotationView(null);
        }
        this.model = null;
        this.services = null;
        this.owner = null;
        this.oldPoint = null;
        this.originalPoint = null;
        this.dragRect = null;
        this.noteArea = null;
        if (this.tempStrokes != null) {
            this.tempStrokes.clear();
        }
    }

    public void annotationToolChanged(CMBSelectedAnnotationToolChangedEvent e) {
        if (this.penStrokes != null && this.penStrokes.size() > 0) {
            this.createPenAnnotation();
        }
        if (e.getAnnotationTool() == 0 && this.owner != null) {
            this.owner.setCursor(this.getModel().getAnnotationServices().getHandleCursor(9));
        }
        if (e.getAnnotationTool() != 0 && e.getAnnotationTool() != 21) {
            this.registerCommonKeyBindings(this.commonCreateBindings);
            this.registerCommonKeyBindings(this.commonEditBindings);
        }
        if (e.getAnnotationTool() == 0 && this.getSelectedAnnotation() != null) {
            this.registerCommonKeyBindings(this.commonEditBindings);
        }
    }

    public void annotationCreated(CMBAnnotationCreatedEvent evt) {
        if (evt.getAnnotation().getPageNumber() == this.currentPage) {
            this.refreshSlightlyBiggerRect(evt.getAnnotation().getRefreshRect());
        }
    }

    public void annotationReordered(CMBAnnotationReorderedEvent evt) {
        if (evt.getAnnotation().getPageNumber() == this.currentPage) {
            this.refreshEntireDrawArea();
        }
    }

    public void annotationDeleted(CMBAnnotationDeletedEvent evt) {
        if (evt.getAnnotation().getPageNumber() == this.currentPage) {
            this.refreshEntireDrawArea();
        }
    }

    public boolean isOverAnnotation(Point p) {
        Point scaledPoint = (Point)p.clone();
        this.scalePoint(scaledPoint);
        CMBPageAnnotation annotation = this.findAnnotationFromPoint(scaledPoint);
        return annotation != null;
    }

    class KeyBinding {
        public KeyStroke key;
        public Action action;

        public KeyBinding(Action action, KeyStroke key) {
            this.key = key;
            this.action = action;
        }

        public String toString() {
            return super.toString() + "key: " + this.key.toString() + " action: " + this.action.getValue("Name");
        }
    }

    private class AnnotationViewMouseHandler
    implements MouseListener,
    MouseMotionListener {
        private CMBPageAnnotation lastCreatedAnnotation;

        private AnnotationViewMouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            CMBPageAnnotation a;
            Point p;
            String methodName = "mouseclicked";
            if (e.isConsumed()) {
                return;
            }
            if ((e.getModifiers() & 0x10) == 16 && CMBAnnotationView.this.services.getMode() == 5) {
                p = e.getPoint();
                CMBAnnotationView.this.scalePoint(p);
                a = CMBAnnotationView.this.findAnnotationFromPoint(p);
                if (a == null) {
                    return;
                }
                if (!(a instanceof CMBPenAnnotation)) {
                    try {
                        CMBAnnotationView.this.model.removeAnnotation(a);
                    }
                    catch (CMBAnnotationEngineException aee) {
                        ViewerLogger.logError((Object)this, methodName, aee);
                    }
                }
            } else if ((e.getModifiers() & 4) == 4) {
                p = e.getPoint();
                CMBAnnotationView.this.scalePoint(p);
                a = CMBAnnotationView.this.findAnnotationFromPoint(p);
                if (a == null) {
                    return;
                }
                CMBAnnotationView.this.setSelectedAnnotation(a);
                if (CMBAnnotationView.this.services.getPopupMenu() != null) {
                    CMBAnnotationView.this.services.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                } else {
                    CMBAnnotationView.this.services.changeAnnotationProperties(a);
                }
            }
            if (e.getClickCount() == 2) {
                if (CMBAnnotationView.this.getSelectedAnnotation() == null || !CMBAnnotationView.this.getSelectedAnnotation().canUpdate() || !CMBAnnotationView.this.model.isEditable()) {
                    return;
                }
                if (CMBAnnotationView.this.getSelectedAnnotation().getType() == 5) {
                    CMBAnnotationView.this.editNoteAnnotation(false);
                } else if (CMBAnnotationView.this.getSelectedAnnotation().getType() == 9) {
                    CMBAnnotationView.this.editTextAnnotation(e.getPoint(), false);
                }
            }
            if (CMBAnnotationView.this.services.getMode() == 112) {
                CMBAnnotationView.this.services.setIdleDrawingMode();
                p = e.getPoint();
                CMBAnnotationView.this.scalePoint(p);
                CMBPageAnnotation annoFromPoint = CMBAnnotationView.this.findAnnotationFromPoint(p);
                if (annoFromPoint != null) {
                    CMBAnnotationView.this.setSelectedAnnotation(annoFromPoint);
                    return;
                }
            }
            CMBAnnotationView.this.services.commitPen();
            CMBAnnotationView.this.setIdleMode();
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            String methodName = "mousePressed";
            if ((e.getModifiers() & 4) == 4) {
                return;
            }
            CMBAnnotationView.this.oldPoint = e.getPoint();
            CMBAnnotationView.this.originalPoint = new Point(CMBAnnotationView.this.oldPoint);
            CMBAnnotationView.this.scalePoint(CMBAnnotationView.this.originalPoint);
            CMBAnnotationView.this.scalePoint(CMBAnnotationView.this.oldPoint);
            switch (CMBAnnotationView.this.services.getMode()) {
                case 112: {
                    if (CMBAnnotationView.this.getSelectedAnnotation() != null) {
                        CMBAnnotationView.this.setSelectedAnnotation(null);
                    }
                    return;
                }
                case 1: 
                case 2: 
                case 3: {
                    CMBAnnotationView.this.clickedOnAnnotation(CMBAnnotationView.this.oldPoint);
                    if (CMBAnnotationView.this.getSelectedAnnotation() != null) {
                        CMBAnnotationView.this.originalAnnotationLocation = CMBAnnotationView.this.getSelectedAnnotation().getAnnoDrawRect().getLocation();
                        break;
                    }
                    CMBAnnotationView.this.originalAnnotationLocation = null;
                    break;
                }
                case 4: {
                    if (((CMBAnnotationView)CMBAnnotationView.this).oldPoint.x < 0 || ((CMBAnnotationView)CMBAnnotationView.this).oldPoint.x > CMBAnnotationView.this.model.getImageWidth()) {
                        CMBAnnotationView.this.oldPoint = null;
                        CMBAnnotationView.this.dragRect = null;
                        return;
                    }
                    if (((CMBAnnotationView)CMBAnnotationView.this).oldPoint.y < 0 || ((CMBAnnotationView)CMBAnnotationView.this).oldPoint.y > CMBAnnotationView.this.model.getImageHeight()) {
                        CMBAnnotationView.this.oldPoint = null;
                        CMBAnnotationView.this.dragRect = null;
                        return;
                    }
                    if (!CMBAnnotationView.this.model.isEditable()) {
                        return;
                    }
                    int scaledInitialWidth = CMBAnnotationView.this.scale(0);
                    int scaledInitialHeight = CMBAnnotationView.this.scale(0);
                    Point createPoint = new Point(((CMBAnnotationView)CMBAnnotationView.this).oldPoint.x, ((CMBAnnotationView)CMBAnnotationView.this).oldPoint.y);
                    CMBAnnotationView.this.rotatePoint(createPoint, 0, 0);
                    createPoint.x -= scaledInitialWidth;
                    createPoint.y -= scaledInitialHeight;
                    Rectangle newRect = new Rectangle(createPoint.x, createPoint.y, scaledInitialWidth, scaledInitialHeight);
                    CMBAnnotationView.this.dragRect = (Rectangle)newRect.clone();
                    CMBPageAnnotation a = null;
                    CMBAnnotationView.this.createState = true;
                    switch (CMBAnnotationView.this.services.getSelectedAnnotationTool()) {
                        case 6: {
                            CMBAnnotationView.this.model.setPenPending(true);
                            break;
                        }
                        case 3: {
                            a = new CMBHighlightAnnotation(newRect, CMBAnnotationView.this.currentPage);
                            if (a == null) break;
                            CMBAnnotationView.this.createAnnotation(a, CMBAnnotationView.this.oldPoint);
                            break;
                        }
                        case 2: {
                            a = new CMBCircleAnnotation(newRect, CMBAnnotationView.this.currentPage);
                            if (a == null) break;
                            CMBAnnotationView.this.createAnnotation(a, CMBAnnotationView.this.oldPoint);
                            break;
                        }
                        case 4: {
                            a = new CMBLineAnnotation(newRect, CMBAnnotationView.this.currentPage);
                            if (a == null) break;
                            CMBAnnotationView.this.createAnnotation(a, CMBAnnotationView.this.oldPoint);
                            break;
                        }
                        case 1: {
                            a = new CMBArrowAnnotation(newRect, CMBAnnotationView.this.currentPage);
                            if (a == null) break;
                            CMBAnnotationView.this.createAnnotation(a, CMBAnnotationView.this.oldPoint);
                            break;
                        }
                        case 9: {
                            CMBAnnotationView.this.services.setMode(3);
                            CMBAnnotationView.this.editTextAnnotation(e.getPoint(), true);
                            break;
                        }
                        case 8: {
                            CMBAnnotationView.this.services.setMode(3);
                            CMBAnnotationView.this.createStampAnnotation(e.getPoint(), CMBAnnotationView.this.currentPage);
                            break;
                        }
                        case 7: {
                            a = new CMBRectAnnotation(newRect, CMBAnnotationView.this.currentPage);
                            if (a == null) break;
                            CMBAnnotationView.this.createAnnotation(a, CMBAnnotationView.this.oldPoint);
                            break;
                        }
                        case 5: {
                            a = new CMBNoteAnnotation(newRect, "", CMBAnnotationView.this.currentPage);
                            if (a != null) {
                                CMBAnnotationView.this.createAnnotation(a, CMBAnnotationView.this.oldPoint);
                            }
                            CMBAnnotationView.this.creatingNoteAnnotation = true;
                            break;
                        }
                        default: {
                            if (CMBAnnotationView.this.services.getSelectedAnnotationTool() < 100) {
                                return;
                            }
                            String className = CMBAnnotationView.this.services.getCustomAnnoClassName();
                            try {
                                Class<?> newAnnoClass = Class.forName(className);
                                Class[] params = new Class[]{Class.forName("java.awt.Rectangle"), Integer.TYPE};
                                Constructor<?> con = newAnnoClass.getConstructor(params);
                                Object[] initargs = new Object[]{newRect, new Integer(CMBAnnotationView.this.currentPage)};
                                a = (CMBPageAnnotation)con.newInstance(initargs);
                                if (a == null) break;
                                CMBAnnotationView.this.createAnnotation(a, CMBAnnotationView.this.oldPoint);
                                break;
                            }
                            catch (Exception ex) {
                                ViewerLogger.logError(this, methodName, "Unable to create custom annotation:" + className, ex);
                            }
                        }
                    }
                    this.lastCreatedAnnotation = a;
                    break;
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.lastCreatedAnnotation = null;
            if (CMBAnnotationView.this.getSelectedAnnotation() == null) {
                return;
            }
            if (!CMBAnnotationView.this.getSelectedAnnotation().canUpdate() || !CMBAnnotationView.this.model.isEditable()) {
                CMBAnnotationView.this.getSelectedAnnotation().setInMotion(false);
                CMBAnnotationView.this.services.setMode(3);
                CMBAnnotationView.this.createState = false;
                return;
            }
            Point currentPoint = e.getPoint();
            CMBAnnotationView.this.scalePoint(currentPoint);
            if (CMBAnnotationView.this.services.getMode() == 1 || CMBAnnotationView.this.services.getMode() == 2) {
                if (CMBAnnotationView.this.getSelectedAnnotation() != null) {
                    Rectangle oldrefRect = CMBAnnotationView.this.getSelectedAnnotation().getRefreshRect();
                    CMBAnnotationView.this.getSelectedAnnotation().setInMotion(false);
                    if (CMBAnnotationView.this.services.getMode() == 2) {
                        if (!currentPoint.equals(CMBAnnotationView.this.originalPoint)) {
                            CMBAnnotationView.this.model.fireCMBAnnMovedEvent(CMBAnnotationView.this, CMBAnnotationView.this.getSelectedAnnotation(), currentPoint, CMBAnnotationView.this.originalPoint);
                        }
                    } else if (CMBAnnotationView.this.services.getMode() == 1 && !CMBAnnotationView.this.createState && !currentPoint.equals(CMBAnnotationView.this.originalPoint)) {
                        CMBAnnotationView.this.model.fireCMBAnnResizedEvent(CMBAnnotationView.this, CMBAnnotationView.this.getSelectedAnnotation(), currentPoint, CMBAnnotationView.this.originalPoint);
                    }
                    Rectangle refRect = CMBAnnotationView.this.getSelectedAnnotation().getRefreshRect();
                    CMBAnnotationView.this.owner.repaint(oldrefRect.x, oldrefRect.y, oldrefRect.width, oldrefRect.height);
                    CMBAnnotationView.this.owner.repaint(refRect.x, refRect.y, refRect.width, refRect.height);
                }
                if (CMBAnnotationView.this.creatingNoteAnnotation) {
                    CMBAnnotationView.this.creatingNoteAnnotation = false;
                    int annoWidth = ((CMBAnnotationView)CMBAnnotationView.this).getSelectedAnnotation().getDrawRect().width;
                    int annoHeight = ((CMBAnnotationView)CMBAnnotationView.this).getSelectedAnnotation().getDrawRect().height;
                    if (annoWidth < 250 || annoHeight < 100) {
                        int newWidth = Math.max(annoWidth, 250);
                        int newHeight = Math.max(annoHeight, 100);
                        CMBAnnotationView.this.getSelectedAnnotation().growBy(newWidth - annoWidth, newHeight - annoHeight);
                    }
                    CMBAnnotationView.this.editNoteAnnotation(true);
                } else if (CMBAnnotationView.this.noteScroll != null && CMBAnnotationView.this.noteScroll.isVisible()) {
                    CMBAnnotationView.this.noteArea.requestFocus();
                }
                CMBAnnotationView.this.setIdleMode();
            }
        }

        public void mouseDragged(MouseEvent e) {
            String methodName = "mouseDragged";
            if (!CMBAnnotationView.this.model.isEditable()) {
                return;
            }
            Point newPoint = e.getPoint();
            CMBAnnotationView.this.scalePoint(newPoint);
            block1 : switch (CMBAnnotationView.this.services.getMode()) {
                case 1: 
                case 2: {
                    if (this.lastCreatedAnnotation != null && CMBAnnotationView.this.getSelectedAnnotation() == null) {
                        CMBAnnotationView.this.setSelectedAnnotation(this.lastCreatedAnnotation);
                    }
                    if (CMBAnnotationView.this.getSelectedAnnotation() == null || !CMBAnnotationView.this.getSelectedAnnotation().canUpdate()) break;
                    Rectangle originalRefRect = CMBAnnotationView.this.getSelectedAnnotation().getRefreshRect();
                    if (CMBAnnotationView.this.services.getMode() == 2) {
                        Point currentAnnotationLocation = CMBAnnotationView.this.getSelectedAnnotation().getAnnoDrawRect().getLocation();
                        CMBAnnotationView.this.getSelectedAnnotation().translateBy(((CMBAnnotationView)CMBAnnotationView.this).originalAnnotationLocation.x + (newPoint.x - ((CMBAnnotationView)CMBAnnotationView.this).originalPoint.x) - currentAnnotationLocation.x, ((CMBAnnotationView)CMBAnnotationView.this).originalAnnotationLocation.y + (newPoint.y - ((CMBAnnotationView)CMBAnnotationView.this).originalPoint.y) - currentAnnotationLocation.y);
                    } else {
                        CMBAnnotationView.this.getSelectedAnnotation().growBy(newPoint.x - ((CMBAnnotationView)CMBAnnotationView.this).oldPoint.x, newPoint.y - ((CMBAnnotationView)CMBAnnotationView.this).oldPoint.y);
                    }
                    if (CMBAnnotationView.this.directEditing) {
                        CMBAnnotationView.this.positionNoteAnnotationEditor();
                    }
                    Rectangle newRefRect = CMBAnnotationView.this.getSelectedAnnotation().getRefreshRect();
                    Rectangle unionRefRect = newRefRect.union(originalRefRect);
                    CMBAnnotationView.this.owner.repaint(unionRefRect);
                    break;
                }
                case 5: {
                    CMBPageAnnotation a = CMBAnnotationView.this.findAnnotationFromPoint(newPoint);
                    if (a == null) {
                        return;
                    }
                    if (!(a instanceof CMBPenAnnotation)) break;
                    CMBPageAnnotation oldProps = (CMBPageAnnotation)a.clone();
                    ((CMBPenAnnotation)a).eraseSegment(newPoint);
                    CMBPageAnnotation newProps = (CMBPageAnnotation)a.clone();
                    int oldSize = ((CMBPenAnnotation)oldProps).getPenStrokes().size();
                    int newSize = ((CMBPenAnnotation)newProps).getPenStrokes().size();
                    if (oldSize != newSize) {
                        CMBAnnotationView.this.model.fireCMBAnnPropertiesUpdatedEvent(CMBAnnotationView.this, a, oldProps, newProps);
                    }
                    if (newSize == 0) {
                        try {
                            CMBAnnotationView.this.model.removeAnnotation(a);
                        }
                        catch (CMBAnnotationEngineException aaee) {
                            ViewerLogger.logError((Object)this, methodName, aaee);
                        }
                        CMBAnnotationView.this.setIdleMode();
                    }
                    CMBAnnotationView.this.refreshRect(a.getRefreshRect());
                    break;
                }
                case 4: {
                    if (CMBAnnotationView.this.oldPoint == null) {
                        return;
                    }
                    switch (CMBAnnotationView.this.services.getSelectedAnnotationTool()) {
                        case 6: {
                            CMBPenStroke s = new CMBPenStroke(CMBAnnotationView.this.oldPoint, newPoint);
                            CMBAnnotationView.this.tempStrokes.addElement(s);
                            Color penColor = CMBPenAnnotation.defaultBorderColor;
                            BasicStroke penStroke = new BasicStroke(CMBPenAnnotation.defaultWidth);
                            CMBAnnotationView.this.setPenStrokes(CMBAnnotationView.this.tempStrokes, true, penColor, penStroke, CMBAnnotationView.this.currentPage);
                            CMBAnnotationView.this.drawStroke(s, penColor, penStroke);
                            break block1;
                        }
                    }
                    if (CMBAnnotationView.this.dragRect == null) break;
                    CMBAnnotationView.this.refreshRect(CMBAnnotationView.this.dragRect);
                    CMBAnnotationView.this.dragRect.setSize(newPoint.x - ((CMBAnnotationView)CMBAnnotationView.this).oldPoint.x, newPoint.y - ((CMBAnnotationView)CMBAnnotationView.this).oldPoint.y);
                    CMBAnnotationView.this.refreshRect(CMBAnnotationView.this.dragRect);
                }
            }
            if (CMBAnnotationView.this.oldPoint == null) {
                CMBAnnotationView.this.oldPoint = new Point();
            }
            ((CMBAnnotationView)CMBAnnotationView.this).oldPoint.x = newPoint.x;
            ((CMBAnnotationView)CMBAnnotationView.this).oldPoint.y = newPoint.y;
        }

        public void mouseMoved(MouseEvent e) {
            if (CMBAnnotationView.this.services.getMode() == 3) {
                if (CMBAnnotationView.this.getSelectedAnnotation() != null && CMBAnnotationView.this.getSelectedAnnotation().canUpdate() && CMBAnnotationView.this.model.isEditable() && CMBAnnotationView.this.model.isActive()) {
                    Point newPoint = e.getPoint();
                    CMBAnnotationView.this.scalePoint(newPoint);
                    if (CMBAnnotationView.this.getSelectedAnnotation().pointInHandle(newPoint)) {
                        int handleType = CMBAnnotationView.this.getSelectedAnnotation().getCurrentHandleCursorType(CMBAnnotationView.this.getSelectedAnnotation().getCurrentHandleType());
                        CMBAnnotationView.this.owner.setCursor(CMBAnnotationView.this.getModel().getAnnotationServices().getHandleCursor(handleType));
                    } else if (CMBAnnotationView.this.getSelectedAnnotation().contains(newPoint)) {
                        CMBAnnotationView.this.owner.setCursor(CMBAnnotationView.this.getModel().getAnnotationServices().getHandleCursor(8));
                    } else {
                        CMBAnnotationView.this.owner.setCursor(CMBAnnotationView.this.getModel().getAnnotationServices().getHandleCursor(9));
                    }
                    return;
                }
                CMBAnnotationView.this.owner.setCursor(CMBAnnotationView.this.getModel().getAnnotationServices().getHandleCursor(9));
            } else if (CMBAnnotationView.this.services.getMode() != 112) {
                Point oldPoint = e.getPoint();
                CMBAnnotationView.this.scalePoint(oldPoint);
                if (!CMBAnnotationView.this.owner.getCursor().equals(CMBAnnotationView.this.getModel().getAnnotationServices().getHandleCursor(9))) {
                    CMBAnnotationView.this.oldCursor = CMBAnnotationView.this.owner.getCursor();
                }
                if (oldPoint.x < 0 || oldPoint.x > CMBAnnotationView.this.model.getImageWidth()) {
                    CMBAnnotationView.this.owner.setCursor(CMBAnnotationView.this.getModel().getAnnotationServices().getHandleCursor(9));
                } else if (oldPoint.y < 0 || oldPoint.y > CMBAnnotationView.this.model.getImageHeight()) {
                    CMBAnnotationView.this.owner.setCursor(CMBAnnotationView.this.getModel().getAnnotationServices().getHandleCursor(9));
                } else {
                    CMBAnnotationView.this.owner.setCursor(CMBAnnotationView.this.oldCursor);
                }
            }
        }
    }

    private class AnnotationViewFocusHandler
    implements FocusListener {
        private AnnotationViewFocusHandler() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            if (CMBAnnotationView.this.tempStrokes.size() > 0) {
                if (CMBAnnotationView.this.model.isPenPending() && CMBAnnotationView.this.services.getSelectedAnnotationTool() == 6) {
                    CMBAnnotationView.this.model.setDirty(true);
                }
                CMBAnnotationView.this.services.commitPen();
            }
        }
    }
}

