/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer.annotation;

import com.ibm.mm.viewer.annotation.CMBAnnotationCreatedEvent;
import com.ibm.mm.viewer.annotation.CMBAnnotationCreatedListener;
import com.ibm.mm.viewer.annotation.CMBAnnotationDeletedEvent;
import com.ibm.mm.viewer.annotation.CMBAnnotationDeletedListener;
import com.ibm.mm.viewer.annotation.CMBAnnotationEngine;
import com.ibm.mm.viewer.annotation.CMBAnnotationEngineException;
import com.ibm.mm.viewer.annotation.CMBAnnotationMovedEvent;
import com.ibm.mm.viewer.annotation.CMBAnnotationMovedListener;
import com.ibm.mm.viewer.annotation.CMBAnnotationPropertiesUpdatedEvent;
import com.ibm.mm.viewer.annotation.CMBAnnotationPropertiesUpdatedListener;
import com.ibm.mm.viewer.annotation.CMBAnnotationReorderedEvent;
import com.ibm.mm.viewer.annotation.CMBAnnotationReorderedListener;
import com.ibm.mm.viewer.annotation.CMBAnnotationResizedEvent;
import com.ibm.mm.viewer.annotation.CMBAnnotationResizedListener;
import com.ibm.mm.viewer.annotation.CMBAnnotationSelectedEvent;
import com.ibm.mm.viewer.annotation.CMBAnnotationSelectedListener;
import com.ibm.mm.viewer.annotation.CMBAnnotationServices;
import com.ibm.mm.viewer.annotation.CMBAnnotationView;
import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import com.ibm.mm.viewer.annotation.PAnnotationUtilities;
import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public class CMBAnnotationSet
implements Serializable {
    private static final String copyright = "Licensed Materials - Property of IBM\nIBM DB2 Content Manager Enterprise Edition V8 (program number 5724-B19)\n(c ) Copyright IBM Corp.  1998, 2004.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private Vector annotations = new Vector();
    private Vector annCreatedListeners = new Vector();
    private Vector annDeletedListeners = new Vector();
    private Vector annPropertiesUpdatedListeners = new Vector();
    private Vector annReorderedListeners = new Vector();
    private Vector annMovedListeners = new Vector();
    private Vector annResizedListeners = new Vector();
    private Vector annSelectedListeners = new Vector();
    private String format;
    private int position;
    private int scale = 1000;
    private double scaleFactor = 1.0;
    private int rotation = 0;
    private int imageWidth = 0;
    private int imageHeight = 0;
    private double aspectRatio = 1.0;
    private transient CMBAnnotationServices services;
    private transient CMBAnnotationEngine engine;
    private Object hAnnotationSet;
    private InputStream firstPartStream;
    private int annotationPartNumber;
    private boolean bDirty = false;
    private boolean penPending = false;
    private boolean permanentlyRotating = false;
    private boolean createPrivilegeSet = false;
    private boolean createPrivilege;
    private boolean deletePrivilegeSet = false;
    private boolean deletePrivilege;
    private boolean updatePrivilegeSet = false;
    private boolean updatePrivilege;
    private boolean viewPrivilegeSet = false;
    private boolean viewPrivilege;
    private boolean editable = true;
    private boolean visible = true;
    private CMBPageAnnotation[] selectedAnnotations = new CMBPageAnnotation[0];
    private ArrayList views = new ArrayList();
    private boolean active = true;

    CMBAnnotationSet(CMBAnnotationServices services, CMBAnnotationEngine engine, Object hEngine, String format, int position, int partNumber) throws CMBAnnotationEngineException {
        this.services = services;
        this.engine = engine;
        this.hAnnotationSet = hEngine;
        this.format = format;
        this.position = position;
        this.annotationPartNumber = partNumber;
        CMBPageAnnotation[] loadedSet = engine.getAnnotations(hEngine);
        if (loadedSet == null) {
            return;
        }
        for (int i = 0; i < loadedSet.length; ++i) {
            CMBPageAnnotation anno = loadedSet[i];
            if (anno == null) continue;
            anno.setCreationIndex(i);
            this.annotations.addElement(anno);
            anno.setAnnotationSet(this);
        }
    }

    CMBAnnotationSet(CMBAnnotationServices services, InputStream firstPartStream, String format, int partNumber) {
        this.services = services;
        this.firstPartStream = firstPartStream;
        this.format = format;
        this.annotationPartNumber = partNumber;
    }

    public boolean getCanLoadAnnotationFormat(String format) {
        if (this.engine == null) {
            return false;
        }
        return this.engine.canLoadAnnotationFormat(format);
    }

    public boolean getCanSaveAnnotationFormat(String srcFormat, String dstFormat) {
        if (this.engine == null) {
            return false;
        }
        return this.engine.canSaveAnnotationFormat(srcFormat, dstFormat);
    }

    public String getAnnotationFormat() {
        return this.format;
    }

    public int getAnnotationPosition() {
        return this.position;
    }

    public void setAnnotationPosition(int annotationPosition) {
        if (this.engine != null) {
            this.engine.setAnnotationPosition(this.hAnnotationSet, annotationPosition);
        }
        this.position = annotationPosition;
    }

    public boolean getPrivilege(int privilege) throws CMBAnnotationEngineException {
        if (this.services == null) {
            return false;
        }
        if (privilege == 8) {
            if (!this.createPrivilegeSet) {
                this.createPrivilege = this.services.getPrivilege(this, privilege);
                this.createPrivilegeSet = true;
            }
            return this.createPrivilege;
        }
        if (privilege == 62) {
            if (!this.deletePrivilegeSet) {
                this.deletePrivilege = this.services.getPrivilege(this, privilege);
                this.deletePrivilegeSet = true;
            }
            return this.deletePrivilege;
        }
        if (privilege == 50) {
            if (!this.updatePrivilegeSet) {
                this.updatePrivilege = this.services.getPrivilege(this, privilege);
                this.updatePrivilegeSet = true;
            }
            return this.updatePrivilege;
        }
        if (privilege == 7) {
            if (!this.viewPrivilegeSet) {
                this.viewPrivilege = this.services.getPrivilege(this, privilege);
                this.viewPrivilegeSet = true;
            }
            return this.viewPrivilege;
        }
        return this.services.getPrivilege(this, privilege);
    }

    public CMBPageAnnotation[] getPageAnnotations() {
        Object[] pageAnnoArray = new CMBPageAnnotation[this.annotations.size()];
        this.annotations.copyInto(pageAnnoArray);
        return pageAnnoArray;
    }

    public CMBPageAnnotation[] getPageAnnotations(int pageNum) {
        Vector<CMBPageAnnotation> pageAnnoList = new Vector<CMBPageAnnotation>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            CMBPageAnnotation pageAnno = (CMBPageAnnotation)this.annotations.elementAt(i);
            if (pageAnno.getPageNumber() != pageNum) continue;
            pageAnnoList.addElement(pageAnno);
        }
        Object[] pageAnnoArray = new CMBPageAnnotation[pageAnnoList.size()];
        pageAnnoList.copyInto(pageAnnoArray);
        return pageAnnoArray;
    }

    public int getAnnotationCount() {
        return this.annotations.size();
    }

    public int getAnnotationPartNumber() {
        return this.annotationPartNumber;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        for (int i = 0; i < size; ++i) {
            CMBPageAnnotation pageAnno = new CMBPageAnnotation();
            pageAnno = (CMBPageAnnotation)stream.readObject();
            this.annotations.addElement(pageAnno);
            pageAnno.setAnnotationSet(this);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        int size = this.annotations.size();
        stream.writeInt(size);
        for (int i = 0; i < size; ++i) {
            CMBPageAnnotation pageAnno = (CMBPageAnnotation)this.annotations.elementAt(i);
            stream.writeObject(pageAnno);
        }
    }

    public void addAnnotation(CMBPageAnnotation a) throws CMBAnnotationEngineException {
        this.addAnnotation(a, true);
    }

    void addAnnotation(CMBPageAnnotation a, boolean select) throws CMBAnnotationEngineException {
        if (!this.getPrivilege(8)) {
            return;
        }
        a.setScaleNum((int)((double)this.getScale() * this.getScaleFactor()));
        this.annotations.add(0, a);
        a.setAnnotationSet(this);
        a.setCreationIndex(0);
        if (this.engine != null) {
            this.engine.addAnnotation(this.hAnnotationSet, a, a.getPageNumber());
        }
        this.setDirty(true);
        a.setPermanentlyRotating(this.getPermanentlyRotating());
        if (this.visible) {
            a.pleaseDraw();
        } else {
            a.dontDraw();
        }
        if (select) {
            this.setSelectedAnnotation(a);
        }
        this.fireCMBAnnCreatedEvent(this.services.getActiveView(), a);
    }

    public CMBPageAnnotation removeAnnotation(CMBPageAnnotation a) throws CMBAnnotationEngineException {
        int i;
        if (a == null || !a.canDelete()) {
            return a;
        }
        int size = this.annotations.size();
        int index = this.annotations.indexOf(a);
        CMBPageAnnotation[] annotationsOnPage = this.getPageAnnotations(a.getPageNumber());
        int indexOfAnnotationOnPage = 0;
        for (i = 0; i < annotationsOnPage.length; ++i) {
            if (!a.equals(annotationsOnPage[i])) continue;
            indexOfAnnotationOnPage = i;
        }
        this.annotations.remove(index);
        a.setAnnotationSet(null);
        for (i = index; i < this.annotations.size(); ++i) {
            CMBPageAnnotation annotation = (CMBPageAnnotation)this.annotations.elementAt(i);
            annotation.setCurrentIndex(i);
        }
        if (this.engine != null) {
            this.engine.removeAnnotation(this.hAnnotationSet, a);
        }
        this.setDirty(true);
        CMBPageAnnotation nextAnno = indexOfAnnotationOnPage >= 1 ? annotationsOnPage[indexOfAnnotationOnPage - 1] : (annotationsOnPage.length >= 2 ? annotationsOnPage[1] : null);
        this.setSelectedAnnotation(nextAnno);
        this.fireCMBAnnDeletedEvent(this.services.getActiveView(), a, nextAnno);
        return nextAnno;
    }

    public void reorderAnnotation(CMBPageAnnotation a, int index) throws CMBAnnotationEngineException {
        if (a == null || !a.canUpdate() || !this.isEditable()) {
            return;
        }
        int size = this.annotations.size();
        int oldIndex = this.annotations.indexOf(a);
        this.annotations.remove(oldIndex);
        this.annotations.insertElementAt(a, index);
        a.setCurrentIndex(index);
        if (index < oldIndex) {
            for (int i = index + 1; i <= oldIndex; ++i) {
                CMBPageAnnotation annotation = (CMBPageAnnotation)this.annotations.elementAt(i);
                annotation.setCurrentIndex(i);
            }
        } else if (index > oldIndex) {
            for (int i = oldIndex; i < index; ++i) {
                CMBPageAnnotation annotation = (CMBPageAnnotation)this.annotations.elementAt(i);
                annotation.setCurrentIndex(i);
            }
        }
        if (this.engine != null) {
            this.engine.reorderAnnotation(this.hAnnotationSet, a, index);
        }
        this.setDirty(true);
        this.fireCMBAnnReorderedEvent(this.services.getActiveView(), a, oldIndex, index);
    }

    public CMBPageAnnotation getAnnotationAt(int index) {
        return (CMBPageAnnotation)this.annotations.elementAt(index);
    }

    public void updateAnnotation(CMBPageAnnotation a, int index) throws CMBAnnotationEngineException {
        if (!a.canUpdate()) {
            return;
        }
        this.annotations.setElementAt(a, index);
        if (this.engine != null) {
            this.engine.updateAnnotation(this.hAnnotationSet, a, index);
        }
        this.setDirty(true);
        this.updateViews(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAnnotations() throws CMBAnnotationEngineException {
        if (this.engine == null) {
            return;
        }
        Object[] annArray = new CMBPageAnnotation[this.annotations.size()];
        this.annotations.copyInto(annArray);
        CMBAnnotationEngine cMBAnnotationEngine = this.engine;
        synchronized (cMBAnnotationEngine) {
            this.engine.saveAnnotationSet(this.hAnnotationSet, (CMBPageAnnotation[])annArray);
        }
        this.setDirty(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream annotationStream) throws CMBAnnotationEngineException {
        if (annotationStream == null) {
            throw new NullPointerException();
        }
        if (this.engine == null) {
            return;
        }
        Object[] annArray = new CMBPageAnnotation[this.annotations.size()];
        this.annotations.copyInto(annArray);
        CMBAnnotationEngine cMBAnnotationEngine = this.engine;
        synchronized (cMBAnnotationEngine) {
            this.services.writeAnnotationStream = annotationStream;
            this.services.annotationStreamWritten = false;
            this.engine.saveAnnotationSet(this.hAnnotationSet, (CMBPageAnnotation[])annArray);
            this.services.writeAnnotationStream = null;
        }
    }

    public Iterator getIterator() {
        return this.annotations.iterator();
    }

    Iterator getReverseIterator(int pageNum) {
        Vector<CMBPageAnnotation> reverseAnnoList = new Vector<CMBPageAnnotation>();
        int size = this.annotations.size();
        for (int i = size - 1; i >= 0; --i) {
            CMBPageAnnotation anno = (CMBPageAnnotation)this.annotations.elementAt(i);
            if (pageNum == -1) {
                reverseAnnoList.addElement(anno);
                continue;
            }
            if (anno.getPageNumber() != pageNum) continue;
            reverseAnnoList.addElement(anno);
        }
        return reverseAnnoList.iterator();
    }

    public Iterator getIterator(int pageNum) {
        Vector<CMBPageAnnotation> pageAnnoList = new Vector<CMBPageAnnotation>();
        Iterator a = this.getIterator();
        while (a.hasNext()) {
            CMBPageAnnotation anno = (CMBPageAnnotation)a.next();
            if (anno.getPageNumber() != pageNum) continue;
            pageAnnoList.addElement(anno);
        }
        return pageAnnoList.iterator();
    }

    public void addAnnCreatedListener(CMBAnnotationCreatedListener listener) {
        this.annCreatedListeners.addElement(listener);
    }

    public void removeAnnCreatedListener(CMBAnnotationCreatedListener listener) {
        this.annCreatedListeners.removeElement(listener);
    }

    public void fireCMBAnnCreatedEvent(CMBAnnotationView view, CMBPageAnnotation annotation) {
        CMBAnnotationCreatedEvent annCreatedEvent = new CMBAnnotationCreatedEvent(this, view, annotation);
        for (int i = 0; i < this.annCreatedListeners.size(); ++i) {
            CMBAnnotationCreatedListener listener = (CMBAnnotationCreatedListener)this.annCreatedListeners.elementAt(i);
            listener.annotationCreated(annCreatedEvent);
        }
    }

    public void addAnnDeletedListener(CMBAnnotationDeletedListener listener) {
        this.annDeletedListeners.addElement(listener);
    }

    public void removeAnnDeletedListener(CMBAnnotationDeletedListener listener) {
        this.annDeletedListeners.removeElement(listener);
    }

    public void fireCMBAnnDeletedEvent(CMBAnnotationView view, CMBPageAnnotation annotation, CMBPageAnnotation nextAnno) {
        CMBAnnotationDeletedEvent annDeletedEvent = new CMBAnnotationDeletedEvent(this, view, annotation, nextAnno);
        for (int i = 0; i < this.annDeletedListeners.size(); ++i) {
            CMBAnnotationDeletedListener listener = (CMBAnnotationDeletedListener)this.annDeletedListeners.elementAt(i);
            listener.annotationDeleted(annDeletedEvent);
        }
    }

    public void addAnnPropertiesUpdatedListener(CMBAnnotationPropertiesUpdatedListener listener) {
        this.annPropertiesUpdatedListeners.addElement(listener);
    }

    public void removeAnnPropertiesUpdatedListener(CMBAnnotationPropertiesUpdatedListener listener) {
        this.annPropertiesUpdatedListeners.removeElement(listener);
    }

    public void fireCMBAnnPropertiesUpdatedEvent(CMBAnnotationView view, CMBPageAnnotation annotation) {
        this.fireCMBAnnPropertiesUpdatedEvent(view, annotation, annotation, annotation);
    }

    public void fireCMBAnnPropertiesUpdatedEvent(CMBAnnotationView view, CMBPageAnnotation annotation, CMBPageAnnotation oldProps, CMBPageAnnotation newProps) {
        CMBAnnotationPropertiesUpdatedEvent annPropertiesUpdatedEvent = new CMBAnnotationPropertiesUpdatedEvent(this, view, annotation, oldProps, newProps);
        for (int i = 0; i < this.annPropertiesUpdatedListeners.size(); ++i) {
            CMBAnnotationPropertiesUpdatedListener listener = (CMBAnnotationPropertiesUpdatedListener)this.annPropertiesUpdatedListeners.elementAt(i);
            listener.annotationPropertiesUpdated(annPropertiesUpdatedEvent);
        }
    }

    public void addAnnReorderedListener(CMBAnnotationReorderedListener listener) {
        this.annReorderedListeners.addElement(listener);
    }

    public void removeAnnReorderedListener(CMBAnnotationReorderedListener listener) {
        this.annReorderedListeners.removeElement(listener);
    }

    public void fireCMBAnnReorderedEvent(CMBAnnotationView view, CMBPageAnnotation annotation, int origIndex, int newIndex) {
        CMBAnnotationReorderedEvent annReorderedEvent = new CMBAnnotationReorderedEvent(this, view, annotation, origIndex, newIndex);
        for (int i = 0; i < this.annReorderedListeners.size(); ++i) {
            CMBAnnotationReorderedListener listener = (CMBAnnotationReorderedListener)this.annReorderedListeners.elementAt(i);
            listener.annotationReordered(annReorderedEvent);
        }
    }

    public void addAnnMovedListener(CMBAnnotationMovedListener listener) {
        this.annMovedListeners.addElement(listener);
    }

    public void removeAnnMovedListener(CMBAnnotationMovedListener listener) {
        this.annMovedListeners.removeElement(listener);
    }

    public void fireCMBAnnMovedEvent(CMBAnnotationView view, CMBPageAnnotation annotation, Point newPoint, Point oldPoint) {
        CMBAnnotationMovedEvent annMovedEvent = new CMBAnnotationMovedEvent(this, view, annotation, newPoint, oldPoint);
        for (int i = 0; i < this.annMovedListeners.size(); ++i) {
            CMBAnnotationMovedListener listener = (CMBAnnotationMovedListener)this.annMovedListeners.elementAt(i);
            listener.annotationMoved(annMovedEvent);
        }
    }

    public void addAnnResizedListener(CMBAnnotationResizedListener listener) {
        this.annResizedListeners.addElement(listener);
    }

    public void removeAnnResizedListener(CMBAnnotationResizedListener listener) {
        this.annResizedListeners.removeElement(listener);
    }

    public void fireCMBAnnResizedEvent(CMBAnnotationView view, CMBPageAnnotation annotation, Point deltaSize, Point oldSize) {
        CMBAnnotationResizedEvent annResizedEvent = new CMBAnnotationResizedEvent(this, view, annotation, deltaSize, oldSize);
        for (int i = 0; i < this.annResizedListeners.size(); ++i) {
            CMBAnnotationResizedListener listener = (CMBAnnotationResizedListener)this.annResizedListeners.elementAt(i);
            listener.annotationResized(annResizedEvent);
        }
    }

    public void addAnnSelectedListener(CMBAnnotationSelectedListener listener) {
        this.annSelectedListeners.addElement(listener);
    }

    public void removeAnnSelectedListener(CMBAnnotationSelectedListener listener) {
        this.annSelectedListeners.removeElement(listener);
    }

    public void fireCMBAnnSelectedEvent(CMBAnnotationView view, CMBPageAnnotation annotation) {
        CMBAnnotationSelectedEvent annSelectedEvent = new CMBAnnotationSelectedEvent(this, view, annotation);
        for (int i = 0; i < this.annSelectedListeners.size(); ++i) {
            CMBAnnotationSelectedListener listener = (CMBAnnotationSelectedListener)this.annSelectedListeners.elementAt(i);
            listener.annotationSelected(annSelectedEvent);
        }
    }

    private void fireCMBAnnSelectedEvent(CMBAnnotationView view, CMBPageAnnotation[] selectedAnnotations, CMBPageAnnotation[] previousSelection) {
        CMBAnnotationSelectedEvent annSelectedEvent = new CMBAnnotationSelectedEvent(this, view, selectedAnnotations, previousSelection);
        for (int i = 0; i < this.annSelectedListeners.size(); ++i) {
            CMBAnnotationSelectedListener listener = (CMBAnnotationSelectedListener)this.annSelectedListeners.elementAt(i);
            listener.annotationSelected(annSelectedEvent);
        }
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
        for (CMBPageAnnotation a : this.annotations) {
            a.setRotation(rotation);
        }
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation, int pageNumber) {
        this.rotation = rotation;
        Iterator i = this.getIterator(pageNumber);
        while (i.hasNext()) {
            CMBPageAnnotation a = (CMBPageAnnotation)i.next();
            a.setRotation(rotation);
        }
    }

    public void rotate(int rotation, int pageNumber) {
        Iterator i = this.getIterator(pageNumber);
        while (i.hasNext()) {
            CMBPageAnnotation a = (CMBPageAnnotation)i.next();
            a.rotate(rotation);
        }
        this.setDirty(true);
    }

    public boolean getPermanentlyRotating() {
        return this.permanentlyRotating;
    }

    public void setPermanentlyRotating(boolean permanentlyRotating) {
        this.permanentlyRotating = permanentlyRotating;
        for (CMBPageAnnotation a : this.annotations) {
            a.setPermanentlyRotating(permanentlyRotating);
        }
    }

    public void setScaleFactor(double factor) {
        this.scaleFactor = factor;
        this.setScale(this.scale);
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScale(int s) {
        if (s == 0) {
            throw new IllegalArgumentException(PAnnotationUtilities.getMessage("Annotation.invalidScale"));
        }
        this.scale = s;
        for (CMBPageAnnotation a : this.annotations) {
            int originalScale = a.getScaleNum();
            a.setScaleNum((int)((double)this.scale * this.scaleFactor));
        }
    }

    public int getScale() {
        return this.scale;
    }

    public void setImageSize(int wd, int ht, int pageNumber) {
        double s = (double)this.getScale() * this.getScaleFactor() / 1000.0;
        this.imageWidth = (int)((double)wd / s);
        this.imageHeight = (int)((double)ht / s);
        this.drawAreaSizeChanged(this.imageWidth, this.imageHeight, pageNumber);
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    double getImageAspectRatio() {
        return this.aspectRatio;
    }

    public void setDirty(boolean bAnnoDirty) {
        this.bDirty = bAnnoDirty;
    }

    public boolean isDirty() {
        return this.bDirty;
    }

    public boolean isCorrupt() {
        for (CMBPageAnnotation a : this.annotations) {
            if (!a.isCorrupt()) continue;
            return true;
        }
        return false;
    }

    public boolean isEditable() {
        return this.editable;
    }

    void setEditable(boolean editable) {
        this.editable = editable;
        for (int i = 0; i < this.views.size(); ++i) {
            CMBAnnotationView view = (CMBAnnotationView)this.views.get(i);
            view.setActionsEnabled(editable);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    void setVisible(boolean visible) {
        this.visible = visible;
        if (visible) {
            Iterator i = this.getIterator();
            while (i.hasNext()) {
                CMBPageAnnotation a = (CMBPageAnnotation)i.next();
                if (a.canShow()) {
                    a.pleaseDraw();
                    continue;
                }
                a.dontDraw();
            }
        } else {
            Iterator i = this.getIterator();
            while (i.hasNext()) {
                CMBPageAnnotation a = (CMBPageAnnotation)i.next();
                if (!a.canHide()) continue;
                a.dontDraw();
            }
        }
    }

    private void drawAreaSizeChanged(int w, int h, int pageNumber) {
        CMBPageAnnotation a = null;
        Iterator i = this.getIterator(pageNumber);
        while (i.hasNext()) {
            a = (CMBPageAnnotation)i.next();
            a.setImageWidth(w);
            a.setImageHeight(h);
        }
    }

    public CMBPageAnnotation[] getSelectedAnnotations() {
        return this.selectedAnnotations;
    }

    public void setSelectedAnnotations(CMBPageAnnotation[] selectedAnnotations) {
        int i;
        CMBPageAnnotation[] previousSelection = this.selectedAnnotations;
        this.selectedAnnotations = selectedAnnotations;
        for (i = 0; i < previousSelection.length; ++i) {
            previousSelection[i].showHandles(false);
            previousSelection[i].setInMotion(false);
        }
        for (i = 0; i < selectedAnnotations.length; ++i) {
            selectedAnnotations[i].showHandles(true);
            selectedAnnotations[i].setInMotion(false);
        }
        this.fireCMBAnnSelectedEvent(this.services.getActiveView(), selectedAnnotations, previousSelection);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        this.updateViews(null);
    }

    void setSelectedAnnotation(CMBPageAnnotation selectedAnnotation) {
        if (selectedAnnotation == null) {
            this.setSelectedAnnotations(new CMBPageAnnotation[0]);
        } else {
            this.setSelectedAnnotations(new CMBPageAnnotation[]{selectedAnnotation});
        }
    }

    CMBAnnotationEngine getAnnotationEngine() {
        return this.engine;
    }

    Object getAnnotationSetHandle() {
        return this.hAnnotationSet;
    }

    public void dispose() {
        if (this.hAnnotationSet != null) {
            if (this.annotations != null) {
                int size = this.annotations.size();
                for (int i = 0; i < size; ++i) {
                    if (this.annotations.elementAt(i) == null) continue;
                    ((CMBPageAnnotation)this.annotations.elementAt(i)).dispose();
                }
                this.annotations.clear();
            }
            this.engine.dropAnnotationSet(this.hAnnotationSet);
            this.hAnnotationSet = null;
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer("CMBAnnotationSet: [");
        int size = this.annotations.size();
        for (int i = 0; i < size; ++i) {
            CMBPageAnnotation anno = (CMBPageAnnotation)this.annotations.elementAt(i);
            s.append(anno + "\n");
        }
        s.append("]");
        return s.toString();
    }

    public CMBAnnotationServices getAnnotationServices() {
        return this.services;
    }

    void addView(CMBAnnotationView view) {
        if (!this.views.contains(view)) {
            this.views.add(view);
        }
    }

    void removeView(CMBAnnotationView view) {
        if (this.views.contains(view)) {
            this.views.remove(view);
        }
    }

    void updateViews(CMBPageAnnotation annotation) {
        if (annotation != null) {
            for (int i = 0; i < this.views.size(); ++i) {
                CMBAnnotationView view = (CMBAnnotationView)this.views.get(i);
                if (view.getCurrentPage() != annotation.getPageNumber()) continue;
                view.refreshEntireDrawArea();
            }
        } else {
            for (int i = 0; i < this.views.size(); ++i) {
                CMBAnnotationView view = (CMBAnnotationView)this.views.get(i);
                view.refreshEntireDrawArea();
            }
        }
    }

    void updateComponentUI() {
        for (int i = 0; i < this.views.size(); ++i) {
            CMBAnnotationView view = (CMBAnnotationView)this.views.get(i);
            view.updateComponentUI();
        }
    }

    boolean isPenPending() {
        return this.penPending;
    }

    void setPenPending(boolean penPending) {
        this.penPending = penPending;
    }
}

