/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer.annotation;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.annotation.CMBAnnotationConstants;
import com.ibm.mm.viewer.annotation.CMBAnnotationDefaultsChangedEvent;
import com.ibm.mm.viewer.annotation.CMBAnnotationDefaultsChangedListener;
import com.ibm.mm.viewer.annotation.CMBAnnotationEngine;
import com.ibm.mm.viewer.annotation.CMBAnnotationEngineCallbacks;
import com.ibm.mm.viewer.annotation.CMBAnnotationEngineException;
import com.ibm.mm.viewer.annotation.CMBAnnotationHelpListener;
import com.ibm.mm.viewer.annotation.CMBAnnotationServicesCallbacks;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import com.ibm.mm.viewer.annotation.CMBAnnotationView;
import com.ibm.mm.viewer.annotation.CMBArrowAnnotation;
import com.ibm.mm.viewer.annotation.CMBCircleAnnotation;
import com.ibm.mm.viewer.annotation.CMBHighlightAnnotation;
import com.ibm.mm.viewer.annotation.CMBLineAnnotation;
import com.ibm.mm.viewer.annotation.CMBNoteAnnotation;
import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import com.ibm.mm.viewer.annotation.CMBPenAnnotation;
import com.ibm.mm.viewer.annotation.CMBRectAnnotation;
import com.ibm.mm.viewer.annotation.CMBSelectedAnnotationToolChangedEvent;
import com.ibm.mm.viewer.annotation.CMBSelectedAnnotationToolChangedListener;
import com.ibm.mm.viewer.annotation.CMBStampAnnotation;
import com.ibm.mm.viewer.annotation.CMBTextAnnotation;
import com.ibm.mm.viewer.annotation.PAnnotationUtilities;
import com.ibm.mm.viewer.annotation.PPropertiesDialog;
import com.ibm.mm.viewer.annotation.PStampImageProvider;
import com.ibm.mm.viewer.annotation.PStampSelectDialog;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class CMBAnnotationServices {
    private static final String copyright = "Licensed Materials - Property of IBM\nIBM DB2 Content Manager Enterprise Edition V8 (program number 5724-B19)\n(c ) Copyright IBM Corp.  1998, 2004.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private Properties engineProperties;
    private Vector annotationSets = new Vector();
    private Vector hAnnotationSets = new Vector();
    private Vector engines = null;
    private Vector annotationHelpListeners = new Vector();
    private Vector annotationDefaultsListeners = new Vector();
    private Vector annotationToolListeners = new Vector();
    private CMBAnnotationServicesCallbacks servicesCallbacks;
    private JPopupMenu annoPopupMenu = null;
    private int annotationTool = 0;
    private boolean annotationToolSticky = false;
    private CMBAnnotationView activeView;
    private int mode = 3;
    OutputStream writeAnnotationStream = null;
    boolean annotationStreamWritten = false;
    private PPropertiesDialog propertiesDialog = null;
    private PStampSelectDialog stampSelectDialog = null;
    private CMBStampAnnotation selectedStamp;
    private static Cursor[] cursorArray;
    String customAnnoClassName = null;
    private transient PStampImageProvider stampImageProvider;

    public CMBAnnotationServices() {
        this._init(new CMBAnnotationServicesCallbacks(){}, null);
    }

    public CMBAnnotationServices(CMBAnnotationServicesCallbacks callbacks) {
        this._init(callbacks, null);
        this.servicesCallbacks = callbacks;
    }

    public CMBAnnotationServices(CMBAnnotationServicesCallbacks callbacks, Properties engineProperties) {
        this._init(callbacks, engineProperties);
    }

    private void _init(CMBAnnotationServicesCallbacks callbacks, Properties engineProperties) {
        block4: {
            this.servicesCallbacks = callbacks;
            try {
                if (engineProperties == null || engineProperties != null && engineProperties.get("ANNOTATION_ENGINES") == null) {
                    engineProperties = new Properties();
                    InputStream defaultConfigStream = this.getClass().getClassLoader().getResourceAsStream("com/ibm/mm/viewer/annotation/cmbannotationengine.properties");
                    engineProperties.load(defaultConfigStream);
                    if (this.traceEnabled()) {
                        this.trace("Default engine properties used from com/ibm/mm/viewer/annotation/cmbannotationengine.properties");
                    }
                }
            }
            catch (IOException e) {
                if (!this.traceEnabled()) break block4;
                this.trace("IO exception loading properties from com/ibm/mm/viewer/annotation/cmbannotationengine.properties");
            }
        }
        this.engineProperties = engineProperties;
    }

    public Properties getEngineProperties() {
        return this.engineProperties;
    }

    public void setEngineProperties(Properties engineProperties) {
        this.engineProperties = engineProperties;
    }

    public synchronized CMBAnnotationSet[] getAllAnnotationSets() {
        Object[] annArray = new CMBAnnotationSet[this.annotationSets.size()];
        this.annotationSets.copyInto(annArray);
        return annArray;
    }

    public synchronized CMBAnnotationSet getAnnotationSet(int index) throws ArrayIndexOutOfBoundsException {
        return (CMBAnnotationSet)this.annotationSets.elementAt(index);
    }

    public synchronized CMBAnnotationSet loadAnnotationSet(InputStream annotationStream, String format, int annotationPosition, int numOfParts, int partNumber) throws ClassNotFoundException, IllegalAccessException, InstantiationException, CMBAnnotationEngineException {
        if (this.engines == null) {
            this.loadEngines();
        }
        CMBAnnotationSet annotationSet = null;
        if (this.traceEnabled()) {
            this.trace("annotation format is " + format + ", anno Pos:" + annotationPosition + ", number of parts:" + numOfParts + ", part number:" + partNumber);
        }
        int engineCount = this.engines.size();
        for (int i = 0; i < engineCount && annotationSet == null; ++i) {
            Object engineSet;
            CMBAnnotationEngine engine = (CMBAnnotationEngine)this.engines.elementAt(i);
            if (engine == null || !engine.canLoadAnnotationFormat(format)) continue;
            if (this.traceEnabled()) {
                this.trace("Engine " + engine.getClass().getName() + " can load annotation format:" + format);
            }
            if ((engineSet = engine.loadAnnotationSet(annotationStream, format, annotationPosition, numOfParts, partNumber)) != null) {
                annotationSet = new CMBAnnotationSet(this, engine, engineSet, format, annotationPosition, partNumber);
                for (int j = 0; j < annotationSet.getAnnotationCount(); ++j) {
                    CMBPageAnnotation annotation = annotationSet.getAnnotationAt(j);
                    annotation.showHandles(false);
                }
            }
            if (!this.traceEnabled()) continue;
            this.trace("Engine load annotation set completed :" + annotationSet);
        }
        if (annotationSet == null) {
            if (this.traceEnabled()) {
                this.trace("None of the engines can load this annotation format :" + format);
            }
            annotationSet = new CMBAnnotationSet(this, annotationStream, format, partNumber);
        }
        this.annotationSets.addElement(annotationSet);
        this.hAnnotationSets.addElement(null);
        return annotationSet;
    }

    public synchronized void saveAllAnnotationSets() throws CMBAnnotationEngineException {
        CMBAnnotationSet annSet = null;
        for (int i = 0; i < this.annotationSets.size(); ++i) {
            annSet = (CMBAnnotationSet)this.annotationSets.elementAt(i);
            this.saveAnnotationSet(annSet);
        }
    }

    public synchronized void saveAnnotationSet(CMBAnnotationSet annSet) throws CMBAnnotationEngineException {
        if (annSet != null) {
            annSet.saveAnnotations();
        }
    }

    public synchronized void dropAllAnnotationSets() {
        while (this.annotationSets.size() > 0) {
            CMBAnnotationSet annSet = (CMBAnnotationSet)this.annotationSets.elementAt(0);
            this.dropAnnotationSet(annSet);
        }
    }

    public synchronized void dropAnnotationSet(CMBAnnotationSet annSet) {
        int index = this.annotationSets.indexOf(annSet);
        if (index >= 0) {
            annSet.dispose();
            annSet = null;
            this.annotationSets.removeElementAt(index);
            this.hAnnotationSets.removeElementAt(index);
        }
    }

    public synchronized void setItemHandle(CMBAnnotationSet annSet, Object handle) {
        int size = this.annotationSets.size();
        for (int i = 0; i < size; ++i) {
            if (!this.annotationSets.elementAt(i).equals(annSet)) continue;
            this.hAnnotationSets.setElementAt(handle, i);
        }
    }

    public synchronized Object getItemHandle(CMBAnnotationSet annSet) {
        int size = this.annotationSets.size();
        for (int i = 0; i < size; ++i) {
            if (!this.annotationSets.elementAt(i).equals(annSet)) continue;
            return this.hAnnotationSets.elementAt(i);
        }
        return null;
    }

    public synchronized CMBAnnotationSet getAnnotationSet(Object hItem) {
        int size = this.hAnnotationSets.size();
        for (int i = 0; i < size; ++i) {
            Object hAnnSet = this.hAnnotationSets.elementAt(i);
            if (!hAnnSet.equals(hItem)) continue;
            CMBAnnotationSet annSet = (CMBAnnotationSet)this.annotationSets.elementAt(i);
            return annSet;
        }
        return null;
    }

    public boolean getPrivilege(CMBAnnotationSet annoSet, int privilegeID) throws CMBAnnotationEngineException {
        boolean bPrivilege = false;
        if (this.servicesCallbacks != null) {
            bPrivilege = this.servicesCallbacks.getPrivilege(annoSet, privilegeID);
        }
        return bPrivilege;
    }

    public synchronized void terminate() {
        this.dropAllAnnotationSets();
        if (this.engines != null) {
            int size = this.engines.size();
            for (int i = 0; i < size; ++i) {
                CMBAnnotationEngine engine = (CMBAnnotationEngine)this.engines.elementAt(i);
                engine.terminate();
                Object var3_3 = null;
            }
            this.engines.removeAllElements();
            this.engines = null;
        }
        this.annotationHelpListeners.clear();
        this.annotationDefaultsListeners.clear();
        this.annotationToolListeners.clear();
        this.annotationSets.clear();
        this.hAnnotationSets.clear();
        this.annoPopupMenu = null;
        if (this.propertiesDialog != null) {
            this.propertiesDialog.dispose();
        }
        this.propertiesDialog = null;
        if (this.stampSelectDialog != null) {
            this.stampSelectDialog.dispose();
        }
        this.stampSelectDialog = null;
    }

    boolean traceEnabled() {
        return this.servicesCallbacks.traceEnabled();
    }

    void trace(String message) {
        this.servicesCallbacks.trace(message);
    }

    public boolean getCanLoadAnnotationFormat(String format) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (this.engines == null) {
            this.loadEngines();
        }
        int engineCount = this.engines.size();
        for (int i = 0; i < engineCount; ++i) {
            CMBAnnotationEngine engine = (CMBAnnotationEngine)this.engines.elementAt(i);
            if (engine == null || !engine.canLoadAnnotationFormat(format)) continue;
            if (this.traceEnabled()) {
                this.trace("Engine " + engine.getClass().getName() + " can load annotation format:" + format);
            }
            return true;
        }
        return false;
    }

    public void addAnnotationDefaultsChangedListener(CMBAnnotationDefaultsChangedListener listener) {
        this.annotationDefaultsListeners.addElement(listener);
    }

    public void removeAnnotationDefaultsChangedListener(CMBAnnotationDefaultsChangedListener listener) {
        this.annotationDefaultsListeners.removeElement(listener);
    }

    void fireCMBAnnotationDefaultsChangedEvent(Class annotationClassName) {
        CMBAnnotationDefaultsChangedEvent e = new CMBAnnotationDefaultsChangedEvent(this, annotationClassName);
        for (int i = 0; i < this.annotationDefaultsListeners.size(); ++i) {
            CMBAnnotationDefaultsChangedListener l = (CMBAnnotationDefaultsChangedListener)this.annotationDefaultsListeners.elementAt(i);
            l.annotationDefaultsChanged(e);
        }
    }

    public void removeAnnotationToolListener(CMBSelectedAnnotationToolChangedListener listener) {
        this.annotationToolListeners.removeElement(listener);
    }

    public void addAnnotationToolListener(CMBSelectedAnnotationToolChangedListener listener) {
        this.annotationToolListeners.addElement(listener);
    }

    void fireCMBSelectedToolChangedEvent(int annotationTool) {
        CMBSelectedAnnotationToolChangedEvent e = new CMBSelectedAnnotationToolChangedEvent(this, annotationTool, this.activeView != null ? this.activeView.getModel() : null, this.activeView);
        for (int i = 0; i < this.annotationToolListeners.size(); ++i) {
            CMBSelectedAnnotationToolChangedListener l = (CMBSelectedAnnotationToolChangedListener)this.annotationToolListeners.elementAt(i);
            l.annotationToolChanged(e);
        }
    }

    public int getSelectedAnnotationTool() {
        return this.annotationTool;
    }

    public void setSelectedAnnotationTool(int newTool) {
        if (newTool == this.annotationTool) {
            return;
        }
        this.annotationTool = newTool;
        this.fireCMBSelectedToolChangedEvent(this.annotationTool);
    }

    public void prepareToAddAnnotation(int annoType, int pageNumber) {
        boolean stampSelected;
        if (annoType == 8 && !(stampSelected = this.selectStampAnnotation())) {
            this.setSelectedAnnotationTool(0);
            return;
        }
        this.setMode(4);
        this.setSelectedAnnotationTool(annoType);
        this.setCurrentPageNumber(pageNumber);
    }

    private boolean selectStampAnnotation() {
        this.selectedStamp = new CMBStampAnnotation(new Rectangle());
        CMBAnnotationSet selectedStampAnnotationSet = new CMBAnnotationSet(this, null, null, 0);
        this.selectedStamp.setAnnotationSet(selectedStampAnnotationSet);
        this.selectedStamp.addAnnotationDefaultsChangedListener(new CMBAnnotationDefaultsChangedListener(){

            public void annotationDefaultsChanged(CMBAnnotationDefaultsChangedEvent e) {
                CMBAnnotationServices.this.fireCMBAnnotationDefaultsChangedEvent(e.getAnnotationClassName());
            }
        });
        this.selectedStamp.setDummyStamp(true);
        if (this.stampSelectDialog == null) {
            this.stampSelectDialog = new PStampSelectDialog(this.activeView == null ? null : this.activeView.getOwningFrame(), this);
        }
        this.stampSelectDialog.setAnnotation(this.selectedStamp);
        this.stampSelectDialog.setLocationRelativeTo(this.activeView == null ? null : this.activeView.getOwningFrame());
        this.stampSelectDialog.setVisible(true);
        if (!this.stampSelectDialog.isOkPressed()) {
            this.selectedStamp = null;
            this.setMode(3);
            return false;
        }
        this.selectedStamp.setDummyStamp(false);
        this.selectedStamp.setInMotion(false);
        return true;
    }

    CMBStampAnnotation getSelectedStamp() {
        return this.selectedStamp;
    }

    public void prepareToAddAnnotation(int annoType, String className, int pageNumber) {
        this.customAnnoClassName = className;
        this.prepareToAddAnnotation(annoType, pageNumber);
    }

    String getCustomAnnoClassName() {
        return this.customAnnoClassName;
    }

    public void setCurrentPageNumber(int pageNumber) {
        if (this.activeView != null) {
            this.activeView.setCurrentPage(pageNumber);
        }
    }

    public void setIdleDrawingMode() {
        if (this.mode == 3) {
            if (this.getSelectedAnnotationTool() != 0) {
                this.setSelectedAnnotationTool(0);
            }
            return;
        }
        this.setMode(3);
        this.setSelectedAnnotationTool(0);
    }

    public void setSelectAreaMode() {
        this.setMode(112);
        this.setSelectedAnnotationTool(21);
    }

    public boolean isSelectAreaMode() {
        return this.getMode() == 112;
    }

    public void setEraseMode() {
        this.setMode(5);
        this.setSelectedAnnotationTool(20);
    }

    public CMBPageAnnotation getSelectedAnnotation() {
        if (this.activeView == null) {
            return null;
        }
        CMBPageAnnotation[] selectedAnnotations = this.activeView.getModel().getSelectedAnnotations();
        if (selectedAnnotations.length == 0) {
            return null;
        }
        return selectedAnnotations[0];
    }

    public void setSelectedAnnotation(CMBPageAnnotation a) throws IllegalArgumentException {
        if (this.activeView == null) {
            return;
        }
        CMBAnnotationSet annoSet = this.activeView.getModel();
        if (a == null) {
            annoSet.setSelectedAnnotations(new CMBPageAnnotation[0]);
            return;
        }
        if (annoSet == null || annoSet.getPageAnnotations().length <= 0 || !Arrays.asList(annoSet.getPageAnnotations()).contains(a)) {
            throw new IllegalArgumentException();
        }
        annoSet.setSelectedAnnotations(new CMBPageAnnotation[]{a});
    }

    public void addAnnotation(CMBPageAnnotation a) throws CMBAnnotationEngineException {
        if (this.activeView != null) {
            this.activeView.getModel().addAnnotation(a);
        }
    }

    public void removeAnnotation(CMBPageAnnotation a) throws CMBAnnotationEngineException {
        if (a.getAnnotationSet() == null) {
            return;
        }
        a.getAnnotationSet().removeAnnotation(a);
    }

    public void reorderAnnotation(CMBPageAnnotation a, int index) throws CMBAnnotationEngineException {
        if (a.getAnnotationSet() == null) {
            return;
        }
        a.getAnnotationSet().reorderAnnotation(a, index);
    }

    public void hideAllAnnotations() {
        for (CMBAnnotationSet model : this.annotationSets) {
            model.setVisible(false);
            model.setSelectedAnnotations(new CMBPageAnnotation[0]);
        }
    }

    public void showAllAnnotations() {
        for (CMBAnnotationSet model : this.annotationSets) {
            model.setVisible(true);
        }
    }

    public void changeAnnotationProperties(CMBPageAnnotation a) {
        boolean editable;
        boolean bl = editable = a.canUpdate() && (a.getAnnotationSet() == null || a.getAnnotationSet().isEditable());
        if (editable) {
            a.addAnnotationDefaultsChangedListener(new CMBAnnotationDefaultsChangedListener(){

                public void annotationDefaultsChanged(CMBAnnotationDefaultsChangedEvent e) {
                    CMBAnnotationServices.this.fireCMBAnnotationDefaultsChangedEvent(e.getAnnotationClassName());
                }
            });
            CMBPageAnnotation oldProps = (CMBPageAnnotation)a.clone();
            boolean ok = this.showPropertiesDialog(a);
            if (ok) {
                CMBPageAnnotation newProps = (CMBPageAnnotation)a.clone();
                if (a.getAnnotationSet() != null) {
                    a.getAnnotationSet().fireCMBAnnPropertiesUpdatedEvent(this.activeView, a, oldProps, newProps);
                }
                if (this.activeView != null) {
                    this.activeView.refreshSlightlyBiggerRect(a.getRefreshRect());
                }
            }
        } else {
            this.showPropertiesDialog(a);
        }
    }

    boolean showPropertiesDialog(CMBPageAnnotation a) {
        Frame owningFrame = null;
        if (this.activeView != null) {
            owningFrame = this.activeView.getOwningFrame();
        }
        if (this.propertiesDialog == null) {
            this.propertiesDialog = new PPropertiesDialog(owningFrame, false);
            if (!this.annotationHelpListeners.isEmpty()) {
                int size = this.annotationHelpListeners.size();
                for (int i = 0; i < size; ++i) {
                    this.propertiesDialog.addAnnHelpListener((CMBAnnotationHelpListener)this.annotationHelpListeners.elementAt(i));
                }
            }
        }
        this.propertiesDialog.setEditable(a.canUpdate() && (a.getAnnotationSet() == null || a.getAnnotationSet().isEditable()));
        this.propertiesDialog.setAnnotation(a);
        this.propertiesDialog.setLocationRelativeTo(owningFrame);
        this.propertiesDialog.setVisible(true);
        return this.propertiesDialog.isOkPressed();
    }

    public void setPopupMenu(Object popupmenu) {
        if (popupmenu instanceof JPopupMenu) {
            this.annoPopupMenu = (JPopupMenu)popupmenu;
        }
    }

    JPopupMenu getPopupMenu() {
        return this.annoPopupMenu;
    }

    public void updateComponentUI() {
        if (this.propertiesDialog != null) {
            SwingUtilities.updateComponentTreeUI(this.propertiesDialog);
        }
        if (this.stampSelectDialog != null) {
            SwingUtilities.updateComponentTreeUI(this.stampSelectDialog);
        }
        for (int i = 0; i < this.annotationSets.size(); ++i) {
            CMBAnnotationSet annoSet = (CMBAnnotationSet)this.annotationSets.get(i);
            annoSet.updateComponentUI();
        }
        if (this.annoPopupMenu != null) {
            this.annoPopupMenu.updateUI();
        }
    }

    public CMBAnnotationView prepareAnnotationView(JComponent viewcomponent, CMBAnnotationSet annotationSet) {
        CMBAnnotationView view = new CMBAnnotationView(annotationSet);
        view.setViewComponent(viewcomponent);
        this.setAnnotationView(view, annotationSet);
        return view;
    }

    public void setAnnotationView(CMBAnnotationView view, CMBAnnotationSet annoSet) {
        if (view.getModel() != annoSet) {
            view.setModel(annoSet);
            Iterator annos = annoSet.getIterator();
            while (annos.hasNext()) {
                CMBPageAnnotation a = (CMBPageAnnotation)annos.next();
                a.addAnnotationPropertiesListener(view);
            }
            view.refreshEntireDrawArea();
        }
        this.setActiveAnnotationView(view);
    }

    void setActiveAnnotationView(CMBAnnotationView view) {
        this.activeView = view;
    }

    CMBAnnotationView getActiveAnnotationView() {
        return this.activeView;
    }

    public void setAnnotationSetEditable(CMBAnnotationSet annSet, boolean editable) {
        int index = this.annotationSets.indexOf(annSet);
        if (index >= 0) {
            annSet.setEditable(editable);
        }
    }

    public void setAnnotationToolSticky(boolean sticky) {
        this.annotationToolSticky = sticky;
    }

    boolean isAnnotationToolSticky() {
        return this.annotationToolSticky;
    }

    public void addAnnHelpListener(CMBAnnotationHelpListener listener) {
        if (this.propertiesDialog != null) {
            this.propertiesDialog.addAnnHelpListener(listener);
        } else {
            this.annotationHelpListeners.addElement(listener);
        }
    }

    public void removeAnnHelpListener(CMBAnnotationHelpListener listener) {
        if (this.propertiesDialog != null) {
            this.propertiesDialog.removeAnnHelpListener(listener);
        }
        this.annotationHelpListeners.removeElement(listener);
    }

    public void setDefaultAnnotationProperties(Properties properties) {
        CMBArrowAnnotation.setDefaultAnnotationProperties(properties);
        CMBCircleAnnotation.setDefaultAnnotationProperties(properties);
        CMBHighlightAnnotation.setDefaultAnnotationProperties(properties);
        CMBLineAnnotation.setDefaultAnnotationProperties(properties);
        CMBNoteAnnotation.setDefaultAnnotationProperties(properties);
        CMBPenAnnotation.setDefaultAnnotationProperties(properties);
        CMBRectAnnotation.setDefaultAnnotationProperties(properties);
        CMBStampAnnotation.setDefaultAnnotationProperties(properties);
        CMBTextAnnotation.setDefaultAnnotationProperties(properties);
    }

    public void setDefaultAnnotationProperties(Class propClass, Properties properties) {
        if (propClass.equals(CMBArrowAnnotation.class)) {
            CMBArrowAnnotation.setDefaultAnnotationProperties(properties);
        } else if (propClass.equals(CMBCircleAnnotation.class)) {
            CMBCircleAnnotation.setDefaultAnnotationProperties(properties);
        } else if (propClass.equals(CMBHighlightAnnotation.class)) {
            CMBHighlightAnnotation.setDefaultAnnotationProperties(properties);
        } else if (propClass.equals(CMBLineAnnotation.class)) {
            CMBLineAnnotation.setDefaultAnnotationProperties(properties);
        } else if (propClass.equals(CMBNoteAnnotation.class)) {
            CMBNoteAnnotation.setDefaultAnnotationProperties(properties);
        } else if (propClass.equals(CMBPenAnnotation.class)) {
            CMBPenAnnotation.setDefaultAnnotationProperties(properties);
        } else if (propClass.equals(CMBRectAnnotation.class)) {
            CMBRectAnnotation.setDefaultAnnotationProperties(properties);
        } else if (propClass.equals(CMBStampAnnotation.class)) {
            CMBStampAnnotation.setDefaultAnnotationProperties(properties);
        } else if (propClass.equals(CMBTextAnnotation.class)) {
            CMBTextAnnotation.setDefaultAnnotationProperties(properties);
        }
    }

    public void getDefaultAnnotationProperties(Properties properties) {
        CMBArrowAnnotation.getDefaultAnnotationProperties(properties);
        CMBCircleAnnotation.getDefaultAnnotationProperties(properties);
        CMBHighlightAnnotation.getDefaultAnnotationProperties(properties);
        CMBLineAnnotation.getDefaultAnnotationProperties(properties);
        CMBNoteAnnotation.getDefaultAnnotationProperties(properties);
        CMBPenAnnotation.getDefaultAnnotationProperties(properties);
        CMBRectAnnotation.getDefaultAnnotationProperties(properties);
        CMBStampAnnotation.getDefaultAnnotationProperties(properties);
        CMBTextAnnotation.getDefaultAnnotationProperties(properties);
    }

    public void getDefaultAnnotationProperties(Class propClass, Properties properties) {
        if (propClass.equals(CMBArrowAnnotation.class)) {
            CMBArrowAnnotation.getDefaultAnnotationProperties(properties);
        } else if (propClass.equals(CMBCircleAnnotation.class)) {
            CMBCircleAnnotation.getDefaultAnnotationProperties(properties);
        } else if (propClass.equals(CMBHighlightAnnotation.class)) {
            CMBHighlightAnnotation.getDefaultAnnotationProperties(properties);
        } else if (propClass.equals(CMBLineAnnotation.class)) {
            CMBLineAnnotation.getDefaultAnnotationProperties(properties);
        } else if (propClass.equals(CMBNoteAnnotation.class)) {
            CMBNoteAnnotation.getDefaultAnnotationProperties(properties);
        } else if (propClass.equals(CMBPenAnnotation.class)) {
            CMBPenAnnotation.getDefaultAnnotationProperties(properties);
        } else if (propClass.equals(CMBRectAnnotation.class)) {
            CMBRectAnnotation.getDefaultAnnotationProperties(properties);
        } else if (propClass.equals(CMBStampAnnotation.class)) {
            CMBStampAnnotation.getDefaultAnnotationProperties(properties);
        } else if (propClass.equals(CMBTextAnnotation.class)) {
            CMBTextAnnotation.getDefaultAnnotationProperties(properties);
        }
    }

    Cursor getHandleCursor(int handleId) {
        if (cursorArray == null) {
            this.createHandleCursors();
        }
        return cursorArray[handleId];
    }

    private void createHandleCursors() {
        String methodName = "createHandleCursors";
        cursorArray = new Cursor[10];
        try {
            Cursor tb_cursor = this.createCustomCursor(CMBAnnotationConstants.HANDLE_CURSOR[0], CMBAnnotationConstants.HANDLE_HOTSPOT);
            if (tb_cursor != null) {
                CMBAnnotationServices.cursorArray[0] = tb_cursor;
                CMBAnnotationServices.cursorArray[4] = tb_cursor;
            } else {
                CMBAnnotationServices.cursorArray[0] = Cursor.getPredefinedCursor(8);
                CMBAnnotationServices.cursorArray[4] = Cursor.getPredefinedCursor(9);
            }
            Cursor lr_cursor = this.createCustomCursor(CMBAnnotationConstants.HANDLE_CURSOR[6], CMBAnnotationConstants.HANDLE_HOTSPOT);
            if (lr_cursor != null) {
                CMBAnnotationServices.cursorArray[6] = lr_cursor;
                CMBAnnotationServices.cursorArray[2] = lr_cursor;
            } else {
                CMBAnnotationServices.cursorArray[6] = Cursor.getPredefinedCursor(10);
                CMBAnnotationServices.cursorArray[2] = Cursor.getPredefinedCursor(11);
            }
            Cursor ll_cursor = this.createCustomCursor(CMBAnnotationConstants.HANDLE_CURSOR[1], CMBAnnotationConstants.HANDLE_HOTSPOT);
            if (ll_cursor != null) {
                CMBAnnotationServices.cursorArray[1] = ll_cursor;
                CMBAnnotationServices.cursorArray[5] = ll_cursor;
            } else {
                CMBAnnotationServices.cursorArray[1] = Cursor.getPredefinedCursor(7);
                CMBAnnotationServices.cursorArray[5] = Cursor.getPredefinedCursor(4);
            }
            Cursor ldr_cursor = this.createCustomCursor(CMBAnnotationConstants.HANDLE_CURSOR[7], CMBAnnotationConstants.HANDLE_HOTSPOT);
            if (ldr_cursor != null) {
                CMBAnnotationServices.cursorArray[7] = ldr_cursor;
                CMBAnnotationServices.cursorArray[3] = ldr_cursor;
            } else {
                CMBAnnotationServices.cursorArray[7] = Cursor.getPredefinedCursor(6);
                CMBAnnotationServices.cursorArray[3] = Cursor.getPredefinedCursor(5);
            }
            Cursor move_cursor = this.createCustomCursor(CMBAnnotationConstants.HANDLE_CURSOR[8], CMBAnnotationConstants.MOVE_CURSOR_HOTSPOT);
            CMBAnnotationServices.cursorArray[8] = move_cursor != null ? move_cursor : Cursor.getPredefinedCursor(13);
            Cursor default_cursor = this.createCustomCursor(CMBAnnotationConstants.HANDLE_CURSOR[9], CMBAnnotationConstants.DEFAULT_CURSOR_HOTSPOT);
            CMBAnnotationServices.cursorArray[9] = default_cursor != null ? default_cursor : Cursor.getDefaultCursor();
        }
        catch (Exception e) {
            ViewerLogger.logError(this, methodName, "Error during createHandleCursors", e);
        }
    }

    ImageIcon getImageIcon(String name) {
        ImageIcon img_icon = null;
        if (name == null) {
            return null;
        }
        URL img_url = this.getClass().getClassLoader().getResource(name);
        if (img_url == null) {
            img_url = this.getClass().getClassLoader().getResource("com/ibm/mm/viewer/images/" + name);
        }
        if (img_url == null) {
            return null;
        }
        try {
            URLConnection img_conn = img_url.openConnection();
            img_conn.setUseCaches(true);
            InputStream img_is = img_conn.getInputStream();
            int imgSize = img_is.available();
            byte[] img_data = new byte[imgSize];
            for (int offRead = 0; offRead < imgSize; offRead += img_is.read(img_data, offRead, imgSize - offRead)) {
            }
            img_is.close();
            img_icon = new ImageIcon(img_data);
        }
        catch (IOException ignore) {
            if (this.traceEnabled()) {
                this.trace("ERROR: Creating image icon for " + img_url.toString() + " failed.");
            }
            return null;
        }
        if (img_icon == null) {
            return null;
        }
        return img_icon;
    }

    public Cursor createCustomCursor(String cursorStr, Point hotSpot) {
        String methodName = "createCustomCursor";
        try {
            Toolkit tk = Toolkit.getDefaultToolkit();
            Cursor cr = null;
            try {
                ImageIcon cursor = this.getImageIcon(cursorStr);
                cr = tk.createCustomCursor(cursor.getImage(), hotSpot, "");
            }
            catch (IndexOutOfBoundsException e) {
                ViewerLogger.logError((Object)this, methodName, e);
            }
            return cr;
        }
        catch (Exception ex) {
            if (this.traceEnabled()) {
                this.trace("ERROR: Creating custom cursor for " + cursorStr + " failed. Using default cursor.");
            }
            return Cursor.getDefaultCursor();
        }
    }

    void setMode(int modeType) {
        this.mode = modeType;
    }

    int getMode() {
        return this.mode;
    }

    CMBAnnotationView getActiveView() {
        return this.activeView;
    }

    private void loadEngines() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (this.engineProperties == null) {
            return;
        }
        this.engines = new Vector();
        int engineCount = 0;
        try {
            engineCount = Integer.parseInt(this.engineProperties.getProperty("ANNOTATION_ENGINES", "0"));
            if (this.traceEnabled()) {
                this.trace("Annotation Engine count from properties:" + this.engineProperties.getProperty("ANNOTATION_ENGINES", "0"));
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (this.traceEnabled()) {
            this.trace("Annotation Engine count:" + engineCount);
        }
        for (int i = 0; i < engineCount; ++i) {
            String name;
            CMBAnnotationEngine engine = null;
            String engineClassName = this.engineProperties.getProperty("ANNOTATION_ENGINE" + String.valueOf(i + 1) + "_CLASSNAME", "");
            Class<?> engineClass = Class.forName(engineClassName);
            engine = (CMBAnnotationEngine)engineClass.newInstance();
            if (this.traceEnabled()) {
                this.trace("Loading annotation engine:" + engineClassName + "...");
            }
            Properties thisEnginesProperties = new Properties();
            Enumeration<?> en = this.engineProperties.propertyNames();
            while (en.hasMoreElements()) {
                name = (String)en.nextElement();
                if (name.startsWith("ANNOTATION_ENGINE")) continue;
                thisEnginesProperties.put(name, this.engineProperties.getProperty(name));
            }
            en = this.engineProperties.propertyNames();
            while (en.hasMoreElements()) {
                String enginePrefix;
                name = (String)en.nextElement();
                if (!name.startsWith(enginePrefix = "ANNOTATION_ENGINE" + (i + 1) + "_")) continue;
                String newName = name.substring(enginePrefix.length());
                thisEnginesProperties.put(newName, this.engineProperties.getProperty(name));
            }
            if (this.traceEnabled()) {
                this.trace("Engine " + engineClassName + " loaded.");
                this.trace(engineClassName + " :initialized" + "\nproperties: " + thisEnginesProperties);
            }
            engine.initialize(new AnnotationEngineCallbacks(), thisEnginesProperties);
            this.engines.addElement(engine);
        }
        if (this.traceEnabled()) {
            this.trace("Annotation engines loaded successfully.");
        }
    }

    private synchronized CMBAnnotationSet getAnnotationSetFromHandle(Object hEngineAnnSet) {
        int size = this.annotationSets.size();
        for (int i = 0; i < size; ++i) {
            CMBAnnotationSet annSet = (CMBAnnotationSet)this.annotationSets.elementAt(i);
            if (!annSet.getAnnotationSetHandle().equals(hEngineAnnSet)) continue;
            return annSet;
        }
        return null;
    }

    public void commitPen() {
        int currTool;
        if (this.getMode() != 112 && (currTool = this.getSelectedAnnotationTool()) == 6) {
            this.setSelectedAnnotationTool(0);
            if (this.isAnnotationToolSticky()) {
                this.setSelectedAnnotationTool(currTool);
            }
        }
    }

    PStampImageProvider getStampImageProvider() {
        if (this.stampImageProvider == null) {
            this.stampImageProvider = new PStampImageProvider(this);
        }
        return this.stampImageProvider;
    }

    private class AnnotationEngineCallbacks
    extends CMBAnnotationEngineCallbacks {
        AnnotationEngineCallbacks() {
        }

        public InputStream getAnnotationPart(Object hAnnotationSet, int annotationNumber) throws CMBAnnotationEngineException {
            if (CMBAnnotationServices.this.servicesCallbacks == null) {
                return null;
            }
            CMBAnnotationSet annSet = CMBAnnotationServices.this.getAnnotationSetFromHandle(hAnnotationSet);
            if (annSet == null) {
                return null;
            }
            return CMBAnnotationServices.this.servicesCallbacks.getAnnotationPart(annSet, annotationNumber);
        }

        public boolean getPrivilege(Object hAnnotationSet, int privilegeID) throws CMBAnnotationEngineException {
            if (CMBAnnotationServices.this.servicesCallbacks == null) {
                return false;
            }
            CMBAnnotationSet annSet = CMBAnnotationServices.this.getAnnotationSetFromHandle(hAnnotationSet);
            if (annSet == null) {
                return false;
            }
            return CMBAnnotationServices.this.servicesCallbacks.getPrivilege(annSet, privilegeID);
        }

        public int addAnnotationPart(Object hAnnotationSet, byte[] output) throws CMBAnnotationEngineException {
            if (CMBAnnotationServices.this.servicesCallbacks == null) {
                return -1;
            }
            CMBAnnotationSet annSet = CMBAnnotationServices.this.getAnnotationSetFromHandle(hAnnotationSet);
            if (annSet == null) {
                return -1;
            }
            if (CMBAnnotationServices.this.writeAnnotationStream != null) {
                if (CMBAnnotationServices.this.annotationStreamWritten) {
                    throw new CMBAnnotationEngineException(PAnnotationUtilities.getMessage("Annotation.cannotWriteMultipartAnnotation"));
                }
                try {
                    CMBAnnotationServices.this.writeAnnotationStream.write(output);
                    CMBAnnotationServices.this.annotationStreamWritten = true;
                }
                catch (IOException e) {
                    throw new CMBAnnotationEngineException(PAnnotationUtilities.getMessage("Annotation.ioErrorWritingAnnotations"), (Object)e);
                }
                return 0;
            }
            return CMBAnnotationServices.this.servicesCallbacks.addAnnotationPart(annSet, output);
        }

        public void updateAnnotationPart(Object hAnnotationSet, byte[] annotationData, int annotationNumber) throws CMBAnnotationEngineException {
            if (CMBAnnotationServices.this.servicesCallbacks == null) {
                return;
            }
            CMBAnnotationSet annSet = CMBAnnotationServices.this.getAnnotationSetFromHandle(hAnnotationSet);
            if (annSet == null) {
                return;
            }
            if (CMBAnnotationServices.this.writeAnnotationStream != null) {
                if (annotationNumber >= 1 || CMBAnnotationServices.this.annotationStreamWritten) {
                    throw new CMBAnnotationEngineException(PAnnotationUtilities.getMessage("Annotation.cannotWriteMultipartAnnotation"));
                }
                try {
                    CMBAnnotationServices.this.writeAnnotationStream.write(annotationData);
                    CMBAnnotationServices.this.annotationStreamWritten = true;
                }
                catch (IOException e) {
                    throw new CMBAnnotationEngineException(PAnnotationUtilities.getMessage("Annotation.ioErrorWritingAnnotations"), (Object)e);
                }
            } else {
                CMBAnnotationServices.this.servicesCallbacks.updateAnnotationPart(annSet, annotationData, annotationNumber);
            }
        }

        public void removeAnnotationPart(Object hAnnotationSet, int annotationNumber) throws CMBAnnotationEngineException {
            if (CMBAnnotationServices.this.servicesCallbacks == null) {
                return;
            }
            CMBAnnotationSet annSet = CMBAnnotationServices.this.getAnnotationSetFromHandle(hAnnotationSet);
            if (annSet == null) {
                return;
            }
            CMBAnnotationServices.this.servicesCallbacks.removeAnnotationPart(annSet, annotationNumber);
        }

        public boolean traceEnabled() {
            if (CMBAnnotationServices.this.servicesCallbacks == null) {
                return false;
            }
            return CMBAnnotationServices.this.servicesCallbacks.traceEnabled();
        }

        public void trace(String message) {
            if (CMBAnnotationServices.this.servicesCallbacks == null) {
                return;
            }
            CMBAnnotationServices.this.servicesCallbacks.trace(message);
        }
    }
}

