/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JPanel;

class PrintPreviewPanel
extends JPanel {
    private Pageable pageable;
    private int currentPage = 0;

    public PrintPreviewPanel(Pageable doc) {
        this.pageable = doc;
    }

    public void paintComponent(Graphics g) {
        double yoffset;
        double xoffset;
        double scale;
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        PageFormat pageFormat = this.pageable.getPageFormat(this.currentPage);
        double pw = pageFormat.getWidth();
        double ph = pageFormat.getHeight();
        double sw = this.getWidth() - 1;
        double sh = this.getHeight() - 1;
        if (pw / ph < sw / sh) {
            scale = sh / ph;
            xoffset = 0.5 * (sw - scale * pw);
            yoffset = 0.0;
        } else {
            scale = sw / pw;
            xoffset = 0.0;
            yoffset = 0.5 * (sh - scale * ph);
        }
        g2.translate((float)xoffset, (float)yoffset);
        g2.scale(scale, scale);
        Rectangle2D.Double page = new Rectangle2D.Double(0.0, 0.0, pw, ph);
        g2.setPaint(Color.white);
        g2.fill(page);
        g2.setPaint(Color.black);
        g2.draw(page);
        Printable printable = this.pageable.getPrintable(this.currentPage);
        System.out.println("printable:" + printable);
        try {
            printable.print(g2, pageFormat, this.currentPage);
        }
        catch (PrinterException e) {
            g2.draw(new Line2D.Double(0.0, 0.0, pw, ph));
            g2.draw(new Line2D.Double(0.0, pw, 0.0, ph));
        }
    }

    public void flipPage(int diff) {
        int newPage = this.currentPage + diff;
        if (newPage >= 0 && newPage < this.pageable.getNumberOfPages()) {
            this.currentPage = newPage;
            this.repaint();
        }
    }
}

