/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBGenericDocClosedEvent;
import com.ibm.mm.viewer.CMBGenericDocClosedListener;
import com.ibm.mm.viewer.CMBGenericDocSelectedEvent;
import com.ibm.mm.viewer.CMBGenericDocSelectedListener;
import com.ibm.mm.viewer.CMBGenericDocStateChangedEvent;
import com.ibm.mm.viewer.CMBGenericDocStateChangedListener;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.CMBPage;
import com.ibm.mm.viewer.PPageModel;
import com.ibm.mm.viewer.PViewerUtilities;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

class PZoomCustomTool
extends JPanel {
    private CMBGenericDocViewer gdv;
    private JComboBox zoomCustomComboBox = new JComboBox(){

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width += 10;
            return dimension;
        }
    };
    private JTextField editTextField;
    private boolean didFit;

    public PZoomCustomTool(CMBGenericDocViewer gdv) {
        super(new GridBagLayout());
        this.gdv = gdv;
        this.zoomCustomComboBox.setEditable(true);
        this.zoomCustomComboBox.setEnabled(false);
        this.populateList();
        this.add(this.zoomCustomComboBox);
        if (this.zoomCustomComboBox.getComponentCount() == 3) {
            this.editTextField = (JTextField)this.zoomCustomComboBox.getComponent(2);
            this.editTextField.addFocusListener(new ZoomCustomFocusListener());
            this.editTextField.addKeyListener(new ZoomCustomKeyListener());
            this.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    PZoomCustomTool.this.editTextField.requestFocus();
                }
            });
        }
        this.zoomCustomComboBox.addItemListener(new ZoomCustomItemListener());
        this.zoomCustomComboBox.getEditor().addActionListener(new ZoomCustomActionListener());
        gdv.addDocStateChangedListener(new ZoomCustomDocStateChangedListener());
        gdv.addDocSelectedListener(new ZoomCustomDocSelectedListener());
        gdv.addDocClosedListener(new ZoomCustomDocClosedListener());
    }

    private void populateList() {
        String options = PViewerUtilities.getMessage("DocumentViewer.ZoomCustomOptions");
        StringTokenizer tok = new StringTokenizer(options, ",");
        DefaultComboBoxModel comboBoxModel = (DefaultComboBoxModel)this.zoomCustomComboBox.getModel();
        comboBoxModel.removeAllElements();
        while (tok.hasMoreTokens()) {
            String option = tok.nextToken();
            if (option.endsWith(PViewerUtilities.getMessage("DocumentViewer.ZoomPercentageSymbol"))) {
                String numberString = option.substring(0, option.length() - 1);
                double scaleValueOfOption = (double)new Integer(numberString.trim()).intValue() / 100.0;
                if (this.gdv.getSelectedModel() instanceof PPageModel) {
                    PPageModel model = (PPageModel)this.gdv.getSelectedModel();
                    CMBPage page = model.getPage(model.getCurrentPageNumber());
                    if (!(page.getMaxScale() >= scaleValueOfOption)) continue;
                    comboBoxModel.addElement(option);
                    continue;
                }
                comboBoxModel.addElement(option);
                continue;
            }
            comboBoxModel.addElement(option);
        }
        this.zoomCustomComboBox.getEditor().setItem("");
    }

    private void processText() {
        if (this.didFit) {
            this.updateText();
            this.didFit = false;
            return;
        }
        try {
            String option = (String)this.zoomCustomComboBox.getEditor().getItem();
            if (option.equals(PViewerUtilities.getMessage("DocumentViewer.FitHeight"))) {
                this.gdv.fitHeight();
                this.didFit = true;
            } else if (option.equals(PViewerUtilities.getMessage("DocumentViewer.FitWidth"))) {
                this.gdv.fitWidth();
                this.didFit = true;
            } else if (option.equals(PViewerUtilities.getMessage("DocumentViewer.FitInWindow"))) {
                this.gdv.fitInWindow();
                this.didFit = true;
            } else if (option.equals(PViewerUtilities.getMessage("DocumentViewer.ActualSize"))) {
                this.gdv.fitActualSize();
                this.didFit = true;
            } else {
                String numberString = option.endsWith(PViewerUtilities.getMessage("DocumentViewer.ZoomPercentageSymbol")) ? option.substring(0, option.length() - 1) : option;
                int newscalePercent = new Integer(numberString.trim());
                this.gdv.setScale((double)newscalePercent / 100.0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateText();
    }

    private void updateText() {
        if (this.gdv.getSelectedDocument() == null) {
            this.zoomCustomComboBox.getEditor().setItem("");
            this.zoomCustomComboBox.setEnabled(false);
            return;
        }
        this.zoomCustomComboBox.setEnabled(true);
        double scale = this.gdv.getScale();
        int percentage = (int)Math.floor(scale * 100.0);
        this.zoomCustomComboBox.getEditor().setItem(Integer.toString(percentage) + PViewerUtilities.getMessage("DocumentViewer.ZoomPercentageSymbol"));
        this.zoomCustomComboBox.invalidate();
    }

    private class ZoomCustomKeyListener
    extends KeyAdapter {
        private ZoomCustomKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getModifiers() == 0) {
                if (e.getKeyCode() == 39) {
                    Container c = PZoomCustomTool.this.getFocusCycleRootAncestor();
                    c.getFocusTraversalPolicy().getComponentAfter(c, PZoomCustomTool.this.editTextField).requestFocus();
                } else if (e.getKeyCode() == 37) {
                    Container c = PZoomCustomTool.this.getFocusCycleRootAncestor();
                    c.getFocusTraversalPolicy().getComponentBefore(c, PZoomCustomTool.this.editTextField).requestFocus();
                }
            }
        }
    }

    private class ZoomCustomActionListener
    implements ActionListener {
        private ZoomCustomActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            PZoomCustomTool.this.processText();
        }
    }

    private class ZoomCustomItemListener
    implements ItemListener {
        private ZoomCustomItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            PZoomCustomTool.this.processText();
        }
    }

    private class ZoomCustomFocusListener
    implements FocusListener {
        private ZoomCustomFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            PZoomCustomTool.this.zoomCustomComboBox.getEditor().selectAll();
        }

        public void focusLost(FocusEvent e) {
            PZoomCustomTool.this.processText();
        }
    }

    private class ZoomCustomDocClosedListener
    implements CMBGenericDocClosedListener {
        private ZoomCustomDocClosedListener() {
        }

        public void genericDocClosed(CMBGenericDocClosedEvent evt) {
            PZoomCustomTool.this.updateText();
        }
    }

    private class ZoomCustomDocSelectedListener
    implements CMBGenericDocSelectedListener {
        private ZoomCustomDocSelectedListener() {
        }

        public void genericDocSelected(CMBGenericDocSelectedEvent evt) {
            PZoomCustomTool.this.updateText();
        }
    }

    private class ZoomCustomDocStateChangedListener
    implements CMBGenericDocStateChangedListener {
        private ZoomCustomDocStateChangedListener() {
        }

        public void genericDocStateChanged(CMBGenericDocStateChangedEvent evt) {
            PZoomCustomTool.this.updateText();
        }
    }
}

