/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class PViewerUtilities {
    static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private static String RESOURCE_BASE_NAME = "com.ibm.mm.viewer.CMBViewerMessages";
    private static String VIEWER_CONFIG_FILE = "com.ibm.mm.viewer.CMBViewerConfiguration";
    private static final int MAX_BUNDLE_NAMES = 4;
    private static ResourceBundle viewerMessages = null;
    private static Vector availableBundles = new Vector(4);
    private static PropertyResourceBundle propertyBundle = null;
    private static Vector availablePropertyBundles = new Vector(4);
    private static int IO_BUFFER_LENGTH = 4096;

    PViewerUtilities() {
    }

    private static String getMessageString(String messageKey) {
        String message = messageKey;
        try {
            message = PViewerUtilities.getResourceBundle().getString(messageKey);
            return message;
        }
        catch (MissingResourceException mre) {
            int size = availableBundles.size();
            for (int i = size - 1; i > 0; --i) {
                try {
                    return ((ResourceBundle)availableBundles.elementAt(i)).getString(messageKey);
                }
                catch (MissingResourceException me) {
                    continue;
                }
            }
            return messageKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Vector availableBundlesFor(String name) {
        Vector bundleNames = new Vector(4);
        Vector<PropertyResourceBundle> returnBundles = new Vector<PropertyResourceBundle>(4);
        bundleNames = PViewerUtilities.calculateBundleNames(name.replace('.', '/'), Locale.getDefault());
        InputStream stream = null;
        String resPathName = name.replace('.', '/');
        int size = bundleNames.size();
        for (int i = 0; i < size; ++i) {
            resPathName = (String)bundleNames.elementAt(i) + ".properties";
            URL myurl = PViewerUtilities.class.getClassLoader().getResource(resPathName);
            if (myurl != null) {
                try {
                    URLConnection myconn = myurl.openConnection();
                    myconn.setUseCaches(true);
                    stream = myconn.getInputStream();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (stream == null) continue;
            stream = new BufferedInputStream(stream);
            PropertyResourceBundle bundle = new PropertyResourceBundle(stream);
            returnBundles.insertElementAt(bundle, 0);
            Object var11_11 = null;
            try {
                stream.close();
            }
            catch (Exception e2) {}
            continue;
            {
                catch (Exception e) {
                    var11_11 = null;
                    try {
                        stream.close();
                    }
                    catch (Exception e2) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var11_11 = null;
                try {
                    stream.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return returnBundles;
    }

    private static ResourceBundle getResourceBundle() {
        if (viewerMessages == null && !(availableBundles = PViewerUtilities.availableBundlesFor(RESOURCE_BASE_NAME)).isEmpty()) {
            viewerMessages = (PropertyResourceBundle)availableBundles.elementAt(0);
        }
        return viewerMessages;
    }

    private static Vector calculateBundleNames(String baseName, Locale locale) {
        Vector<String> result = new Vector<String>(4);
        String language = locale.getLanguage();
        int languageLength = language.length();
        String country = locale.getCountry();
        int countryLength = country.length();
        String variant = locale.getVariant();
        int variantLength = variant.length();
        result.addElement(baseName);
        if (languageLength + countryLength + variantLength == 0) {
            return result;
        }
        if (language.equals("en") && (country.equals("US") || country.equals("")) && variant.equals("")) {
            return result;
        }
        StringBuffer temp = new StringBuffer(baseName);
        temp.append('_');
        temp.append(language);
        result.addElement(temp.toString());
        if (countryLength + variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(country);
        result.addElement(temp.toString());
        if (variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(variant);
        result.addElement(temp.toString());
        return result;
    }

    public static String getMessage(String messageKey) {
        try {
            return PViewerUtilities.getMessageString(messageKey);
        }
        catch (Throwable e) {
            return "";
        }
    }

    public static String getMessage(String messageKey, Object[] args) {
        try {
            String message = PViewerUtilities.getMessageString(messageKey);
            message = MessageFormat.format(message, args);
            return message;
        }
        catch (Throwable e) {
            return "";
        }
    }

    public static boolean isLeftToRight() {
        try {
            return ComponentOrientation.getOrientation(Locale.getDefault()).isLeftToRight();
        }
        catch (Throwable t) {
            return true;
        }
    }

    public static boolean getBooleanProperty(String key, Properties properties, boolean defaultValue) {
        String prop = properties.getProperty(key);
        if (prop == null) {
            return defaultValue;
        }
        if (!prop.equalsIgnoreCase("true") && !prop.equalsIgnoreCase("false")) {
            properties.put(key, Boolean.toString(defaultValue));
            System.out.println(PViewerUtilities.getMessage("preference.InvalidValue", new Object[]{key}));
            return defaultValue;
        }
        boolean value = new Boolean(prop);
        return value;
    }

    public static void setBooleanProperty(String key, Properties properties, boolean value) {
        String prop = Boolean.toString(value);
        properties.setProperty(key, prop);
    }

    public static int getIntegerProperty(String key, Properties properties, int defaultValue) {
        String prop = properties.getProperty(key);
        if (prop == null) {
            return defaultValue;
        }
        int value = Integer.parseInt(prop);
        return value;
    }

    public static int getIntegerProperty(String key, Properties properties, int defaultValue, int minValue, int maxValue) {
        String prop = properties.getProperty(key);
        if (prop == null) {
            return defaultValue;
        }
        try {
            int value = Integer.parseInt(prop);
            if (value > maxValue || value < minValue) {
                System.out.println(PViewerUtilities.getMessage("preference.InvalidValue", new Object[]{key}));
                return defaultValue;
            }
            return value;
        }
        catch (NumberFormatException e) {
            System.out.println(PViewerUtilities.getMessage("preference.InvalidValue", new Object[]{key}));
            return defaultValue;
        }
    }

    public static void setStringProperty(String key, Properties properties, String value) {
        properties.setProperty(key, value);
    }

    public static String getStringProperty(String key, Properties properties, String defaultValue) {
        String prop = properties.getProperty(key);
        if (prop == null) {
            return defaultValue;
        }
        return prop;
    }

    public static String getStringProperty(String key, Properties properties, String defaultValue, String[] validValues) {
        String prop = properties.getProperty(key);
        if (prop == null) {
            return defaultValue;
        }
        for (int i = 0; i < validValues.length; ++i) {
            if (!validValues[i].equalsIgnoreCase(prop)) continue;
            return prop;
        }
        System.out.println(PViewerUtilities.getMessage("preference.InvalidValue", new Object[]{key}));
        properties.put(key, defaultValue);
        return defaultValue;
    }

    public static void setIntegerProperty(String key, Properties properties, int value) {
        String prop = Integer.toString(value);
        properties.setProperty(key, prop);
    }

    public static String getColorProperty(String key, Properties properties, String defaultValue) {
        String o = properties.getProperty(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            Color c = Color.decode(o);
            return o;
        }
        catch (NumberFormatException e) {
            System.out.println(PViewerUtilities.getMessage("preference.InvalidValue", new Object[]{key}));
            return defaultValue;
        }
    }

    public static String getColorProperty(String key, Properties properties, Color defaultValue) {
        String c = "#" + Integer.toHexString(defaultValue.getRGB() & 0xFFFFFF);
        return PViewerUtilities.getColorProperty(key, properties, c);
    }

    public static void setColorProperty(String key, Properties properties, String value) {
        properties.put(key, value);
    }

    public static String stripHtml(String sourceString) {
        Pattern pattern = Pattern.compile("<[^>]*>", 2);
        Matcher matcher = pattern.matcher(sourceString);
        return matcher.replaceAll("");
    }

    public static void writeFileToStream(File inFile, OutputStream outStream) throws IOException {
        BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(inFile));
        PViewerUtilities.writeStreamToStream(inStream, outStream);
        inStream.close();
    }

    public static void writeStreamToFile(InputStream inStream, File outFile) throws IOException {
        BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(outFile));
        PViewerUtilities.writeStreamToStream(inStream, outStream);
        outStream.close();
    }

    public static void writeStreamToStream(InputStream inStream, OutputStream outStream) throws IOException {
        byte[] buf = new byte[IO_BUFFER_LENGTH];
        int len = 0;
        do {
            if ((len = inStream.read(buf)) <= 0) continue;
            outStream.write(buf, 0, len);
        } while (len >= 0);
    }

    public static String showName(Component c) {
        if (c == null) {
            return "component is null";
        }
        String s = c.getClass().getName() + "@" + c.hashCode() + ":" + c.getName();
        return s;
    }

    public static String showName(Object c) {
        if (c == null) {
            return "component is null";
        }
        String s = c.getClass().getName() + "@" + c.hashCode();
        return s;
    }

    public static String howLong(long startTime, long endTime, String msg) {
        String s = msg + ":" + (double)(endTime - startTime) / 1000.0 + " seconds";
        return s;
    }
}

