/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBDocumentEngineException;
import com.ibm.mm.viewer.PDocModel;
import com.ibm.mm.viewer.PDocView;
import com.ibm.mm.viewer.PSingleDocViewer;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.util.ArrayList;

abstract class PThumbnailsView
extends PDocView {
    static final int WD_OFFSET = 20;
    static final int HT_OFFSET = 20;
    static final int STD_THUMBNAIL_WIDTH = 60;
    static final int STD_THUMBNAIL_HEIGHT = 78;
    int popupPageNumber;
    protected ArrayList actionListeners;

    abstract void buildThumbnails() throws IOException, CMBDocumentEngineException;

    abstract void updateThumbnails(int var1, int var2);

    abstract void setThumbnailSize(int var1, int var2);

    abstract void setThumbnailSize(Dimension var1);

    abstract Dimension getThumbnailSize();

    abstract void setThumbnailOffsets(Dimension var1);

    abstract Dimension getThumbnailOffsets();

    abstract boolean isMultiSelectAllowed();

    abstract void setMultiSelectAllowed(boolean var1);

    boolean isDragDropAllowed() {
        return false;
    }

    void setDragDropAllowed(boolean bDragDropAlloded) {
    }

    protected PThumbnailsView(PSingleDocViewer viewer, PDocModel model) {
        super(viewer, model);
    }

    Dimension getPageNumberStringBounds(int pageNumber) {
        Rectangle2D stringRect;
        String strPageNum = "0";
        strPageNum = pageNumber < 10 ? strPageNum + String.valueOf(pageNumber) : String.valueOf(pageNumber);
        Graphics2D g2d = (Graphics2D)this.getGraphics();
        if (g2d != null) {
            Font currFont = g2d.getFont();
            Font newFont = new Font(currFont.getName(), 1, 15);
            FontRenderContext frc = g2d.getFontRenderContext();
            stringRect = newFont.getStringBounds(strPageNum, frc);
            g2d.dispose();
        } else {
            stringRect = new Rectangle(0, 0, 12, 15);
        }
        Dimension bounds = new Dimension((int)((RectangularShape)stringRect).getWidth(), (int)((RectangularShape)stringRect).getHeight());
        return bounds;
    }

    int getPopupPage() {
        return this.popupPageNumber;
    }

    public void addActionListener(ActionListener listener) {
        if (this.actionListeners == null) {
            this.actionListeners = new ArrayList();
        }
        this.actionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }

    protected void fireActionEvent() {
        if (this.actionListeners == null) {
            return;
        }
        ActionEvent event = new ActionEvent(this, 0, "Action");
        for (int i = 0; i < this.actionListeners.size(); ++i) {
            ActionListener listener = (ActionListener)this.actionListeners.get(i);
            listener.actionPerformed(event);
        }
    }
}

