/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.PFullSizePageView;
import com.ibm.mm.viewer.PFullSizeView;
import com.ibm.mm.viewer.PPageModel;
import com.ibm.mm.viewer.PSingleDocViewer;
import com.ibm.mm.viewer.PThumbnailListView;
import com.ibm.mm.viewer.PThumbnailsView;
import com.ibm.mm.viewer.PViewerLayout;
import com.ibm.mm.viewer.PViewerUtilities;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class PThumbnailsOnlyViewerLayout
extends PViewerLayout
implements ChangeListener {
    private CMBGenericDocViewer gdv;
    private JTabbedPane tabbedPane;
    private ArrayList thumbnailsViews = new ArrayList();
    private EventHandler eventHandler = new EventHandler();
    private ThumbnailActionListener thumbnailActionListener = new ThumbnailActionListener();

    public PThumbnailsOnlyViewerLayout(CMBGenericDocViewer gdv) {
        this.gdv = gdv;
        gdv.currentLayout = this;
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addContainerListener(this.eventHandler);
        ActionListener enterViewAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PSingleDocViewer viewer = PThumbnailsOnlyViewerLayout.this.gdv.getSelectedViewer();
                if (viewer != null) {
                    viewer.getThumbnailsView().requestFocus();
                }
            }
        };
        this.tabbedPane.registerKeyboardAction(enterViewAction, KeyStroke.getKeyStroke(10, 0, false), 2);
        PSingleDocViewer selectedViewer = gdv.getSelectedViewer();
        for (int i = 0; i < gdv.getViewerCount(); ++i) {
            PSingleDocViewer viewer = gdv.getViewer(i);
            this.addDocView(viewer.getDocModel().getDocument(), viewer.getDocModel().getAnnotationSet(), viewer.getDocModel().getDocName(), viewer == selectedViewer);
            this.buildThumbnails(viewer.getDocModel().getDocument());
        }
        if (gdv.getSelectedDocument() != null) {
            this.activateDocument(gdv.getSelectedDocument());
        }
        this.addViewerTabbedPaneChangeListener();
    }

    public int getViewType() {
        return 3;
    }

    public JComponent getViewerComponent() {
        return this.tabbedPane;
    }

    public void dispose() {
        for (int i = 0; i < this.thumbnailsViews.size(); ++i) {
            PThumbnailsView thumbnailsView = (PThumbnailsView)this.thumbnailsViews.get(i);
            thumbnailsView.removeActionListener(this.thumbnailActionListener);
        }
        this.thumbnailsViews.clear();
        this.tabbedPane.removeChangeListener(this);
        this.tabbedPane.removeAll();
        this.tabbedPane = null;
    }

    public void registerKeyboardAction(Action action, KeyStroke keystroke, int inputMapID) {
        String aCommand = (String)action.getValue("Name");
        this.tabbedPane.getInputMap(inputMapID).put(keystroke, aCommand);
        this.tabbedPane.getActionMap().put(aCommand, action);
    }

    private void addViewerTabbedPaneChangeListener() {
        ChangeListener[] cls = (ChangeListener[])this.tabbedPane.getListeners(ChangeListener.class);
        boolean found = false;
        for (int i = 0; i < cls.length; ++i) {
            if (!cls[i].equals(this)) continue;
            found = true;
        }
        if (!found) {
            this.tabbedPane.addChangeListener(this);
        }
    }

    public void activateDocument(CMBDocument document) {
        for (int i = 0; i < this.gdv.getViewerCount(); ++i) {
            PSingleDocViewer v = this.gdv.getViewer(i);
            v.getDocModel().setActiveDocument(false);
        }
        PSingleDocViewer viewer = this.gdv.getViewer(document);
        this.gdv.setSelectedViewer(viewer);
        viewer.getDocModel().setActiveDocument(true);
        this.activateThumbnailView(document);
        this.gdv.checkToIndicateDocument();
    }

    private void activateThumbnailView(CMBDocument document) {
        PThumbnailsView thumbView = null;
        PSingleDocViewer viewer = this.gdv.getViewer(document);
        if (viewer != null) {
            thumbView = viewer.getThumbnailsView();
            if (thumbView != null) {
                if (this.gdv.areThumbnailsShowing()) {
                    try {
                        thumbView.buildThumbnails();
                    }
                    catch (Exception e) {
                        System.out.println(PViewerUtilities.getMessage("DocumentViewer.thumbnailsNotBuilt") + e);
                    }
                    thumbView.setOrientation(2);
                }
                thumbView.setDisplayNeeded(true);
                this.tabbedPane.setSelectedComponent(thumbView.getParent().getParent());
            }
            this.gdv.revalidate();
            this.addViewerTabbedPaneChangeListener();
        }
        ((PPageModel)viewer.getDocModel()).activeFullSizeView = (PFullSizePageView)this.getSelectedFullSizeView();
        this.gdv.fireCMBDocSelectedEvent(document);
    }

    public void closeDocument(CMBDocument document, boolean activate) {
        String methodName = "closeDocument";
        PSingleDocViewer viewer = this.gdv.getViewer(document);
        int index = this.gdv.getViewerIndex(viewer);
        try {
            PThumbnailsView thumbView = viewer.getThumbnailsView();
            JScrollPane scrollPane = (JScrollPane)thumbView.getParent().getParent();
            this.tabbedPane.removeChangeListener(this);
            this.tabbedPane.removeTabAt(index);
            this.addViewerTabbedPaneChangeListener();
            thumbView.removeActionListener(this.thumbnailActionListener);
            this.gdv.validate();
        }
        catch (IndexOutOfBoundsException e) {
            ViewerLogger.logError((Object)this, methodName, e);
        }
    }

    public JPanel getThumbnailsPanel() {
        return null;
    }

    public void setThumbnailsPosition(String thumbnailsPosition) {
    }

    public void setTabPlacement(int position) {
        this.tabbedPane.setTabPlacement(position);
    }

    public PFullSizeView getSelectedFullSizeView() {
        return null;
    }

    public void indicateDocument(CMBDocument document, boolean indicate) {
        PSingleDocViewer docView = this.gdv.getViewer(document);
        if (docView == null) {
            return;
        }
        if (indicate && this.gdv.hasDocumentBeenViewed(document)) {
            String indicateString = (String)this.gdv.getClientProperty("Appearance.tab.color");
            String htmlColor = "<p style=\"color : " + indicateString + "\">";
            String indicateStyle = (String)this.gdv.getClientProperty("Appearance.tab.fontstyle");
            String title = PViewerUtilities.stripHtml(this.gdv.getDocName(document));
            if (indicateStyle.equalsIgnoreCase("bold")) {
                String styleString = "<html><body>" + htmlColor + "<b>" + title + "</b></p></body></html>";
                this.setStyledDocName(document, styleString);
            } else if (indicateStyle.equalsIgnoreCase("italic")) {
                String styleString = "<html><body>" + htmlColor + "<i>" + title + "</i></p></body></html>";
                this.setStyledDocName(document, styleString);
            } else if (indicateStyle.equalsIgnoreCase("bold_italic")) {
                String styleString = "<html><body>" + htmlColor + "<b><i>" + title + "</i></b></p></body></html>";
                this.setStyledDocName(document, styleString);
            } else if (indicateStyle.equalsIgnoreCase("plain")) {
                String styleString = "<html><body>" + htmlColor + title + "</p></body></html>";
                this.setStyledDocName(document, styleString);
            }
        } else {
            String title = this.gdv.getDocName(document);
            this.setStyledDocName(document, this.gdv.getDocName(document));
        }
    }

    private void setStyledDocName(CMBDocument document, String styledDocName) {
        PSingleDocViewer viewer = this.gdv.getViewer(document);
        int index = this.gdv.getViewerIndex(viewer);
        if (index > -1 && this.tabbedPane != null) {
            this.tabbedPane.setTitleAt(index, styledDocName);
        }
    }

    public void addDocView(CMBDocument document, CMBAnnotationSet annotationSet, String docName, boolean selectInShow) {
        this.addThumbView(document);
        PSingleDocViewer viewer = this.gdv.getViewer(document);
        ((PPageModel)viewer.getDocModel()).setCurrentViewRectangle(null);
        if (this.gdv.hasDocumentBeenViewed(document)) {
            boolean indicate = (Boolean)this.gdv.getClientProperty("Appearance.tab.indicate");
            this.indicateDocument(document, indicate);
        }
        this.gdv.reregisterKeyboardActions();
    }

    private void addThumbView(CMBDocument document) {
        PSingleDocViewer viewer = this.gdv.getViewer(document);
        PThumbnailsView thumbnailView = viewer.getThumbnailsView();
        thumbnailView.addActionListener(this.thumbnailActionListener);
        this.thumbnailsViews.add(thumbnailView);
        thumbnailView.setMultiSelectAllowed(this.gdv.isMultiplePageSelectionEnabled());
        thumbnailView.setDragDropAllowed(this.gdv.canDragDrop());
        thumbnailView.setOrientation(2);
        if (this.gdv.getThumbnailsSize() != null) {
            thumbnailView.setThumbnailSize(this.gdv.getThumbnailsSize());
        }
        thumbnailView.setTransferHandler(null);
        thumbnailView.setTransferHandler(this.gdv.getTransferHandler());
        JScrollPane thumbScrollPane = new JScrollPane(thumbnailView);
        thumbScrollPane.getViewport().setFocusable(false);
        thumbScrollPane.getHorizontalScrollBar().setFocusable(false);
        thumbScrollPane.getVerticalScrollBar().setFocusable(false);
        thumbScrollPane.getHorizontalScrollBar().setUnitIncrement(thumbnailView.getThumbnailSize().width + thumbnailView.getThumbnailOffsets().width);
        thumbScrollPane.getVerticalScrollBar().setUnitIncrement(thumbnailView.getThumbnailSize().height + thumbnailView.getThumbnailOffsets().height + thumbnailView.getPageNumberStringBounds((int)0).height + 4);
        if (thumbnailView instanceof PThumbnailListView) {
            thumbScrollPane.getViewport().addChangeListener((PThumbnailListView)thumbnailView);
        }
        this.gdv.setupThumbnailPopupMenu(thumbnailView);
        this.tabbedPane.addTab(viewer.getDocModel().getDocName(), thumbScrollPane);
    }

    public void showThumbnails(boolean show) {
    }

    public void suspendDocSelectedEvents(boolean suspend) {
        if (suspend) {
            this.tabbedPane.removeChangeListener(this);
        } else {
            this.addViewerTabbedPaneChangeListener();
        }
    }

    public void stateChanged(ChangeEvent event) {
        int currentIndex = this.tabbedPane.getSelectedIndex();
        int tabCount = this.tabbedPane.getTabCount();
        if (tabCount >= 1 && currentIndex >= 0) {
            PSingleDocViewer viewer = this.gdv.getViewer(currentIndex);
            this.gdv.activateDocument(viewer.getDocModel().getDocument());
        } else {
            this.tabbedPane.setEnabled(false);
            this.gdv.stopDocViewedTimer();
            this.gdv.setSelectedViewer(null);
        }
    }

    public void setCursor(Cursor cursor) {
    }

    public void setDocName(CMBDocument document, String docName) {
        int index = this.gdv.getViewerIndex(this.gdv.getViewer(document));
        this.tabbedPane.setTitleAt(index, docName);
    }

    public JPanel getFindPanel() {
        return null;
    }

    public void showFindPanel(boolean show) {
    }

    private void buildThumbnails(CMBDocument document) {
        PThumbnailsView thumbView = null;
        PSingleDocViewer viewer = this.gdv.getViewer(document);
        if (viewer != null && (thumbView = viewer.getThumbnailsView()) != null) {
            try {
                thumbView.buildThumbnails();
            }
            catch (Exception e) {
                System.out.println(PViewerUtilities.getMessage("DocumentViewer.thumbnailsNotBuilt") + e);
            }
        }
    }

    private class ThumbnailActionListener
    implements ActionListener {
        private ThumbnailActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            PThumbnailsOnlyViewerLayout.this.gdv.setViewerLayout(PThumbnailsOnlyViewerLayout.this.gdv.getPreviousLayout());
        }
    }

    private class EventHandler
    implements ContainerListener {
        private EventHandler() {
        }

        public void componentAdded(ContainerEvent e) {
            if (e.getChild() instanceof JScrollPane) {
                JScrollPane component = (JScrollPane)e.getChild();
                this.updateMap("page_prev", component);
                this.updateMap("page_next", component);
                this.updateMap("page_first", component);
                this.updateMap("page_last", component);
            }
        }

        public void componentRemoved(ContainerEvent e) {
        }

        private void updateMap(String keyName, JComponent component) {
            Action a = PThumbnailsOnlyViewerLayout.this.gdv.getActionMap().get(keyName);
            if (a == null) {
                return;
            }
            KeyStroke ks = (KeyStroke)a.getValue("AcceleratorKey");
            if (ks == null) {
                return;
            }
            Object o = PThumbnailsOnlyViewerLayout.this.gdv.getInputMap(1).get(ks);
            if (o != null && PThumbnailsOnlyViewerLayout.this.gdv.getActionForKeyStroke(ks) != null) {
                a = (Action)PThumbnailsOnlyViewerLayout.this.gdv.getActionForKeyStroke(ks);
                String aName = null;
                if (a.getValue("Name") != null) {
                    aName = (String)a.getValue("Name");
                    o = component.getInputMap(1).get(ks);
                    if (o != null) {
                        component.getInputMap(1).put(ks, aName);
                        component.getActionMap().put(aName, a);
                        if (component instanceof JScrollPane) {
                            JScrollPane c = (JScrollPane)component;
                            c.getHorizontalScrollBar().getInputMap().put(ks, aName);
                            c.getHorizontalScrollBar().getActionMap().put(aName, a);
                            c.getVerticalScrollBar().getInputMap().put(ks, aName);
                            c.getVerticalScrollBar().getActionMap().put(aName, a);
                        }
                    }
                }
            }
        }
    }
}

