/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBDocumentEngineException;
import com.ibm.mm.viewer.CMBGenericDocSelectedEvent;
import com.ibm.mm.viewer.CMBGenericDocSelectedListener;
import com.ibm.mm.viewer.CMBGenericDocStateChangedEvent;
import com.ibm.mm.viewer.CMBGenericDocStateChangedListener;
import com.ibm.mm.viewer.PDocModel;
import com.ibm.mm.viewer.PPageModel;
import com.ibm.mm.viewer.PPageTransferHandler;
import com.ibm.mm.viewer.PSingleDocViewer;
import com.ibm.mm.viewer.PSingleThumbnailView;
import com.ibm.mm.viewer.PThumbnailListModel;
import com.ibm.mm.viewer.PThumbnailsView;
import com.ibm.mm.viewer.PViewerUtilities;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class PThumbnailListView
extends PThumbnailsView
implements ListSelectionListener,
ChangeListener,
MouseListener,
MouseMotionListener,
CMBGenericDocSelectedListener,
CMBGenericDocStateChangedListener,
ContainerListener {
    private static final int FOCUS_BORDER_WIDTH = 2;
    private JList _thumbnailList;
    private PThumbnailListModel _thumbListModel;
    private JScrollPane _scrollingPane;
    private boolean _addListtoScrollPane = false;
    private int _dragStartInIndex = -1;
    private boolean isDragging = false;
    private boolean _multiSelectAllowed = false;
    private boolean _dragDropAllowed = false;
    private JPopupMenu _thumbPopupMenu;
    private boolean _draggingRedRect;

    PThumbnailListView(PSingleDocViewer viewer, PDocModel model, Dimension thumbnailSize) {
        super(viewer, model);
        Border border = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        this.setBorder(border);
        Insets borderInsets = this.getBorder().getBorderInsets(this);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.setPreferredSize(new Dimension(80 + borderInsets.left + borderInsets.right, 98 + borderInsets.top + borderInsets.bottom));
        this._thumbnailList = new PThumbnailList();
        this.addContainerListener(this);
        InputMap iMap = this._thumbnailList.getInputMap();
        ActionMap aMap = this._thumbnailList.getActionMap();
        ActionMap uiAMap = aMap.getParent();
        uiAMap.remove(iMap.get(KeyStroke.getKeyStroke("ctrl C")));
        uiAMap.remove(iMap.get(KeyStroke.getKeyStroke("ctrl X")));
        uiAMap.remove(iMap.get(KeyStroke.getKeyStroke("ctrl V")));
        if (PThumbnailListModel.isContinuousPaginationEnabled()) {
            uiAMap.remove(iMap.get(KeyStroke.getKeyStroke("PAGE_UP")));
            uiAMap.remove(iMap.get(KeyStroke.getKeyStroke("PAGE_DOWN")));
        }
        this._thumbnailList.setBackground(this.getBackground());
        this._thumbnailList.addMouseListener(this);
        this._thumbnailList.addMouseMotionListener(this);
        this.addMouseListener(this);
        TransferHandler txHandler = this.getTransferHandler();
        if (txHandler instanceof PPageTransferHandler) {
            this._thumbnailList.setTransferHandler(txHandler);
        }
        if (this._addListtoScrollPane) {
            this._scrollingPane = new JScrollPane(this._thumbnailList);
            this.add(this._scrollingPane);
            this._scrollingPane.setBorder(BorderFactory.createEmptyBorder());
        } else {
            this.add(this._thumbnailList);
        }
        this.revalidate();
        this._thumbnailList.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent event) {
                if (!event.isTemporary()) {
                    PThumbnailListView.this.setBorder(BorderFactory.createLineBorder(SystemColor.controlShadow, 2));
                }
            }

            public void focusLost(FocusEvent event) {
                if (!event.isTemporary()) {
                    PThumbnailListView.this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                }
            }
        });
        this._thumbListModel = new PThumbnailListModel(viewer, (PPageModel)model);
        this._thumbnailList.setModel(this._thumbListModel);
        this._thumbnailList.setCellRenderer(this._thumbListModel);
        this._thumbnailList.addListSelectionListener(this);
        this._thumbListModel.setThumbListSelectionModel(this._thumbnailList.getSelectionModel());
        this.setThumbnailSize(thumbnailSize);
        model.addDocStateChangedListener(this);
    }

    public void addActionListener(ActionListener listener) {
        super.addActionListener(listener);
        if (this.actionListeners.size() == 1) {
            AbstractAction enterAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    PThumbnailListView.this.fireActionEvent();
                }
            };
            this._thumbnailList.getInputMap().put(KeyStroke.getKeyStroke(10, 0, false), "ENTER");
            this._thumbnailList.getActionMap().put("ENTER", enterAction);
        }
    }

    public void removeActionListener(ActionListener listener) {
        super.removeActionListener(listener);
        if (this.actionListeners.size() == 0) {
            this._thumbnailList.getInputMap().put(KeyStroke.getKeyStroke(10, 0, false), null);
            this._thumbnailList.getActionMap().put("ENTER", null);
        }
    }

    public void requestFocus() {
        this._thumbnailList.requestFocus();
    }

    void buildThumbnails() throws IOException, CMBDocumentEngineException {
        this._thumbListModel.buildThumbnails();
    }

    void updateThumbnails(int startPage, int endPage) {
        this._thumbListModel.updateThumbnails(startPage, endPage);
    }

    void updateThumbnails(CMBGenericDocStateChangedEvent evt) {
        this._thumbListModel.updateThumbnails(evt);
        this.revalidate();
    }

    void setThumbnailSize(int width, int height) {
        this.setThumbnailSize(new Dimension(width, height));
    }

    void setThumbnailSize(Dimension size) {
        this._thumbListModel.setThumbnailSize(size);
        PSingleThumbnailView stView = null;
        for (int i = 0; i < this._thumbListModel.getSize(); ++i) {
            stView = (PSingleThumbnailView)this._thumbListModel.getElementAt(i);
            if (stView == null) continue;
            stView.setThumbnailSize(size);
        }
    }

    Dimension getThumbnailSize() {
        return this._thumbListModel.getThumbnailSize();
    }

    void setThumbnailOffsets(Dimension offsets) {
        this._thumbListModel.setThumbnailOffsets(offsets);
    }

    Dimension getThumbnailOffsets() {
        return this._thumbListModel.getThumbnailOffsets();
    }

    boolean isMultiSelectAllowed() {
        return this._multiSelectAllowed;
    }

    void setMultiSelectAllowed(boolean bMultiSelectAllowed) {
        this._multiSelectAllowed = bMultiSelectAllowed;
        if (this._multiSelectAllowed) {
            this._thumbnailList.setSelectionMode(2);
        } else {
            this._thumbnailList.setSelectionMode(0);
        }
    }

    boolean isDragDropAllowed() {
        return this._dragDropAllowed;
    }

    void setDragDropAllowed(boolean dragDropAllowed) {
        this._dragDropAllowed = dragDropAllowed;
    }

    private void display() {
        PSingleThumbnailView stView = null;
        for (int i = 0; i < this._thumbListModel.getSize(); ++i) {
            stView = (PSingleThumbnailView)this._thumbListModel.getElementAt(i);
            if (stView == null) continue;
            stView.setOrientation(this.getOrientation());
            stView.display();
        }
        this._thumbListModel.synchListSelectionToPageModel();
        int leadSelectionIndex = this._thumbnailList.getLeadSelectionIndex();
        this._thumbnailList.ensureIndexIsVisible(leadSelectionIndex);
        this.repaint();
    }

    void dispose() {
        this.getDocModel().removeDocStateChangedListener(this);
        this._thumbListModel.dispose();
        this._thumbListModel = null;
        super.dispose();
    }

    public void setTransferHandler(TransferHandler txHandler) {
        this._thumbnailList.setTransferHandler(txHandler);
    }

    public Dimension getPreferredSize() {
        PPageModel thePageModel = (PPageModel)this.getDocModel();
        if (thePageModel != null) {
            int rowCount;
            int columnCount;
            int thumbnailsCount = thePageModel.getPageCount();
            if (thumbnailsCount == -1) {
                thumbnailsCount = this._thumbListModel.getThumbnailsCount() > 0 ? this._thumbListModel.getThumbnailsCount() : 1;
            }
            Insets borderInsets = this.getBorder().getBorderInsets(this);
            Dimension pageNumStringBounds = this.getPageNumberStringBounds(0);
            Dimension _pageNumStringOffset = new Dimension(4, 4);
            Dimension thumbViewSize = this.getParent().getSize();
            if (this.getOrientation() == 1 || this.getOrientation() == 2) {
                columnCount = (int)(thumbViewSize.getWidth() / (double)(this._thumbListModel.getThumbnailSize().width + this._thumbListModel.getThumbnailOffsets().width + borderInsets.left + borderInsets.right));
                columnCount = columnCount != 0 ? columnCount : 1;
                rowCount = thumbnailsCount / columnCount + (thumbnailsCount % columnCount != 0 ? 1 : 0);
            } else {
                rowCount = (int)(thumbViewSize.getHeight() / (double)(this._thumbListModel.getThumbnailSize().height + this._thumbListModel.getThumbnailOffsets().height + pageNumStringBounds.height + _pageNumStringOffset.height + borderInsets.top + borderInsets.bottom));
                rowCount = rowCount != 0 ? rowCount : 1;
                columnCount = thumbnailsCount / rowCount + (thumbnailsCount % rowCount != 0 ? 1 : 0);
            }
            this._thumbnailList.setVisibleRowCount(rowCount);
            Dimension preferredSize = new Dimension((this._thumbListModel.getThumbnailSize().width + this._thumbListModel.getThumbnailOffsets().width) * columnCount + borderInsets.left + borderInsets.right, (this._thumbListModel.getThumbnailSize().height + this._thumbListModel.getThumbnailOffsets().height + pageNumStringBounds.height + _pageNumStringOffset.height) * rowCount + borderInsets.top + borderInsets.bottom);
            return preferredSize;
        }
        return super.getPreferredSize();
    }

    public void setPopupMenu(JPopupMenu pMenu, String menuName) {
        if (menuName.equalsIgnoreCase("thumbPopup")) {
            this._thumbPopupMenu = pMenu;
        }
    }

    public void setOrientation(int orientation) {
        if (orientation == 1) {
            this._thumbnailList.setLayoutOrientation(1);
        } else {
            this._thumbnailList.setLayoutOrientation(2);
        }
        super.setOrientation(orientation);
    }

    public void valueChanged(ListSelectionEvent lse) {
        if (lse.getValueIsAdjusting()) {
            return;
        }
        if (lse.getSource().equals(this._thumbnailList)) {
            PPageModel thePageModel = (PPageModel)this.getDocModel();
            if (PPageTransferHandler.isDragging() || this.isDragging && this._dragStartInIndex != this._thumbnailList.getSelectedIndex()) {
                return;
            }
            int[] pageIndices = this._thumbnailList.getSelectedIndices();
            if (pageIndices.length == 1) {
                if (thePageModel.isPageValid(thePageModel.getPageNumber(pageIndices[0] + 1))) {
                    int selectedPageNumber = thePageModel.getPageNumber(pageIndices[0] + 1);
                    int[] selectedPages = thePageModel.getSelectedPages();
                    thePageModel.setFireChangeEvents(false);
                    thePageModel.setSelectedPages(null);
                    thePageModel.setFireChangeEvents(true);
                    if (selectedPages != null && selectedPages.length > 1) {
                        thePageModel.setSelectedPages(new int[]{selectedPageNumber});
                    } else {
                        thePageModel.setCurrentPagePosition(pageIndices[0] + 1);
                    }
                }
            } else {
                int[] pageNumbers = new int[pageIndices.length];
                for (int i = 0; i < pageIndices.length; ++i) {
                    pageNumbers[i] = thePageModel.getPageNumber(pageIndices[i] + 1);
                }
                try {
                    thePageModel.setSelectedPages(pageNumbers);
                }
                catch (IllegalArgumentException iae) {
                    // empty catch block
                }
            }
        }
    }

    public void mouseClicked(MouseEvent mEvent) {
        if ((mEvent.getModifiers() & 4) == 4 && this._thumbPopupMenu != null && this._thumbPopupMenu.isVisible()) {
            this.setPopupPoint(mEvent.getPoint());
        }
        if (mEvent.isPopupTrigger()) {
            this.showPopupMenu(mEvent);
        }
        if (mEvent.getClickCount() == 2) {
            this.fireActionEvent();
        }
        this.transferMouseEventToElement(mEvent);
    }

    public void mouseEntered(MouseEvent mEvent) {
        this.transferMouseEventToElement(mEvent);
    }

    public void mouseExited(MouseEvent mEvent) {
        this.transferMouseEventToElement(mEvent);
    }

    public void mousePressed(MouseEvent mEvent) {
        if (mEvent.isPopupTrigger()) {
            this.showPopupMenu(mEvent);
        }
        this._draggingRedRect = false;
        this.transferMouseEventToElement(mEvent);
    }

    public void mouseReleased(MouseEvent mEvent) {
        this.isDragging = false;
        if (mEvent.isPopupTrigger()) {
            this.showPopupMenu(mEvent);
        }
        this.transferMouseEventToElement(mEvent);
        this._draggingRedRect = false;
        this._thumbnailList.setValueIsAdjusting(false);
    }

    public void mouseDragged(MouseEvent mEvent) {
        if (!this.isDragging) {
            this.isDragging = true;
            this._dragStartInIndex = this._thumbnailList.locationToIndex(mEvent.getPoint());
        }
        this.transferMouseEventToElement(mEvent);
        this.repaint();
    }

    public void mouseMoved(MouseEvent mEvent) {
        this.transferMouseEventToElement(mEvent);
    }

    public void stateChanged(ChangeEvent evtChange) {
        if (this._thumbListModel == null) {
            return;
        }
        int firstVisible = this._thumbnailList.getFirstVisibleIndex();
        firstVisible = firstVisible < 0 ? 0 : firstVisible;
        int lastVisible = this._thumbnailList.getLastVisibleIndex();
        if (lastVisible == -1) {
            Dimension viewableDim = ((JViewport)evtChange.getSource()).getExtentSize();
            Insets borderInsets = this.getBorder().getBorderInsets(this);
            Dimension pageNumStringBounds = this.getPageNumberStringBounds(0);
            Dimension _pageNumStringOffset = new Dimension(4, 4);
            Dimension thumbnailSize = new Dimension(this._thumbListModel.getThumbnailSize().width + this._thumbListModel.getThumbnailOffsets().width + borderInsets.left + borderInsets.right, this._thumbListModel.getThumbnailSize().height + this._thumbListModel.getThumbnailOffsets().height + pageNumStringBounds.height + _pageNumStringOffset.height + borderInsets.top + borderInsets.bottom);
            lastVisible = this.getOrientation() == 1 ? viewableDim.height / thumbnailSize.height : viewableDim.width / thumbnailSize.width;
        }
        this._thumbListModel.setVisibleRange(firstVisible, lastVisible, this._thumbnailList.isShowing());
    }

    private void setPopupPoint(Point p) {
        int thumbIndex = this._thumbnailList.locationToIndex(p);
        PSingleThumbnailView tView = (PSingleThumbnailView)this._thumbListModel.getElementAt(thumbIndex);
        if (tView != null) {
            Rectangle thumbViewTopLeft = this._thumbnailList.getCellBounds(thumbIndex, thumbIndex);
            p.translate(-thumbViewTopLeft.x, -thumbViewTopLeft.y);
            this.popupPoint = tView.getViewPoint(p);
            this.popupPageNumber = tView.getPageNumber();
        }
    }

    private void showPopupMenu(MouseEvent e) {
        this.popupPoint = null;
        if (this._thumbPopupMenu != null) {
            Point ePoint = e.getPoint();
            int thumbIndex = this._thumbnailList.locationToIndex(ePoint);
            PSingleThumbnailView tView = (PSingleThumbnailView)this._thumbListModel.getElementAt(thumbIndex);
            if (tView != null) {
                Rectangle thumbViewTopLeft = this._thumbnailList.getCellBounds(thumbIndex, thumbIndex);
                ePoint.translate(-thumbViewTopLeft.x, -thumbViewTopLeft.y);
                this.popupPoint = tView.getViewPoint(ePoint);
                this.popupPageNumber = tView.getPageNumber();
            }
            this._thumbPopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void transferMouseEventToElement(MouseEvent mEvent) {
        boolean bCtrlDown;
        if (this._thumbnailList != mEvent.getSource()) {
            return;
        }
        boolean bShiftDown = (mEvent.getModifiersEx() & 0x40) == 64;
        boolean bl = bCtrlDown = (mEvent.getModifiersEx() & 0x80) == 128;
        if (bShiftDown || bCtrlDown) {
            return;
        }
        int thumbIndex = this._thumbnailList.locationToIndex(mEvent.getPoint());
        PSingleThumbnailView mousedView = (PSingleThumbnailView)this._thumbListModel.getElementAt(thumbIndex);
        if (mousedView != null) {
            Rectangle thumbViewTopLeft = this._thumbnailList.getCellBounds(thumbIndex, thumbIndex);
            MouseEvent meView = new MouseEvent(mousedView, mEvent.getID(), mEvent.getWhen(), mEvent.getModifiers(), mEvent.getX(), mEvent.getY(), mEvent.getClickCount(), mEvent.isPopupTrigger(), mEvent.getButton());
            meView.translatePoint(-thumbViewTopLeft.x, -thumbViewTopLeft.y);
            mousedView.dispatchEvent(meView);
            this.setCursor(mousedView.getCursor());
            if (mEvent.getID() == 501 || mEvent.getID() == 506) {
                if (!mousedView.isInRedRect()) {
                    this._thumbnailList.setDragEnabled(this._dragDropAllowed);
                } else {
                    this._draggingRedRect = true;
                }
            } else {
                this.isDragging = false;
                if (mousedView.isInRedRect()) {
                    this._thumbnailList.setDragEnabled(false);
                } else {
                    this._thumbnailList.setDragEnabled(this._dragDropAllowed);
                }
            }
        }
    }

    public void genericDocStateChanged(CMBGenericDocStateChangedEvent evt) {
        if (evt.getChangeType() == 10 || evt.getChangeType() == 11) {
            return;
        }
        if (evt.getChangeType() == 14 || evt.getChangeType() == 18 || evt.getChangeType() == 15 || evt.getChangeType() == 13 || evt.getChangeType() == 1 || evt.getChangeType() == 17 || evt.getChangeType() == 3) {
            this.updateThumbnails(evt);
        } else if (evt.getChangeType() == 4) {
            this.updateThumbnails(0, -1);
        }
        if (this.isDisplayNeeded()) {
            this.display();
        }
    }

    public void genericDocSelected(CMBGenericDocSelectedEvent evt) {
        if (this.isDisplayNeeded()) {
            this.display();
        }
    }

    public void componentAdded(ContainerEvent e) {
        JList component;
        if (e.getChild() instanceof JList && (component = (JList)e.getChild()).getParent() instanceof PThumbnailListView) {
            PThumbnailListView parent = (PThumbnailListView)component.getParent();
            this.updateMap("page_prev", component);
            this.updateMap("page_prev", parent);
            this.updateMap("page_next", component);
            this.updateMap("page_next", parent);
            this.updateMap("page_first", component);
            this.updateMap("page_first", parent);
            this.updateMap("page_last", component);
            this.updateMap("page_last", parent);
            this.updateMap("rotate_90", component);
            this.updateMap("rotate_90", parent);
            this.updateMap("rotate_180", component);
            this.updateMap("rotate_180", parent);
            this.updateMap("rotate_270", component);
            this.updateMap("rotate_270", parent);
        }
    }

    public void componentRemoved(ContainerEvent e) {
    }

    private void updateMap(String keyName, JComponent component) {
        Action a = this.getViewer().getGdv().getActionMap().get(keyName);
        if (a == null) {
            return;
        }
        KeyStroke ks = (KeyStroke)a.getValue("AcceleratorKey");
        if (ks == null) {
            return;
        }
        Object o = this.getViewer().getGdv().getInputMap(1).get(ks);
        if (o != null && this.getViewer().getGdv().getActionForKeyStroke(ks) != null) {
            a = (Action)this.getViewer().getGdv().getActionForKeyStroke(ks);
            String aName = null;
            if (a.getValue("Name") != null) {
                aName = (String)a.getValue("Name");
                o = component.getInputMap(0).get(ks);
                if (o != null) {
                    component.getInputMap(0).put(ks, aName);
                    component.getActionMap().put(aName, a);
                }
            }
        }
    }

    class PThumbnailList
    extends JList
    implements ComponentListener {
        private ThumbDropTargetListener thumbDropTargetListener;

        public PThumbnailList() {
            this.getAccessibleContext().setAccessibleName(PViewerUtilities.getMessage("DocumentViewer.thumbnailsAltText"));
            this.addComponentListener(this);
        }

        public void setSelectionInterval(int anchor, int lead) {
            if (PThumbnailListView.this.isDragging) {
                if (PThumbnailListView.this._dragDropAllowed && !PThumbnailListView.this._draggingRedRect) {
                    this.getSelectionModel().setSelectionInterval(anchor, lead);
                }
            } else {
                this.getSelectionModel().setSelectionInterval(anchor, lead);
            }
        }

        public JPopupMenu getComponentPopupMenu() {
            return PThumbnailListView.this._thumbPopupMenu;
        }

        public void setDropTarget(DropTarget t) {
            super.setDropTarget(t);
            if (t != null) {
                try {
                    if (this.thumbDropTargetListener == null) {
                        this.thumbDropTargetListener = new ThumbDropTargetListener();
                    }
                    t.removeDropTargetListener(this.thumbDropTargetListener);
                    t.addDropTargetListener(this.thumbDropTargetListener);
                }
                catch (TooManyListenersException tooManyListenersException) {
                    // empty catch block
                }
            }
        }

        public int getDropIndex() {
            PSingleThumbnailView stView;
            int selectedIndex = this.getSelectedIndex();
            if (this.isSelectionEmpty()) {
                selectedIndex = this.thumbDropTargetListener.previousIndex;
            }
            if ((stView = (PSingleThumbnailView)PThumbnailListView.this._thumbListModel.getElementAt(selectedIndex)).getDropBefore()) {
                return selectedIndex - 1;
            }
            return selectedIndex;
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (PThumbnailListView.this._thumbListModel.isBuilding()) {
                String loadingMesg = PViewerUtilities.getMessage("DocumentViewer.LoadingThumbnails");
                g.setColor(SystemColor.textText);
                int line = 1;
                int margin = 5;
                StringBuffer sb = new StringBuffer();
                Rectangle viewRect = PThumbnailListView.this._thumbnailList.getVisibleRect();
                FontMetrics fm = g.getFontMetrics();
                line = (viewRect.y + viewRect.height) / fm.getHeight() - 2;
                StringTokenizer st = new StringTokenizer(loadingMesg);
                while (st.hasMoreTokens()) {
                    String nextword = st.nextToken();
                    if (fm.stringWidth(sb.toString() + nextword) + margin < this.getSize().width) {
                        sb.append(nextword);
                        sb.append(' ');
                        continue;
                    }
                    if (sb.length() == 0) {
                        g.drawString(nextword, viewRect.x + viewRect.width - fm.stringWidth(nextword) - 5, line * fm.getHeight());
                        ++line;
                        continue;
                    }
                    g.drawString(sb.toString(), viewRect.x + viewRect.width - fm.stringWidth(sb.toString()) - 5, line * fm.getHeight());
                    sb = new StringBuffer(nextword + " ");
                    ++line;
                }
                if (sb.length() > 0) {
                    g.drawString(sb.toString(), viewRect.x + viewRect.width - fm.stringWidth(sb.toString()) - 5, line * fm.getHeight());
                    ++line;
                }
            }
        }

        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            if (visibleRect == null) {
                throw new IllegalArgumentException("visibleRect must be non-null");
            }
            switch (orientation) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
                }
            }
            int row = this.getFirstVisibleIndex();
            Rectangle r = this.getCellBounds(row, row);
            if (orientation == 0) {
                if (direction > 0) {
                    return r == null ? 15 : r.width - (visibleRect.x - r.x);
                }
                return visibleRect.x - r.x + 15;
            }
            if (direction > 0) {
                return r == null ? 15 : r.height - (visibleRect.y - r.y);
            }
            return visibleRect.y - r.y + 15;
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
        }

        public void componentShown(ComponentEvent e) {
            int leadSelectionIndex = this.getLeadSelectionIndex();
            this.ensureIndexIsVisible(leadSelectionIndex);
        }

        private class ThumbDropTargetListener
        extends DropTargetAdapter {
            boolean entered;
            PSingleThumbnailView previousMousedView;
            int previousIndex;

            private ThumbDropTargetListener() {
            }

            public void dragEnter(DropTargetDragEvent dtde) {
                this.entered = true;
            }

            public void dragExit(DropTargetEvent dte) {
                if (this.entered) {
                    this.entered = false;
                    int thumbListSize = PThumbnailListView.this._thumbnailList.getModel().getSize();
                    for (int i = 0; i < thumbListSize; ++i) {
                        PSingleThumbnailView thumbView = (PSingleThumbnailView)PThumbnailListView.this._thumbListModel.getElementAt(i);
                        thumbView.setFirstThumb(i == 0);
                        thumbView.clearDropFlags();
                    }
                    PThumbnailList.this.repaint();
                }
            }

            public void dragOver(DropTargetDragEvent dtde) {
                Point location = dtde.getLocation();
                int thumbListSize = PThumbnailListView.this._thumbnailList.getModel().getSize();
                int thumbIndex = PThumbnailListView.this._thumbnailList.locationToIndex(location);
                PSingleThumbnailView mousedView = (PSingleThumbnailView)PThumbnailListView.this._thumbListModel.getElementAt(thumbIndex);
                if (mousedView != null) {
                    Rectangle thumbViewBounds = PThumbnailListView.this._thumbnailList.getCellBounds(thumbIndex, thumbIndex);
                    Point thumbLocation = (Point)location.clone();
                    thumbLocation.translate(-thumbViewBounds.x, -thumbViewBounds.y);
                    boolean oldDropBefore = mousedView.getDropBefore();
                    boolean oldDropAfter = mousedView.getDropAfter();
                    mousedView.updateDropFlags(thumbLocation);
                    if (mousedView != this.previousMousedView || oldDropBefore != mousedView.getDropBefore() || oldDropAfter != mousedView.getDropAfter()) {
                        for (int i = 0; i < thumbListSize; ++i) {
                            Point ypt;
                            PSingleThumbnailView thumbView = (PSingleThumbnailView)PThumbnailListView.this._thumbListModel.getElementAt(i);
                            thumbViewBounds = PThumbnailListView.this._thumbnailList.getCellBounds(i, i);
                            thumbLocation = (Point)location.clone();
                            thumbLocation.translate(-thumbViewBounds.x, -thumbViewBounds.y);
                            thumbView.setFirstThumb(i == 0);
                            thumbView.updateDropFlags(thumbLocation);
                            PPageTransferHandler pageTransferHandler = (PPageTransferHandler)PThumbnailList.this.getTransferHandler();
                            if (!pageTransferHandler.validateLocalDropAfterPage(PThumbnailList.this)) {
                                thumbView.setValidDrop(false);
                            } else {
                                thumbView.setValidDrop(true);
                            }
                            if (PThumbnailListView.this._thumbnailList.getLayoutOrientation() != 2 || thumbViewBounds.contains(ypt = new Point((int)thumbViewBounds.getCenterX(), location.y))) continue;
                            thumbView.setValidDrop(false);
                        }
                        PThumbnailList.this.repaint();
                    }
                    this.previousMousedView = mousedView;
                    this.previousIndex = thumbIndex;
                }
            }

            public void drop(DropTargetDropEvent dtde) {
            }
        }
    }
}

