/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBDocumentEngineException;
import com.ibm.mm.viewer.CMBGenericDocStateChangedEvent;
import com.ibm.mm.viewer.PPageModel;
import com.ibm.mm.viewer.PSingleDocViewer;
import com.ibm.mm.viewer.PSingleThumbnailView;
import com.ibm.mm.viewer.PViewerUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;

class PThumbnailListModel
extends AbstractListModel
implements ListCellRenderer {
    private PSingleDocViewer _theViewer;
    private PPageModel _thePageModel;
    private Hashtable _thumbnails;
    private Dimension _thumbnailSize;
    private Dimension _thumbnailOffsets;
    private int _thumbnailsCount = 0;
    private ListSelectionModel _thumbListSelectionModel = null;
    static final short RENDER_VISIBLE = 0;
    static final short RENDER_AHEAD = 1;
    static final short RENDER_ALL = 2;
    static short _renderingMode = (short)2;
    static boolean _continuousPaginationEnabled = false;
    private int _firstVisibleIndex;
    private int _lastVisibleIndex;
    private boolean _listVisible = false;
    private thumbnailBuilder currThumbnailBuilder = null;

    public PThumbnailListModel(PSingleDocViewer viewer, PPageModel model) {
        this._theViewer = viewer;
        this._thePageModel = model;
        this._thumbnailSize = new Dimension(60, 78);
        this._thumbnailOffsets = new Dimension(20, 20);
        this._thumbnails = new Hashtable();
    }

    void buildThumbnails() throws IOException, CMBDocumentEngineException {
        if (this.currThumbnailBuilder == null) {
            this.currThumbnailBuilder = new thumbnailBuilder("ThumbnailBuilder");
            this.currThumbnailBuilder.setPriority(2);
            this.currThumbnailBuilder.byCurrThreadState = (byte)3;
            this.currThumbnailBuilder.byNextThreadState = (byte)2;
            this.currThumbnailBuilder.traceOut("in buildThumbnails THREAD " + this.currThumbnailBuilder.getName() + " is created, starting it now");
            try {
                this.currThumbnailBuilder.setDaemon(true);
            }
            catch (SecurityException e) {
                // empty catch block
            }
            this.currThumbnailBuilder.start();
        } else if (!this.currThumbnailBuilder.isAlive()) {
            this.currThumbnailBuilder = new thumbnailBuilder("ThumbnailBuilder");
            this.currThumbnailBuilder.traceOut("in buildThumbnails THREAD " + this.currThumbnailBuilder.getName() + " is not alive, starting it now");
            this.currThumbnailBuilder.byCurrThreadState = (byte)3;
            this.currThumbnailBuilder.byNextThreadState = (byte)2;
            this.currThumbnailBuilder.setPriority(2);
            try {
                this.currThumbnailBuilder.setDaemon(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.currThumbnailBuilder.start();
        } else if (this.currThumbnailBuilder.byCurrThreadState == 2 || this.currThumbnailBuilder.byCurrThreadState == 6) {
            this.currThumbnailBuilder.traceOut("in buildThumbnails thumbnailBuilder is alive\tand threadState is run or renderahead");
            this.currThumbnailBuilder.jumpPagePosition = this._firstVisibleIndex + 1;
            this.currThumbnailBuilder.byNextThreadState = (byte)5;
        } else if (this.currThumbnailBuilder.byCurrThreadState == 5) {
            this.currThumbnailBuilder.traceOut("in buildThumbnails thumbnailBuilder is alive\tand threadState is jumpto");
            if (this.currThumbnailBuilder.currPagePosition > this._firstVisibleIndex + 1) {
                this.currThumbnailBuilder.currPagePosition = this._firstVisibleIndex + 1;
            }
            this.currThumbnailBuilder.traceOut("currPagePosition changed to " + this.currThumbnailBuilder.currPagePosition);
        } else if (this.currThumbnailBuilder.byCurrThreadState == 0) {
            this.currThumbnailBuilder.traceOut("in buildThumbnails thumbnailBuilder is alive\tand threadState is stop");
            this.currThumbnailBuilder.byCurrThreadState = (byte)3;
            this.currThumbnailBuilder.byNextThreadState = (byte)3;
        } else if (this.currThumbnailBuilder.byCurrThreadState == 1) {
            this.currThumbnailBuilder.byNextThreadState = (byte)2;
        }
    }

    void updateThumbnails(int startPage, int endPage) {
        int currPagePosition = this._thePageModel.getCurrentPagePosition();
        if (startPage == 0 && endPage == 0) {
            startPage = currPagePosition;
            endPage = currPagePosition;
        }
        if (startPage == 0 && endPage == -1) {
            startPage = 1;
            endPage = this._thePageModel.getPageCount();
        }
        PSingleThumbnailView viewToUpdate = null;
        for (int index = startPage - 1; index < endPage; ++index) {
            try {
                int pageNumber = this._thePageModel.getPageNumber(index + 1);
                viewToUpdate = (PSingleThumbnailView)this._thumbnails.get(new Integer(pageNumber - 1));
                if (viewToUpdate == null) continue;
                viewToUpdate.clearThumbnail();
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        try {
            this.buildThumbnails();
        }
        catch (Exception e) {
            System.out.println("Thumbnails not built. Caught exception :" + e);
        }
    }

    void updateThumbnails(CMBGenericDocStateChangedEvent evt) {
        Image[] pageThumbnailImages;
        int[] pageNumbers = evt.getPageNumbers();
        int changeType = evt.getChangeType();
        boolean needToBuildThumbnails = false;
        int lastThumbPageNumber = 0;
        Enumeration thumbenum = this._thumbnails.elements();
        while (thumbenum.hasMoreElements()) {
            PSingleThumbnailView stView = (PSingleThumbnailView)thumbenum.nextElement();
            if (stView.getPageNumber() <= lastThumbPageNumber) continue;
            lastThumbPageNumber = stView.getPageNumber();
        }
        if (pageNumbers[pageNumbers.length - 1] > lastThumbPageNumber) {
            lastThumbPageNumber = pageNumbers[pageNumbers.length - 1];
        }
        if (changeType == 15) {
            pageThumbnailImages = evt.getPageThumbnails();
            PSingleThumbnailView viewToUpdate = null;
            for (int j = 0; j < pageNumbers.length; ++j) {
                for (int i = lastThumbPageNumber; i >= pageNumbers[j]; --i) {
                    viewToUpdate = (PSingleThumbnailView)this._thumbnails.remove(new Integer(i - 1));
                    if (viewToUpdate == null) continue;
                    viewToUpdate.setPageNumber(i + 1);
                    if (viewToUpdate.getPageNumber() > lastThumbPageNumber) {
                        lastThumbPageNumber = viewToUpdate.getPageNumber();
                    }
                    this._thumbnails.put(new Integer(i), viewToUpdate);
                }
                int pageNumber = pageNumbers[j];
                if (pageThumbnailImages != null && pageThumbnailImages[j] != null && this.getThumbnailSize().equals(evt.getThumbnailsSize()) && evt.areThumbnailsInverted() == this.getPageModel().getDocument().getInvert() && evt.areThumbnailsEnhanced() == this.getPageModel().getDocument().getEnhance() && evt.getThumbnailsRotation() == this.getPageModel().getDocument().getRotation()) {
                    PSingleThumbnailView singleThumbView = (PSingleThumbnailView)this.addNewElementAtPage(pageNumber);
                    if (this.isIndexInRenderingRange(pageNumber - 1)) {
                        singleThumbView.setUseSoftReference(false);
                    } else {
                        singleThumbView.setUseSoftReference(true);
                    }
                    singleThumbView.setThumbnailInfo(pageThumbnailImages[j], evt.getThumbnailsSize(), evt.areThumbnailsInverted(), evt.getThumbnailsRotation());
                }
                ++this._thumbnailsCount;
            }
            needToBuildThumbnails = true;
        } else if (changeType == 14) {
            pageThumbnailImages = new Image[pageNumbers.length];
            for (int i = 0; i < pageNumbers.length; ++i) {
                PSingleThumbnailView removedView = (PSingleThumbnailView)this._thumbnails.get(new Integer(pageNumbers[i] - 1));
                if (removedView == null) continue;
                pageThumbnailImages[i] = removedView.getThumbImage();
            }
            evt.setThumbnailsInfo(pageThumbnailImages, this.getThumbnailSize(), this.getPageModel().getDocument());
            PSingleThumbnailView viewToUpdate = null;
            for (int i = 0; i < pageNumbers.length; ++i) {
                for (int j = pageNumbers[i] - i; j < lastThumbPageNumber; ++j) {
                    this._thumbnails.remove(new Integer(j - 1));
                    viewToUpdate = (PSingleThumbnailView)this._thumbnails.remove(new Integer(j));
                    if (viewToUpdate == null) continue;
                    viewToUpdate.setPageNumber(j);
                    this._thumbnails.put(new Integer(j - 1), viewToUpdate);
                }
                --this._thumbnailsCount;
            }
            if (_renderingMode != 2) {
                needToBuildThumbnails = true;
            }
        } else if (changeType == 18) {
            pageThumbnailImages = new Image[pageNumbers.length];
            for (int i = 0; i < pageNumbers.length; ++i) {
                PSingleThumbnailView copiedView = (PSingleThumbnailView)this._thumbnails.get(new Integer(pageNumbers[i] - 1));
                if (copiedView == null) continue;
                pageThumbnailImages[i] = copiedView.getThumbImage();
            }
            evt.setThumbnailsInfo(pageThumbnailImages, this.getThumbnailSize(), this.getPageModel().getDocument());
        } else if (changeType == 1 || changeType == 17) {
            for (int i = 0; i < pageNumbers.length; ++i) {
                PSingleThumbnailView stView = (PSingleThumbnailView)this._thumbnails.get(new Integer(pageNumbers[i] - 1));
                if (stView == null || stView.getThumbImage() == null) {
                    needToBuildThumbnails = true;
                    continue;
                }
                if (stView.getThumbnailSize().equals(this._thumbnailSize) && stView.isThumbnailInverted() == this.getPageModel().isInvert() && stView.getThumbnailRotation() == this.getPageModel().getRotation()) continue;
                this._thumbnails.remove(new Integer(pageNumbers[i] - 1));
                needToBuildThumbnails = true;
            }
        } else if (changeType == 3 || changeType == 13) {
            for (int i = 0; i < pageNumbers.length; ++i) {
                PSingleThumbnailView stView = (PSingleThumbnailView)this._thumbnails.get(new Integer(pageNumbers[i] - 1));
                if (stView == null) continue;
                stView.clearThumbnail();
            }
            needToBuildThumbnails = true;
        }
        if (needToBuildThumbnails) {
            try {
                this.buildThumbnails();
            }
            catch (Exception e) {
                System.out.println("Thumbnails not built. Caught exception :" + e);
            }
        }
    }

    int getThumbnailsCount() {
        return this._thumbnails.size();
    }

    PPageModel getPageModel() {
        return this._thePageModel;
    }

    Dimension getThumbnailOffsets() {
        return this._thumbnailOffsets;
    }

    Dimension getThumbnailSize() {
        return this._thumbnailSize;
    }

    ListSelectionModel getThumbListSelectionModel() {
        return this._thumbListSelectionModel;
    }

    void setPageModel(PPageModel _thePageModel) {
        this._thePageModel = _thePageModel;
    }

    void setThumbnailOffsets(Dimension _thumbnailOffsets) {
        this._thumbnailOffsets = _thumbnailOffsets;
    }

    void setThumbnailSize(Dimension _thumbnailSize) {
        this._thumbnailSize = _thumbnailSize;
    }

    void setThumbListSelectionModel(ListSelectionModel thumbListSelectionModel) {
        this._thumbListSelectionModel = thumbListSelectionModel;
    }

    static short getRenderingMode() {
        return _renderingMode;
    }

    static void setRenderingMode(short mode) {
        _renderingMode = mode;
    }

    static boolean isContinuousPaginationEnabled() {
        return _continuousPaginationEnabled;
    }

    static void setContinuousPaginationEnabled(boolean value) {
        _continuousPaginationEnabled = value;
    }

    void setVisibleRange(int firstVisible, int lastVisible, boolean listVisible) {
        this._listVisible = listVisible;
        if (firstVisible != this._firstVisibleIndex || lastVisible != this._lastVisibleIndex) {
            this._firstVisibleIndex = firstVisible < 0 ? 0 : firstVisible;
            int n = this._lastVisibleIndex = lastVisible > this.getSize() - 1 ? this.getSize() - 1 : lastVisible;
            if (_renderingMode != 2) {
                try {
                    this.buildThumbnails();
                }
                catch (Exception e) {
                    System.out.println(PViewerUtilities.getMessage("DocumentViewer.thumbnailsNotBuilt") + e);
                }
            }
        }
    }

    boolean isIndexInRenderingRange(int index) {
        if (PThumbnailListModel.getRenderingMode() == 2) {
            return true;
        }
        return this.isIndexInVisibleRange(index);
    }

    boolean isIndexInVisibleRange(int index) {
        boolean inRange = false;
        int verifiedLastRenderableIndex = this._lastVisibleIndex;
        if (verifiedLastRenderableIndex <= 0) {
            int n = verifiedLastRenderableIndex = this.getSize() > 0 ? this.getSize() - 1 : 0;
        }
        if (index >= this._firstVisibleIndex && index <= verifiedLastRenderableIndex) {
            inRange = true;
        }
        return inRange;
    }

    void synchListSelectionToPageModel() {
        if (this.getElementAt(0) != null) {
            boolean inSynch = true;
            int[] selectedListIndices = this.getSelectedIndices();
            int[] selectedPageNumbers = this._thePageModel.getSelectedPages();
            int[] selectedPageIndices = new int[selectedPageNumbers.length];
            if (selectedListIndices.length != selectedPageNumbers.length) {
                inSynch = false;
            }
            for (int i = 0; i < selectedPageIndices.length; ++i) {
                selectedPageIndices[i] = this._thePageModel.getPagePosition(selectedPageNumbers[i]) - 1;
                if (i >= selectedListIndices.length) {
                    inSynch = false;
                    continue;
                }
                if (selectedListIndices[i] == selectedPageIndices[i]) continue;
                inSynch = false;
            }
            if (!inSynch) {
                this.setSelectedIndices(selectedPageIndices);
            }
        }
    }

    void dispose() {
        if (this.currThumbnailBuilder != null && this.currThumbnailBuilder.isAlive()) {
            this.currThumbnailBuilder.byCurrThreadState = 0;
            this.currThumbnailBuilder.byNextThreadState = 0;
            this.currThumbnailBuilder.interrupt();
            this.currThumbnailBuilder = null;
        }
        Enumeration enumSingleThumbViews = this._thumbnails.elements();
        while (enumSingleThumbViews.hasMoreElements()) {
            PSingleThumbnailView element = (PSingleThumbnailView)enumSingleThumbViews.nextElement();
            element.dispose();
        }
        this._thumbnails.clear();
        this._theViewer = null;
        this._thePageModel = null;
    }

    Object addNewElementAt(int index) {
        int currPageNumber = this._thePageModel.getPageNumber(index + 1);
        return this.addNewElementAtPage(currPageNumber);
    }

    Object addNewElementAtPage(int currPageNumber) {
        PSingleThumbnailView stView = new PSingleThumbnailView(this._theViewer, this._thePageModel);
        stView.setPageNumber(currPageNumber);
        if (PThumbnailListModel.getRenderingMode() != 2) {
            stView.setUseSoftReference(true);
        }
        stView.setThumbnailSize(this._thumbnailSize);
        stView.setThumbnailOffsets(this._thumbnailOffsets);
        stView.setIndicator();
        this._thumbnails.put(new Integer(currPageNumber - 1), stView);
        return stView;
    }

    boolean isBuilding() {
        return _renderingMode == 2 && this.currThumbnailBuilder != null && this.currThumbnailBuilder.byCurrThreadState != 0 && this.currThumbnailBuilder.byCurrThreadState != 6;
    }

    public int getSize() {
        int pageCountFromModel = -1;
        if (this._thePageModel != null) {
            pageCountFromModel = this._thePageModel.getPageCount();
        }
        if (pageCountFromModel >= 0) {
            return pageCountFromModel;
        }
        return this._thumbnails.size();
    }

    public Object getElementAt(int pageIndex) {
        int pageNumber = this._thePageModel.getPageNumber(pageIndex + 1);
        return this._thumbnails.get(new Integer(pageNumber - 1));
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        PSingleThumbnailView stView = null;
        stView = value instanceof PSingleThumbnailView ? (PSingleThumbnailView)value : (PSingleThumbnailView)this.addNewElementAt(index);
        stView.setHasFocus(hasFocus);
        if (stView.getViewer().getGdv().areThumbnailsDocked()) {
            if (list.getLayoutOrientation() == 0 || list.getLayoutOrientation() == 1) {
                stView.setOrientation(1);
            } else {
                stView.setOrientation(0);
            }
        } else {
            stView.setOrientation(0);
        }
        return stView;
    }

    private int[] getSelectedIndices() {
        int iMin = this._thumbListSelectionModel.getMinSelectionIndex();
        int iMax = this._thumbListSelectionModel.getMaxSelectionIndex();
        if (iMin < 0 || iMax < 0) {
            return new int[0];
        }
        int[] rvTmp = new int[1 + (iMax - iMin)];
        int n = 0;
        for (int i = iMin; i <= iMax; ++i) {
            if (!this._thumbListSelectionModel.isSelectedIndex(i)) continue;
            rvTmp[n++] = i;
        }
        int[] rv = new int[n];
        System.arraycopy(rvTmp, 0, rv, 0, n);
        return rv;
    }

    private void setSelectedIndices(int[] indices) {
        this._thumbListSelectionModel.clearSelection();
        for (int i = 0; i < indices.length; ++i) {
            try {
                this._thumbListSelectionModel.addSelectionInterval(indices[i], indices[i]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class thumbnailBuilder
    extends Thread {
        private boolean _trace;
        public int currPagePosition;
        public int jumpPagePosition;
        private static final byte TS_STOP = 0;
        private static final byte TS_PAUSE = 1;
        private static final byte TS_RUN = 2;
        private static final byte TS_INIT = 3;
        private static final byte TS_RESET = 4;
        private static final byte TS_JUMPTO = 5;
        private static final byte TS_RENDERAHEAD = 6;
        public byte byCurrThreadState;
        public byte byNextThreadState;

        public thumbnailBuilder(String name) {
            super(name);
            this._trace = false;
            this.currPagePosition = 0;
            this.jumpPagePosition = 0;
            this.byCurrThreadState = 1;
            this.byNextThreadState = (byte)2;
        }

        private void traceOut(String message) {
            if (this._trace) {
                System.out.println(this.getName() + this.hashCode() + ": " + message);
            }
        }

        public void run() {
            String methodName = "run";
            int pageCountFromModel = -1;
            PSingleThumbnailView singleThumbView = null;
            boolean next = true;
            int renderAheadPosition = 1;
            boolean renderingRange = false;
            while (this.byCurrThreadState != 0) {
                if (PThumbnailListModel.this._thePageModel == null) {
                    this.byCurrThreadState = 0;
                    this.byNextThreadState = 0;
                    return;
                }
                if (this.isInterrupted()) {
                    this.byCurrThreadState = 0;
                    this.byNextThreadState = 0;
                }
                switch (this.byCurrThreadState) {
                    case 1: {
                        this.traceOut("Entered TS_PAUSE");
                        try {
                            thumbnailBuilder.sleep(1000L);
                            this.byNextThreadState = (byte)2;
                        }
                        catch (InterruptedException e) {
                            this.byNextThreadState = 0;
                        }
                        this.traceOut("Exiting TS_PAUSE");
                        break;
                    }
                    case 4: {
                        this.traceOut("Entered TS_RESET");
                        final int size = PThumbnailListModel.this._thumbnails.size();
                        PThumbnailListModel.this._thumbnails.clear();
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                public void run() {
                                    PThumbnailListModel.this.fireIntervalRemoved(PThumbnailListModel.this, 0, size);
                                }
                            });
                            this.currPagePosition = 1;
                            this.byNextThreadState = 1;
                        }
                        catch (InterruptedException e) {
                            this.byNextThreadState = 0;
                        }
                        catch (Exception e) {
                            if (PThumbnailListModel.this._thePageModel != null && PThumbnailListModel.this._thePageModel.getDocument() != null && !PThumbnailListModel.this._thePageModel.getDocument().isDisposed()) {
                                ViewerLogger.logError((Object)this, methodName, e);
                            }
                            this.byNextThreadState = 0;
                        }
                        this.traceOut("Exiting TS_RESET");
                        break;
                    }
                    case 5: {
                        this.traceOut("Entered TS_JUMP");
                        int jumpPageNumber = PThumbnailListModel.this._thePageModel.getPageNumber(this.jumpPagePosition);
                        this.traceOut("\tjumpPageNumber " + jumpPageNumber);
                        try {
                            if (PThumbnailListModel.this._thumbnails.containsKey(new Integer(jumpPageNumber - 1))) {
                                this.traceOut("\tHas singleThumbnailView for page " + jumpPageNumber);
                                singleThumbView = (PSingleThumbnailView)PThumbnailListModel.this._thumbnails.get(new Integer(jumpPageNumber - 1));
                                if (singleThumbView.isDirty() || singleThumbView.getThumbImage() == null) {
                                    if (PThumbnailListModel.this.isIndexInRenderingRange(this.jumpPagePosition - 1)) {
                                        this.traceOut("\tBuilding thumbnail for page " + jumpPageNumber);
                                        singleThumbView.setUseSoftReference(false);
                                        singleThumbView.buildThumbnails();
                                        SwingUtilities.invokeAndWait(new Runnable(){

                                            public void run() {
                                                PThumbnailListModel.this.fireContentsChanged(PThumbnailListModel.this, thumbnailBuilder.this.jumpPagePosition - 1, thumbnailBuilder.this.jumpPagePosition - 1);
                                            }
                                        });
                                    } else {
                                        this.traceOut("\tThumbnail outside of rendering range, not building - page " + jumpPageNumber);
                                        singleThumbView.setUseSoftReference(true);
                                    }
                                }
                            } else {
                                this.traceOut("\tCreating singlethumbnailView for page " + jumpPageNumber);
                                singleThumbView = (PSingleThumbnailView)PThumbnailListModel.this.addNewElementAt(this.jumpPagePosition - 1);
                                if (PThumbnailListModel.this.isIndexInRenderingRange(this.jumpPagePosition - 1)) {
                                    singleThumbView.setUseSoftReference(false);
                                    singleThumbView.buildThumbnails();
                                } else {
                                    singleThumbView.setUseSoftReference(true);
                                }
                                singleThumbView.display();
                                if (singleThumbView.getThumbImage() != null) {
                                    final boolean synchSelection = PThumbnailListModel.this._thePageModel.isPageSelected(jumpPageNumber) != PThumbnailListModel.this._thumbListSelectionModel.isSelectedIndex(this.jumpPagePosition - 1);
                                    SwingUtilities.invokeAndWait(new Runnable(){

                                        public void run() {
                                            int leastSelectedIndex = PThumbnailListModel.this._thumbListSelectionModel.getMinSelectionIndex();
                                            if (thumbnailBuilder.this.jumpPagePosition > leastSelectedIndex + 1 && !PThumbnailListModel.this._thumbListSelectionModel.isSelectedIndex(thumbnailBuilder.this.jumpPagePosition - 1)) {
                                                thumbnailBuilder.this.traceOut("\t\tfiring intervalAdded");
                                                PThumbnailListModel.this.fireIntervalAdded(PThumbnailListModel.this, thumbnailBuilder.this.jumpPagePosition - 1, thumbnailBuilder.this.jumpPagePosition - 1);
                                                if (synchSelection) {
                                                    thumbnailBuilder.this.traceOut("\t\tfiring addSelectionInterval");
                                                    PThumbnailListModel.this._thumbListSelectionModel.addSelectionInterval(thumbnailBuilder.this.jumpPagePosition - 1, thumbnailBuilder.this.jumpPagePosition - 1);
                                                }
                                            } else {
                                                thumbnailBuilder.this.traceOut("\t\tfiring intervalChanged");
                                                PThumbnailListModel.this.fireContentsChanged(PThumbnailListModel.this, thumbnailBuilder.this.jumpPagePosition - 1, thumbnailBuilder.this.jumpPagePosition - 1);
                                            }
                                        }
                                    });
                                }
                            }
                            if (this.jumpPagePosition <= this.currPagePosition) {
                                this.traceOut("\t\tChanging currentPagePosition to jumpPagePosition+1");
                                this.currPagePosition = this.jumpPagePosition + 1;
                            }
                            this.byNextThreadState = (byte)2;
                        }
                        catch (InterruptedException e) {
                            this.byNextThreadState = 0;
                        }
                        catch (Exception ex) {
                            if (PThumbnailListModel.this._thePageModel != null && PThumbnailListModel.this._thePageModel.getDocument() != null && !PThumbnailListModel.this._thePageModel.getDocument().isDisposed()) {
                                ViewerLogger.logError((Object)this, methodName, ex);
                            }
                            this.byNextThreadState = 0;
                        }
                        catch (OutOfMemoryError memError) {
                            System.out.println("Getting pageImage:" + memError);
                            this.byNextThreadState = 1;
                        }
                        this.traceOut("Exiting TS_JUMP");
                        break;
                    }
                    case 3: {
                        this.traceOut("Entering TS_INIT");
                        pageCountFromModel = PThumbnailListModel.this._thePageModel.getPageCount();
                        if (pageCountFromModel == 0) {
                            this.traceOut("pageCountFromModel = 0");
                            PThumbnailListModel.this._thumbnailsCount = 0;
                            this.byCurrThreadState = 0;
                            this.byNextThreadState = 0;
                            break;
                        }
                        if (pageCountFromModel < 0) {
                            this.traceOut("pageCountFromModel < 0");
                            PThumbnailListModel.this._thumbnailsCount = 0;
                        } else {
                            this.traceOut("_thumbnailsCount=pageCountFromModel=" + pageCountFromModel);
                            PThumbnailListModel.this._thumbnailsCount = pageCountFromModel;
                        }
                        this.currPagePosition = 1;
                        this.byCurrThreadState = (byte)2;
                        this.byNextThreadState = (byte)2;
                        this.traceOut("Falling through to TS_RUN");
                    }
                    case 2: {
                        this.traceOut("Entering TS_RUN:currPagePosition: " + this.currPagePosition + " and pageCountFromModel=" + pageCountFromModel);
                        try {
                            if (PThumbnailListModel.this._thePageModel == null) {
                                this.byCurrThreadState = 0;
                                this.byNextThreadState = 0;
                                return;
                            }
                            if (this.currPagePosition < 1 || !PThumbnailListModel.this._thePageModel.isValidPagePosition(this.currPagePosition)) {
                                if (_renderingMode == 1) {
                                    renderAheadPosition = 1;
                                    this.byCurrThreadState = (byte)6;
                                    this.byNextThreadState = (byte)6;
                                } else {
                                    this.byCurrThreadState = 0;
                                    this.byNextThreadState = 0;
                                }
                                PThumbnailListModel.this.fireContentsChanged(PThumbnailListModel.this, pageCountFromModel - 1, pageCountFromModel - 1);
                                this.traceOut("\tcurrPagePosition=" + this.currPagePosition + "and pageCountFromModel=" + pageCountFromModel + " hence changing to TS_STOP");
                                this.traceOut("Exiting TS_RUN");
                                break;
                            }
                            int currPageNumber = PThumbnailListModel.this._thePageModel.getPageNumber(this.currPagePosition);
                            if (PThumbnailListModel.this._thumbnails.containsKey(new Integer(currPageNumber - 1))) {
                                this.traceOut("\tHas singleThumbView for page " + currPageNumber);
                                singleThumbView = (PSingleThumbnailView)PThumbnailListModel.this._thumbnails.get(new Integer(currPageNumber - 1));
                                if (PThumbnailListModel.this.isIndexInRenderingRange(this.currPagePosition - 1)) {
                                    singleThumbView.setUseSoftReference(false);
                                } else {
                                    singleThumbView.setUseSoftReference(true);
                                }
                                if (singleThumbView.isDirty() || singleThumbView.getThumbImage() == null) {
                                    if (PThumbnailListModel.this.isIndexInRenderingRange(this.currPagePosition - 1)) {
                                        this.traceOut("\tBuilding thumbnail for page " + currPageNumber);
                                        singleThumbView.buildThumbnails();
                                        SwingUtilities.invokeAndWait(new Runnable(){

                                            public void run() {
                                                PThumbnailListModel.this.fireContentsChanged(PThumbnailListModel.this, thumbnailBuilder.this.currPagePosition - 1, thumbnailBuilder.this.currPagePosition - 1);
                                            }
                                        });
                                    } else {
                                        this.traceOut("\tThumbnail is outside of rendering range, not building a thumbnail for page " + currPageNumber);
                                    }
                                } else {
                                    this.traceOut("\tThumbnail already exists and is current, not building a new thumbnail for page " + currPageNumber);
                                }
                                ++this.currPagePosition;
                            } else {
                                this.traceOut("\tCreating singleThumbView for page " + currPageNumber);
                                singleThumbView = (PSingleThumbnailView)PThumbnailListModel.this.addNewElementAt(this.currPagePosition - 1);
                                if (PThumbnailListModel.this.isIndexInRenderingRange(this.currPagePosition - 1)) {
                                    singleThumbView.setUseSoftReference(false);
                                    singleThumbView.buildThumbnails();
                                } else {
                                    singleThumbView.setUseSoftReference(true);
                                }
                                singleThumbView.display();
                                if (pageCountFromModel == -1 && PThumbnailListModel.this._thumbnailsCount < this.currPagePosition) {
                                    PThumbnailListModel.this._thumbnailsCount++;
                                }
                                if (pageCountFromModel == -1 && (pageCountFromModel = PThumbnailListModel.this._thePageModel.getPageCount()) != -1) {
                                    PThumbnailListModel.this._thumbnailsCount = pageCountFromModel;
                                }
                                if (pageCountFromModel != -1 && this.currPagePosition >= pageCountFromModel) {
                                    this.traceOut("\tcurrPageNumber=" + currPageNumber + "pageCountfromModel=" + pageCountFromModel + " hence changing to TS_STOP");
                                    if (_renderingMode == 1) {
                                        renderAheadPosition = 1;
                                        this.byNextThreadState = (byte)6;
                                    } else {
                                        this.byCurrThreadState = 0;
                                        this.byNextThreadState = 0;
                                    }
                                }
                                final boolean synchSelection = PThumbnailListModel.this._thePageModel != null && PThumbnailListModel.this._thePageModel.isPageSelected(currPageNumber);
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    public void run() {
                                        int leastSelectedIndex = PThumbnailListModel.this._thumbListSelectionModel.getMinSelectionIndex();
                                        if (thumbnailBuilder.this.currPagePosition > leastSelectedIndex + 1 && !PThumbnailListModel.this._thumbListSelectionModel.isSelectedIndex(thumbnailBuilder.this.currPagePosition - 1)) {
                                            thumbnailBuilder.this.traceOut("\t\tfiring intervalAdded");
                                            PThumbnailListModel.this.fireIntervalAdded(PThumbnailListModel.this, thumbnailBuilder.this.currPagePosition - 1, thumbnailBuilder.this.currPagePosition - 1);
                                            if (synchSelection) {
                                                thumbnailBuilder.this.traceOut("\t\tfiring addSelectionInterval");
                                                PThumbnailListModel.this._thumbListSelectionModel.addSelectionInterval(thumbnailBuilder.this.currPagePosition - 1, thumbnailBuilder.this.currPagePosition - 1);
                                            }
                                        } else {
                                            thumbnailBuilder.this.traceOut("\t\tfiring contentChanged");
                                            PThumbnailListModel.this.fireContentsChanged(PThumbnailListModel.this, thumbnailBuilder.this.currPagePosition - 1, thumbnailBuilder.this.currPagePosition - 1);
                                        }
                                    }
                                });
                                ++this.currPagePosition;
                            }
                        }
                        catch (InterruptedException e) {
                            this.byNextThreadState = 0;
                        }
                        catch (Exception ex) {
                            if (PThumbnailListModel.this._thePageModel != null && PThumbnailListModel.this._thePageModel.getDocument() != null && !PThumbnailListModel.this._thePageModel.getDocument().isDisposed()) {
                                ViewerLogger.logError((Object)this, methodName, ex);
                            }
                            this.byNextThreadState = 0;
                            if (!PThumbnailListModel.this._thumbListSelectionModel.isSelectedIndex(this.currPagePosition - 1)) {
                                PThumbnailListModel.this.fireIntervalAdded(PThumbnailListModel.this, this.currPagePosition - 1, this.currPagePosition - 1);
                            }
                        }
                        catch (OutOfMemoryError memError) {
                            this.traceOut("Getting pageImage:" + memError);
                            this.byNextThreadState = 1;
                        }
                        this.traceOut("Exiting TS_RUN");
                        break;
                    }
                    case 6: {
                        int raPagePosition;
                        this.traceOut("Entered TS_RENDERAHEAD");
                        if (next) {
                            raPagePosition = PThumbnailListModel.this._lastVisibleIndex + 1 + renderAheadPosition > PThumbnailListModel.this.getSize() ? PThumbnailListModel.this.getSize() : PThumbnailListModel.this._lastVisibleIndex + 1 + renderAheadPosition;
                            next = false;
                        } else {
                            raPagePosition = PThumbnailListModel.this._firstVisibleIndex + 1 - renderAheadPosition < 1 ? 1 : PThumbnailListModel.this._firstVisibleIndex + 1 - renderAheadPosition;
                            next = true;
                        }
                        int raPageNumber = PThumbnailListModel.this._thePageModel.getPageNumber(raPagePosition);
                        this.traceOut("\traPageNumber " + raPageNumber);
                        try {
                            if (PThumbnailListModel.this._thePageModel.isPageValid(raPageNumber)) {
                                if (PThumbnailListModel.this._thumbnails.containsKey(new Integer(raPageNumber - 1))) {
                                    this.traceOut("\tHas singleThumbnailView for page " + raPageNumber);
                                    singleThumbView = (PSingleThumbnailView)PThumbnailListModel.this._thumbnails.get(new Integer(raPageNumber - 1));
                                    if (singleThumbView.isDirty() || singleThumbView.getThumbImage() == null) {
                                        this.traceOut("\tBuilding thumbnail for page " + raPageNumber);
                                        singleThumbView.setUseSoftReference(true);
                                        singleThumbView.buildThumbnails();
                                        SwingUtilities.invokeAndWait(new Runnable(){

                                            public void run() {
                                                PThumbnailListModel.this.fireContentsChanged(PThumbnailListModel.this, raPagePosition - 1, raPagePosition - 1);
                                            }
                                        });
                                    } else {
                                        this.traceOut("\tThumbnail already exists and is current, not building a thumbnail for page " + raPageNumber);
                                    }
                                } else {
                                    this.traceOut("\tCreating singlethumbnailView for page " + raPageNumber);
                                    singleThumbView = (PSingleThumbnailView)PThumbnailListModel.this.addNewElementAt(raPagePosition - 1);
                                    singleThumbView.setUseSoftReference(true);
                                    singleThumbView.buildThumbnails();
                                    singleThumbView.display();
                                    if (singleThumbView.getThumbImage() != null) {
                                        final boolean synchSelection = PThumbnailListModel.this._thePageModel.isPageSelected(raPageNumber) != PThumbnailListModel.this._thumbListSelectionModel.isSelectedIndex(raPagePosition - 1);
                                        SwingUtilities.invokeAndWait(new Runnable(){

                                            public void run() {
                                                int leastSelectedIndex = PThumbnailListModel.this._thumbListSelectionModel.getMinSelectionIndex();
                                                if (raPagePosition > leastSelectedIndex + 1 && !PThumbnailListModel.this._thumbListSelectionModel.isSelectedIndex(raPagePosition - 1)) {
                                                    thumbnailBuilder.this.traceOut("\t\tfiring intervalAdded");
                                                    PThumbnailListModel.this.fireIntervalAdded(PThumbnailListModel.this, raPagePosition - 1, raPagePosition - 1);
                                                    if (synchSelection) {
                                                        thumbnailBuilder.this.traceOut("\t\tfiring addSelectionInterval");
                                                        PThumbnailListModel.this._thumbListSelectionModel.addSelectionInterval(raPagePosition - 1, raPagePosition - 1);
                                                    }
                                                } else {
                                                    thumbnailBuilder.this.traceOut("\t\tfiring intervalChanged");
                                                    PThumbnailListModel.this.fireContentsChanged(PThumbnailListModel.this, raPagePosition - 1, raPagePosition - 1);
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                            if (next) {
                                ++renderAheadPosition;
                            }
                            if (renderAheadPosition > PThumbnailListModel.this._lastVisibleIndex - PThumbnailListModel.this._firstVisibleIndex + 1) {
                                if (this.byNextThreadState != 5) {
                                    this.byNextThreadState = 0;
                                }
                                this.traceOut("Exiting TS_RENDERAHEAD");
                            }
                        }
                        catch (InterruptedException e) {
                            this.byNextThreadState = 0;
                        }
                        catch (Exception ex) {
                            if (PThumbnailListModel.this._thePageModel != null && PThumbnailListModel.this._thePageModel.getDocument() != null && !PThumbnailListModel.this._thePageModel.getDocument().isDisposed()) {
                                ViewerLogger.logError((Object)this, methodName, ex);
                            }
                            this.byNextThreadState = 0;
                        }
                        catch (OutOfMemoryError memError) {
                            System.out.println("Getting pageImage:" + memError);
                            this.byNextThreadState = 1;
                        }
                        this.traceOut("Exiting TS_RENDERAHEAD");
                    }
                }
                this.traceOut("Changing from " + this.byCurrThreadState + " to " + this.byNextThreadState);
                this.byCurrThreadState = this.byNextThreadState;
            }
        }
    }
}

