/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBViewerTask;
import com.ibm.mm.viewer.PRedo;
import com.ibm.mm.viewer.PSave;
import com.ibm.mm.viewer.PUndo;
import java.util.LinkedList;

class PTaskManager {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private static final int MAX_HISTORY_LENGTH = 25;
    private LinkedList history = new LinkedList();
    private LinkedList redoList = new LinkedList();
    private int maxHistoryLength = 25;
    private int nesting;

    boolean canUndo() {
        return !this.history.isEmpty();
    }

    String getUndoDescription() {
        if (this.history.isEmpty()) {
            return "";
        }
        CMBViewerTask task = (CMBViewerTask)this.history.getFirst();
        return task.getDescription();
    }

    boolean canRedo() {
        return !this.redoList.isEmpty();
    }

    String getRedoDescription() {
        if (this.redoList.isEmpty()) {
            return "";
        }
        CMBViewerTask task = (CMBViewerTask)this.redoList.getFirst();
        return task.getDescription();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeTask(CMBViewerTask task, boolean doItNow) {
        if (task instanceof PUndo) {
            this.undo();
            return;
        }
        if (task instanceof PRedo) {
            this.redo();
            return;
        }
        if (task instanceof PSave) {
            this.clearTaskHistory();
        } else {
            boolean taskCompletedSuccessfully;
            if (doItNow) {
                ++this.nesting;
                try {
                    taskCompletedSuccessfully = task.doIt();
                }
                finally {
                    --this.nesting;
                }
            } else {
                taskCompletedSuccessfully = true;
            }
            if (this.nesting == 0 && taskCompletedSuccessfully) {
                this.addToTaskHistory(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undo() {
        if (this.history.size() > 0) {
            CMBViewerTask task = (CMBViewerTask)this.history.removeFirst();
            try {
                ++this.nesting;
                task.undoIt();
            }
            finally {
                --this.nesting;
            }
            this.redoList.addFirst(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redo() {
        if (this.redoList.size() > 0) {
            CMBViewerTask task = (CMBViewerTask)this.redoList.removeFirst();
            try {
                ++this.nesting;
                task.doIt();
            }
            finally {
                --this.nesting;
            }
            this.history.addFirst(task);
        }
    }

    private void addToTaskHistory(CMBViewerTask task) {
        this.history.addFirst(task);
        if (this.history.size() > this.maxHistoryLength) {
            this.history.removeLast();
        }
        if (this.redoList.size() > 0) {
            this.redoList.clear();
        }
    }

    private void clearTaskHistory() {
        this.history.clear();
        if (this.redoList.size() > 0) {
            this.redoList.clear();
        }
    }

    void dispose() {
        this.history.clear();
        this.history = null;
        this.redoList.clear();
        this.redoList = null;
    }

    void setMaxHistoryLength(int i) {
        this.maxHistoryLength = i;
    }

    int getMaxHistoryLength() {
        return this.maxHistoryLength;
    }
}

