/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.PFindPanel;
import com.ibm.mm.viewer.PFullSizePageView;
import com.ibm.mm.viewer.PFullSizeView;
import com.ibm.mm.viewer.PPageModel;
import com.ibm.mm.viewer.PPageViewer;
import com.ibm.mm.viewer.PSingleDocViewer;
import com.ibm.mm.viewer.PThumbnailListView;
import com.ibm.mm.viewer.PThumbnailsView;
import com.ibm.mm.viewer.PViewerLayout;
import com.ibm.mm.viewer.PViewerUtilities;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import com.ibm.mm.viewer.annotation.CMBAnnotationView;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class PTabbedViewerLayout
extends PViewerLayout
implements ChangeListener {
    private CMBGenericDocViewer gdv;
    private JPanel mainPanel;
    private JTabbedPane tabbedPane;
    private PThumbnailsPanel thumbnailsPanel;
    private PFindPanel findPanel;
    private ArrayList fullSizeViews = new ArrayList();
    private EventHandler eventHandler = new EventHandler();

    public PTabbedViewerLayout(CMBGenericDocViewer gdv) {
        this.gdv = gdv;
        gdv.currentLayout = this;
        this.mainPanel = new JPanel(){

            public void requestFocus() {
                PTabbedViewerLayout.this.tabbedPane.requestFocus();
            }
        };
        this.mainPanel.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addContainerListener(this.eventHandler);
        this.thumbnailsPanel = new PThumbnailsPanel();
        this.thumbnailsPanel.setLayout(new CardLayout());
        this.thumbnailsPanel.addContainerListener(this.eventHandler);
        this.mainPanel.add((Component)this.thumbnailsPanel, gdv.getThumbnailsPosition());
        this.findPanel = new PFindPanel(gdv);
        this.showFindPanel(false);
        if (gdv.getThumbnailsPosition().equalsIgnoreCase("North")) {
            this.mainPanel.add((Component)this.findPanel, "South");
        } else {
            this.mainPanel.add((Component)this.findPanel, "North");
        }
        this.mainPanel.add((Component)this.tabbedPane, "Center");
        ActionListener enterViewAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PFullSizeView view = PTabbedViewerLayout.this.gdv.getSelectedView();
                if (view != null) {
                    view.requestFocus();
                }
            }
        };
        this.tabbedPane.registerKeyboardAction(enterViewAction, KeyStroke.getKeyStroke(10, 0, false), 2);
        this.thumbnailsPanel.setFocusable(false);
        if (gdv.getViewerCount() == 0) {
            this.tabbedPane.setEnabled(false);
        }
        PSingleDocViewer selectedViewer = gdv.getSelectedViewer();
        for (int i = 0; i < gdv.getViewerCount(); ++i) {
            PSingleDocViewer viewer = gdv.getViewer(i);
            this.addDocView(viewer.getDocModel().getDocument(), viewer.getDocModel().getAnnotationSet(), viewer.getDocModel().getDocName(), viewer == selectedViewer);
            this.buildThumbnails(viewer.getDocModel().getDocument());
        }
        if (gdv.getSelectedDocument() != null) {
            this.activateDocument(gdv.getSelectedDocument());
        }
        this.addViewerTabbedPaneChangeListener();
    }

    public int getViewType() {
        return 0;
    }

    public JComponent getViewerComponent() {
        return this.mainPanel;
    }

    public void dispose() {
        for (int i = 0; i < this.fullSizeViews.size(); ++i) {
            PFullSizeView fullSizeView = (PFullSizeView)this.fullSizeViews.get(i);
            if (fullSizeView.getViewer() == null) continue;
            fullSizeView.getViewer().destroyFullSizeView(fullSizeView);
        }
        this.fullSizeViews.clear();
        this.mainPanel.removeAll();
        this.mainPanel = null;
        this.tabbedPane.removeChangeListener(this);
        this.tabbedPane.removeAll();
        this.tabbedPane = null;
    }

    public void registerKeyboardAction(Action action, KeyStroke keystroke, int inputMapID) {
        String aCommand = (String)action.getValue("Name");
        this.tabbedPane.getInputMap(inputMapID).put(keystroke, aCommand);
        this.tabbedPane.getActionMap().put(aCommand, action);
        for (int i = 0; i < this.fullSizeViews.size(); ++i) {
            PFullSizeView view = (PFullSizeView)this.fullSizeViews.get(i);
            view.getInputMap(inputMapID).put(keystroke, aCommand);
            view.getActionMap().put(aCommand, action);
        }
    }

    private void addViewerTabbedPaneChangeListener() {
        ChangeListener[] cls = (ChangeListener[])this.tabbedPane.getListeners(ChangeListener.class);
        boolean found = false;
        for (int i = 0; i < cls.length; ++i) {
            if (!cls[i].equals(this)) continue;
            found = true;
        }
        if (!found) {
            this.tabbedPane.addChangeListener(this);
        }
    }

    public void activateDocument(CMBDocument document) {
        PFullSizePageView pageView;
        for (int i = 0; i < this.gdv.getViewerCount(); ++i) {
            PSingleDocViewer v = this.gdv.getViewer(i);
            v.getDocModel().setActiveDocument(false);
        }
        PSingleDocViewer viewer = this.gdv.getViewer(document);
        this.gdv.setSelectedViewer(viewer);
        PFullSizeView docView = null;
        if (viewer != null) {
            docView = viewer.getFullSizeView(0);
        }
        if (docView != null) {
            this.gdv.validate();
            if (docView.getDocModel() != null) {
                docView.getDocModel().setActiveDocument(true);
            }
            this.tabbedPane.removeChangeListener(this);
            try {
                this.tabbedPane.setSelectedComponent(docView.getParent().getParent());
            }
            catch (Exception e) {
                // empty catch block
            }
            this.addViewerTabbedPaneChangeListener();
            this.gdv.checkToIndicateDocument();
        }
        this.activateThumbnailView(document);
        if (this.gdv.getAnnotationServices() != null && this.gdv.getSelectedAnnotationSet() != null && docView instanceof PFullSizePageView && (pageView = (PFullSizePageView)docView).getAnnotationView() != null) {
            this.gdv.getAnnotationServices().setAnnotationView(pageView.getAnnotationView(), pageView.getAnnotationView().getModel());
        }
        ((PPageModel)docView.getDocModel()).activeFullSizeView = docView;
        this.gdv.fireCMBDocSelectedEvent(document);
    }

    private void activateThumbnailView(CMBDocument document) {
        String methodName = "activateThumbnailView";
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component c = focusManager.getFocusOwner();
        PThumbnailsView thumbView = null;
        PSingleDocViewer viewer = this.gdv.getViewer(document);
        if (viewer != null) {
            thumbView = viewer.getThumbnailsView();
            if (thumbView != null) {
                if (this.gdv.areThumbnailsShowing()) {
                    try {
                        thumbView.buildThumbnails();
                    }
                    catch (Exception e) {
                        System.out.println(PViewerUtilities.getMessage("DocumentViewer.thumbnailsNotBuilt") + e);
                    }
                    this.gdv._setThumbsViewOrientation(thumbView);
                }
                this.thumbnailsPanel.setVisible(this.gdv.areThumbnailsShowing());
                thumbView.setDisplayNeeded(this.gdv.areThumbnailsShowing());
                CardLayout currThumbLayout = (CardLayout)this.thumbnailsPanel.getLayout();
                try {
                    currThumbLayout.show(this.thumbnailsPanel, document.toString());
                    if (c != null && c.getParent() instanceof PThumbnailListView) {
                        thumbView.requestFocus();
                    }
                }
                catch (Exception e) {
                    ViewerLogger.logError((Object)this, methodName, e);
                }
            }
            this.gdv.revalidate();
            this.addViewerTabbedPaneChangeListener();
            JScrollPane scrollPane = (JScrollPane)viewer.getFullSizeView(0).getParent().getParent();
            if (viewer instanceof PPageViewer) {
                scrollPane.getViewport().addChangeListener((PFullSizePageView)viewer.getFullSizeView(0));
            }
        }
    }

    public void closeDocument(CMBDocument document, boolean activate) {
        String methodName = "closeDocument";
        PSingleDocViewer viewer = this.gdv.getViewer(document);
        if (viewer instanceof PPageViewer) {
            this.tabbedPane.removeMouseListener((PFullSizePageView)viewer.getFullSizeView(0));
        }
        int index = this.gdv.getViewerIndex(viewer);
        try {
            PThumbnailsView thumbView = viewer.getThumbnailsView();
            JScrollPane scrollPane = (JScrollPane)thumbView.getParent().getParent();
            this.tabbedPane.removeChangeListener(this);
            this.tabbedPane.removeTabAt(index);
            this.addViewerTabbedPaneChangeListener();
            this.fullSizeViews.remove(index);
            this.thumbnailsPanel.remove(scrollPane);
            if (this.gdv.getViewerCount() <= 1) {
                this.thumbnailsPanel.setVisible(false);
                if (!this.gdv.areThumbnailsDocked() && this.gdv.thumbnailWindow != null) {
                    this.gdv.thumbnailWindow.setVisible(false);
                }
                if (this.getFindPanel() != null) {
                    this.getFindPanel().show(false);
                }
            }
            this.gdv.validate();
        }
        catch (IndexOutOfBoundsException e) {
            ViewerLogger.logError((Object)this, methodName, e);
        }
    }

    public JPanel getThumbnailsPanel() {
        return this.thumbnailsPanel;
    }

    public void setThumbnailsPosition(String thumbnailsPosition) {
        if (this.gdv.areThumbnailsDocked()) {
            this.mainPanel.remove(this.thumbnailsPanel);
            if (thumbnailsPosition.equalsIgnoreCase("North")) {
                this.mainPanel.add((Component)this.thumbnailsPanel, "North");
            } else if (thumbnailsPosition.equalsIgnoreCase("South")) {
                this.mainPanel.add((Component)this.thumbnailsPanel, "South");
            } else if (thumbnailsPosition.equalsIgnoreCase("East")) {
                this.mainPanel.add((Component)this.thumbnailsPanel, "East");
            } else if (thumbnailsPosition.equalsIgnoreCase("West")) {
                this.mainPanel.add((Component)this.thumbnailsPanel, "West");
            }
        }
        int selIndex = this.tabbedPane.getSelectedIndex();
        int tabCount = this.tabbedPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            PSingleDocViewer viewer = this.gdv.getViewer(i);
            PThumbnailsView thumbnailView = viewer.getThumbnailsView();
            if (thumbnailsPosition.equalsIgnoreCase("North") || thumbnailsPosition.equalsIgnoreCase("South")) {
                thumbnailView.setOrientation(0);
                continue;
            }
            thumbnailView.setOrientation(1);
        }
        this.gdv.revalidate();
    }

    public void setTabPlacement(int position) {
        this.tabbedPane.setTabPlacement(position);
    }

    public PFullSizeView getSelectedFullSizeView() {
        if (this.tabbedPane == null) {
            return null;
        }
        JScrollPane scrollPane = (JScrollPane)this.tabbedPane.getSelectedComponent();
        if (scrollPane == null) {
            return null;
        }
        return (PFullSizeView)scrollPane.getViewport().getView();
    }

    public void indicateDocument(CMBDocument document, boolean indicate) {
        PSingleDocViewer docView = this.gdv.getViewer(document);
        if (docView == null) {
            return;
        }
        if (indicate && this.gdv.hasDocumentBeenViewed(document)) {
            String indicateString = (String)this.gdv.getClientProperty("Appearance.tab.color");
            String htmlColor = "<p style=\"color : " + indicateString + "\">";
            String indicateStyle = (String)this.gdv.getClientProperty("Appearance.tab.fontstyle");
            String title = PViewerUtilities.stripHtml(this.gdv.getDocName(document));
            if (indicateStyle.equalsIgnoreCase("bold")) {
                String styleString = "<html><body>" + htmlColor + "<b>" + title + "</b></p></body></html>";
                this.setStyledDocName(document, styleString);
            } else if (indicateStyle.equalsIgnoreCase("italic")) {
                String styleString = "<html><body>" + htmlColor + "<i>" + title + "</i></p></body></html>";
                this.setStyledDocName(document, styleString);
            } else if (indicateStyle.equalsIgnoreCase("bold_italic")) {
                String styleString = "<html><body>" + htmlColor + "<b><i>" + title + "</i></b></p></body></html>";
                this.setStyledDocName(document, styleString);
            } else if (indicateStyle.equalsIgnoreCase("plain")) {
                String styleString = "<html><body>" + htmlColor + title + "</p></body></html>";
                this.setStyledDocName(document, styleString);
            }
        } else {
            String title = this.gdv.getDocName(document);
            this.setStyledDocName(document, this.gdv.getDocName(document));
        }
    }

    private void setStyledDocName(CMBDocument document, String styledDocName) {
        PSingleDocViewer viewer = this.gdv.getViewer(document);
        int index = this.gdv.getViewerIndex(viewer);
        if (index > -1 && this.tabbedPane != null) {
            this.tabbedPane.setTitleAt(index, styledDocName);
            if (this.gdv.hasDocumentBeenViewed(document)) {
                this.tabbedPane.setToolTipTextAt(index, PViewerUtilities.getMessage("DocumentViewer.documentViewed"));
            } else {
                this.tabbedPane.setToolTipTextAt(index, PViewerUtilities.getMessage("DocumentViewer.documentNotViewed"));
            }
        }
    }

    public void addDocView(CMBDocument document, CMBAnnotationSet annotationSet, String docName, boolean selectInShow) {
        CMBAnnotationView annView = null;
        PSingleDocViewer viewer = this.gdv.getViewer(document);
        PFullSizeView docView = viewer.createFullSizeView();
        this.fullSizeViews.add(docView);
        if (annotationSet != null) {
            try {
                if (document.getPage(1).isValid()) {
                    double pageResolution = document.getPage(1).getPageXResolution();
                    annotationSet.setScaleFactor(document.getPreferredScale() * (double)document.getDisplayResolution() / pageResolution);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.gdv.getAnnotationServices() == null || annotationSet == null) {
            try {
                if (document.getCanShowAnnotations()) {
                    document.setShowAnnotations(true);
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        JScrollPane scrollPane = new JScrollPane(docView);
        scrollPane.getVerticalScrollBar().setUnitIncrement(50);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(50);
        scrollPane.getViewport().setFocusable(false);
        scrollPane.getHorizontalScrollBar().setFocusable(false);
        scrollPane.getVerticalScrollBar().setFocusable(false);
        if (docView instanceof PFullSizePageView) {
            scrollPane.addComponentListener((PFullSizePageView)docView);
        }
        if (docName == null) {
            docName = new String("");
        }
        this.tabbedPane.addTab(docName, scrollPane);
        if (!this.tabbedPane.isEnabled()) {
            this.tabbedPane.setEnabled(true);
        }
        if (selectInShow) {
            this.tabbedPane.setSelectedComponent(scrollPane);
        }
        if (docView instanceof PFullSizePageView) {
            this.tabbedPane.addMouseListener((PFullSizePageView)docView);
        }
        this.gdv.setupPageViewPopupMenus(docView);
        this.addThumbView(document, annView);
        boolean indicate = (Boolean)this.gdv.getClientProperty("Appearance.tab.indicate");
        if (this.gdv.hasDocumentBeenViewed(document)) {
            this.indicateDocument(document, indicate);
        }
        if (indicate) {
            int index = this.tabbedPane.indexOfComponent(scrollPane);
            if (this.gdv.hasDocumentBeenViewed(document)) {
                this.tabbedPane.setToolTipTextAt(index, PViewerUtilities.getMessage("DocumentViewer.documentViewed"));
            } else {
                this.tabbedPane.setToolTipTextAt(index, PViewerUtilities.getMessage("DocumentViewer.documentNotViewed"));
            }
        }
        this.gdv.reregisterKeyboardActions();
    }

    private void addThumbView(CMBDocument document, CMBAnnotationView annView) {
        PSingleDocViewer viewer = this.gdv.getViewer(document);
        PThumbnailsView thumbnailView = viewer.getThumbnailsView();
        thumbnailView.setMultiSelectAllowed(this.gdv.isMultiplePageSelectionEnabled());
        thumbnailView.setDragDropAllowed(this.gdv.canDragDrop());
        this.gdv._setThumbsViewOrientation(thumbnailView);
        thumbnailView.setTransferHandler(null);
        thumbnailView.setTransferHandler(this.gdv.getTransferHandler());
        JScrollPane thumbScrollPane = new JScrollPane(thumbnailView);
        thumbScrollPane.getViewport().setFocusable(false);
        thumbScrollPane.getHorizontalScrollBar().setFocusable(false);
        thumbScrollPane.getVerticalScrollBar().setFocusable(false);
        thumbScrollPane.getHorizontalScrollBar().setUnitIncrement(thumbnailView.getThumbnailSize().width + thumbnailView.getThumbnailOffsets().width);
        thumbScrollPane.getVerticalScrollBar().setUnitIncrement(thumbnailView.getThumbnailSize().height + thumbnailView.getThumbnailOffsets().height + thumbnailView.getPageNumberStringBounds((int)0).height + 4);
        if (thumbnailView instanceof PThumbnailListView) {
            thumbScrollPane.getViewport().addChangeListener((PThumbnailListView)thumbnailView);
        }
        this.thumbnailsPanel.setVisible(this.gdv.areThumbnailsShowing());
        this.thumbnailsPanel.add((Component)thumbScrollPane, document.toString());
        this.gdv.setupThumbnailPopupMenu(thumbnailView);
    }

    public void showThumbnails(boolean show) {
        if (this.gdv.getSelectedDocument() != null) {
            this.activateThumbnailView(this.gdv.getSelectedDocument());
        }
    }

    public void suspendDocSelectedEvents(boolean suspend) {
        if (suspend) {
            this.tabbedPane.removeChangeListener(this);
        } else {
            this.addViewerTabbedPaneChangeListener();
        }
    }

    public void stateChanged(ChangeEvent event) {
        int currentIndex = this.tabbedPane.getSelectedIndex();
        int tabCount = this.tabbedPane.getTabCount();
        if (tabCount >= 1 && currentIndex >= 0) {
            PSingleDocViewer viewer = this.gdv.getViewer(currentIndex);
            this.gdv.activateDocument(viewer.getDocModel().getDocument());
        } else {
            this.thumbnailsPanel.setVisible(false);
            this.tabbedPane.setEnabled(false);
            this.gdv.stopDocViewedTimer();
            this.gdv.setSelectedViewer(null);
        }
    }

    public void setCursor(Cursor cursor) {
        for (int i = 0; i < this.fullSizeViews.size(); ++i) {
            PFullSizeView view = (PFullSizeView)this.fullSizeViews.get(i);
            view.setCursor(cursor);
        }
    }

    private void buildThumbnails(CMBDocument document) {
        PThumbnailsView thumbView = null;
        PSingleDocViewer viewer = this.gdv.getViewer(document);
        if (viewer != null && (thumbView = viewer.getThumbnailsView()) != null && this.gdv.areThumbnailsShowing()) {
            try {
                thumbView.buildThumbnails();
            }
            catch (Exception e) {
                System.out.println(PViewerUtilities.getMessage("DocumentViewer.thumbnailsNotBuilt") + e);
            }
        }
    }

    public void setDocName(CMBDocument document, String docName) {
        int index = this.gdv.getViewerIndex(this.gdv.getViewer(document));
        this.tabbedPane.setTitleAt(index, docName);
    }

    public JPanel getFindPanel() {
        return this.findPanel;
    }

    public void showFindPanel(boolean show) {
        this.findPanel.setVisible(show);
    }

    private class PThumbnailsPanel
    extends JPanel {
        private PThumbnailsPanel() {
        }

        public Dimension getPreferredSize() {
            Dimension aDim = new Dimension(0, 0);
            PThumbnailsView thumbnailView = PTabbedViewerLayout.this.gdv.getSelectedThumbnailView();
            if (thumbnailView != null && thumbnailView.getParent() != null && thumbnailView.getParent().getParent() != null) {
                JScrollPane thumbScrollPane = (JScrollPane)thumbnailView.getParent().getParent();
                Insets scrollInsets = null;
                scrollInsets = thumbScrollPane.getBorder() == null ? new Insets(0, 0, 0, 0) : thumbScrollPane.getBorder().getBorderInsets(thumbScrollPane);
                Dimension pageNumStringBounds = thumbnailView.getPageNumberStringBounds(0);
                Dimension _pageNumStringOffset = new Dimension(4, 4);
                Insets borderInsets = thumbnailView.getBorder() != null ? thumbnailView.getBorder().getBorderInsets(thumbnailView) : new Insets(0, 0, 0, 0);
                Dimension thumbnailViewSize = new Dimension(thumbnailView.getThumbnailSize().width + 20 + borderInsets.left + borderInsets.right, thumbnailView.getThumbnailSize().height + 20 + borderInsets.top + borderInsets.bottom);
                aDim = new Dimension(thumbnailViewSize.width + thumbScrollPane.getVerticalScrollBar().getPreferredSize().width + scrollInsets.left + scrollInsets.right, thumbnailViewSize.height + thumbScrollPane.getHorizontalScrollBar().getPreferredSize().height + scrollInsets.top + scrollInsets.bottom + pageNumStringBounds.height + _pageNumStringOffset.height);
            }
            return aDim;
        }
    }

    private class MouseWheelHandler
    implements MouseWheelListener {
        JScrollPane scrollPane;
        MouseWheelListener defaultListener;

        public MouseWheelHandler(JScrollPane scrollPane, MouseWheelListener defaultListener) {
            this.scrollPane = scrollPane;
            this.defaultListener = defaultListener;
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            JViewport viewport = this.scrollPane.getViewport();
            Rectangle visRect = viewport.getViewRect();
            Dimension vSize = viewport.getView().getSize();
            if (e.getWheelRotation() < 0) {
                if (viewport.getViewPosition().y <= 0) {
                    if (PTabbedViewerLayout.this.gdv.canPrevPage()) {
                        PTabbedViewerLayout.this.gdv.prevPage();
                        visRect = viewport.getViewRect();
                        vSize = viewport.getView().getSize();
                        visRect.y = vSize.height - visRect.height;
                        viewport.setViewPosition(visRect.getLocation());
                    }
                } else {
                    this.defaultListener.mouseWheelMoved(e);
                }
            } else if (viewport.getViewPosition().y + viewport.getExtentSize().height >= viewport.getViewSize().height) {
                if (PTabbedViewerLayout.this.gdv.canNextPage()) {
                    PTabbedViewerLayout.this.gdv.nextPage();
                    visRect = viewport.getViewRect();
                    visRect.y = 0;
                    viewport.setViewPosition(visRect.getLocation());
                }
            } else {
                this.defaultListener.mouseWheelMoved(e);
            }
        }
    }

    private class EventHandler
    implements ContainerListener {
        private EventHandler() {
        }

        public void componentAdded(ContainerEvent e) {
            if (e.getChild() instanceof JScrollPane) {
                JScrollPane component = (JScrollPane)e.getChild();
                this.updateMap("page_prev", component);
                this.updateMap("page_next", component);
                this.updateMap("page_first", component);
                this.updateMap("page_last", component);
                if (PTabbedViewerLayout.this.gdv.isContinuousPaginationEnabled()) {
                    this.updateMap("scrollUp", component);
                    this.updateMap("scrollDown", component);
                    if (!(component.getViewport().getView() instanceof PThumbnailsView)) {
                        MouseWheelListener[] listeners = component.getMouseWheelListeners();
                        component.removeMouseWheelListener(listeners[0]);
                        component.addMouseWheelListener(new MouseWheelHandler(component, listeners[0]));
                    }
                }
            }
        }

        public void componentRemoved(ContainerEvent e) {
        }

        private void updateMap(String keyName, JComponent component) {
            Action a = PTabbedViewerLayout.this.gdv.getActionMap().get(keyName);
            if (a == null) {
                return;
            }
            KeyStroke ks = (KeyStroke)a.getValue("AcceleratorKey");
            if (ks == null) {
                return;
            }
            Object o = PTabbedViewerLayout.this.gdv.getInputMap(1).get(ks);
            if (o != null && PTabbedViewerLayout.this.gdv.getActionForKeyStroke(ks) != null) {
                a = (Action)PTabbedViewerLayout.this.gdv.getActionForKeyStroke(ks);
                String aName = null;
                if (a.getValue("Name") != null) {
                    aName = (String)a.getValue("Name");
                    o = component.getInputMap(1).get(ks);
                    if (o != null) {
                        component.getInputMap(1).put(ks, aName);
                        component.getActionMap().put(aName, a);
                        if (component instanceof JScrollPane) {
                            JScrollPane c = (JScrollPane)component;
                            c.getHorizontalScrollBar().getInputMap().put(ks, aName);
                            c.getHorizontalScrollBar().getActionMap().put(aName, a);
                            c.getVerticalScrollBar().getInputMap().put(ks, aName);
                            c.getVerticalScrollBar().getActionMap().put(aName, a);
                        }
                    }
                }
            }
        }
    }
}

