/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.PDocModel;
import com.ibm.mm.viewer.PFullSizePageView;
import com.ibm.mm.viewer.PFullSizeView;
import com.ibm.mm.viewer.PPageModel;
import com.ibm.mm.viewer.PPageViewer;
import com.ibm.mm.viewer.PSingleDocViewer;
import com.ibm.mm.viewer.PThumbnailListView;
import com.ibm.mm.viewer.PThumbnailsView;
import com.ibm.mm.viewer.PViewerLayout;
import com.ibm.mm.viewer.PViewerUtilities;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import com.ibm.mm.viewer.annotation.CMBAnnotationView;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;

class PSplitViewerLayout
extends PViewerLayout {
    private CMBGenericDocViewer gdv;
    private boolean horizontalSplit;
    private JPanel mainPanel;
    private JSplitPane splitPane;
    private PThumbnailsPanel thumbnailsPanel;
    private JPanel leftPanel;
    private JPanel rightPanel;
    private JComboBox leftComboBox;
    private JComboBox rightComboBox;
    private ComboBoxCellRenderer comboBoxCellRenderer;
    private CardLayout leftCardLayout;
    private CardLayout rightCardLayout;
    private JPanel leftCardPanel;
    private JPanel rightCardPanel;
    private ArrayList leftFullSizeViews = new ArrayList();
    private ArrayList rightFullSizeViews = new ArrayList();
    private Box northPanel = Box.createVerticalBox();
    private Box southPanel = Box.createVerticalBox();
    private Box eastPanel = Box.createHorizontalBox();
    private Box westPanel = Box.createHorizontalBox();
    private EventHandler eventHandler = new EventHandler();
    private LeftPaneFocusListener leftPaneFocusListener = new LeftPaneFocusListener();
    private RightPaneFocusListener rightPaneFocusListener = new RightPaneFocusListener();
    private boolean leftPaneHasFocus = true;
    private boolean ignoreItemEvents = false;
    private boolean indicate;

    public PSplitViewerLayout(CMBGenericDocViewer gdv, boolean horizontalSplit) {
        this.gdv = gdv;
        this.horizontalSplit = horizontalSplit;
        gdv.currentLayout = this;
        this.mainPanel = new JPanel(){

            public void requestFocus() {
                if (PSplitViewerLayout.this.leftPaneHasFocus) {
                    PSplitViewerLayout.this.leftComboBox.requestFocus();
                } else {
                    PSplitViewerLayout.this.rightComboBox.requestFocus();
                }
            }
        };
        this.mainPanel.setLayout(new BorderLayout());
        this.splitPane = new JSplitPane();
        this.splitPane.setResizeWeight(0.5);
        if (horizontalSplit) {
            this.splitPane.setOrientation(1);
        } else {
            this.splitPane.setOrientation(0);
        }
        this.leftPanel = new JPanel(new BorderLayout());
        this.leftPanel.setMinimumSize(new Dimension(0, 0));
        this.rightPanel = new JPanel(new BorderLayout());
        this.rightPanel.setMinimumSize(new Dimension(0, 0));
        this.leftComboBox = new JComboBox();
        this.rightComboBox = new JComboBox();
        this.leftComboBox.setName("LeftComboBox");
        this.rightComboBox.setName("RightComboBox");
        this.comboBoxCellRenderer = new ComboBoxCellRenderer();
        this.leftComboBox.setRenderer(this.comboBoxCellRenderer);
        this.rightComboBox.setRenderer(this.comboBoxCellRenderer);
        this.leftCardLayout = new CardLayout();
        this.rightCardLayout = new CardLayout();
        this.leftCardPanel = new JPanel(this.leftCardLayout);
        this.rightCardPanel = new JPanel(this.rightCardLayout);
        this.leftCardPanel.setName("LeftCardPanel");
        this.rightCardPanel.setName("RightCardPanel");
        this.leftCardPanel.addContainerListener(this.eventHandler);
        this.rightCardPanel.addContainerListener(this.eventHandler);
        this.leftPanel.add((Component)this.leftComboBox, "North");
        this.rightPanel.add((Component)this.rightComboBox, "North");
        this.leftPanel.add((Component)this.leftCardPanel, "Center");
        this.rightPanel.add((Component)this.rightCardPanel, "Center");
        this.splitPane.setLeftComponent(this.leftPanel);
        this.splitPane.setRightComponent(this.rightPanel);
        this.thumbnailsPanel = new PThumbnailsPanel();
        this.thumbnailsPanel.setLayout(new CardLayout());
        this.thumbnailsPanel.addContainerListener(this.eventHandler);
        if (gdv.getThumbnailsPosition().equalsIgnoreCase("North")) {
            this.northPanel.add(this.thumbnailsPanel);
        } else if (gdv.getThumbnailsPosition().equalsIgnoreCase("South")) {
            this.southPanel.add(this.thumbnailsPanel);
        } else if (gdv.getThumbnailsPosition().equalsIgnoreCase("East")) {
            this.eastPanel.add(this.thumbnailsPanel);
        } else {
            this.westPanel.add(this.thumbnailsPanel);
        }
        this.mainPanel.add((Component)this.northPanel, "North");
        this.mainPanel.add((Component)this.eastPanel, "East");
        this.mainPanel.add((Component)this.westPanel, "West");
        this.mainPanel.add((Component)this.southPanel, "South");
        this.mainPanel.add((Component)this.splitPane, "Center");
        this.northPanel.setFocusable(false);
        this.southPanel.setFocusable(false);
        this.eastPanel.setFocusable(false);
        this.westPanel.setFocusable(false);
        this.thumbnailsPanel.setFocusable(false);
        if (gdv.getViewerCount() == 0) {
            this.splitPane.setEnabled(false);
        }
        this.leftFullSizeViews = new ArrayList();
        this.rightFullSizeViews = new ArrayList();
        PSingleDocViewer selectedViewer = gdv.getSelectedViewer();
        for (int i = 0; i < gdv.getViewerCount(); ++i) {
            PSingleDocViewer viewer = gdv.getViewer(i);
            this.addDocView(viewer.getDocModel().getDocument(), viewer.getDocModel().getAnnotationSet(), viewer.getDocModel().getDocName(), viewer == selectedViewer);
            this.buildThumbnails(viewer.getDocModel().getDocument());
        }
        if (gdv.getSelectedDocument() != null) {
            this.activateDocument(gdv.getSelectedDocument(), true);
        }
        this.leftComboBox.addFocusListener(this.leftPaneFocusListener);
        this.rightComboBox.addFocusListener(this.rightPaneFocusListener);
        this.leftComboBox.addItemListener(new ComboBoxItemListener());
        this.rightComboBox.addItemListener(new ComboBoxItemListener());
        ActionListener enterViewAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PFullSizeView view = PSplitViewerLayout.this.gdv.getSelectedView();
                if (view != null) {
                    view.requestFocus();
                }
            }
        };
        KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0, false);
        this.mainPanel.registerKeyboardAction(enterViewAction, enterKey, 2);
        this.mainPanel.registerKeyboardAction(enterViewAction, KeyStroke.getKeyStroke(10, 0, false), 2);
    }

    public void setHorizontalSplit(boolean horizontalSplit) {
        this.horizontalSplit = horizontalSplit;
        if (horizontalSplit) {
            this.splitPane.setOrientation(1);
        } else {
            this.splitPane.setOrientation(0);
        }
        this.splitPane.resetToPreferredSizes();
    }

    public int getViewType() {
        if (this.horizontalSplit) {
            return 1;
        }
        return 2;
    }

    public JComponent getViewerComponent() {
        return this.mainPanel;
    }

    public void dispose() {
        PFullSizeView fullSizeView;
        int i;
        for (i = 0; i < this.leftFullSizeViews.size(); ++i) {
            fullSizeView = (PFullSizeView)this.leftFullSizeViews.get(i);
            fullSizeView.getViewer().destroyFullSizeView(fullSizeView);
        }
        this.leftFullSizeViews.clear();
        for (i = 0; i < this.rightFullSizeViews.size(); ++i) {
            fullSizeView = (PFullSizeView)this.rightFullSizeViews.get(i);
            fullSizeView.getViewer().destroyFullSizeView(fullSizeView);
        }
        this.rightFullSizeViews.clear();
        this.mainPanel.removeAll();
        this.mainPanel = null;
        this.eastPanel.removeAll();
        this.eastPanel = null;
        this.northPanel.removeAll();
        this.northPanel = null;
        this.southPanel.removeAll();
        this.southPanel = null;
        this.westPanel.removeAll();
        this.westPanel = null;
        this.splitPane.removeAll();
        this.splitPane = null;
    }

    public void registerKeyboardAction(Action action, KeyStroke keystroke, int inputMapID) {
        PFullSizeView view;
        int i;
        if (keystroke == null) {
            return;
        }
        if (keystroke.getKeyCode() == 117 && keystroke.getModifiers() == 0 || keystroke.getKeyCode() == 119 && keystroke.getModifiers() == 0) {
            return;
        }
        String aCommand = (String)action.getValue("Name");
        this.splitPane.getInputMap(inputMapID).put(keystroke, aCommand);
        this.splitPane.getActionMap().put(aCommand, action);
        if (keystroke.getKeyCode() != 10 && keystroke.getKeyCode() != 38 && keystroke.getKeyCode() != 40 && keystroke.getKeyCode() != 37 && keystroke.getKeyCode() != 39 || keystroke.getModifiers() != 0) {
            this.leftComboBox.getInputMap(inputMapID).put(keystroke, aCommand);
            this.leftComboBox.getActionMap().put(aCommand, action);
            this.rightComboBox.getInputMap(inputMapID).put(keystroke, aCommand);
            this.rightComboBox.getActionMap().put(aCommand, action);
        }
        for (i = 0; i < this.leftFullSizeViews.size(); ++i) {
            view = (PFullSizeView)this.leftFullSizeViews.get(i);
            view.getInputMap(inputMapID).put(keystroke, aCommand);
            view.getActionMap().put(aCommand, action);
        }
        for (i = 0; i < this.rightFullSizeViews.size(); ++i) {
            view = (PFullSizeView)this.rightFullSizeViews.get(i);
            view.getInputMap(inputMapID).put(keystroke, aCommand);
            view.getActionMap().put(aCommand, action);
        }
    }

    public void activateDocument(CMBDocument document) {
        this.activateDocument(document, false);
    }

    private void activateDocument(CMBDocument document, boolean allViews) {
        PFullSizePageView pageView;
        PFullSizeView docView;
        int lastViewIndex;
        int firstViewIndex;
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component c = focusManager.getFocusOwner();
        for (int i = 0; i < this.gdv.getViewerCount(); ++i) {
            PSingleDocViewer v = this.gdv.getViewer(i);
            v.getDocModel().setActiveDocument(false);
        }
        PSingleDocViewer viewer = this.gdv.getViewer(document);
        this.gdv.setSelectedViewer(viewer);
        viewer.getDocModel().setActiveDocument(true);
        if (allViews) {
            firstViewIndex = 0;
            lastViewIndex = 1;
        } else if (this.leftPaneHasFocus) {
            firstViewIndex = 0;
            lastViewIndex = 0;
        } else {
            firstViewIndex = 1;
            lastViewIndex = 1;
        }
        for (int i = firstViewIndex; i <= lastViewIndex; ++i) {
            PFullSizeView docView2 = viewer.getFullSizeView(i);
            try {
                if (i == 0) {
                    this.leftCardLayout.show(this.leftCardPanel, "Left" + viewer.getDocModel().hashCode());
                    this.leftComboBox.setSelectedItem(viewer.getDocModel());
                } else {
                    this.rightCardLayout.show(this.rightCardPanel, "Right" + viewer.getDocModel().hashCode());
                    this.rightComboBox.setSelectedItem(viewer.getDocModel());
                }
                if (c instanceof PFullSizePageView) {
                    this.getSelectedFullSizeView().requestFocusInWindow();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.gdv.checkToIndicateDocument();
        }
        this.getSelectedFullSizeView().setViewStateIntoModel();
        this.activateThumbnailView(document);
        if (this.gdv.getAnnotationServices() != null && this.gdv.getSelectedAnnotationSet() != null && (docView = this.getSelectedFullSizeView()) instanceof PFullSizePageView && (pageView = (PFullSizePageView)docView).getAnnotationView() != null) {
            this.gdv.getAnnotationServices().setAnnotationView(pageView.getAnnotationView(), pageView.getAnnotationView().getModel());
        }
        ((PPageModel)this.getSelectedFullSizeView().getDocModel()).activeFullSizeView = (PFullSizePageView)this.getSelectedFullSizeView();
        this.gdv.fireCMBDocSelectedEvent(document);
    }

    private void activateThumbnailView(CMBDocument document) {
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component c = focusManager.getFocusOwner();
        PThumbnailsView thumbView = null;
        PSingleDocViewer viewer = this.gdv.getViewer(document);
        if (viewer != null) {
            thumbView = viewer.getThumbnailsView();
            if (this.gdv.isSelectedViewTemporary()) {
                thumbView.setDisplayNeeded(false);
                return;
            }
            if (thumbView != null) {
                if (this.gdv.areThumbnailsShowing()) {
                    try {
                        thumbView.buildThumbnails();
                    }
                    catch (Exception e) {
                        System.out.println(PViewerUtilities.getMessage("DocumentViewer.thumbnailsNotBuilt") + e);
                    }
                    this.gdv._setThumbsViewOrientation(thumbView);
                }
                this.thumbnailsPanel.setVisible(this.gdv.areThumbnailsShowing());
                thumbView.setDisplayNeeded(this.gdv.areThumbnailsShowing());
                CardLayout currThumbLayout = (CardLayout)this.thumbnailsPanel.getLayout();
                currThumbLayout.show(this.thumbnailsPanel, document.toString());
                if (c != null && c.getParent() instanceof PThumbnailListView) {
                    thumbView.requestFocus();
                }
            }
            this.gdv.revalidate();
            PFullSizePageView currentFullSizeView = this.leftPaneHasFocus ? (PFullSizePageView)viewer.getFullSizeView(0) : (PFullSizePageView)viewer.getFullSizeView(1);
            JScrollPane scrollPane = (JScrollPane)currentFullSizeView.getParent().getParent();
            if (currentFullSizeView instanceof PFullSizePageView) {
                scrollPane.getViewport().addChangeListener(currentFullSizeView);
            }
        }
    }

    public void closeDocument(CMBDocument document, boolean activate) {
        String methodName = "closeDocument";
        PSingleDocViewer viewer = this.gdv.getViewer(document);
        if (viewer instanceof PPageViewer) {
            this.splitPane.removeMouseListener((PFullSizePageView)viewer.getFullSizeView(0));
            this.splitPane.removeMouseListener((PFullSizePageView)viewer.getFullSizeView(1));
        }
        try {
            PThumbnailsView thumbView = viewer.getThumbnailsView();
            JScrollPane scrollPane = (JScrollPane)thumbView.getParent().getParent();
            int index = this.gdv.getViewerIndex(viewer);
            PFullSizeView leftView = (PFullSizeView)this.leftFullSizeViews.get(index);
            this.leftCardLayout.removeLayoutComponent(leftView.getParent().getParent());
            this.leftCardPanel.remove(leftView.getParent().getParent());
            this.leftComboBox.removeItem(viewer.getDocModel());
            PFullSizeView rightView = (PFullSizeView)this.rightFullSizeViews.get(index);
            this.rightCardLayout.removeLayoutComponent(rightView.getParent().getParent());
            this.rightCardPanel.remove(rightView.getParent().getParent());
            this.rightComboBox.removeItem(viewer.getDocModel());
            this.leftFullSizeViews.remove(index);
            this.rightFullSizeViews.remove(index);
            this.thumbnailsPanel.remove(scrollPane);
            if (this.gdv.getViewerCount() <= 1) {
                this.thumbnailsPanel.setVisible(false);
                if (!this.gdv.areThumbnailsDocked() && this.gdv.thumbnailWindow != null) {
                    this.gdv.thumbnailWindow.setVisible(false);
                }
            }
            if (this.leftFullSizeViews.size() > 0) {
                PDocModel model = (PDocModel)this.leftComboBox.getSelectedItem();
                this.leftCardLayout.show(this.leftCardPanel, "Left" + model.hashCode());
                model = (PDocModel)this.rightComboBox.getSelectedItem();
                this.rightCardLayout.show(this.rightCardPanel, "Right" + model.hashCode());
            }
            this.gdv.validate();
        }
        catch (IndexOutOfBoundsException e) {
            ViewerLogger.logError((Object)this, methodName, e);
        }
    }

    public JPanel getThumbnailsPanel() {
        return this.thumbnailsPanel;
    }

    public void setThumbnailsPosition(String thumbnailsPosition) {
        this.mainPanel.remove(this.thumbnailsPanel);
        if (thumbnailsPosition.equalsIgnoreCase("North")) {
            this.northPanel.add(this.thumbnailsPanel);
        } else if (thumbnailsPosition.equalsIgnoreCase("South")) {
            this.southPanel.add(this.thumbnailsPanel);
        } else if (thumbnailsPosition.equalsIgnoreCase("East")) {
            this.eastPanel.add(this.thumbnailsPanel);
        } else if (thumbnailsPosition.equalsIgnoreCase("West")) {
            this.westPanel.add(this.thumbnailsPanel);
        }
        for (int i = 0; i < this.gdv.getViewerCount(); ++i) {
            PSingleDocViewer viewer = this.gdv.getViewer(i);
            PThumbnailsView thumbnailView = viewer.getThumbnailsView();
            if (thumbnailsPosition.equalsIgnoreCase("North") || thumbnailsPosition.equalsIgnoreCase("South")) {
                thumbnailView.setOrientation(0);
                continue;
            }
            thumbnailView.setOrientation(1);
        }
        this.gdv.revalidate();
    }

    public void setTabPlacement(int position) {
    }

    private JScrollPane getLeftScrollPane() {
        Component[] leftComponents = this.leftCardPanel.getComponents();
        JScrollPane leftScrollPane = null;
        for (int i = 0; i < leftComponents.length; ++i) {
            if (!leftComponents[i].isVisible()) continue;
            leftScrollPane = (JScrollPane)leftComponents[i];
        }
        return leftScrollPane;
    }

    private JScrollPane getRightScrollPane() {
        Component[] rightComponents = this.rightCardPanel.getComponents();
        JScrollPane rightScrollPane = null;
        for (int i = 0; i < rightComponents.length; ++i) {
            if (!rightComponents[i].isVisible()) continue;
            rightScrollPane = (JScrollPane)rightComponents[i];
        }
        return rightScrollPane;
    }

    public void setBorder(Border border) {
        this.mainPanel.setBorder(border);
    }

    public PFullSizeView getOtherFullSizeView() {
        PFullSizeView unselectedView = null;
        if (!this.leftPaneHasFocus) {
            JScrollPane leftScrollPane = this.getLeftScrollPane();
            if (leftScrollPane != null) {
                unselectedView = (PFullSizeView)leftScrollPane.getViewport().getView();
            }
        } else {
            JScrollPane rightScrollPane = this.getRightScrollPane();
            if (rightScrollPane != null) {
                unselectedView = (PFullSizeView)rightScrollPane.getViewport().getView();
            }
        }
        return unselectedView;
    }

    public PFullSizeView getSelectedFullSizeView() {
        PFullSizeView selectedView = null;
        if (this.leftPaneHasFocus) {
            Component[] leftComponents = this.leftCardPanel.getComponents();
            JScrollPane leftScrollPane = null;
            for (int i = 0; i < leftComponents.length; ++i) {
                if (!leftComponents[i].isVisible()) continue;
                leftScrollPane = (JScrollPane)leftComponents[i];
            }
            if (leftScrollPane != null) {
                selectedView = (PFullSizeView)leftScrollPane.getViewport().getView();
            }
        } else {
            Component[] rightComponents = this.rightCardPanel.getComponents();
            JScrollPane rightScrollPane = null;
            for (int i = 0; i < rightComponents.length; ++i) {
                if (!rightComponents[i].isVisible()) continue;
                rightScrollPane = (JScrollPane)rightComponents[i];
            }
            if (rightScrollPane != null) {
                selectedView = (PFullSizeView)rightScrollPane.getViewport().getView();
            }
        }
        return selectedView;
    }

    public void indicateDocument(CMBDocument document, boolean indicate) {
        this.indicate = indicate;
        this.leftComboBox.repaint();
        this.rightComboBox.repaint();
    }

    private String getStyledDocName(PDocModel model, boolean selected) {
        String styleString;
        if (model == null) {
            return "";
        }
        if (this.indicate && this.gdv.hasDocumentBeenViewed(model.getDocument())) {
            String indicateString = (String)this.gdv.getClientProperty("Appearance.tab.color");
            String htmlColor = "";
            if (!selected) {
                htmlColor = "<p style=\"color : " + indicateString + "\">";
            }
            String indicateStyle = (String)this.gdv.getClientProperty("Appearance.tab.fontstyle");
            String title = PViewerUtilities.stripHtml(model.getDocName());
            styleString = indicateStyle.equalsIgnoreCase("bold") ? "<html><body>" + htmlColor + "<b>" + title + "</b></p></body></html>" : (indicateStyle.equalsIgnoreCase("italic") ? "<html><body>" + htmlColor + "<i>" + title + "</i></p></body></html>" : (indicateStyle.equalsIgnoreCase("bold_italic") ? "<html><body>" + htmlColor + "<b><i>" + title + "</i></b></p></body></html>" : "<html><body>" + htmlColor + title + "</p></body></html>"));
        } else {
            styleString = model.getDocName();
        }
        return styleString;
    }

    public void addDocView(CMBDocument document, CMBAnnotationSet annotationSet, String docName, boolean selectInShow) {
        CMBAnnotationView annView = null;
        PSingleDocViewer viewer = this.gdv.getViewer(document);
        PFullSizeView leftDocView = viewer.createFullSizeView();
        leftDocView.setName("LeftDocView");
        this.leftFullSizeViews.add(leftDocView);
        PFullSizeView rightDocView = viewer.createFullSizeView();
        rightDocView.setName("RightDocView");
        this.rightFullSizeViews.add(rightDocView);
        if (annotationSet != null) {
            try {
                double pageResolution = document.getPage(1).getPageXResolution();
                annotationSet.setScaleFactor(document.getPreferredScale() * (double)document.getDisplayResolution() / pageResolution);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.gdv.getAnnotationServices() == null || annotationSet == null) {
            try {
                if (document.getCanShowAnnotations()) {
                    document.setShowAnnotations(true);
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        JScrollPane leftScrollPane = new JScrollPane(leftDocView);
        DefaultBoundedRangeModel defaultVModel = (DefaultBoundedRangeModel)leftScrollPane.getVerticalScrollBar().getModel();
        DefaultBoundedRangeModel defaultHModel = (DefaultBoundedRangeModel)leftScrollPane.getHorizontalScrollBar().getModel();
        ScrollPaneBoundedRangeModel leftVModel = new ScrollPaneBoundedRangeModel("LeftModel", defaultVModel, 1);
        ScrollPaneBoundedRangeModel leftHModel = new ScrollPaneBoundedRangeModel("LeftModel", defaultHModel, 0);
        leftScrollPane.getVerticalScrollBar().setModel(leftVModel);
        leftScrollPane.getHorizontalScrollBar().setModel(leftHModel);
        leftScrollPane.setName("LeftScrollPane");
        JScrollPane rightScrollPane = new JScrollPane(rightDocView);
        rightScrollPane.setName("RightScrollPane");
        defaultVModel = (DefaultBoundedRangeModel)rightScrollPane.getVerticalScrollBar().getModel();
        defaultHModel = (DefaultBoundedRangeModel)rightScrollPane.getHorizontalScrollBar().getModel();
        ScrollPaneBoundedRangeModel rightVModel = new ScrollPaneBoundedRangeModel("RightModel", defaultVModel, 1);
        ScrollPaneBoundedRangeModel rightHModel = new ScrollPaneBoundedRangeModel("RightModel", defaultHModel, 0);
        rightScrollPane.getVerticalScrollBar().setModel(rightVModel);
        rightScrollPane.getHorizontalScrollBar().setModel(rightHModel);
        leftScrollPane.getVerticalScrollBar().setUnitIncrement(50);
        leftScrollPane.getHorizontalScrollBar().setUnitIncrement(50);
        rightScrollPane.getVerticalScrollBar().setUnitIncrement(50);
        rightScrollPane.getHorizontalScrollBar().setUnitIncrement(50);
        leftScrollPane.getViewport().setFocusable(false);
        leftScrollPane.getHorizontalScrollBar().setFocusable(false);
        leftScrollPane.getVerticalScrollBar().setFocusable(false);
        rightScrollPane.getViewport().setFocusable(false);
        rightScrollPane.getHorizontalScrollBar().setFocusable(false);
        rightScrollPane.getVerticalScrollBar().setFocusable(false);
        if (leftDocView instanceof PFullSizePageView) {
            leftScrollPane.addComponentListener((PFullSizePageView)leftDocView);
            rightScrollPane.addComponentListener((PFullSizePageView)rightDocView);
        }
        if (docName == null) {
            docName = new String("");
        }
        this.leftCardPanel.add("Left" + viewer.getDocModel().hashCode(), leftScrollPane);
        this.rightCardPanel.add("Right" + viewer.getDocModel().hashCode(), rightScrollPane);
        this.leftComboBox.addItem(viewer.getDocModel());
        this.rightComboBox.addItem(viewer.getDocModel());
        if (!this.splitPane.isEnabled()) {
            this.splitPane.setEnabled(true);
        }
        if (selectInShow) {
            if (this.leftPaneHasFocus) {
                this.leftComboBox.setSelectedItem(viewer.getDocModel());
                this.leftCardLayout.show(this.leftCardPanel, "Left" + viewer.getDocModel().hashCode());
            } else {
                this.rightComboBox.setSelectedItem(viewer.getDocModel());
                this.rightCardLayout.show(this.rightCardPanel, "Right" + viewer.getDocModel().hashCode());
            }
        }
        if (leftDocView instanceof PFullSizePageView) {
            this.leftComboBox.addMouseListener((PFullSizePageView)leftDocView);
            leftDocView.addFocusListener(this.leftPaneFocusListener);
            this.rightComboBox.addMouseListener((PFullSizePageView)rightDocView);
            rightDocView.addFocusListener(this.rightPaneFocusListener);
        }
        this.gdv.setupPageViewPopupMenus(leftDocView);
        this.gdv.setupPageViewPopupMenus(rightDocView);
        this.addThumbView(document, annView);
        if (this.gdv.hasDocumentBeenViewed(document)) {
            boolean indicate = (Boolean)this.gdv.getClientProperty("Appearance.tab.indicate");
            this.indicateDocument(document, indicate);
        }
        this.gdv.reregisterKeyboardActions();
    }

    private void addThumbView(CMBDocument document, CMBAnnotationView annView) {
        PSingleDocViewer viewer = this.gdv.getViewer(document);
        PThumbnailsView thumbnailView = viewer.getThumbnailsView();
        thumbnailView.setMultiSelectAllowed(this.gdv.isMultiplePageSelectionEnabled());
        thumbnailView.setDragDropAllowed(this.gdv.canDragDrop());
        this.gdv._setThumbsViewOrientation(thumbnailView);
        thumbnailView.setTransferHandler(null);
        thumbnailView.setTransferHandler(this.gdv.getTransferHandler());
        JScrollPane thumbScrollPane = new JScrollPane(thumbnailView);
        thumbScrollPane.getViewport().setFocusable(false);
        thumbScrollPane.getHorizontalScrollBar().setFocusable(false);
        thumbScrollPane.getVerticalScrollBar().setFocusable(false);
        thumbScrollPane.getHorizontalScrollBar().setUnitIncrement(thumbnailView.getThumbnailSize().width + thumbnailView.getThumbnailOffsets().width);
        thumbScrollPane.getVerticalScrollBar().setUnitIncrement(thumbnailView.getThumbnailSize().height + thumbnailView.getThumbnailOffsets().height + thumbnailView.getPageNumberStringBounds((int)0).height + 4);
        if (thumbnailView instanceof PThumbnailListView) {
            thumbScrollPane.getViewport().addChangeListener((PThumbnailListView)thumbnailView);
        }
        this.thumbnailsPanel.setVisible(this.gdv.areThumbnailsShowing());
        this.thumbnailsPanel.add((Component)thumbScrollPane, document.toString());
        this.gdv.setupThumbnailPopupMenu(thumbnailView);
    }

    public void showThumbnails(boolean show) {
        if (this.gdv.getSelectedDocument() != null) {
            this.activateThumbnailView(this.gdv.getSelectedDocument());
        }
    }

    public void suspendDocSelectedEvents(boolean suspend) {
        this.ignoreItemEvents = suspend;
    }

    public void setCursor(Cursor cursor) {
        PFullSizeView view;
        int i;
        for (i = 0; i < this.leftFullSizeViews.size(); ++i) {
            view = (PFullSizeView)this.leftFullSizeViews.get(i);
            view.setCursor(cursor);
        }
        for (i = 0; i < this.rightFullSizeViews.size(); ++i) {
            view = (PFullSizeView)this.rightFullSizeViews.get(i);
            view.setCursor(cursor);
        }
    }

    public void setDocName(CMBDocument document, String docName) {
        this.leftComboBox.repaint();
        this.rightComboBox.repaint();
    }

    public JPanel getFindPanel() {
        return null;
    }

    public void showFindPanel(boolean show) {
    }

    private void buildThumbnails(CMBDocument document) {
        PThumbnailsView thumbView = null;
        PSingleDocViewer viewer = this.gdv.getViewer(document);
        if (viewer != null && (thumbView = viewer.getThumbnailsView()) != null && this.gdv.areThumbnailsShowing()) {
            try {
                thumbView.buildThumbnails();
            }
            catch (Exception e) {
                System.out.println(PViewerUtilities.getMessage("DocumentViewer.thumbnailsNotBuilt") + e);
            }
        }
    }

    private class ScrollPaneBoundedRangeModel
    extends DefaultBoundedRangeModel {
        String name;
        int orientation;

        public ScrollPaneBoundedRangeModel(String name, DefaultBoundedRangeModel model, int orientation) {
            this.name = name;
            this.orientation = orientation;
            this._setRangeProperties(model.getValue(), model.getExtent(), model.getMinimum(), model.getMaximum(), model.getValueIsAdjusting());
        }

        public void _setRangeProperties(int newValue, int newExtent, int newMin, int newMax, boolean adjusting) {
            super.setRangeProperties(newValue, newExtent, newMin, newMax, adjusting);
        }

        public void setRangeProperties(int newValue, int newExtent, int newMin, int newMax, boolean adjusting) {
            int oldValue = this.getValue();
            super.setRangeProperties(newValue, newExtent, newMin, newMax, adjusting);
            if (PSplitViewerLayout.this.gdv.isScrollingLocked()) {
                if (this.getValueIsAdjusting()) {
                    if (this.name.equalsIgnoreCase("LeftModel")) {
                        ScrollPaneBoundedRangeModel rightModel = null;
                        rightModel = this.orientation == 0 ? (ScrollPaneBoundedRangeModel)PSplitViewerLayout.this.getRightScrollPane().getHorizontalScrollBar().getModel() : (ScrollPaneBoundedRangeModel)PSplitViewerLayout.this.getRightScrollPane().getVerticalScrollBar().getModel();
                        int v = rightModel.getValue() + newValue - oldValue;
                        if (v != rightModel.getValue() && v >= rightModel.getMinimum()) {
                            rightModel._setRangeProperties(rightModel.getValue() + newValue - oldValue, rightModel.getExtent(), rightModel.getMinimum(), rightModel.getMaximum(), rightModel.getValueIsAdjusting());
                        }
                    } else {
                        ScrollPaneBoundedRangeModel leftModel = null;
                        leftModel = this.orientation == 0 ? (ScrollPaneBoundedRangeModel)PSplitViewerLayout.this.getLeftScrollPane().getHorizontalScrollBar().getModel() : (ScrollPaneBoundedRangeModel)PSplitViewerLayout.this.getLeftScrollPane().getVerticalScrollBar().getModel();
                        int v = leftModel.getValue() + newValue - oldValue;
                        if (v != leftModel.getValue() && v >= leftModel.getMinimum()) {
                            leftModel._setRangeProperties(leftModel.getValue() + newValue - oldValue, leftModel.getExtent(), leftModel.getMinimum(), leftModel.getMaximum(), leftModel.getValueIsAdjusting());
                        }
                    }
                } else if (this.name.equalsIgnoreCase("LeftModel")) {
                    ScrollPaneBoundedRangeModel rightModel = null;
                    rightModel = this.orientation == 0 ? (ScrollPaneBoundedRangeModel)PSplitViewerLayout.this.getRightScrollPane().getHorizontalScrollBar().getModel() : (ScrollPaneBoundedRangeModel)PSplitViewerLayout.this.getRightScrollPane().getVerticalScrollBar().getModel();
                    int v = rightModel.getValue() + newValue - oldValue;
                    if (v >= 0 && v != rightModel.getValue() && newValue + newExtent < newMax) {
                        rightModel._setRangeProperties(rightModel.getValue() + newValue - oldValue, rightModel.getExtent(), rightModel.getMinimum(), rightModel.getMaximum(), rightModel.getValueIsAdjusting());
                    }
                } else {
                    ScrollPaneBoundedRangeModel leftModel = null;
                    leftModel = this.orientation == 0 ? (ScrollPaneBoundedRangeModel)PSplitViewerLayout.this.getLeftScrollPane().getHorizontalScrollBar().getModel() : (ScrollPaneBoundedRangeModel)PSplitViewerLayout.this.getLeftScrollPane().getVerticalScrollBar().getModel();
                    int v = leftModel.getValue() + newValue - oldValue;
                    if (v >= 0 && v != leftModel.getValue() && newValue + newExtent < newMax) {
                        leftModel._setRangeProperties(leftModel.getValue() + newValue - oldValue, leftModel.getExtent(), leftModel.getMinimum(), leftModel.getMaximum(), leftModel.getValueIsAdjusting());
                    }
                }
            }
        }

        public void _setValue(int n, String name) {
            int newValue = Math.max(n = Math.min(n, Integer.MAX_VALUE - this.getExtent()), this.getMinimum());
            if (newValue + this.getExtent() > this.getMaximum()) {
                newValue = this.getMaximum() - this.getExtent();
            }
            if (name.equalsIgnoreCase(this.name)) {
                this.setRangeProperties(newValue, this.getExtent(), this.getMinimum(), this.getMaximum(), this.getValueIsAdjusting());
            } else {
                this._setRangeProperties(newValue, this.getExtent(), this.getMinimum(), this.getMaximum(), this.getValueIsAdjusting());
            }
        }

        public void setValue(int n) {
            int oldValue = this.getValue();
            super.setValue(n);
            if (PSplitViewerLayout.this.gdv.isScrollingLocked()) {
                if (this.name.equalsIgnoreCase("LeftModel")) {
                    ScrollPaneBoundedRangeModel rightModel = null;
                    rightModel = this.orientation == 0 ? (ScrollPaneBoundedRangeModel)PSplitViewerLayout.this.getRightScrollPane().getHorizontalScrollBar().getModel() : (ScrollPaneBoundedRangeModel)PSplitViewerLayout.this.getRightScrollPane().getVerticalScrollBar().getModel();
                    int v = rightModel.getValue() + n - oldValue;
                    if (v != rightModel.getValue()) {
                        rightModel._setValue(n, this.name);
                    }
                } else {
                    ScrollPaneBoundedRangeModel leftModel = null;
                    leftModel = this.orientation == 0 ? (ScrollPaneBoundedRangeModel)PSplitViewerLayout.this.getLeftScrollPane().getHorizontalScrollBar().getModel() : (ScrollPaneBoundedRangeModel)PSplitViewerLayout.this.getLeftScrollPane().getVerticalScrollBar().getModel();
                    int v = leftModel.getValue() + n - oldValue;
                    if (v != leftModel.getValue()) {
                        leftModel._setValue(n, this.name);
                    }
                }
            }
        }

        public String toString() {
            return this.name + " " + super.toString();
        }
    }

    private class ComboBoxCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public ComboBoxCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(PSplitViewerLayout.this.getStyledDocName((PDocModel)value, isSelected));
            this.setBackground(isSelected ? SystemColor.textHighlight : SystemColor.text);
            this.setForeground(isSelected ? SystemColor.textHighlightText : SystemColor.textText);
            return this;
        }
    }

    private class RightPaneFocusListener
    implements FocusListener {
        private RightPaneFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            if (PSplitViewerLayout.this.leftPaneHasFocus) {
                PSplitViewerLayout.this.leftPaneHasFocus = false;
                PFullSizeView view = PSplitViewerLayout.this.getSelectedFullSizeView();
                if (view != null) {
                    PSplitViewerLayout.this.gdv.activateDocument(view.getViewer().getDocModel().getDocument());
                }
            }
        }

        public void focusLost(FocusEvent e) {
        }
    }

    private class LeftPaneFocusListener
    implements FocusListener {
        private LeftPaneFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            if (!PSplitViewerLayout.this.leftPaneHasFocus) {
                PSplitViewerLayout.this.leftPaneHasFocus = true;
                PFullSizeView view = PSplitViewerLayout.this.getSelectedFullSizeView();
                if (view != null) {
                    PSplitViewerLayout.this.gdv.activateDocument(view.getViewer().getDocModel().getDocument());
                }
            }
        }

        public void focusLost(FocusEvent e) {
        }
    }

    private class PThumbnailsPanel
    extends JPanel {
        private PThumbnailsPanel() {
        }

        public Dimension getPreferredSize() {
            Dimension aDim = new Dimension(0, 0);
            PThumbnailsView thumbnailView = PSplitViewerLayout.this.gdv.getSelectedThumbnailView();
            if (thumbnailView != null && thumbnailView.getParent() != null && thumbnailView.getParent().getParent() != null) {
                JScrollPane thumbScrollPane = (JScrollPane)thumbnailView.getParent().getParent();
                Insets scrollInsets = null;
                scrollInsets = thumbScrollPane.getBorder() == null ? new Insets(0, 0, 0, 0) : thumbScrollPane.getBorder().getBorderInsets(thumbScrollPane);
                Dimension pageNumStringBounds = thumbnailView.getPageNumberStringBounds(0);
                Dimension _pageNumStringOffset = new Dimension(4, 4);
                Insets borderInsets = thumbnailView.getBorder() != null ? thumbnailView.getBorder().getBorderInsets(thumbnailView) : new Insets(0, 0, 0, 0);
                Dimension thumbnailViewSize = new Dimension(thumbnailView.getThumbnailSize().width + 20 + borderInsets.left + borderInsets.right, thumbnailView.getThumbnailSize().height + 20 + borderInsets.top + borderInsets.bottom);
                aDim = new Dimension(thumbnailViewSize.width + thumbScrollPane.getVerticalScrollBar().getPreferredSize().width + scrollInsets.left + scrollInsets.right, thumbnailViewSize.height + thumbScrollPane.getHorizontalScrollBar().getPreferredSize().height + scrollInsets.top + scrollInsets.bottom + pageNumStringBounds.height + _pageNumStringOffset.height);
            }
            return aDim;
        }
    }

    private class MouseWheelHandler
    implements MouseWheelListener {
        JScrollPane scrollPane;
        MouseWheelListener defaultListener;

        public MouseWheelHandler(JScrollPane scrollPane, MouseWheelListener defaultListener) {
            this.scrollPane = scrollPane;
            this.defaultListener = defaultListener;
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            JViewport viewport = this.scrollPane.getViewport();
            Rectangle visRect = viewport.getViewRect();
            Dimension vSize = viewport.getView().getSize();
            if (e.getWheelRotation() < 0) {
                if (viewport.getViewPosition().y <= 0) {
                    if (PSplitViewerLayout.this.gdv.canPrevPage()) {
                        PSplitViewerLayout.this.gdv.prevPage();
                        visRect = viewport.getViewRect();
                        vSize = viewport.getView().getSize();
                        visRect.y = vSize.height - visRect.height;
                        viewport.setViewPosition(visRect.getLocation());
                        if (PSplitViewerLayout.this.gdv.isScrollingLocked()) {
                            ((PFullSizePageView)PSplitViewerLayout.this.gdv.getOtherView()).scrollRectToVisible(visRect);
                        }
                    }
                } else {
                    this.defaultListener.mouseWheelMoved(e);
                }
            } else if (viewport.getViewPosition().y + viewport.getExtentSize().height >= viewport.getViewSize().height) {
                if (PSplitViewerLayout.this.gdv.canNextPage()) {
                    PSplitViewerLayout.this.gdv.nextPage();
                    visRect = viewport.getViewRect();
                    visRect.y = 0;
                    viewport.setViewPosition(visRect.getLocation());
                    if (PSplitViewerLayout.this.gdv.isScrollingLocked()) {
                        ((PFullSizePageView)PSplitViewerLayout.this.gdv.getOtherView()).scrollRectToVisible(visRect);
                    }
                }
            } else {
                this.defaultListener.mouseWheelMoved(e);
            }
        }
    }

    private class EventHandler
    implements ContainerListener {
        private EventHandler() {
        }

        public void componentAdded(ContainerEvent e) {
            if (e.getChild() instanceof JScrollPane) {
                JScrollPane component = (JScrollPane)e.getChild();
                this.updateMap("page_prev", component);
                this.updateMap("page_next", component);
                this.updateMap("page_first", component);
                this.updateMap("page_last", component);
                if (PSplitViewerLayout.this.gdv.isContinuousPaginationEnabled() && !(component.getViewport().getView() instanceof PThumbnailsView)) {
                    this.updateMap("scrollUp", component);
                    this.updateMap("scrollDown", component);
                    MouseWheelListener[] listeners = component.getMouseWheelListeners();
                    component.removeMouseWheelListener(listeners[0]);
                    component.addMouseWheelListener(new MouseWheelHandler(component, listeners[0]));
                }
            }
        }

        public void componentRemoved(ContainerEvent e) {
        }

        private void updateMap(String keyName, JComponent component) {
            Action a = PSplitViewerLayout.this.gdv.getActionMap().get(keyName);
            if (a == null) {
                return;
            }
            KeyStroke ks = (KeyStroke)a.getValue("AcceleratorKey");
            if (ks == null) {
                return;
            }
            Object o = PSplitViewerLayout.this.gdv.getInputMap(1).get(ks);
            if (o != null && PSplitViewerLayout.this.gdv.getActionForKeyStroke(ks) != null) {
                a = (Action)PSplitViewerLayout.this.gdv.getActionForKeyStroke(ks);
                String aName = null;
                if (a.getValue("Name") != null) {
                    aName = (String)a.getValue("Name");
                    o = component.getInputMap(1).get(ks);
                    if (o != null) {
                        component.getInputMap(1).put(ks, aName);
                        component.getActionMap().put(aName, a);
                        if (component instanceof JScrollPane) {
                            JScrollPane c = (JScrollPane)component;
                            c.getHorizontalScrollBar().getInputMap().put(ks, aName);
                            c.getHorizontalScrollBar().getActionMap().put(aName, a);
                            c.getVerticalScrollBar().getInputMap().put(ks, aName);
                            c.getVerticalScrollBar().getActionMap().put(aName, a);
                        }
                    }
                }
            }
        }
    }

    private class ComboBoxItemListener
    implements ItemListener {
        private ComboBoxItemListener() {
        }

        public void itemStateChanged(ItemEvent event) {
            if (PSplitViewerLayout.this.ignoreItemEvents) {
                return;
            }
            if (event.getStateChange() == 1) {
                PSingleDocViewer viewer;
                PDocModel model = (PDocModel)event.getItem();
                PSingleDocViewer selectedViewer = PSplitViewerLayout.this.gdv.getSelectedViewer();
                if (selectedViewer != (viewer = PSplitViewerLayout.this.gdv.getViewer(model.getDocument()))) {
                    PSplitViewerLayout.this.gdv.activateDocument(model.getDocument());
                }
            }
        }
    }
}

