/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.PFullSizePageView;
import com.ibm.mm.viewer.PFullSizeView;
import com.ibm.mm.viewer.PSingleDocViewer;
import com.ibm.mm.viewer.PThumbnailListView;
import com.ibm.mm.viewer.PThumbnailsView;
import com.ibm.mm.viewer.PViewerLayout;
import com.ibm.mm.viewer.PViewerUtilities;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import com.ibm.mm.viewer.annotation.CMBAnnotationView;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;

class PSingleViewerLayout
extends PViewerLayout {
    private CMBGenericDocViewer gdv;
    private JPanel mainPanel;
    private PThumbnailsPanel thumbnailsPanel;
    private CardLayout cardLayout;
    private JPanel cardPanel;
    private ArrayList fullSizeViews = new ArrayList();
    private EventHandler eventHandler = new EventHandler();
    private PaneFocusListener paneFocusListener = new PaneFocusListener();

    public PSingleViewerLayout(CMBGenericDocViewer gdv) {
        this.gdv = gdv;
        gdv.currentLayout = this;
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.cardPanel.addContainerListener(this.eventHandler);
        this.thumbnailsPanel = new PThumbnailsPanel();
        this.thumbnailsPanel.setLayout(new CardLayout());
        this.thumbnailsPanel.addContainerListener(this.eventHandler);
        if (gdv.getThumbnailsPosition().equalsIgnoreCase("North")) {
            this.mainPanel.add((Component)this.thumbnailsPanel, "North");
        } else if (gdv.getThumbnailsPosition().equalsIgnoreCase("South")) {
            this.mainPanel.add((Component)this.thumbnailsPanel, "South");
        } else if (gdv.getThumbnailsPosition().equalsIgnoreCase("East")) {
            this.mainPanel.add((Component)this.thumbnailsPanel, "East");
        } else {
            this.mainPanel.add((Component)this.thumbnailsPanel, "West");
        }
        this.mainPanel.add((Component)this.cardPanel, "Center");
        this.thumbnailsPanel.setFocusable(false);
        if (gdv.getViewerCount() == 0) {
            this.cardPanel.setEnabled(false);
        }
        this.fullSizeViews = new ArrayList();
        PSingleDocViewer selectedViewer = gdv.getSelectedViewer();
        for (int i = 0; i < gdv.getViewerCount(); ++i) {
            PSingleDocViewer viewer = gdv.getViewer(i);
            this.addDocView(viewer.getDocModel().getDocument(), viewer.getDocModel().getAnnotationSet(), viewer.getDocModel().getDocName(), viewer == selectedViewer);
            this.buildThumbnails(viewer.getDocModel().getDocument());
        }
        if (gdv.getSelectedDocument() != null) {
            this.activateDocument(gdv.getSelectedDocument());
        }
        ActionListener enterViewAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PFullSizeView view = PSingleViewerLayout.this.gdv.getSelectedView();
                if (view != null) {
                    view.requestFocus();
                }
            }
        };
        KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0, false);
        this.mainPanel.registerKeyboardAction(enterViewAction, enterKey, 2);
        this.mainPanel.registerKeyboardAction(enterViewAction, KeyStroke.getKeyStroke(10, 0, false), 2);
    }

    public int getViewType() {
        return 4;
    }

    public JComponent getViewerComponent() {
        return this.mainPanel;
    }

    public void dispose() {
        for (int i = 0; i < this.fullSizeViews.size(); ++i) {
            PFullSizeView fullSizeView = (PFullSizeView)this.fullSizeViews.get(i);
            fullSizeView.getViewer().destroyFullSizeView(fullSizeView);
        }
        this.fullSizeViews.clear();
        this.mainPanel.removeAll();
        this.mainPanel = null;
    }

    public void registerKeyboardAction(Action action, KeyStroke keystroke, int inputMapID) {
        String aCommand = (String)action.getValue("Name");
        for (int i = 0; i < this.fullSizeViews.size(); ++i) {
            PFullSizeView view = (PFullSizeView)this.fullSizeViews.get(i);
            view.getInputMap(inputMapID).put(keystroke, aCommand);
            view.getActionMap().put(aCommand, action);
        }
    }

    public void activateDocument(CMBDocument document) {
        PFullSizePageView pageView;
        PFullSizeView docView;
        for (int i = 0; i < this.gdv.getViewerCount(); ++i) {
            PSingleDocViewer v = this.gdv.getViewer(i);
            v.getDocModel().setActiveDocument(false);
        }
        PSingleDocViewer viewer = this.gdv.getViewer(document);
        this.gdv.setSelectedViewer(viewer);
        viewer.getDocModel().setActiveDocument(true);
        try {
            this.cardLayout.show(this.cardPanel, "" + viewer.getDocModel().hashCode());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.gdv.checkToIndicateDocument();
        this.getSelectedFullSizeView().setViewStateIntoModel();
        this.activateThumbnailView(document);
        if (this.gdv.getAnnotationServices() != null && this.gdv.getSelectedAnnotationSet() != null && (docView = this.getSelectedFullSizeView()) instanceof PFullSizePageView && (pageView = (PFullSizePageView)docView).getAnnotationView() != null) {
            this.gdv.getAnnotationServices().setAnnotationView(pageView.getAnnotationView(), pageView.getAnnotationView().getModel());
        }
    }

    private void activateThumbnailView(CMBDocument document) {
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component c = focusManager.getFocusOwner();
        PThumbnailsView thumbView = null;
        PSingleDocViewer viewer = this.gdv.getViewer(document);
        if (viewer != null) {
            thumbView = viewer.getThumbnailsView();
            if (thumbView != null) {
                if (this.gdv.areThumbnailsShowing()) {
                    try {
                        thumbView.buildThumbnails();
                    }
                    catch (Exception e) {
                        System.out.println(PViewerUtilities.getMessage("DocumentViewer.thumbnailsNotBuilt") + e);
                    }
                    this.gdv._setThumbsViewOrientation(thumbView);
                }
                this.thumbnailsPanel.setVisible(this.gdv.areThumbnailsShowing());
                thumbView.setDisplayNeeded(this.gdv.areThumbnailsShowing());
                CardLayout currThumbLayout = (CardLayout)this.thumbnailsPanel.getLayout();
                currThumbLayout.show(this.thumbnailsPanel, document.toString());
                if (c != null && c.getParent() instanceof PThumbnailListView) {
                    thumbView.requestFocus();
                }
            }
            this.gdv.revalidate();
            PFullSizeView currentFullSizeView = viewer.getFullSizeView(0);
            JScrollPane scrollPane = (JScrollPane)currentFullSizeView.getParent().getParent();
            if (currentFullSizeView instanceof PFullSizePageView) {
                scrollPane.getViewport().addChangeListener((PFullSizePageView)currentFullSizeView);
            }
        }
    }

    public void closeDocument(CMBDocument document, boolean activate) {
        String methodName = "closeDocument";
        PSingleDocViewer viewer = this.gdv.getViewer(document);
        try {
            PThumbnailsView thumbView = viewer.getThumbnailsView();
            JScrollPane scrollPane = (JScrollPane)thumbView.getParent().getParent();
            int index = this.gdv.getViewerIndex(viewer);
            PFullSizeView view = (PFullSizeView)this.fullSizeViews.get(index);
            this.cardLayout.removeLayoutComponent(view.getParent().getParent());
            this.cardPanel.remove(view.getParent().getParent());
            this.fullSizeViews.remove(index);
            this.thumbnailsPanel.remove(scrollPane);
            if (this.gdv.getViewerCount() <= 1) {
                this.thumbnailsPanel.setVisible(false);
                if (!this.gdv.areThumbnailsDocked() && this.gdv.thumbnailWindow != null) {
                    this.gdv.thumbnailWindow.setVisible(false);
                }
            }
            this.gdv.validate();
        }
        catch (IndexOutOfBoundsException e) {
            ViewerLogger.logError((Object)this, methodName, e);
        }
    }

    public JPanel getThumbnailsPanel() {
        return this.thumbnailsPanel;
    }

    public void setThumbnailsPosition(String thumbnailsPosition) {
        this.mainPanel.remove(this.thumbnailsPanel);
        if (thumbnailsPosition.equalsIgnoreCase("North")) {
            this.mainPanel.add((Component)this.thumbnailsPanel, "North");
        } else if (thumbnailsPosition.equalsIgnoreCase("South")) {
            this.mainPanel.add((Component)this.thumbnailsPanel, "South");
        } else if (thumbnailsPosition.equalsIgnoreCase("East")) {
            this.mainPanel.add((Component)this.thumbnailsPanel, "East");
        } else if (thumbnailsPosition.equalsIgnoreCase("West")) {
            this.mainPanel.add((Component)this.thumbnailsPanel, "West");
        }
        for (int i = 0; i < this.gdv.getViewerCount(); ++i) {
            PSingleDocViewer viewer = this.gdv.getViewer(i);
            PThumbnailsView thumbnailView = viewer.getThumbnailsView();
            if (thumbnailsPosition.equalsIgnoreCase("North") || thumbnailsPosition.equalsIgnoreCase("South")) {
                thumbnailView.setOrientation(0);
                continue;
            }
            thumbnailView.setOrientation(1);
        }
        this.gdv.revalidate();
    }

    public void setTabPlacement(int position) {
    }

    public PFullSizeView getSelectedFullSizeView() {
        PFullSizeView selectedView = null;
        Component[] components = this.cardPanel.getComponents();
        JScrollPane scrollPane = null;
        for (int i = 0; i < components.length; ++i) {
            if (!components[i].isVisible()) continue;
            scrollPane = (JScrollPane)components[i];
        }
        if (scrollPane != null) {
            selectedView = (PFullSizeView)scrollPane.getViewport().getView();
        }
        return selectedView;
    }

    public void indicateDocument(CMBDocument document, boolean indicate) {
    }

    public void addDocView(CMBDocument document, CMBAnnotationSet annotationSet, String docName, boolean selectInShow) {
        CMBAnnotationView annView = null;
        PSingleDocViewer viewer = this.gdv.getViewer(document);
        PFullSizeView docView = viewer.createFullSizeView();
        this.fullSizeViews.add(docView);
        if (annotationSet != null) {
            try {
                if (annotationSet != null && document.getPage(1).isValid()) {
                    double pageResolution = document.getPage(1).getPageXResolution();
                    annotationSet.setScaleFactor(document.getPreferredScale() * (double)document.getDisplayResolution() / pageResolution);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.gdv.getAnnotationServices() == null || annotationSet == null) {
            try {
                if (document.getCanShowAnnotations()) {
                    document.setShowAnnotations(true);
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        JScrollPane scrollPane = new JScrollPane(docView);
        scrollPane.getVerticalScrollBar().setUnitIncrement(50);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(50);
        scrollPane.getViewport().setFocusable(false);
        scrollPane.getHorizontalScrollBar().setFocusable(false);
        scrollPane.getVerticalScrollBar().setFocusable(false);
        if (docView instanceof PFullSizePageView) {
            scrollPane.addComponentListener((PFullSizePageView)docView);
        }
        this.cardPanel.add("" + viewer.getDocModel().hashCode(), scrollPane);
        if (!this.cardPanel.isEnabled()) {
            this.cardPanel.setEnabled(true);
        }
        if (selectInShow) {
            this.cardLayout.show(this.cardPanel, docName + viewer.getDocModel().hashCode());
        }
        if (docView instanceof PFullSizePageView) {
            docView.addFocusListener(this.paneFocusListener);
        }
        this.gdv.setupPageViewPopupMenus(docView);
        this.addThumbView(document, annView);
        if (this.gdv.hasDocumentBeenViewed(document)) {
            boolean indicate = (Boolean)this.gdv.getClientProperty("Appearance.tab.indicate");
            this.indicateDocument(document, indicate);
        }
        this.gdv.reregisterKeyboardActions();
        if (this.gdv.getViewerCount() == 1) {
            this.activateDocument(document);
        }
    }

    private void addThumbView(CMBDocument document, CMBAnnotationView annView) {
        PSingleDocViewer viewer = this.gdv.getViewer(document);
        PThumbnailsView thumbnailView = viewer.getThumbnailsView();
        thumbnailView.setMultiSelectAllowed(this.gdv.isMultiplePageSelectionEnabled());
        thumbnailView.setDragDropAllowed(this.gdv.canDragDrop());
        this.gdv._setThumbsViewOrientation(thumbnailView);
        thumbnailView.setTransferHandler(null);
        thumbnailView.setTransferHandler(this.gdv.getTransferHandler());
        JScrollPane thumbScrollPane = new JScrollPane(thumbnailView);
        thumbScrollPane.getViewport().setFocusable(false);
        thumbScrollPane.getHorizontalScrollBar().setFocusable(false);
        thumbScrollPane.getVerticalScrollBar().setFocusable(false);
        thumbScrollPane.getHorizontalScrollBar().setUnitIncrement(thumbnailView.getThumbnailSize().width + thumbnailView.getThumbnailOffsets().width);
        thumbScrollPane.getVerticalScrollBar().setUnitIncrement(thumbnailView.getThumbnailSize().height + thumbnailView.getThumbnailOffsets().height + thumbnailView.getPageNumberStringBounds((int)0).height + 4);
        if (thumbnailView instanceof PThumbnailListView) {
            thumbScrollPane.getViewport().addChangeListener((PThumbnailListView)thumbnailView);
        }
        this.thumbnailsPanel.setVisible(this.gdv.areThumbnailsShowing());
        this.thumbnailsPanel.add((Component)thumbScrollPane, document.toString());
        this.gdv.setupThumbnailPopupMenu(thumbnailView);
    }

    public void showThumbnails(boolean show) {
        if (this.gdv.getSelectedDocument() != null) {
            this.activateThumbnailView(this.gdv.getSelectedDocument());
        }
    }

    public void suspendDocSelectedEvents(boolean suspend) {
    }

    public void setCursor(Cursor cursor) {
        for (int i = 0; i < this.fullSizeViews.size(); ++i) {
            PFullSizeView view = (PFullSizeView)this.fullSizeViews.get(i);
            view.setCursor(cursor);
        }
    }

    public void setDocName(CMBDocument document, String docName) {
    }

    public JPanel getFindPanel() {
        return null;
    }

    public void showFindPanel(boolean show) {
    }

    private void buildThumbnails(CMBDocument document) {
        PThumbnailsView thumbView = null;
        PSingleDocViewer viewer = this.gdv.getViewer(document);
        if (viewer != null && (thumbView = viewer.getThumbnailsView()) != null && this.gdv.areThumbnailsShowing()) {
            try {
                thumbView.buildThumbnails();
            }
            catch (Exception e) {
                System.out.println(PViewerUtilities.getMessage("DocumentViewer.thumbnailsNotBuilt") + e);
            }
        }
    }

    private class PaneFocusListener
    implements FocusListener {
        private PaneFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            PFullSizeView view = PSingleViewerLayout.this.getSelectedFullSizeView();
            if (view != null && view.getViewer() != PSingleViewerLayout.this.gdv.getSelectedViewer()) {
                PSingleViewerLayout.this.gdv.activateDocument(view.getViewer().getDocModel().getDocument());
            }
        }

        public void focusLost(FocusEvent e) {
        }
    }

    private class PThumbnailsPanel
    extends JPanel {
        private PThumbnailsPanel() {
        }

        public Dimension getPreferredSize() {
            Dimension aDim = new Dimension(0, 0);
            PThumbnailsView thumbnailView = PSingleViewerLayout.this.gdv.getSelectedThumbnailView();
            if (thumbnailView != null && thumbnailView.getParent() != null && thumbnailView.getParent().getParent() != null) {
                JScrollPane thumbScrollPane = (JScrollPane)thumbnailView.getParent().getParent();
                Insets scrollInsets = null;
                scrollInsets = thumbScrollPane.getBorder() == null ? new Insets(0, 0, 0, 0) : thumbScrollPane.getBorder().getBorderInsets(thumbScrollPane);
                Dimension pageNumStringBounds = thumbnailView.getPageNumberStringBounds(0);
                Dimension _pageNumStringOffset = new Dimension(4, 4);
                Insets borderInsets = thumbnailView.getBorder() != null ? thumbnailView.getBorder().getBorderInsets(thumbnailView) : new Insets(0, 0, 0, 0);
                Dimension thumbnailViewSize = new Dimension(thumbnailView.getThumbnailSize().width + 20 + borderInsets.left + borderInsets.right, thumbnailView.getThumbnailSize().height + 20 + borderInsets.top + borderInsets.bottom);
                aDim = new Dimension(thumbnailViewSize.width + thumbScrollPane.getVerticalScrollBar().getPreferredSize().width + scrollInsets.left + scrollInsets.right, thumbnailViewSize.height + thumbScrollPane.getHorizontalScrollBar().getPreferredSize().height + scrollInsets.top + scrollInsets.bottom + pageNumStringBounds.height + _pageNumStringOffset.height);
            }
            return aDim;
        }
    }

    private class MouseWheelHandler
    implements MouseWheelListener {
        JScrollPane scrollPane;
        MouseWheelListener defaultListener;

        public MouseWheelHandler(JScrollPane scrollPane, MouseWheelListener defaultListener) {
            this.scrollPane = scrollPane;
            this.defaultListener = defaultListener;
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            JViewport viewport = this.scrollPane.getViewport();
            Rectangle visRect = viewport.getViewRect();
            Dimension vSize = viewport.getView().getSize();
            if (e.getWheelRotation() < 0) {
                if (viewport.getViewPosition().y <= 0) {
                    if (PSingleViewerLayout.this.gdv.canPrevPage()) {
                        PSingleViewerLayout.this.gdv.prevPage();
                        visRect = viewport.getViewRect();
                        vSize = viewport.getView().getSize();
                        visRect.y = vSize.height - visRect.height;
                        viewport.setViewPosition(visRect.getLocation());
                    }
                } else {
                    this.defaultListener.mouseWheelMoved(e);
                }
            } else if (viewport.getViewPosition().y + viewport.getExtentSize().height >= viewport.getViewSize().height) {
                if (PSingleViewerLayout.this.gdv.canNextPage()) {
                    PSingleViewerLayout.this.gdv.nextPage();
                    visRect = viewport.getViewRect();
                    visRect.y = 0;
                    viewport.setViewPosition(visRect.getLocation());
                }
            } else {
                this.defaultListener.mouseWheelMoved(e);
            }
        }
    }

    private class EventHandler
    implements ContainerListener {
        private EventHandler() {
        }

        public void componentAdded(ContainerEvent e) {
            if (e.getChild() instanceof JScrollPane) {
                JScrollPane component = (JScrollPane)e.getChild();
                this.updateMap("page_prev", component);
                this.updateMap("page_next", component);
                this.updateMap("page_first", component);
                this.updateMap("page_last", component);
                if (PSingleViewerLayout.this.gdv.isContinuousPaginationEnabled() && !(component.getViewport().getView() instanceof PThumbnailsView)) {
                    this.updateMap("scrollUp", component);
                    this.updateMap("scrollDown", component);
                    MouseWheelListener[] listeners = component.getMouseWheelListeners();
                    component.removeMouseWheelListener(listeners[0]);
                    component.addMouseWheelListener(new MouseWheelHandler(component, listeners[0]));
                }
            }
        }

        public void componentRemoved(ContainerEvent e) {
        }

        private void updateMap(String keyName, JComponent component) {
            Action a = PSingleViewerLayout.this.gdv.getActionMap().get(keyName);
            if (a == null) {
                return;
            }
            KeyStroke ks = (KeyStroke)a.getValue("AcceleratorKey");
            if (ks == null) {
                return;
            }
            Object o = PSingleViewerLayout.this.gdv.getInputMap(1).get(ks);
            if (o != null && PSingleViewerLayout.this.gdv.getActionForKeyStroke(ks) != null) {
                a = (Action)PSingleViewerLayout.this.gdv.getActionForKeyStroke(ks);
                String aName = null;
                if (a.getValue("Name") != null) {
                    aName = (String)a.getValue("Name");
                    o = component.getInputMap(1).get(ks);
                    if (o != null) {
                        component.getInputMap(1).put(ks, aName);
                        component.getActionMap().put(aName, a);
                        if (component instanceof JScrollPane) {
                            JScrollPane c = (JScrollPane)component;
                            c.getHorizontalScrollBar().getInputMap().put(ks, aName);
                            c.getHorizontalScrollBar().getActionMap().put(aName, a);
                            c.getVerticalScrollBar().getInputMap().put(ks, aName);
                            c.getVerticalScrollBar().getActionMap().put(aName, a);
                        }
                    }
                }
            }
        }
    }
}

