/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBDocumentEngineException;
import com.ibm.mm.viewer.CMBGenericDocStateChangedEvent;
import com.ibm.mm.viewer.CMBGenericDocStateChangedListener;
import com.ibm.mm.viewer.CMBPage;
import com.ibm.mm.viewer.PDocModel;
import com.ibm.mm.viewer.PDocView;
import com.ibm.mm.viewer.PPageModel;
import com.ibm.mm.viewer.PPageTransferHandler;
import com.ibm.mm.viewer.PSingleDocViewer;
import com.ibm.mm.viewer.PThumbnailsView;
import com.ibm.mm.viewer.PViewerUtilities;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import com.ibm.mm.viewer.annotation.CMBPageAnnotation;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.SoftReference;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.border.Border;

class PSingleThumbnailView
extends PThumbnailsView {
    private int _pageNumber = 0;
    private final String ELEMENT_PAGENUMBER_PROPERTY = "Page Number";
    private Dimension _thumbnailSize = new Dimension(60, 78);
    private boolean _thumbnailInverted;
    private int _thumbnailRotation;
    private Dimension _thumbnailOffsets = new Dimension(20, 20);
    private Image _thumbImage;
    private SoftReference _thumbImageRef;
    private boolean _bUseSoftReference = false;
    private double _thumbScale;
    private Rectangle _currImageRect;
    private Rectangle _redRect = null;
    private boolean hasFocus = false;
    private boolean pageNumberDisplayed = true;
    private boolean redRectangleDisplayed = true;
    private boolean borderDisplayed = false;
    private boolean panAsDragged = true;
    private boolean scaleAsDragged = true;
    private boolean _updateRedRectFromModel = true;
    private boolean _inRedRect = false;
    private boolean _isDirty = false;
    private boolean _dropBefore = false;
    private boolean _dropAfter = false;
    private boolean _firstThumb = false;
    private boolean _validDrop;
    private int ocrConfidentLevel = 0;
    private ImageIcon ocrConfidentIcon = null;
    static final int BORDERGAP = 3;
    static final int LINETHICKNESS_ACTIVEBORDER = 4;
    static final int LINETHICKNESS_SELECTEDBORDER = 2;
    static final int LINETHICKNESS_DROPCURSOR = 2;
    static final int REDRECTHANDLE_SIDE = 5;
    private PSingleThumbnailViewer _thumbViewer = new PSingleThumbnailViewer();

    PSingleThumbnailView(PSingleDocViewer viewer, PDocModel model) {
        super(viewer, model);
        this._currImageRect = new Rectangle(this._thumbnailOffsets.width, this._thumbnailOffsets.height, this._thumbnailSize.width, this._thumbnailSize.height);
        this.addMouseListener(this._thumbViewer);
        this.addMouseMotionListener(this._thumbViewer);
        this.addFocusListener(this._thumbViewer);
        this.setFocusable(true);
        this.getDocModel().addDocStateChangedListener(new CMBGenericDocStateChangedListener(){

            public void genericDocStateChanged(CMBGenericDocStateChangedEvent evt) {
                if (evt.getChangeType() == 2) {
                    String msg = PViewerUtilities.getMessage("DocumentViewer.singleThumbnailAltText", new Object[]{new Integer(PSingleThumbnailView.this._pageNumber), new Integer(PSingleThumbnailView.this.getDocModel().getNumberOfPages())});
                    PSingleThumbnailView.this.getAccessibleContext().setAccessibleName(msg);
                } else if (evt.getChangeType() == 23) {
                    if (evt.getCurrentPageNumber() == PSingleThumbnailView.this._pageNumber && evt.getDocument() == PSingleThumbnailView.this.getDocModel().getDocument()) {
                        PSingleThumbnailView.this.setIndicator();
                    }
                } else if (evt.getChangeType() == 26 && evt.getCurrentPageNumber() == PSingleThumbnailView.this._pageNumber && evt.getDocument() == PSingleThumbnailView.this.getDocModel().getDocument()) {
                    PSingleThumbnailView.this.setIndicator();
                }
            }
        });
        this.addPropertyChangeListener("Page Number", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String msg = PViewerUtilities.getMessage("DocumentViewer.singleThumbnailAltText", new Object[]{new Integer(PSingleThumbnailView.this._pageNumber), new Integer(PSingleThumbnailView.this.getDocModel().getNumberOfPages())});
                PSingleThumbnailView.this.getAccessibleContext().setAccessibleName(msg);
            }
        });
    }

    void setIndicator() {
        PPageModel thePageModel = (PPageModel)this.getDocModel();
        CMBPage page = thePageModel.getPage(this.getPageNumber());
        this.ocrConfidentLevel = page.getConfidenceLevel();
        if (this.ocrConfidentLevel == 2) {
            this.ocrConfidentIcon = this.getViewer().getGdv().getImageIcon("OcrConfidenceHigh.png");
        }
        if (this.ocrConfidentLevel == 1) {
            this.ocrConfidentIcon = this.getViewer().getGdv().getImageIcon("OcrConfidenceLow.png");
        }
    }

    void buildThumbnails() throws IOException, CMBDocumentEngineException {
        if (this.isDirty()) {
            this.clearThumbnail();
        }
        Image thumbImage = null;
        if (this._bUseSoftReference) {
            Object obj;
            if (this._thumbImageRef != null && (obj = this._thumbImageRef.get()) instanceof Image) {
                thumbImage = (Image)obj;
            }
        } else {
            thumbImage = this._thumbImage;
        }
        if (thumbImage == null) {
            PPageModel thePageModel = (PPageModel)this.getDocModel();
            if (thePageModel != null && thePageModel.getDocument() != null) {
                this._thumbnailInverted = thePageModel.isInvert();
                this._thumbnailRotation = thePageModel.getRotation();
                thePageModel.updateAnnoForRotation(this._pageNumber);
            }
            int pagePosition = thePageModel.getPagePosition(this._pageNumber);
            this._thumbScale = thePageModel.getScaleToFit(this._pageNumber, this._thumbnailSize, 0, 0, 3);
            thumbImage = thePageModel.getThumbnailImage(pagePosition, this._thumbScale);
            try {
                MediaTracker tracker = new MediaTracker(this);
                tracker.addImage(thumbImage, 0);
                tracker.waitForID(0);
                if (this._bUseSoftReference) {
                    this._thumbImageRef = new SoftReference<Image>(thumbImage);
                } else {
                    this._thumbImage = thumbImage;
                }
                this.setIsDirty(false);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    void updateThumbnails(int startPage, int endPage) {
        if (startPage != this._pageNumber && endPage != this._pageNumber) {
            throw new IllegalArgumentException();
        }
        this.clearThumbnail();
        try {
            this.buildThumbnails();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void clearThumbnail() {
        if (this._bUseSoftReference) {
            Image thumbImage = null;
            if (this._thumbImageRef != null) {
                Object obj = this._thumbImageRef.get();
                if (obj instanceof Image) {
                    thumbImage = (Image)obj;
                }
                this._thumbImageRef.clear();
            }
            if (thumbImage != null) {
                thumbImage.flush();
            }
            thumbImage = null;
            this._thumbImageRef = null;
        } else {
            if (this._thumbImage != null) {
                this._thumbImage.flush();
            }
            this._thumbImage = null;
        }
    }

    void setThumbnailSize(int width, int height) {
        this.setThumbnailSize(new Dimension(width, height));
    }

    void setThumbnailSize(Dimension size) {
        this._thumbnailSize = size;
    }

    Dimension getThumbnailSize() {
        return this._thumbnailSize;
    }

    void setThumbnailOffsets(Dimension offsets) {
        this._thumbnailOffsets = offsets;
    }

    Dimension getThumbnailOffsets() {
        return this._thumbnailOffsets;
    }

    boolean isMultiSelectAllowed() {
        return false;
    }

    void setMultiSelectAllowed(boolean bMultiSelectAllowed) {
    }

    boolean isDragDropAllowed() {
        return false;
    }

    void setDragDropAllowed(boolean bDragDropAlloded) {
    }

    boolean isDirty() {
        return this._isDirty;
    }

    void setIsDirty(boolean isDirty) {
        this._isDirty = isDirty;
    }

    void display() {
        this._updateRedRectFromModel = true;
        this.repaint();
    }

    void dispose() {
        if (this._bUseSoftReference) {
            Image thumbImage = null;
            if (this._thumbImageRef != null) {
                Object obj = this._thumbImageRef.get();
                if (obj instanceof Image) {
                    thumbImage = (Image)obj;
                }
                this._thumbImageRef.clear();
            }
            if (thumbImage != null) {
                thumbImage.flush();
            }
        } else if (this._thumbImage != null) {
            this._thumbImage.flush();
        }
        super.dispose();
    }

    public void paint(Graphics g) {
        block33: {
            int currImgWidth = 0;
            int currImgHeight = 0;
            Image offScreenImage = null;
            Font currFont = g.getFont();
            Insets borderInsets = this.getInsets();
            Dimension pageNumStringBounds = this.getPageNumberStringBounds(this._pageNumber);
            Dimension _pageNumStringOffset = new Dimension(4, 4);
            int thumbRectLeft = borderInsets.left + this._thumbnailOffsets.width / 2;
            int thumbRectTop = borderInsets.top + this._thumbnailOffsets.height / 2 + pageNumStringBounds.height + _pageNumStringOffset.height;
            this.setBorder(BorderFactory.createEmptyBorder());
            g.setColor(Color.gray);
            g.fillRect(thumbRectLeft - 1, thumbRectTop - 1, this._thumbnailSize.width + 1, this._thumbnailSize.height + 1);
            g.setColor(Color.black);
            g.drawRect(thumbRectLeft - 1, thumbRectTop - 1, this._thumbnailSize.width + 1, this._thumbnailSize.height + 1);
            try {
                Image _thumbImage;
                PPageModel thePageModel = (PPageModel)this.getDocModel();
                int currPageNumber = thePageModel.getCurrentPageNumber();
                g.setColor(SystemColor.textText);
                if (this._pageNumber == currPageNumber) {
                    g.setColor(SystemColor.textHighlight);
                    for (int q = 7; q > 3; --q) {
                        g.drawRect(thumbRectLeft - q, thumbRectTop - q, this._thumbnailSize.width + 1 + 2 * (q - 1), this._thumbnailSize.height + 1 + 2 * (q - 1));
                    }
                    if (this.pageNumberDisplayed) {
                        g.fillRect(thumbRectLeft + this._thumbnailSize.width / 2 - (pageNumStringBounds.width / 2 + _pageNumStringOffset.width), thumbRectTop - 3 - pageNumStringBounds.height - _pageNumStringOffset.height, pageNumStringBounds.width + _pageNumStringOffset.width * 2, pageNumStringBounds.height + _pageNumStringOffset.height);
                        g.setColor(SystemColor.textHighlightText);
                    }
                } else if (thePageModel.isPageSelected(this._pageNumber)) {
                    g.setColor(SystemColor.textHighlight);
                    for (int r = 5; r > 3; --r) {
                        g.drawRect(thumbRectLeft - r, thumbRectTop - r, this._thumbnailSize.width + 1 + 2 * (r - 1), this._thumbnailSize.height + 1 + 2 * (r - 1));
                    }
                } else if (this.hasFocus && this.borderDisplayed) {
                    Rectangle boundsRect = this.getBounds();
                    g.setColor(Color.BLACK);
                    g.drawRect(0, 0, boundsRect.width - 1, boundsRect.height - 1);
                }
                if (PPageTransferHandler.isDragging() && this._validDrop) {
                    Rectangle boundsRect = this.getBounds();
                    Color savedColor = g.getColor();
                    g.setColor(SystemColor.textHighlight);
                    if (this._dropBefore && this._firstThumb) {
                        if (this.getOrientation() == 0) {
                            g.fillRect(0, thumbRectTop, 2, this._thumbnailSize.height);
                        } else {
                            g.fillRect(thumbRectLeft, 0, this._thumbnailSize.width, 2);
                        }
                    }
                    if (this._dropAfter) {
                        if (this.getOrientation() == 0) {
                            g.fillRect(boundsRect.width - 2 - 1, thumbRectTop, 2, this._thumbnailSize.height);
                        } else {
                            g.fillRect(thumbRectLeft, boundsRect.height - 2 - 1, this._thumbnailSize.width, 2);
                        }
                    }
                    g.setColor(savedColor);
                }
                if (this.pageNumberDisplayed) {
                    String strPageNum = "0";
                    strPageNum = this._pageNumber < 10 ? strPageNum + String.valueOf(this._pageNumber) : String.valueOf(this._pageNumber);
                    Font newFont = new Font(currFont.getName(), 1, 15);
                    g.setFont(newFont);
                    g.drawString(strPageNum, thumbRectLeft + this._thumbnailSize.width / 2 - pageNumStringBounds.width / 2, thumbRectTop - 3 - _pageNumStringOffset.height - 1);
                    g.setFont(currFont);
                }
                if ((_thumbImage = this.getThumbImage()) == null) break block33;
                currImgWidth = _thumbImage.getWidth(this);
                currImgHeight = _thumbImage.getHeight(this);
                int ptX = (this._thumbnailSize.width - currImgWidth) / 2;
                int ptY = (this._thumbnailSize.height - currImgHeight) / 2;
                if (currImgWidth > 0 && currImgHeight > 0) {
                    if (offScreenImage != null) {
                        offScreenImage.flush();
                    }
                    offScreenImage = this.createImage(currImgWidth, currImgHeight);
                    Graphics2D thumbGraphics = (Graphics2D)offScreenImage.getGraphics();
                    thumbGraphics.drawImage(_thumbImage, 0, 0, this);
                    CMBDocument document = this.getDocModel().getDocument();
                    CMBPage page = thePageModel.getPage(this._pageNumber);
                    if (this._thumbScale == 0.0) {
                        try {
                            this._thumbScale = thePageModel.getScaleToFit(this._pageNumber, this._thumbnailSize, 0, 0, 3);
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    thumbGraphics.scale(this._thumbScale / (double)Math.max(page.getPageXResolution(), page.getPageYResolution()) * (double)document.getDisplayResolution(), this._thumbScale / (double)Math.max(page.getPageXResolution(), page.getPageYResolution()) * (double)document.getDisplayResolution());
                    CMBAnnotationSet annoSet = thePageModel.getAnnotationSet();
                    if (annoSet != null) {
                        CMBPageAnnotation[] a = annoSet.getPageAnnotations(this._pageNumber);
                        for (int i = a.length - 1; i >= 0; --i) {
                            boolean handlesShowing = a[i].handlesShowing();
                            boolean isInMotion = a[i].getInMotion();
                            a[i].showHandles(false);
                            a[i].setInMotion(false);
                            a[i].draw(thumbGraphics);
                            a[i].showHandles(handlesShowing);
                            a[i].setInMotion(isInMotion);
                        }
                    }
                    thumbGraphics.dispose();
                    g.drawImage(offScreenImage, thumbRectLeft + ptX, thumbRectTop + ptY, this);
                } else {
                    g.drawImage(_thumbImage, thumbRectLeft + ptX, thumbRectTop + ptY, this);
                }
                this._currImageRect = new Rectangle(thumbRectLeft + ptX, thumbRectTop + ptY, currImgWidth, currImgHeight);
                if (this._pageNumber == currPageNumber && this.redRectangleDisplayed) {
                    if (this._redRect == null || this._updateRedRectFromModel) {
                        this._redRect = this.getRedRectangle(thePageModel.getCurrentViewRectangle());
                        if (this._redRect != null) {
                            this._redRect.translate(this._currImageRect.x, this._currImageRect.y);
                        }
                        if (!this._isDirty) {
                            this._updateRedRectFromModel = false;
                        }
                    }
                    if (this._redRect != null) {
                        if (!this._currImageRect.contains(this._redRect)) {
                            this._redRect = (Rectangle)this._currImageRect.createIntersection(this._redRect);
                        }
                        Rectangle redRectHandle = new Rectangle(this._redRect.x + this._redRect.width - 5, this._redRect.y + this._redRect.height - 5, 5, 5);
                        Stroke oldStroke = ((Graphics2D)g).getStroke();
                        ((Graphics2D)g).setStroke(new BasicStroke(1.0f));
                        ((Graphics2D)g).setColor(Color.cyan);
                        Rectangle InnerRectHandle = new Rectangle(redRectHandle.x - 1, redRectHandle.y - 1, redRectHandle.width, redRectHandle.height);
                        Rectangle InnerRectangle = new Rectangle(this._redRect.x + 1, this._redRect.y + 1, this._redRect.width, this._redRect.height);
                        ((Graphics2D)g).fill(redRectHandle);
                        ((Graphics2D)g).draw(InnerRectangle);
                        ((Graphics2D)g).setColor(Color.red);
                        ((Graphics2D)g).setStroke(new BasicStroke(2.0f));
                        ((Graphics2D)g).draw(this._redRect);
                        ((Graphics2D)g).draw(InnerRectHandle);
                        ((Graphics2D)g).setStroke(oldStroke);
                    }
                }
                if (this.ocrConfidentLevel > 0 && this.ocrConfidentIcon != null) {
                    Rectangle r = new Rectangle(thumbRectLeft, thumbRectTop, this._thumbnailSize.width, this._thumbnailSize.height);
                    g.drawImage(this.ocrConfidentIcon.getImage(), (int)(r.getMaxX() - 16.0), (int)(r.getMaxY() - 16.0), 16, 16, this);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        super.paint(g);
    }

    public double getThumbScale() {
        return this._thumbScale;
    }

    public void setThumbScale(double _thumbScale) {
        this._thumbScale = _thumbScale;
    }

    boolean isThumbnailInverted() {
        return this._thumbnailInverted;
    }

    int getThumbnailRotation() {
        return this._thumbnailRotation;
    }

    public Image getThumbImage() {
        Image thumbImage = null;
        if (this._bUseSoftReference) {
            Object obj;
            if (this._thumbImageRef != null && (obj = this._thumbImageRef.get()) instanceof Image) {
                thumbImage = (Image)obj;
            }
        } else {
            thumbImage = this._thumbImage;
        }
        return thumbImage;
    }

    private void setThumbImage(Image thumbImage) {
        if (this._bUseSoftReference) {
            if (this._thumbImageRef != null) {
                this._thumbImageRef.clear();
            }
            this._thumbImageRef = new SoftReference<Image>(thumbImage);
        } else {
            this._thumbImage = thumbImage;
        }
    }

    public void setThumbnailInfo(Image thumbImage, Dimension thumbSize, boolean inverted, int rotation) {
        this.setThumbImage(thumbImage);
        this.setThumbnailSize(thumbSize);
        this._thumbnailInverted = inverted;
        this._thumbnailRotation = rotation;
    }

    public int getPageNumber() {
        return this._pageNumber;
    }

    public void setPageNumber(int _pageNumber) {
        int oldPageNumber = this._pageNumber;
        this._pageNumber = _pageNumber;
        this.firePropertyChange("Page Number", oldPageNumber, _pageNumber);
    }

    public boolean isBorderDisplayed() {
        return this.borderDisplayed;
    }

    public boolean isPageNumberDisplayed() {
        return this.pageNumberDisplayed;
    }

    public boolean isRedRectangleDisplayed() {
        return this.redRectangleDisplayed;
    }

    public void setBorderDisplayed(boolean _displayBorder) {
        this.borderDisplayed = _displayBorder;
    }

    public void setPageNumberDisplayed(boolean _displayPageNumber) {
        this.pageNumberDisplayed = _displayPageNumber;
    }

    public void setRedRectangleDisplayed(boolean _displayRedRectangle) {
        this.redRectangleDisplayed = _displayRedRectangle;
    }

    public PSingleThumbnailViewer getThumbViewer() {
        return this._thumbViewer;
    }

    public void setThumbViewer(PSingleThumbnailViewer thumbViewer) {
        this._thumbViewer = thumbViewer;
    }

    public boolean isInRedRect() {
        return this._inRedRect;
    }

    public boolean isPanAsDragged() {
        return this.panAsDragged;
    }

    public boolean isScaleAsDragged() {
        return this.scaleAsDragged;
    }

    public void setPanAsDragged(boolean panningRT) {
        this.panAsDragged = panningRT;
    }

    public void setScaleAsDragged(boolean scalingRT) {
        this.scaleAsDragged = scalingRT;
    }

    public boolean isHasFocus() {
        return this.hasFocus;
    }

    public void setHasFocus(boolean hasFocus) {
        this.hasFocus = hasFocus;
    }

    public boolean isUseSoftReference() {
        return this._bUseSoftReference;
    }

    public void setUseSoftReference(boolean useSR) {
        this._bUseSoftReference = useSR;
        Image thumbImage = null;
        if (this._bUseSoftReference) {
            if (this._thumbImage != null) {
                thumbImage = this._thumbImage;
                this._thumbImageRef = new SoftReference<Image>(thumbImage);
                this._thumbImage.flush();
                this._thumbImage = null;
            }
        } else if (this._thumbImageRef != null) {
            Object obj = this._thumbImageRef.get();
            if (obj instanceof Image) {
                thumbImage = (Image)obj;
            }
            this._thumbImage = thumbImage;
            this._thumbImageRef.clear();
            this._thumbImageRef = null;
        }
    }

    public Dimension getPreferredSize() {
        Border border = this.getBorder();
        if (this.borderDisplayed) {
            this.setBorder(border != null ? border : BorderFactory.createLineBorder(Color.black));
        }
        Insets borderInsets = this.getInsets();
        if (border != null) {
            borderInsets = border.getBorderInsets(this);
        }
        Dimension stringBounds = this.getPageNumberStringBounds(this._pageNumber);
        Dimension _pageNumStringOffset = new Dimension(4, 4);
        int compWidth = this._thumbnailSize.width + this._thumbnailOffsets.width + borderInsets.left + borderInsets.right;
        int compHeight = this._thumbnailSize.height + this._thumbnailOffsets.height + borderInsets.top + borderInsets.bottom + stringBounds.height + _pageNumStringOffset.height;
        return new Dimension(compWidth, compHeight);
    }

    public void updateDropFlags(Point p) {
        Dimension d = this.getPreferredSize();
        if (this.getOrientation() == 0) {
            this._dropBefore = p.getX() >= (double)(-d.width / 2) && p.getX() < (double)(d.width / 2);
            this._dropAfter = p.getX() >= (double)(d.width / 2) && p.getX() < (double)(d.width + d.width / 2);
        } else {
            this._dropBefore = p.getY() >= (double)(-d.height / 2) && p.getY() < (double)(d.height / 2);
            this._dropAfter = p.getY() >= (double)(d.height / 2) && p.getY() < (double)(d.height + d.height / 2);
        }
    }

    public void clearDropFlags() {
        this._dropBefore = false;
        this._dropAfter = false;
    }

    public boolean getDropBefore() {
        return this._dropBefore;
    }

    public boolean getDropAfter() {
        return this._dropAfter;
    }

    public void setFirstThumb(boolean first) {
        this._firstThumb = first;
    }

    public void setValidDrop(boolean validDrop) {
        this._validDrop = validDrop;
    }

    private Rectangle getRedRectangle(Rectangle viewRect) {
        Rectangle redRectangle = null;
        if (redRectangle == null) {
            redRectangle = new Rectangle();
        }
        if (viewRect == null) {
            return null;
        }
        double scale = this.getDocModel().getScale();
        if (this._thumbScale == 0.0) {
            PPageModel thePageModel = (PPageModel)this.getDocModel();
            try {
                this._thumbScale = thePageModel.getScaleToFit(this._pageNumber, this._thumbnailSize, 0, 0, 3);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        int newX = (int)((double)viewRect.x * this._thumbScale / scale);
        int newY = (int)((double)viewRect.y * this._thumbScale / scale);
        int newWidth = (int)((double)viewRect.width * this._thumbScale / scale);
        int newHeight = (int)((double)viewRect.height * this._thumbScale / scale);
        redRectangle.setBounds(newX, newY, newWidth, newHeight);
        return redRectangle;
    }

    Point getViewPoint(Point tPoint) {
        Dimension pageNumStringBounds = this.getPageNumberStringBounds(this._pageNumber);
        Dimension _pageNumStringOffset = new Dimension(4, 4);
        Insets borderInsets = this.getInsets();
        int currImgWidth = this._currImageRect.width;
        int currImgHeight = this._currImageRect.height;
        Image _thumbImage = this.getThumbImage();
        if (_thumbImage != null) {
            currImgWidth = _thumbImage.getWidth(this);
            currImgHeight = _thumbImage.getHeight(this);
        }
        int ptX = (this._thumbnailSize.width - currImgWidth) / 2;
        int ptY = (this._thumbnailSize.height - currImgHeight) / 2;
        int thumbRectLeft = borderInsets.left + this._thumbnailOffsets.width / 2;
        int thumbRectTop = borderInsets.top + this._thumbnailOffsets.height / 2 + pageNumStringBounds.height + _pageNumStringOffset.height;
        Point vPoint = new Point(tPoint);
        vPoint.translate(-thumbRectLeft - ptX, -thumbRectTop - ptY);
        PPageModel thePageModel = (PPageModel)this.getDocModel();
        CMBPage page = thePageModel.getPage(this._pageNumber);
        double vScale = ((PPageModel)this.getDocModel()).getScale(this._pageNumber);
        double tScale = this._thumbScale;
        vPoint.x = (int)((double)vPoint.x * vScale / tScale);
        vPoint.y = (int)((double)vPoint.y * vScale / tScale);
        return vPoint;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSingleThumbnailView();
        }
        return this.accessibleContext;
    }

    protected class AccessibleSingleThumbnailView
    extends PDocView.AccessiblePDocView {
        protected AccessibleSingleThumbnailView() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST_ITEM;
        }
    }

    class PSingleThumbnailViewer
    implements FocusListener,
    MouseListener,
    MouseMotionListener {
        private Point ptInRedRect;
        private boolean scalingRedRect;
        private boolean redRectClicked;
        private Rectangle RedRectAtDragStart;

        PSingleThumbnailViewer() {
        }

        public void mouseClicked(MouseEvent mEvent) {
        }

        public void mouseEntered(MouseEvent mEvent) {
        }

        public void mouseExited(MouseEvent mEvent) {
            PSingleThumbnailView.this._inRedRect = false;
            PSingleThumbnailView.this.setCursor(Cursor.getPredefinedCursor(0));
        }

        public void mousePressed(MouseEvent mEvent) {
            PPageModel thePageModel = (PPageModel)PSingleThumbnailView.this.getDocModel();
            int currPageNumber = thePageModel.getCurrentPageNumber();
            if (currPageNumber == PSingleThumbnailView.this._pageNumber && PSingleThumbnailView.this.redRectangleDisplayed) {
                Point ptClick = mEvent.getPoint();
                if ((mEvent.getModifiers() & 0x10) == 16) {
                    PSingleThumbnailView.this._redRect = PSingleThumbnailView.this.getRedRectangle(thePageModel.getCurrentViewRectangle());
                    if (PSingleThumbnailView.this._redRect != null) {
                        if (PSingleThumbnailView.this._currImageRect != null) {
                            PSingleThumbnailView.this._redRect.setLocation(((PSingleThumbnailView)PSingleThumbnailView.this)._redRect.x + ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.x, ((PSingleThumbnailView)PSingleThumbnailView.this)._redRect.y + ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.y);
                        }
                        Rectangle redRectHandle = new Rectangle(((PSingleThumbnailView)PSingleThumbnailView.this)._redRect.x + ((PSingleThumbnailView)PSingleThumbnailView.this)._redRect.width - 5, ((PSingleThumbnailView)PSingleThumbnailView.this)._redRect.y + ((PSingleThumbnailView)PSingleThumbnailView.this)._redRect.height - 5, 5, 5);
                        this.ptInRedRect = ptClick;
                        this.RedRectAtDragStart = new Rectangle(PSingleThumbnailView.this._redRect);
                        if (redRectHandle.contains(ptClick)) {
                            PSingleThumbnailView.this.setCursor(Cursor.getPredefinedCursor(5));
                            this.scalingRedRect = true;
                            PSingleThumbnailView.this._inRedRect = true;
                            return;
                        }
                        if (PSingleThumbnailView.this._redRect.contains(ptClick)) {
                            PSingleThumbnailView.this.setCursor(Cursor.getPredefinedCursor(12));
                            this.redRectClicked = true;
                            PSingleThumbnailView.this._inRedRect = true;
                            return;
                        }
                        PSingleThumbnailView.this.setCursor(Cursor.getPredefinedCursor(0));
                        PSingleThumbnailView.this._inRedRect = false;
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent mEvent) {
            PPageModel thePageModel = (PPageModel)PSingleThumbnailView.this.getDocModel();
            int currPageNumber = thePageModel.getCurrentPageNumber();
            if (currPageNumber == PSingleThumbnailView.this._pageNumber && PSingleThumbnailView.this.redRectangleDisplayed) {
                Point ptClick = mEvent.getPoint();
                if ((mEvent.getModifiers() & 0x10) == 16) {
                    if (this.redRectClicked || this.scalingRedRect) {
                        PSingleThumbnailView.this.setCursor(Cursor.getPredefinedCursor(3));
                        int xDelta = ptClick.x - this.ptInRedRect.x;
                        int yDelta = ptClick.y - this.ptInRedRect.y;
                        if (this.scalingRedRect) {
                            int newWidth = this.RedRectAtDragStart.width + xDelta;
                            int newHeight = this.RedRectAtDragStart.height + yDelta;
                            if (newWidth < 7) {
                                newWidth = 7;
                            }
                            if (newHeight < 7) {
                                newHeight = 7;
                            }
                            if (this.RedRectAtDragStart.x + newWidth > ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.x + ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.width) {
                                newWidth = ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.x + ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.width - this.RedRectAtDragStart.x;
                            }
                            if (this.RedRectAtDragStart.y + newHeight > ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.y + ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.height) {
                                newHeight = ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.y + ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.height - this.RedRectAtDragStart.y;
                            }
                            PSingleThumbnailView.this._redRect.setSize(newWidth, newHeight);
                        } else if (this.redRectClicked) {
                            int newX = this.RedRectAtDragStart.x + xDelta;
                            int newY = this.RedRectAtDragStart.y + yDelta;
                            if (newX < ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.x) {
                                newX = ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.x;
                            }
                            if (newY < ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.y) {
                                newY = ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.y;
                            }
                            if (newX + this.RedRectAtDragStart.width > ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.x + ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.width) {
                                newX = ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.x + ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.width - this.RedRectAtDragStart.width - 1;
                            }
                            if (newY + this.RedRectAtDragStart.height > ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.y + ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.height) {
                                newY = ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.y + ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.height - this.RedRectAtDragStart.height - 1;
                            }
                            PSingleThumbnailView.this._redRect.setLocation(newX, newY);
                        }
                        PSingleThumbnailView.this._updateRedRectFromModel = true;
                        this.setCurrentViewRect();
                    }
                    if (PSingleThumbnailView.this._redRect != null) {
                        Rectangle redRectHandle = new Rectangle(((PSingleThumbnailView)PSingleThumbnailView.this)._redRect.x + ((PSingleThumbnailView)PSingleThumbnailView.this)._redRect.width - 5, ((PSingleThumbnailView)PSingleThumbnailView.this)._redRect.y + ((PSingleThumbnailView)PSingleThumbnailView.this)._redRect.height - 5, 5, 5);
                        if (redRectHandle.contains(ptClick)) {
                            PSingleThumbnailView.this.setCursor(Cursor.getPredefinedCursor(5));
                            PSingleThumbnailView.this._inRedRect = true;
                        } else if (PSingleThumbnailView.this._redRect.contains(ptClick)) {
                            PSingleThumbnailView.this.setCursor(Cursor.getPredefinedCursor(12));
                            PSingleThumbnailView.this._inRedRect = true;
                        } else {
                            PSingleThumbnailView.this.setCursor(Cursor.getPredefinedCursor(0));
                            PSingleThumbnailView.this._inRedRect = false;
                        }
                    }
                    this.redRectClicked = false;
                    this.scalingRedRect = false;
                }
            }
        }

        public void mouseDragged(MouseEvent mEvent) {
            PPageModel thePageModel = (PPageModel)PSingleThumbnailView.this.getDocModel();
            int currPageNumber = thePageModel.getCurrentPageNumber();
            if (currPageNumber == PSingleThumbnailView.this._pageNumber && PSingleThumbnailView.this.redRectangleDisplayed) {
                Point ptClick = mEvent.getPoint();
                if ((mEvent.getModifiers() & 0x10) == 16) {
                    if (this.scalingRedRect) {
                        PSingleThumbnailView.this.setCursor(Cursor.getPredefinedCursor(5));
                        int xDelta = ptClick.x - this.ptInRedRect.x;
                        int yDelta = ptClick.y - this.ptInRedRect.y;
                        if (xDelta != 0 || yDelta != 0) {
                            float redRectAspect = (float)this.RedRectAtDragStart.width / (float)this.RedRectAtDragStart.height;
                            int newWidth = this.RedRectAtDragStart.width + xDelta;
                            int newHeight = this.RedRectAtDragStart.height + yDelta;
                            if (newWidth < 7) {
                                newWidth = 7;
                            }
                            if (newHeight < 7) {
                                newHeight = 7;
                            }
                            if (this.RedRectAtDragStart.x + newWidth > ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.x + ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.width) {
                                newWidth = ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.x + ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.width - this.RedRectAtDragStart.x;
                            }
                            if (this.RedRectAtDragStart.y + newHeight > ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.y + ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.height) {
                                newHeight = ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.y + ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.height - this.RedRectAtDragStart.y;
                            }
                            PSingleThumbnailView.this._redRect.setSize(newWidth, newHeight);
                            if (PSingleThumbnailView.this.scaleAsDragged) {
                                PSingleThumbnailView.this._updateRedRectFromModel = true;
                                this.setCurrentViewRect();
                            } else if (PSingleThumbnailView.this.isShowing()) {
                                PSingleThumbnailView.this.repaint();
                            }
                        }
                    } else if (this.redRectClicked) {
                        PSingleThumbnailView.this.setCursor(Cursor.getPredefinedCursor(12));
                        int xDelta = ptClick.x - this.ptInRedRect.x;
                        int yDelta = ptClick.y - this.ptInRedRect.y;
                        if (xDelta != 0 || yDelta != 0) {
                            int newX = this.RedRectAtDragStart.x + xDelta;
                            int newY = this.RedRectAtDragStart.y + yDelta;
                            if (newX < ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.x) {
                                newX = ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.x;
                            }
                            if (newY < ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.y) {
                                newY = ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.y;
                            }
                            if (newX + this.RedRectAtDragStart.width > ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.x + ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.width) {
                                newX = ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.x + ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.width - this.RedRectAtDragStart.width - 1;
                            }
                            if (newY + this.RedRectAtDragStart.height > ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.y + ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.height) {
                                newY = ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.y + ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.height - this.RedRectAtDragStart.height - 1;
                            }
                            PSingleThumbnailView.this._redRect.setLocation(newX, newY);
                            if (PSingleThumbnailView.this.panAsDragged) {
                                PSingleThumbnailView.this._updateRedRectFromModel = true;
                                this.setCurrentViewRect();
                            } else if (PSingleThumbnailView.this.isShowing()) {
                                PSingleThumbnailView.this.repaint();
                            }
                        }
                    }
                }
            } else {
                PSingleThumbnailView.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        public void mouseMoved(MouseEvent mEvent) {
            PPageModel thePageModel = (PPageModel)PSingleThumbnailView.this.getDocModel();
            int currPageNumber = thePageModel.getCurrentPageNumber();
            Point ptClick = mEvent.getPoint();
            if (currPageNumber == PSingleThumbnailView.this._pageNumber && PSingleThumbnailView.this.redRectangleDisplayed) {
                if (PSingleThumbnailView.this._redRect == null) {
                    PSingleThumbnailView.this.setCursor(Cursor.getPredefinedCursor(0));
                    PSingleThumbnailView.this._inRedRect = false;
                    return;
                }
                Rectangle redRectHandle = new Rectangle(((PSingleThumbnailView)PSingleThumbnailView.this)._redRect.x + ((PSingleThumbnailView)PSingleThumbnailView.this)._redRect.width - 5, ((PSingleThumbnailView)PSingleThumbnailView.this)._redRect.y + ((PSingleThumbnailView)PSingleThumbnailView.this)._redRect.height - 5, 5, 5);
                if (redRectHandle.contains(ptClick)) {
                    PSingleThumbnailView.this.setCursor(Cursor.getPredefinedCursor(5));
                    PSingleThumbnailView.this._inRedRect = true;
                } else if (PSingleThumbnailView.this._redRect.contains(ptClick)) {
                    PSingleThumbnailView.this.setCursor(Cursor.getPredefinedCursor(12));
                    PSingleThumbnailView.this._inRedRect = true;
                } else {
                    PSingleThumbnailView.this.setCursor(Cursor.getPredefinedCursor(0));
                    PSingleThumbnailView.this._inRedRect = false;
                }
            } else {
                PSingleThumbnailView.this.setCursor(Cursor.getPredefinedCursor(0));
                PSingleThumbnailView.this._inRedRect = false;
            }
        }

        public void focusGained(FocusEvent arg0) {
            PSingleThumbnailView.this.hasFocus = true;
            PSingleThumbnailView.this.repaint();
        }

        public void focusLost(FocusEvent arg0) {
            PSingleThumbnailView.this.hasFocus = false;
            PSingleThumbnailView.this.repaint();
        }

        private void setCurrentViewRect() {
            PPageModel thePageModel = (PPageModel)PSingleThumbnailView.this.getDocModel();
            double docScale = PSingleThumbnailView.this.getDocModel().getDocument().getPreferredScale();
            Rectangle modelRect = new Rectangle(thePageModel.getCurrentViewRectangle());
            if (this.scalingRedRect) {
                double newWidth = (double)((PSingleThumbnailView)PSingleThumbnailView.this)._redRect.width / PSingleThumbnailView.this._thumbScale;
                double newHeight = (double)((PSingleThumbnailView)PSingleThumbnailView.this)._redRect.height / PSingleThumbnailView.this._thumbScale;
                double widthScale = (double)modelRect.width / newWidth;
                double heightScale = (double)modelRect.height / newHeight;
                double newScale = Math.min(widthScale, heightScale);
                thePageModel.setScale(newScale);
            } else if (this.redRectClicked) {
                int newX = (int)((double)(((PSingleThumbnailView)PSingleThumbnailView.this)._redRect.x - ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.x) / PSingleThumbnailView.this._thumbScale * docScale);
                int newY = (int)((double)(((PSingleThumbnailView)PSingleThumbnailView.this)._redRect.y - ((PSingleThumbnailView)PSingleThumbnailView.this)._currImageRect.y) / PSingleThumbnailView.this._thumbScale * docScale);
                if (newX < 0) {
                    newX = 0;
                }
                if (newY < 0) {
                    newY = 0;
                }
                modelRect.setLocation(newX, newY);
                thePageModel.setCurrentViewRectangle(modelRect);
            }
        }
    }
}

