/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.PDocModel;
import com.ibm.mm.viewer.PFullSizeView;
import com.ibm.mm.viewer.PThumbnailsView;
import com.ibm.mm.viewer.annotation.CMBAnnotationSet;
import java.awt.Container;
import java.util.ArrayList;

abstract class PSingleDocViewer {
    private PDocModel docModel;
    private PThumbnailsView thumbnailsView;
    ArrayList fullSizeViews = new ArrayList();
    private CMBGenericDocViewer gdv;

    private PSingleDocViewer() {
    }

    protected PSingleDocViewer(CMBGenericDocViewer gdv, CMBDocument document, CMBAnnotationSet annoSet, String docName) {
        this.gdv = gdv;
        this.docModel = this.createDocModel(document, annoSet);
        this.docModel.setDocName(docName);
    }

    public CMBGenericDocViewer getGdv() {
        return this.gdv;
    }

    public abstract PFullSizeView createFullSizeView();

    public void destroyFullSizeView(PFullSizeView view) {
        this.fullSizeViews.remove(view);
        Container parent = view.getParent();
        if (parent != null) {
            parent.remove(view);
            parent.validate();
        }
        view.dispose();
    }

    public int getFullSizeViewCount() {
        return this.fullSizeViews.size();
    }

    public PFullSizeView getFullSizeView(int index) {
        return (PFullSizeView)this.fullSizeViews.get(index);
    }

    protected abstract PDocModel createDocModel(CMBDocument var1, CMBAnnotationSet var2);

    public PDocModel getDocModel() {
        return this.docModel;
    }

    protected abstract PThumbnailsView createThumbnailsView();

    public PThumbnailsView getThumbnailsView() {
        if (this.thumbnailsView == null && this.docModel != null) {
            this.thumbnailsView = this.createThumbnailsView();
        }
        return this.thumbnailsView;
    }

    public void dispose() {
        for (int i = 0; i < this.fullSizeViews.size(); ++i) {
            PFullSizeView view = (PFullSizeView)this.fullSizeViews.get(i);
            Container parent = view.getParent();
            if (parent != null) {
                parent.remove(view);
                parent.validate();
            }
            view.dispose();
        }
        this.fullSizeViews.clear();
        if (this.thumbnailsView != null) {
            this.thumbnailsView.dispose();
            this.thumbnailsView = null;
        }
        if (this.docModel != null) {
            this.docModel.dispose();
            this.docModel = null;
        }
    }
}

