/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.PDataAccessInterface;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

final class PSimpleStreamAccess
implements PDataAccessInterface {
    private boolean bigEndian;
    private byte[] data;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public PSimpleStreamAccess(InputStream inputStream) throws IOException {
        super();
        methodName = "PSimpleStreamAccess";
        outstream = new ByteArrayOutputStream(Math.max(inputStream.available(), 0x100000));
        try {
            len = 0;
            do {
                if ((len = inputStream.read(buff = new byte[Math.max(65536, inputStream.available())])) <= 0) continue;
                outstream.write(buff, 0, len);
            } while (len != -1);
            var7_6 = null;
            ** if (inputStream == null) goto lbl-1000
        }
        catch (Throwable var6_10) {
            var7_7 = null;
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    ViewerLogger.logError((Object)this, methodName, e);
                }
            }
            throw var6_10;
        }
lbl-1000:
        // 1 sources

        {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                ViewerLogger.logError((Object)this, methodName, e);
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        this.data = outstream.toByteArray();
    }

    public int getSize() {
        return this.data.length;
    }

    public boolean getBigEndian() {
        return this.bigEndian;
    }

    public byte getByte(int offset) {
        return this.data[offset];
    }

    public byte[] getByteArray(int offset, int length) {
        return this.getByteArray(offset, length, false);
    }

    public byte[] getByteArray(int offset, int length, boolean invertBits) {
        byte[] returnData = new byte[length];
        for (int i = 0; i < length; ++i) {
            returnData[i] = invertBits ? this.invertBits(this.data[offset + i]) : this.data[offset + i];
        }
        return returnData;
    }

    public byte invertBits(byte dataByte) {
        byte invertedByte = 0;
        if ((dataByte & 0x80) == 128) {
            invertedByte = (byte)(invertedByte | 1);
        }
        if ((dataByte & 0x40) == 64) {
            invertedByte = (byte)(invertedByte | 2);
        }
        if ((dataByte & 0x20) == 32) {
            invertedByte = (byte)(invertedByte | 4);
        }
        if ((dataByte & 0x10) == 16) {
            invertedByte = (byte)(invertedByte | 8);
        }
        if ((dataByte & 8) == 8) {
            invertedByte = (byte)(invertedByte | 0x10);
        }
        if ((dataByte & 4) == 4) {
            invertedByte = (byte)(invertedByte | 0x20);
        }
        if ((dataByte & 2) == 2) {
            invertedByte = (byte)(invertedByte | 0x40);
        }
        if ((dataByte & 1) == 1) {
            invertedByte = (byte)(invertedByte | 0x80);
        }
        return invertedByte;
    }

    public int getByteArray(int offset, int length, byte[] returnData, int returnDataOffset) {
        int actualLength = Math.min(length, this.data.length - offset);
        for (int i = 0; i < actualLength; ++i) {
            returnData[i + returnDataOffset] = this.data[offset + i];
        }
        return actualLength;
    }

    public int getInt(int offset) {
        int returnInt;
        if (this.bigEndian) {
            returnInt = this.data[offset] & 0xFF;
            returnInt = (returnInt << 8) + (this.data[offset + 1] & 0xFF);
            returnInt = (returnInt << 8) + (this.data[offset + 2] & 0xFF);
            returnInt = (returnInt << 8) + (this.data[offset + 3] & 0xFF);
        } else {
            returnInt = this.data[offset + 3] & 0xFF;
            returnInt = (returnInt << 8) + (this.data[offset + 2] & 0xFF);
            returnInt = (returnInt << 8) + (this.data[offset + 1] & 0xFF);
            returnInt = (returnInt << 8) + (this.data[offset] & 0xFF);
        }
        return returnInt;
    }

    public int[] getIntArray(int offset, int length) {
        int[] returnIntArray = new int[length];
        for (int i = 0; i < length; ++i) {
            returnIntArray[i] = this.getInt(offset + 4 * i);
        }
        return returnIntArray;
    }

    public int getShort(int offset) {
        int returnShort;
        if (this.bigEndian) {
            returnShort = this.data[offset] & 0xFF;
            returnShort = (short)(returnShort << 8) + (this.data[offset + 1] & 0xFF);
        } else {
            returnShort = this.data[offset + 1] & 0xFF;
            returnShort = (returnShort << 8) + (this.data[offset] & 0xFF);
        }
        return returnShort;
    }

    public int[] getShortArray(int offset, int length) {
        int[] returnShortArray = new int[length];
        for (int i = 0; i < length; ++i) {
            returnShortArray[i] = this.getShort(offset + 2 * i);
        }
        return returnShortArray;
    }

    public void setBigEndian(boolean bigEndian) {
        this.bigEndian = bigEndian;
    }

    public boolean isValidOffset(int offset) {
        return offset < this.data.length;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.data);
    }

    public void dispose() {
        this.data = null;
    }
}

