/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.ecm.servicability.ViewerLogger;
import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.PAbstractTask;
import com.ibm.mm.viewer.PPageModel;
import com.ibm.mm.viewer.PTaskManager;
import com.ibm.mm.viewer.PViewerUtilities;

class PRotatePagesTask
extends PAbstractTask {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    private CMBGenericDocViewer viewer = null;
    private int[] pages;
    private int rotation;
    private boolean rotatedPermanently;

    PRotatePagesTask(PTaskManager taskManager, CMBGenericDocViewer viewer, int[] pages, int rotation) {
        super(taskManager);
        this.viewer = viewer;
        this.pages = pages;
        this.rotation = rotation;
        this.getManager().invokeTask(this, true);
    }

    public boolean doIt() {
        String methodName = "doIt";
        try {
            PPageModel model = (PPageModel)this.viewer.getSelectedModel();
            boolean results = false;
            if (this.viewer.isPageManipulationEnabled() && model.getDocument().getCanManipulatePages() && model.getPrivilege(4)) {
                model.rotatePagesPermanently(this.rotation, this.pages);
                this.rotatedPermanently = true;
                results = true;
            } else {
                model.rotatePages(this.rotation, this.pages);
                results = false;
            }
            this.viewer.dropOCRPages(model.getDocument(), this.pages);
            model.document.setOCRValid(false);
            return results;
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
            return false;
        }
    }

    public boolean undoIt() {
        String methodName = "undoIt";
        try {
            PPageModel model = (PPageModel)this.viewer.getSelectedModel();
            int oppositeRotation = 0;
            if (this.rotation == 1) {
                oppositeRotation = 3;
            } else if (this.rotation == 2) {
                oppositeRotation = 2;
            } else if (this.rotation == 3) {
                oppositeRotation = 1;
            }
            if (this.rotatedPermanently) {
                model.rotatePagesPermanently(oppositeRotation, this.pages);
            } else {
                model.rotatePages(oppositeRotation, this.pages);
            }
            this.viewer.dropOCRPages(model.getDocument(), this.pages);
            model.document.setOCRValid(false);
        }
        catch (Exception e) {
            ViewerLogger.logError((Object)this, methodName, e);
            return false;
        }
        return true;
    }

    public String getDescription() {
        if (this.pages.length == 1) {
            return PViewerUtilities.getMessage("rotatePageTask.description");
        }
        return PViewerUtilities.getMessage("rotatePagesTask.description");
    }
}

