/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mm.viewer;

import com.ibm.mm.viewer.CMBGenericDocViewer;
import com.ibm.mm.viewer.POptionPane;
import com.ibm.mm.viewer.PPageModel;
import com.ibm.mm.viewer.PRotatePagesTask;
import com.ibm.mm.viewer.PViewerUtilities;
import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

class PRotatePagesDialog {
    private static final String copyright = "Licensed Materials - Property of IBM\n\ufffd Copyright IBM Corp.  1998, 2006.  All Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by GSA ADP Schedule\nContract with IBM Corporation\n";
    int pageCount;
    int pageRotation;
    int startPage;
    int endPage;
    JPanel rotationPanel = null;
    JPanel pageRangePanel = null;
    TitledBorder rotationBorder = null;
    TitledBorder pageRangeBorder = null;
    JRadioButton rbRotation_90CW = null;
    JRadioButton rbRotation_90CCW = null;
    JRadioButton rbRotation_180 = null;
    ButtonGroup rotationRadioGrp = null;
    JRadioButton rbCurrentPage = null;
    JRadioButton rbAllPages = null;
    JRadioButton rbRangePages = null;
    ButtonGroup pageRangeRadioGrp = null;
    JComboBox cbStartPage = null;
    JLabel fromLabel = null;
    JComboBox cbEndPage = null;
    JLabel toLabel = null;
    private CMBGenericDocViewer viewer = null;

    PRotatePagesDialog(int pageCount, CMBGenericDocViewer viewer) {
        BasicComboBoxRenderer r;
        boolean ltr = PViewerUtilities.isLeftToRight();
        ComponentOrientation compOri = ComponentOrientation.LEFT_TO_RIGHT;
        float alignmentX = 0.0f;
        if (!ltr) {
            compOri = ComponentOrientation.RIGHT_TO_LEFT;
            alignmentX = 1.0f;
        }
        String degreeSymbol = new String("\u00b0");
        this.pageCount = pageCount;
        this.viewer = viewer;
        this.rotationPanel = new JPanel();
        this.pageRangePanel = new JPanel();
        int titleJustification = ltr ? 1 : 3;
        this.rotationBorder = new TitledBorder(PViewerUtilities.getMessage("DocumentViewer.Direction"));
        this.rotationBorder.setTitleJustification(titleJustification);
        this.pageRangeBorder = new TitledBorder(PViewerUtilities.getMessage("DocumentViewer.PageRange"));
        this.pageRangeBorder.setTitleJustification(titleJustification);
        this.rotationPanel.setBorder(this.rotationBorder);
        this.pageRangePanel.setBorder(this.pageRangeBorder);
        this.rotationPanel.setLayout(new BoxLayout(this.rotationPanel, 1));
        this.rotationPanel.setComponentOrientation(compOri);
        this.rotationPanel.setAlignmentX(alignmentX);
        this.pageRangePanel.setLayout(new BoxLayout(this.pageRangePanel, 1));
        this.pageRangePanel.setComponentOrientation(compOri);
        this.pageRangePanel.setAlignmentX(alignmentX);
        this.rbRotation_90CW = new JRadioButton(PViewerUtilities.getMessage("DocumentViewer.90") + degreeSymbol + " " + PViewerUtilities.getMessage("DocumentViewer.CW"));
        this.rbRotation_90CW.setActionCommand("1");
        this.rbRotation_90CW.setMnemonic(PViewerUtilities.getMessage("DocumentViewer.CW.mnemonic").charAt(0));
        this.rbRotation_90CW.setComponentOrientation(compOri);
        this.rbRotation_90CW.setAlignmentX(alignmentX);
        this.rbRotation_90CCW = new JRadioButton(PViewerUtilities.getMessage("DocumentViewer.90") + degreeSymbol + " " + PViewerUtilities.getMessage("DocumentViewer.CCW"));
        this.rbRotation_90CCW.setActionCommand("3");
        this.rbRotation_90CCW.setMnemonic(PViewerUtilities.getMessage("DocumentViewer.CCW.mnemonic").charAt(0));
        this.rbRotation_90CCW.setComponentOrientation(compOri);
        this.rbRotation_90CCW.setAlignmentX(alignmentX);
        this.rbRotation_180 = new JRadioButton(PViewerUtilities.getMessage("DocumentViewer.180") + degreeSymbol);
        this.rbRotation_180.setActionCommand("2");
        this.rbRotation_180.setMnemonic(PViewerUtilities.getMessage("DocumentViewer.180.mnemonic").charAt(0));
        this.rbRotation_180.setComponentOrientation(compOri);
        this.rbRotation_180.setAlignmentX(alignmentX);
        this.rotationRadioGrp = new ButtonGroup();
        this.rotationRadioGrp.add(this.rbRotation_90CW);
        this.rotationRadioGrp.add(this.rbRotation_90CCW);
        this.rotationRadioGrp.add(this.rbRotation_180);
        ItemListener rotationListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JRadioButton rButton = (JRadioButton)e.getSource();
                if (rButton.isSelected()) {
                    PRotatePagesDialog.this.pageRotation = Integer.parseInt(rButton.getActionCommand());
                }
            }
        };
        this.rbRotation_90CW.addItemListener(rotationListener);
        this.rbRotation_90CCW.addItemListener(rotationListener);
        this.rbRotation_180.addItemListener(rotationListener);
        this.rbRotation_90CW.setSelected(true);
        this.rotationPanel.add(this.rbRotation_90CW);
        this.rotationPanel.add(this.rbRotation_90CCW);
        this.rotationPanel.add(this.rbRotation_180);
        this.rbCurrentPage = new JRadioButton(PViewerUtilities.getMessage("DocumentViewer.Current"));
        this.rbCurrentPage.setMnemonic(PViewerUtilities.getMessage("DocumentViewer.Current.mnemonic").charAt(0));
        this.rbCurrentPage.setActionCommand(String.valueOf(0));
        this.rbCurrentPage.setComponentOrientation(compOri);
        this.rbCurrentPage.setAlignmentX(alignmentX);
        this.rbAllPages = new JRadioButton(PViewerUtilities.getMessage("DocumentViewer.AllPages"));
        this.rbAllPages.setMnemonic(PViewerUtilities.getMessage("DocumentViewer.AllPages.mnemonic").charAt(0));
        this.rbAllPages.setActionCommand(String.valueOf(1));
        this.rbAllPages.setComponentOrientation(compOri);
        this.rbAllPages.setAlignmentX(alignmentX);
        this.rbRangePages = new JRadioButton(PViewerUtilities.getMessage("DocumentViewer.Pages"));
        this.rbRangePages.setMnemonic(PViewerUtilities.getMessage("DocumentViewer.Pages.mnemonic").charAt(0));
        this.rbRangePages.setActionCommand(String.valueOf(2));
        this.rbRangePages.setComponentOrientation(compOri);
        this.rbRangePages.setAlignmentX(alignmentX);
        this.pageRangeRadioGrp = new ButtonGroup();
        this.pageRangeRadioGrp.add(this.rbCurrentPage);
        this.pageRangeRadioGrp.add(this.rbAllPages);
        this.pageRangeRadioGrp.add(this.rbRangePages);
        Integer[] pages = new Integer[pageCount];
        for (int arrIndex = 0; arrIndex < pageCount; ++arrIndex) {
            pages[arrIndex] = new Integer(((PPageModel)viewer.getSelectedModel()).getPageNumber(arrIndex + 1));
        }
        this.cbStartPage = new JComboBox<Integer>(pages);
        this.cbStartPage.setComponentOrientation(compOri);
        this.cbStartPage.setAlignmentX(alignmentX);
        this.cbStartPage.setPrototypeDisplayValue(new Integer(1000));
        ListCellRenderer renderer = this.cbStartPage.getRenderer();
        if (renderer instanceof BasicComboBoxRenderer) {
            r = (BasicComboBoxRenderer)renderer;
            r.setComponentOrientation(compOri);
        }
        this.fromLabel = new JLabel(PViewerUtilities.getMessage("DocumentViewer.From"));
        this.fromLabel.setLabelFor(this.cbStartPage);
        this.fromLabel.setDisplayedMnemonic(PViewerUtilities.getMessage("DocumentViewer.From.mnemonic").charAt(0));
        this.fromLabel.setComponentOrientation(compOri);
        this.fromLabel.setAlignmentX(alignmentX);
        this.cbEndPage = new JComboBox<Integer>(pages);
        this.cbEndPage.setComponentOrientation(compOri);
        this.cbEndPage.setAlignmentX(alignmentX);
        this.cbEndPage.setPrototypeDisplayValue(new Integer(1000));
        renderer = this.cbEndPage.getRenderer();
        if (renderer instanceof BasicComboBoxRenderer) {
            r = (BasicComboBoxRenderer)renderer;
            r.setComponentOrientation(compOri);
        }
        this.toLabel = new JLabel(PViewerUtilities.getMessage("DocumentViewer.To"));
        this.toLabel.setLabelFor(this.cbEndPage);
        this.toLabel.setDisplayedMnemonic(PViewerUtilities.getMessage("DocumentViewer.To.mnemonic").charAt(0));
        this.toLabel.setComponentOrientation(compOri);
        this.toLabel.setAlignmentX(alignmentX);
        JPanel rangeBox = new JPanel();
        rangeBox.setLayout(new BoxLayout(rangeBox, 0));
        rangeBox.setAlignmentX(alignmentX);
        rangeBox.setComponentOrientation(compOri);
        if (ltr) {
            rangeBox.add(this.rbRangePages);
            rangeBox.add(Box.createHorizontalStrut(10));
            rangeBox.add(this.fromLabel);
            rangeBox.add(this.cbStartPage);
            rangeBox.add(Box.createHorizontalStrut(10));
            rangeBox.add(this.toLabel);
            rangeBox.add(this.cbEndPage);
        } else {
            rangeBox.add(this.cbEndPage);
            rangeBox.add(this.toLabel);
            rangeBox.add(Box.createHorizontalStrut(10));
            rangeBox.add(this.cbStartPage);
            rangeBox.add(this.fromLabel);
            rangeBox.add(Box.createHorizontalStrut(10));
            rangeBox.add(this.rbRangePages);
        }
        ItemListener pageRangeRadioListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JRadioButton rButton = (JRadioButton)e.getSource();
                if (rButton.isSelected()) {
                    if (rButton.getActionCommand().equalsIgnoreCase("0")) {
                        PRotatePagesDialog.this.startPage = 0;
                        PRotatePagesDialog.this.endPage = 0;
                    } else if (rButton.getActionCommand().equalsIgnoreCase("1")) {
                        PRotatePagesDialog.this.startPage = 0;
                        PRotatePagesDialog.this.endPage = -1;
                    } else {
                        PRotatePagesDialog.this.fromLabel.setEnabled(true);
                        PRotatePagesDialog.this.cbStartPage.setEnabled(true);
                        PRotatePagesDialog.this.toLabel.setEnabled(true);
                        PRotatePagesDialog.this.cbEndPage.setEnabled(true);
                        PRotatePagesDialog.this.startPage = (Integer)PRotatePagesDialog.this.cbStartPage.getSelectedItem();
                        PRotatePagesDialog.this.endPage = (Integer)PRotatePagesDialog.this.cbEndPage.getSelectedItem();
                    }
                } else if (rButton.getActionCommand().equalsIgnoreCase("2")) {
                    PRotatePagesDialog.this.fromLabel.setEnabled(false);
                    PRotatePagesDialog.this.cbStartPage.setEnabled(false);
                    PRotatePagesDialog.this.toLabel.setEnabled(false);
                    PRotatePagesDialog.this.cbEndPage.setEnabled(false);
                }
            }
        };
        this.rbCurrentPage.addItemListener(pageRangeRadioListener);
        this.rbAllPages.addItemListener(pageRangeRadioListener);
        this.rbRangePages.addItemListener(pageRangeRadioListener);
        this.rbCurrentPage.setSelected(true);
        this.fromLabel.setEnabled(false);
        this.cbStartPage.setEnabled(false);
        this.toLabel.setEnabled(false);
        this.cbEndPage.setEnabled(false);
        ActionListener rangeComboListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PRotatePagesDialog.this.startPage = (Integer)PRotatePagesDialog.this.cbStartPage.getSelectedItem();
                if (PRotatePagesDialog.this.startPage > (Integer)PRotatePagesDialog.this.cbEndPage.getSelectedItem()) {
                    PRotatePagesDialog.this.endPage = PRotatePagesDialog.this.startPage;
                    PRotatePagesDialog.this.cbEndPage.setSelectedItem(new Integer(PRotatePagesDialog.this.startPage));
                } else {
                    PRotatePagesDialog.this.endPage = (Integer)PRotatePagesDialog.this.cbEndPage.getSelectedItem();
                }
            }
        };
        this.cbStartPage.addActionListener(rangeComboListener);
        this.cbEndPage.addActionListener(rangeComboListener);
        this.pageRangePanel.add(this.rbCurrentPage);
        this.pageRangePanel.add(this.rbAllPages);
        this.pageRangePanel.add(rangeBox);
    }

    void showRotatePagesDialog() {
        Object[] messages = new Object[]{this.rotationPanel, this.pageRangePanel};
        boolean ltr = PViewerUtilities.isLeftToRight();
        ComponentOrientation cOrient = ComponentOrientation.LEFT_TO_RIGHT;
        if (!ltr) {
            cOrient = ComponentOrientation.RIGHT_TO_LEFT;
        }
        JPanel dialogPanel = new JPanel();
        dialogPanel.setLayout(new BoxLayout(dialogPanel, 0));
        this.rotationPanel.setAlignmentY(0.0f);
        this.pageRangePanel.setAlignmentY(0.0f);
        dialogPanel.setComponentOrientation(cOrient);
        if (ltr) {
            dialogPanel.add(this.rotationPanel);
            dialogPanel.add(this.pageRangePanel);
        } else {
            dialogPanel.add(this.pageRangePanel);
            dialogPanel.add(this.rotationPanel);
        }
        int n = POptionPane.showOptionDialog(this.viewer, PViewerUtilities.getMessage("DocumentViewer.RotatePagesDialogTitle"), dialogPanel, -1, -1, null);
        if (n != 0) {
            this.pageRotation = 0;
        }
        if (this.pageRotation != 0) {
            int[] pages;
            if (this.endPage == 0 && this.startPage == 0) {
                pages = new int[]{this.viewer.getCurrentPageNumber()};
            } else if (this.endPage == -1 && this.startPage == 0) {
                try {
                    if (this.viewer.getViewablePageNumbers() != null) {
                        pages = this.viewer.getViewablePageNumbers();
                    }
                    pages = new int[this.viewer.getPageCount()];
                    for (int i = 0; i < pages.length; ++i) {
                        pages[i] = i + 1;
                    }
                }
                catch (IOException e) {
                    pages = new int[]{};
                }
            } else {
                try {
                    if (this.viewer.getViewablePageNumbers() != null) {
                        int[] viewablePages = this.viewer.getViewablePageNumbers();
                        int nviewableInRange = 0;
                        for (int i = this.startPage; i <= this.endPage; ++i) {
                            for (int j = 0; j < viewablePages.length; ++j) {
                                if (i != viewablePages[j]) continue;
                                ++nviewableInRange;
                            }
                        }
                        pages = new int[nviewableInRange];
                        int m = 0;
                        for (int i = this.startPage; i <= this.endPage; ++i) {
                            for (int j = 0; j < viewablePages.length; ++j) {
                                if (i != viewablePages[j]) continue;
                                pages[m] = i;
                                ++m;
                            }
                        }
                    } else {
                        pages = new int[this.endPage - this.startPage + 1];
                        for (int i = 0; i < this.endPage - this.startPage + 1; ++i) {
                            pages[i] = this.startPage + i;
                        }
                    }
                }
                catch (IOException e) {
                    pages = new int[]{};
                }
            }
            new PRotatePagesTask(this.viewer.getSelectedModel().getTaskManager(), this.viewer, pages, this.pageRotation);
        }
    }
}

